/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.resultset.interfaces.IIterator;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.storage.BTreeTupleStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class TupleIndex {
    private static final long DEFAULT_MAXSIZEFORHASH = 95000L;
    private static long maxSizeForHash = 95000L;
    private static final String MAX_SIZE_FOR_HASH_KEY = "TupleIndexHashThreshold";
    private static XQELogger mWarningLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MDXEngine", LogLevel.WARN);
    private boolean useHash;
    private BTreeTupleStorage tree = null;
    private HashSet<ITuple> hash = null;
    private long treeSize = 0L;

    public TupleIndex(Set s, String name, boolean load) {
        long allocSize = s.size();
        boolean bl = this.useHash = allocSize <= maxSizeForHash;
        if (this.useHash) {
            this.hash = new HashSet((int)allocSize);
        } else {
            mWarningLogger.log("Large tuple index: disk-backing threshold exceeded. (" + allocSize + " > " + maxSizeForHash + ")");
            this.tree = this.createTempTupleStorage(name, s);
        }
        if (load) {
            this.loadIndex(s);
        }
    }

    private void loadIndex(Set s) {
        IIterator it = s.iterator();
        while (it.hasNext()) {
            Tuple t = (Tuple)it.next();
            this.add(t);
        }
    }

    public void add(Tuple key) {
        if (this.useHash) {
            this.hash.add((ITuple)key.copy());
        } else if (!key.containsNullMember() && !this.tree.contains(key)) {
            this.tree.putLong(key, 0L);
            ++this.treeSize;
        }
    }

    public void remove(Tuple key) {
        if (this.useHash) {
            this.hash.remove(key);
        } else if (this.contains(key)) {
            this.tree.remove(key);
            --this.treeSize;
        }
    }

    public boolean contains(Tuple key) {
        if (this.useHash) {
            return this.hash.contains(key);
        }
        return !key.containsNullMember() && this.tree.contains(key);
    }

    public long size() {
        if (this.useHash) {
            return this.hash.size();
        }
        return this.treeSize;
    }

    public boolean isEmpty() {
        return this.size() < 1L;
    }

    private BTreeTupleStorage createTempTupleStorage(String name, ISet s) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String tempDirectory = configuration.getXqeTempDirectory();
        long tid = Thread.currentThread().getId();
        String dataFile = tempDirectory + File.separator + name + tid + ".dat";
        String indexFile = tempDirectory + File.separator + name + tid + ".idx";
        List<IDimension> dims = Arrays.asList(s.getDimensions());
        boolean create = true;
        boolean delete = true;
        boolean cubeScope = false;
        return new BTreeTupleStorage(dims, dataFile, indexFile, create, delete, cubeScope);
    }

    public void close() {
        if (!this.useHash) {
            this.tree.close();
            this.tree = null;
        } else {
            this.hash.clear();
            this.hash = null;
        }
    }

    public static long getMaxSizeForHash() {
        return maxSizeForHash;
    }

    static {
        String hashThresholdProperty = System.getProperty(MAX_SIZE_FOR_HASH_KEY);
        if (hashThresholdProperty != null) {
            maxSizeForHash = Integer.parseInt(hashThresholdProperty);
        }
    }
}

