/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.SortedTupleList;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import java.util.Arrays;
import java.util.Comparator;

public class TupleListQSort
implements Comparator<Long> {
    private ITupleList tupleList;
    private boolean postOrder = false;
    private Long[] index;

    public void setSubject(ITupleList tl) {
        this.tupleList = tl;
        this.index = new Long[(int)tl.size()];
        for (long inx = 0L; inx < tl.size(); ++inx) {
            this.index[(int)inx] = inx;
        }
    }

    public void setPostOrder(boolean so) {
        this.postOrder = so;
    }

    @Override
    public int compare(Long o1, Long o2) {
        return this.compareTuples(o1, o2, 0);
    }

    private int compareTuples(Long o1, Long o2, int ind) {
        ITuple at = this.tupleList.iterator().getTuple(o1);
        ITuple bt = this.tupleList.iterator().getTuple(o2);
        IMember am = at.getMember(ind);
        IMember bm = bt.getMember(ind);
        int ret = 0;
        ret = ((IMemberCubics)am).hierarchyCompare(bm, this.postOrder);
        if (ret == 0) {
            if (ind + 1 < at.size() && ind + 1 < bt.size()) {
                ret = this.compareTuples(o1, o2, ind + 1);
            }
        } else {
            ret *= -1;
        }
        return ret;
    }

    public ITupleList sort() {
        Arrays.sort(this.index, this);
        long[] ind = new long[this.index.length];
        for (int i = 0; i < this.index.length; ++i) {
            ind[i] = this.index[i];
        }
        return SortedTupleList.construct(this.tupleList, ind);
    }
}

