/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.data.providers.olap.securecache.SecurityAwareLayer;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class LOLAPDimension
extends Dimension {
    private static final String OPEN_BRACKET_STR = "[";
    private static final String CLOSE_BRACKET_STR = "]";
    protected IDimension modelDimension;
    private boolean keyFigureStructure = false;
    private boolean isAttributeDimension = false;
    private final ReentrantLock dimensionLock = new ReentrantLock();

    public LOLAPDimension(String name, LOLAPCube cube, IDimension dim) {
        super(name, cube);
        this.setConnection(cube.getConnection());
        this.modelDimension = dim;
        this.setType(dim.getType());
        this.setCardinality(dim.getCardinality());
        this.keyFigureStructure = dim.isKeyFigureStructure();
        this.isAttributeDimension = dim.isAttributeDimension();
        if (this.isAttributeDimension) {
            cube.setCubeContainsAttributeDimensions(this.isAttributeDimension);
        }
    }

    protected void initialiseHierarchies() {
        LOLAPHierarchy hierarchy = null;
        if (this.modelDimension.getType() == DimensionTypeEnum.MEASURE && this.modelDimension.getHierarchyCount() == 0) {
            hierarchy = new LOLAPHierarchy("Measures", this, null);
            hierarchy.initializeHierarchy(null);
        } else {
            int hierarchyCount = this.modelDimension.getHierarchyCount();
            for (int i = 0; i < hierarchyCount; ++i) {
                IHierarchy modelHierarchy = this.modelDimension.getHierarchy(i);
                hierarchy = new LOLAPHierarchy(modelHierarchy.getName(), this, modelHierarchy);
                hierarchy.initializeHierarchy(modelHierarchy);
            }
            if (!this.isDefaultHierarchyExistInModel()) {
                IHierarchy hier = this.modelDimension.getDefaultHierarchy();
                hierarchy = new LOLAPHierarchy(hier.getName(), this, hier);
                hierarchy.initializeHierarchy(hier);
            }
        }
    }

    public String getExternalName() {
        return this.modelDimension.getUniqueName();
    }

    @Override
    public String getV5UniqueName() {
        if (this.modelDimension == null) {
            return super.getV5UniqueName();
        }
        return this.modelDimension.getV5UniqueName();
    }

    @Override
    public boolean isKeyFigureStructure() {
        return this.keyFigureStructure;
    }

    @Override
    public boolean isDefaultHierarchyExistInModel() {
        return this.modelDimension.isDefaultHierarchyExistInModel();
    }

    private IHierarchy getHierarchyByName(String hierName) {
        int i;
        IHierarchy hier = super.getHierarchy(hierName);
        if (hier != null) {
            return hier;
        }
        String extHierName = hierName;
        if (!extHierName.startsWith(OPEN_BRACKET_STR)) {
            extHierName = OPEN_BRACKET_STR + hierName + CLOSE_BRACKET_STR;
        }
        int hierCnt = this.getHierarchyCount();
        for (i = 0; i < hierCnt; ++i) {
            hier = this.getHierarchy(i);
            String extName = ((LOLAPHierarchy)hier).getExternalName();
            if (extName.compareTo(extHierName) == 0) {
                return hier;
            }
            String[] parts = UniqueNameParser.parseNoThrow(extName);
            if (parts == null || 2 != parts.length || hierName.compareTo(parts[1]) != 0) continue;
            return hier;
        }
        for (i = 0; i < hierCnt; ++i) {
            hier = this.getHierarchy(i);
            String name = ((LOLAPHierarchy)hier).getName();
            if (name.compareTo(hierName) != 0) continue;
            return hier;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMember findMember(String memberNamePart) throws MetadataException {
        if (memberNamePart == null || memberNamePart.isEmpty()) {
            return null;
        }
        IMember member = null;
        if (this.isMeasuresDimension()) {
            LOLAPLevel lolapLevel = (LOLAPLevel)this.getHierarchy(0).getLevel(0);
            if (lolapLevel.loadMeasuresOnDemanding()) {
                member = this.findMeasure(lolapLevel.getMembersOrderedMap(), memberNamePart);
                if (member == null) {
                    IOrderedMap<IMember> measuresMap = null;
                    this.dimensionLock.lock();
                    try {
                        member = this.findMeasure(lolapLevel.getMembersOrderedMap(), memberNamePart);
                        if (member == null) {
                            measuresMap = lolapLevel.fetchReferencedMeasuresOnLevel();
                            member = this.findMeasure(measuresMap, memberNamePart);
                        }
                    }
                    finally {
                        this.dimensionLock.unlock();
                    }
                }
                return member;
            }
            return super.findMember(memberNamePart);
        }
        LOLAPCube c = (LOLAPCube)this.getCube();
        String trimmedName = memberNamePart.trim();
        String mdxName = null;
        if (trimmedName.startsWith(OPEN_BRACKET_STR)) {
            mdxName = trimmedName;
            member = c.handleDefaultMemberSyntax(mdxName);
        }
        if (member == null) {
            ICacheKey memberKey = null;
            boolean validateDim = false;
            if (mdxName != null) {
                memberKey = c.getSingleMemberFromCache(null, null, mdxName);
                validateDim = true;
            } else {
                Hierarchy[] hiers = this.getHierarchies().toArray(new Hierarchy[0]);
                for (int j = 0; j < hiers.length && memberKey == null; ++j) {
                    Hierarchy hier = hiers[j];
                    mdxName = c.prepareMDXMemberName((LOLAPHierarchy)hier, memberNamePart);
                    memberKey = c.getSingleMemberFromCache(this, (LOLAPHierarchy)hier, mdxName);
                }
            }
            if (memberKey != null) {
                int memberId;
                int memberLevelNumber;
                String dun;
                IDimension dim;
                SecurityAwareLayer sal = c.getSAL();
                String name = c.getMemberName(memberKey);
                if (validateDim && (dim = c.getDimension(dun = sal.getDimensionUniqueNameFromCache(memberKey))) != this) {
                    throw new XQERuntimeException(XQEMessageKeys.MD_UnexpectedDimForMemberFound, (Object)name, (Object)dim.getUniqueName(), (Object)this.getUniqueName());
                }
                String hun = sal.getHierarchyUniqueNameFromCache(memberKey);
                IHierarchy hier = this.getHierarchy(hun, c.getKeyDate(), null, null);
                Level level = (Level)hier.getLevel(memberLevelNumber = c.getCorrespondingLOLAPLevelIndex(hier, sal.getMemberLevelIndexFromCache(memberKey)));
                member = level.getMember(name, memberId = sal.getMemberIdFromCache(memberKey));
                if (member == null) {
                    Level level2 = level;
                    synchronized (level2) {
                        IMember memberDoubleCheck = level.getMember(name, memberId);
                        if (memberDoubleCheck == null) {
                            member = LOLAPMemberProxy.initMemberProxy(memberKey, level);
                        }
                    }
                }
            }
        }
        return member;
    }

    private IMember findMeasure(IOrderedMap<IMember> measuresMap, String nameNoBrackets) {
        Set<String> keyset = measuresMap.keySet();
        for (String key : keyset) {
            IMember measure = measuresMap.get(key);
            String measureName = measure.getName();
            if (!measureName.equals(nameNoBrackets)) continue;
            return measure;
        }
        return null;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    public void resetDefaultMember(LOLAPHierarchy hier) {
        ((LOLAPCube)this.getCube()).resetDefaultMember(hier);
    }

    public IMember[] getMembersFromHierarchyLessModeledDim() {
        IMember[] members = null;
        if (this.isMeasuresDimension() && this.modelDimension.getHierarchyCount() == 0) {
            members = this.modelDimension.getMembers();
        }
        return members;
    }

    @Override
    public IMember getDummyMember(IHierarchy hier) {
        return ((LOLAPCube)this.getCube()).getDummyMember(hier);
    }

    @Override
    public boolean isAttributeDimension() {
        return this.isAttributeDimension;
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public boolean isShareable() {
        return false;
    }

    @Override
    public IHierarchy getHierarchy(String hierName) {
        LOLAPCube c = (LOLAPCube)this.getCube();
        String keyDate = c.getKeyDate();
        return this.getHierarchy(hierName, keyDate, null, null);
    }

    @Override
    public IHierarchy getHierarchy(String uniqueName, String keyDate, DateValue validFrom, DateValue validTo) {
        if (keyDate == null || keyDate.length() == 0) {
            return this.getHierarchyByName(uniqueName);
        }
        String hierarchyUniqueName = uniqueName;
        if (!hierarchyUniqueName.startsWith(OPEN_BRACKET_STR)) {
            hierarchyUniqueName = OPEN_BRACKET_STR + hierarchyUniqueName + CLOSE_BRACKET_STR;
        }
        IHierarchy hierarchy = null;
        int hierCnt = this.getHierarchyCount();
        for (int i = 0; i < hierCnt; ++i) {
            IHierarchy tempHier = this.getHierarchy(i);
            IHierarchy modelHier = ((LOLAPHierarchy)tempHier).getModelHierarchy();
            IHierarchy hier = this.modelDimension.getHierarchy(hierarchyUniqueName, keyDate, validFrom, validTo);
            if (hier == null || !this.modelDimension.compareTDHierarchies(modelHier, hier)) continue;
            hierarchy = tempHier;
            break;
        }
        if (hierarchy == null) {
            return this.getHierarchyByName(uniqueName);
        }
        return hierarchy;
    }

    @Override
    public IHierarchy getDefaultHierarchy() {
        if (this.defaultHierarchy == null) {
            this.defaultHierarchy = ((LOLAPCube)this.getCube()).getDefaultHierarchy(this);
        }
        return this.defaultHierarchy;
    }

    public IDimension getModelDimension() {
        return this.modelDimension;
    }
}

