/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMDXQuery;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Property;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class LOLAPEssbaseCube
extends LOLAPCube {
    private static final String OPEN_BRACKET_STR = "[";
    private static final String CLOSE_BRACKET_STR = "]";
    private static final String COMMA_OPEN_BRACKET_STR = ", [";
    private static final String DOT_OPEN_BRACKET_STR = ".[";
    private static final String STRING_SPACE = " ";
    private static final String STRING_COMMA = ",";
    private static final String FROM_OPEN_BRACKET_STR = "FROM [";
    private static final String RUN_LOCALE = "runLocale";
    private static final String VALUE = "value";
    private Map<String, String> mDimensionProperties = null;
    private String mdxDefaultDimensionPropsClause = null;
    private boolean cubeContainsAttributeDim = false;

    public LOLAPEssbaseCube(ICatalog catalog, ICube modelCube, IDataSource dataSource, MemberStorage memberStore, List<IMeasure> mdxQueryReferencedMeasures) throws ProviderException {
        super(catalog, modelCube, dataSource, null, memberStore);
        this.setDimensionPropList();
        for (int ii = 0; ii < this.getDimensionCount(); ++ii) {
            if (!this.isAttributeDimensionMember(this.getDimension(ii))) continue;
            this.setCubeContainsAttributeDimensions(true);
            break;
        }
    }

    private void setDimensionPropList() {
        IAlias alias = this.modelCube.getModelDataSource().getAlias();
        IAliasEntry entry = null;
        this.mDimensionProperties = new HashMap<String, String>();
        String[] propsToAdd = new String[]{"ANCESTOR_NAMES", "LEVEL_NUMBER", "GEN_NUMBER", "MEMBER_ALIAS"};
        this.mdxDefaultDimensionPropsClause = OPEN_BRACKET_STR + propsToAdd[0] + CLOSE_BRACKET_STR;
        for (int i = 0; i < propsToAdd.length; ++i) {
            this.mDimensionProperties.put(propsToAdd[i], propsToAdd[i]);
            if (i <= 0) continue;
            this.mdxDefaultDimensionPropsClause = this.mdxDefaultDimensionPropsClause + COMMA_OPEN_BRACKET_STR + propsToAdd[i] + CLOSE_BRACKET_STR;
        }
        if (alias != null) {
            List<IAliasEntry> aliasentries = alias.getAliasEntries();
            Iterator<IAliasEntry> it = aliasentries.iterator();
            HashMap<String, String> aliasTableMap = new HashMap<String, String>();
            while (it.hasNext()) {
                entry = it.next();
                aliasTableMap.put(entry.getKey(), entry.getValue());
                if (this.mDimensionProperties.containsKey(entry.getValue().toUpperCase())) continue;
                this.mDimensionProperties.put(entry.getValue().toUpperCase(), entry.getValue());
            }
            if (this.getSAL().getMemberStorage().getSupportedLocales() == null) {
                this.getSAL().getMemberStorage().initSupportedLocales(aliasTableMap);
            }
        }
    }

    @Override
    public void setMeasureInfo(List<IMeasure> measures) {
    }

    @Override
    public String getMDXMemberUniqueName(IMember member) {
        String uniqueName = member.getUniqueName();
        try {
            String[] parts = UniqueNameParser.parse(uniqueName);
            if (parts.length > 2) {
                String name = null;
                String secondNamePart = UniqueNameParser.escapeSquareBrackets(parts[parts.length - 2]);
                String thirdNamePart = UniqueNameParser.escapeSquareBrackets(parts[parts.length - 1]);
                name = UniqueNameGenerator.createUniqueName(secondNamePart, thirdNamePart);
                return name;
            }
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        return uniqueName;
    }

    @Override
    public String getMDXAxisAttributes(int axisNum) {
        StringBuilder axisName = new StringBuilder();
        axisName.append(" DIMENSION PROPERTIES ");
        axisName.append(this.mdxDefaultDimensionPropsClause);
        IAliasEntry aliasTableEntry = this.getAliasTableEntry();
        if (aliasTableEntry != null) {
            axisName.append(COMMA_OPEN_BRACKET_STR);
            axisName.append(aliasTableEntry.getValue());
            axisName.append(CLOSE_BRACKET_STR);
        }
        axisName.append(" ON Axis(");
        axisName.append(axisNum);
        axisName.append(")");
        return axisName.toString();
    }

    @Override
    public String getMDXFromClause() {
        StringBuilder fromClause = new StringBuilder();
        fromClause.append(FROM_OPEN_BRACKET_STR);
        fromClause.append(this.getCatalogName());
        fromClause.append("].[");
        fromClause.append(this.getName());
        fromClause.append(CLOSE_BRACKET_STR);
        return fromClause.toString();
    }

    @Override
    public String getMDXQueryAttributes() {
        return STRING_SPACE;
    }

    @Override
    public void loadMemberProperties(LOLAPLevel level) {
        MetadataRestriction restrictions = new MetadataRestriction();
        LOLAPDimension dim = (LOLAPDimension)level.getDimension();
        LOLAPCube cube = (LOLAPCube)dim.getCube();
        restrictions.add(RestrictionType.CATALOG, cube.getCatalogName());
        restrictions.add(RestrictionType.CUBE, cube.getName());
        String dimName = dim.getExternalName();
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dim.getExternalName());
        LOLAPHierarchy hier = (LOLAPHierarchy)level.getHierarchy();
        if (this.cubeContainsAttributeDim || dim.getType() == DimensionTypeEnum.MEASURE) {
            return;
        }
        String hierName = hier.getExternalName();
        if (hierName.equals("")) {
            hierName = dimName;
        }
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hierName);
        String levelName = level.getExternalName();
        if (!levelName.equals("")) {
            restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, levelName);
        }
        List<PropertyRecord> propertyRecords = cube.getSecuredMetadataProvider().getProperties(restrictions);
        int rowCount = propertyRecords.size();
        for (int inx = 0; inx < rowCount; ++inx) {
            PropertyRecord propertyRecord = propertyRecords.get(inx);
            String name = propertyRecord.getName();
            if (name.length() > 0 && name.charAt(0) == '[') {
                name = name.substring(1, name.length() - 1);
            }
            Property property = new Property(name, level);
            property.setDataType(propertyRecord.getDataType());
            level.addMemberProperty(property);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateMeasuresLevelInfo(LOLAPLevel level) {
        String uniqueName;
        if (level.getDimension().getType() != DimensionTypeEnum.MEASURE || (uniqueName = level.getUniqueName()) == null) return;
        if (uniqueName.contains(OPEN_BRACKET_STR)) {
            try {
                String[] parts = UniqueNameParser.parse(uniqueName);
                if (parts.length != 2) return;
                level.setName(parts[1]);
                return;
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(e);
            }
        } else {
            level.setName(uniqueName);
        }
    }

    @Override
    public int getCorrespondingLOLAPLevelIndex(IHierarchy hierarchy, int providerLevelIndex) {
        int levelIndex = hierarchy.getDimension().isMeasuresDimension() ? providerLevelIndex - 1 : providerLevelIndex;
        return levelIndex;
    }

    @Override
    public void addProviderSpecificRestrictions(IRestrictions restrictions) {
        restrictions.add(RestrictionType.CUBE_OBJECT, this.modelCube);
        Boolean useMetadataCall = this.getUseMetadataCallOnly();
        if (useMetadataCall == null) {
            useMetadataCall = false;
        }
        restrictions.add(RestrictionType.USE_METADATA_CALL_ONLY, useMetadataCall);
    }

    @Override
    public String getMemberName(ICacheKey memberKey) {
        String name = null;
        try {
            name = this.getSAL().getMemberNameFromCache(memberKey, this.getCubeRestrictionsReference());
            if (name.length() != 0 && name.charAt(0) == '[') {
                name = name.substring(1, name.length() - 1);
            }
        }
        catch (Exception e) {
            String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo(this);
            if (msTsInfo != null) {
                StringBuilder strBldr = new StringBuilder("SAL exception encountered during member name retrieval");
                strBldr.append(msTsInfo);
                mMSErrorLogger.log(strBldr.toString());
            }
            throw XQERuntimeException.wrap(e);
        }
        return name;
    }

    @Override
    protected boolean hasInconsistentMeasureValues() {
        return false;
    }

    @Override
    public IMember resolveProviderSpecificRootMember(Dimension dim, String memberNamePart) throws MetadataException {
        if (dim.isMeasuresDimension()) {
            return null;
        }
        int hCount = dim.getHierarchyCount();
        for (int j = 0; j < hCount; ++j) {
            IHierarchy h = dim.getHierarchy(j);
            ILevel l = h.getLevel(memberNamePart);
            if (l == null) continue;
            return null;
        }
        if (!memberNamePart.startsWith(OPEN_BRACKET_STR)) {
            memberNamePart = UniqueNameGenerator.createUniqueName(memberNamePart);
        }
        return dim.findMember(memberNamePart);
    }

    @Override
    public boolean isProviderSpecificProperty(String propertyName) {
        if (propertyName != null) {
            return this.mDimensionProperties.containsKey(propertyName);
        }
        return false;
    }

    @Override
    public boolean isMemberAnAttribute(String propertyName, ILevel level) {
        LOLAPLevel levelLOLAP = (LOLAPLevel)level;
        String propName = propertyName;
        if (propertyName.contains(OPEN_BRACKET_STR)) {
            propName = propName.substring(propName.lastIndexOf(OPEN_BRACKET_STR) + 1, propName.length() - 1);
        }
        return levelLOLAP.isValidPropertyName(propName);
    }

    @Override
    public String getAttributeUniqueName(String propertyName, ILevel level) {
        if (!propertyName.startsWith(OPEN_BRACKET_STR)) {
            return level.getDimension().getUniqueName() + DOT_OPEN_BRACKET_STR + propertyName + CLOSE_BRACKET_STR;
        }
        return propertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, Object> getAttributeValuesForMembers(String propertyName, IMember[] mArray) {
        String name;
        int i;
        LOLAPLevel level = (LOLAPLevel)mArray[0].getLevel();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, IMember> memberMap = new HashMap<String, IMember>();
        boolean bCompensateForEssbaseAttrBug = true;
        String propUniqueName = this.getAttributeUniqueName(propertyName, level);
        StringBuilder mdx = new StringBuilder();
        mdx.append("SELECT {} ON Axis(0), {");
        int len = mArray.length;
        if (bCompensateForEssbaseAttrBug) {
            for (i = 0; i < len; ++i) {
                name = null;
                name = mArray[i].getDimension().isMeasuresDimension() ? mArray[i].getDimension().getUniqueName() + DOT_OPEN_BRACKET_STR + mArray[i].getName() + CLOSE_BRACKET_STR : mArray[i].getDimension().getUniqueName() + DOT_OPEN_BRACKET_STR + mArray[i].getName() + CLOSE_BRACKET_STR;
                memberMap.put(Integer.toString(i), mArray[i]);
                if (i != 0) {
                    mdx.append(STRING_COMMA);
                }
                mdx.append(name);
                mdx.append(STRING_SPACE);
            }
        } else {
            for (i = 0; i < len; ++i) {
                name = null;
                name = mArray[i].getDimension().isMeasuresDimension() ? mArray[i].getDimension().getUniqueName() + DOT_OPEN_BRACKET_STR + mArray[i].getName() + CLOSE_BRACKET_STR : mArray[i].getDimension().getUniqueName() + DOT_OPEN_BRACKET_STR + mArray[i].getName() + CLOSE_BRACKET_STR;
                memberMap.put(name, mArray[i]);
                if (i != 0) {
                    mdx.append(STRING_COMMA);
                }
                mdx.append(name);
                mdx.append(STRING_SPACE);
            }
        }
        mdx.append("} DIMENSION PROPERTIES  ");
        mdx.append(propUniqueName);
        mdx.append(", [ANCESTOR_NAMES] ON Axis(1) FROM [");
        mdx.append(this.getCatalog().getName());
        mdx.append(".");
        mdx.append(this.getName());
        mdx.append(CLOSE_BRACKET_STR);
        OrderedMap<String> properties = new OrderedMap<String>();
        properties.put("Format", "Multidimensional");
        properties.put("AxisFormat", "TupleFormat");
        properties.put("Content", "Data");
        XQEDebugLog.out.println("MDX: " + mdx.toString());
        ArrayList<IHierarchy> hierarchyList = new ArrayList<IHierarchy>();
        LOLAPMDXQuery mdxQuery = new LOLAPMDXQuery(mdx.toString(), this, hierarchyList);
        ICubeResultSet cubeResult = this.performExecuteRequest(mdxQuery, properties, this);
        int tupCnt = 0;
        XIterator it = cubeResult.getAxisIterator(1);
        try {
            ITuple tuple = null;
            String name2 = null;
            while ((tuple = (ITuple)it.next()) != null) {
                IMember member = tuple.getMember(0);
                Object val = member.getProperty(propUniqueName);
                String memberUniqueName = null;
                if (tuple.getMember(0).getUniqueName().equalsIgnoreCase(tuple.getMember(0).getDimension().getUniqueName())) {
                    memberUniqueName = tuple.getMember(0).getUniqueName();
                } else {
                    try {
                        String[] parts = UniqueNameParser.parse(tuple.getMember(0).getUniqueName());
                        name2 = parts.length > 2 ? UniqueNameGenerator.createUniqueName(parts[1], parts[parts.length - 1]) : UniqueNameGenerator.createUniqueName(parts[0], parts[parts.length - 1]);
                    }
                    catch (UniqueNameParserException e) {
                        throw new XQERuntimeException(e);
                    }
                    memberUniqueName = ((IMember)memberMap.get(Integer.toString(tupCnt))).getUniqueName();
                }
                resultMap.put(memberUniqueName, val);
                ++tupCnt;
            }
        }
        finally {
            if (it != null) {
                it.release();
            }
            if (cubeResult != null) {
                cubeResult.release();
            }
        }
        return resultMap;
    }

    @Override
    public boolean isAttributeDimensionMember(IDimension dim) throws MetadataException {
        return ((LOLAPDimension)dim).isAttributeDimension();
    }

    @Override
    public boolean cubeContainAttributeDimensions() {
        return this.cubeContainsAttributeDim;
    }

    @Override
    public void setCubeContainsAttributeDimensions(boolean isAttribDimension) {
        if (!this.cubeContainsAttributeDim) {
            this.cubeContainsAttributeDim = isAttribDimension;
        }
    }

    @Override
    public IMember getDummyMember(IHierarchy hierarchy) {
        LOLAPDimension dim = (LOLAPDimension)hierarchy.getDimension();
        if (dim.isAttributeDimension()) {
            IMember member = hierarchy.getDefaultMember();
            LOLAPMemberProxy member1 = new LOLAPMemberProxy(member);
            return member1;
        }
        return null;
    }

    @Override
    public boolean isDummyMember(IMember mem) {
        return ((LOLAPMemberProxy)mem).isDummyMember();
    }

    @Override
    public boolean isMemberNameSupported(String propName) {
        return propName.equalsIgnoreCase("MEMBER_NAME");
    }

    @Override
    public boolean supportAttributeDimensionProperties() {
        return !this.cubeContainsAttributeDim;
    }

    @Override
    public IHierarchy pushSingleMemberDimensionOnToRow(IHierarchy hier) {
        return hier;
    }

    @Override
    public boolean addToWhereCondition(IDimension dim, IMember member) {
        return true;
    }

    @Override
    public boolean isProviderEssbase() {
        return true;
    }

    @Override
    public boolean isOfTypeAggregateUnknown(AggregateTypeEnum memberAggrType) {
        return AggregateTypeEnum.UNKNOWN == memberAggrType;
    }

    public IAliasEntry getAliasTableEntry() {
        IAlias alias = this.modelCube.getModelDataSource().getAlias();
        if (alias != null) {
            Element runLocaleElement;
            List<IAliasEntry> aliasentries = alias.getAliasEntries();
            if (aliasentries.isEmpty()) {
                return null;
            }
            Iterator<IAliasEntry> it = aliasentries.iterator();
            ExecutionEnvironment environment = this.getExecutionEnvironment();
            Element connectionElement = environment.getConnectionElement();
            String runLocaleString = null;
            if (connectionElement != null && (runLocaleElement = connectionElement.element(RUN_LOCALE)) != null) {
                runLocaleString = runLocaleElement.attributeValue(VALUE);
            }
            if (runLocaleString == null) {
                runLocaleString = LocaleConverter.getLanguage(((RequestEnvironment)environment.getRequestEnvironment()).getRunLocale());
            }
            String runLocaleLanguage = null;
            int i = runLocaleString.indexOf(45);
            runLocaleLanguage = i >= 0 ? runLocaleString.substring(0, i) : runLocaleString;
            if (runLocaleLanguage != null) {
                IAliasEntry entry = null;
                while (it.hasNext()) {
                    entry = it.next();
                    if (!entry.getKey().equalsIgnoreCase(runLocaleLanguage)) continue;
                    return entry;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCubeExistOnDataSource() {
        return true;
    }

    @Override
    protected IHierarchy getDefaultHierarchy(IDimension dimension) {
        List<IHierarchy> hierarchies = dimension.getHierarchies();
        if (hierarchies.size() > 0) {
            return hierarchies.get(0);
        }
        return null;
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        return ICube.CubeTypeEnum.ESSBASE;
    }

    @Override
    public String getCubeCurrentPeriod() {
        return null;
    }
}

