/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public class LOLAPMediator<T> {
    public static final String VBRK_11_8_00600_6 = "11.8.00600.6";
    private final BooleanSupplier mEnabler;
    private final long mVersionKey;
    private T mResult;
    private Map<String, Long> mBreakerCache = new HashMap<String, Long>();

    public LOLAPMediator(BooleanSupplier enabler, Supplier<String> version) {
        this.mEnabler = enabler;
        this.mVersionKey = this.mEnabler.getAsBoolean() ? this.getVersionKey(version.get()) : -1L;
    }

    public boolean execute(Condition condition, String breaker, Supplier<T> expression) {
        if (!this.applicable(condition, breaker)) {
            return false;
        }
        this.mResult = expression.get();
        return true;
    }

    public boolean applicable(Condition condition, String breaker) {
        if (!this.mEnabler.getAsBoolean()) {
            return false;
        }
        long iBreakerKey = this.getVersionKey(breaker);
        boolean bApplicable = false;
        switch (condition) {
            case LESS_THAN: {
                bApplicable = this.mVersionKey < iBreakerKey;
                break;
            }
            case GREATER_OR_EQUAL: {
                bApplicable = this.mVersionKey >= iBreakerKey;
                break;
            }
        }
        return bApplicable;
    }

    public T getResult() {
        return this.mResult;
    }

    protected long getVersionKey(String version) {
        if (null == version) {
            return 0L;
        }
        Long cachedKey = this.mBreakerCache.get(version);
        if (cachedKey != null) {
            return cachedKey;
        }
        String[] subversions = version.split("\\.");
        if (subversions.length != 4) {
            return -1L;
        }
        long key = Long.parseLong(subversions[0]) << 40;
        key += Long.parseLong(subversions[1]) << 32;
        key += Long.parseLong(subversions[2]) << 8;
        this.mBreakerCache.put(version, key += Long.parseLong(subversions[3]));
        return key;
    }

    public static enum Condition {
        LESS_THAN,
        GREATER_OR_EQUAL;

    }
}

