/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultsets.md.CubicsDimensionalResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPTM1ExternalAggregateStategy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.trace.XQEDebugLog;
import java.util.ArrayList;

public class LOLAPProvider
extends Provider {
    MetadataConnection connection;
    LOLAPCube cube = null;

    @Override
    public void connect() throws ProviderException {
    }

    public void initialize() throws ProviderException {
        XQEDebugLog.out.println("initializing LOLAPProvider");
    }

    public void release() {
    }

    @Override
    public String[] getCatalogs() throws ProviderException {
        String[] result = new String[]{};
        ArrayList<String> resultList = new ArrayList<String>();
        if (this.cube != null) {
            resultList.add(this.cube.getCatalogName());
        }
        result = resultList.toArray(new String[0]);
        return result;
    }

    @Override
    public String[] getCubeNames(String catalogName) throws ProviderException {
        String[] result = new String[]{};
        ArrayList<String> resultList = new ArrayList<String>();
        if (this.cube != null && (catalogName == null || catalogName.length() == 0 || this.cube.getCatalogName().equals(catalogName))) {
            resultList.add(this.cube.getName());
        }
        result = resultList.toArray(new String[0]);
        return result;
    }

    @Override
    public Cube getCube(String cubeName) throws ProviderException {
        if (this.cube != null && this.cube.getName().equals(cubeName)) {
            return this.cube;
        }
        return null;
    }

    public void setCube(LOLAPCube lolapCube) {
        this.cube = lolapCube;
    }

    @Override
    public Cube retrieveCube(String catalogName, String cubeName) throws ProviderException {
        if (this.cube != null && this.cube.getName().equals(cubeName) && this.cube.getCatalogName().equals(catalogName)) {
            return this.cube;
        }
        return null;
    }

    @Override
    public QueryStrategy getQueryStrategy() {
        return this.cube.getQueryStrategy();
    }

    public MetadataConnection getConnection() {
        return this.connection;
    }

    public void setConnection(MetadataConnection theConnection) {
        this.connection = theConnection;
    }

    @Override
    public IExternalAggregateStrategy getExternalAggregateStrategy() {
        if (this.cube.getDatasourceType().equals("TM") || this.cube.getDatasourceType().equals("TMR")) {
            return new LOLAPTM1ExternalAggregateStategy();
        }
        return super.getExternalAggregateStrategy();
    }

    @Override
    public boolean isResultSetCacheEnabled(ICube lolapCube) {
        return ((LOLAPCube)lolapCube).isResultSetCacheEnabled();
    }

    @Override
    public boolean isResultSetCacheable(MDXQuery mdxQuery, XDataContext dataContext, ICubeResultSet executedResultSet, long elapsedQueryTime) {
        if (executedResultSet instanceof CubicsDimensionalResultSet) {
            int[] parameterNodeTypes = new int[]{1163, 1162, 1129, 1161, 1159};
            if (mdxQuery.getDescendantsOfTypes(parameterNodeTypes, false).length > 0) {
                return false;
            }
            return !((CubicsDimensionalResultSet)executedResultSet).getResultSet().isEmpty();
        }
        return false;
    }

    @Override
    public ICubeResultSetCache getResultSetCache(ICube lolapCube) {
        return ((LOLAPCube)lolapCube).getResultSetCache();
    }
}

