/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateCacheLoader;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricQueryBuilder;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricSubqueryIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.List;

public class PrimingQueryStrategy
extends QueryStrategy {
    protected static final String NEWLINE = System.getProperty("line.separator");
    public static final String PRIMING_QUERY = "PrimingQuery";
    private QueryStrategy queryStrategy;
    SymmetricQueryBuilder queryBuilder;
    int minExcessTuplesForSplitQuery = -1;
    double excessTuplesRatioForSplitQuery = -1.0;

    public PrimingQueryStrategy(QueryStrategy qs) {
        this.queryStrategy = qs;
        this.queryBuilder = new SymmetricQueryBuilder(false);
        IDataSourceCapabilities capabilities = null;
        if (qs instanceof LOLAPQueryStrategy) {
            capabilities = ((LOLAPCube)((LOLAPQueryStrategy)qs).getCube()).getCapabilities();
        }
        if (capabilities != null) {
            this.minExcessTuplesForSplitQuery = capabilities.getIntegerValue("lolap.minExcessTuplesForSplitQuery");
            this.excessTuplesRatioForSplitQuery = capabilities.getIntegerValue("lolap.excessTuplesRatioForSplitQuery");
        }
        this.queryStrategy.setCubeletHint(this.generateQueryHint());
    }

    public void runPrimingQuery(InterpreterContext interpreterContext) {
        XQELogger primingLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", PRIMING_QUERY, LogLevel.INFO);
        int ten = 10;
        List<CrossJoinedSet> sets = this.queryBuilder.getConsolidatedSets(10.0);
        primingLogger.log("Executing " + sets.size() + " priming queries.");
        for (Set set : sets) {
            try {
                AggregateCacheLoader.MetricsOnlyResultSet resultSet = new AggregateCacheLoader.MetricsOnlyResultSet((CrossJoinedSet)set);
                this.queryStrategy.execute((CrossJoinedSet)set, resultSet);
            }
            catch (InterpreterException e) {
                primingLogger.log(LogLevel.ERROR, e.getStackTrace().toString());
            }
        }
    }

    @Override
    public void execute(CrossJoinedSet cjs, IResultSet resultSet) throws InterpreterException {
        DMRCube cube;
        List<IHierarchy> hiers;
        IHierarchy[] cubeHiers;
        IMember[][] cjsSelections;
        if (this.getPushDownMode()) {
            return;
        }
        if (this.queryStrategy instanceof DMRQueryStrategy && ((DMRQueryStrategy)this.queryStrategy).checkTagForCompleteTuple(cjsSelections = cjs.getMembers(cubeHiers = (hiers = (cube = (DMRCube)this.queryStrategy.getCube()).getHierarchies(false)).toArray(new IHierarchy[hiers.size()])))) {
            return;
        }
        XQELogger primingLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", PRIMING_QUERY, LogLevel.TRACE);
        primingLogger.log("PrimingQueryStrategy received " + cjs.size() + " tuples.");
        SymmetricSubqueryIterator iterator = new SymmetricSubqueryIterator(cjs, this.minExcessTuplesForSplitQuery, this.excessTuplesRatioForSplitQuery, false, null);
        primingLogger.log("Input set is asymmetric.");
        while (iterator.hasNext()) {
            this.queryBuilder.addSet((Set)iterator.next());
        }
    }

    private String generateQueryHint() {
        StringBuffer queryHint = new StringBuffer();
        queryHint.append(PrimingQueryStrategy.getRequestId());
        return queryHint.toString();
    }

    public QueryStrategy getBaseStrategy() {
        return this.queryStrategy;
    }
}

