/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider.sapbw;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.sapbw.LOLAPSAPDimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import java.util.List;
import java.util.Map;

public class LOLAPSAPCube
extends LOLAPCube {
    public LOLAPSAPCube(ICatalog catalog, ICube modelCube, IDataSource dataSource, String keyDate, MemberStorage memberStore, List<IMeasure> mdxQueryReferencedMeasures) throws ProviderException {
        super(catalog, modelCube, dataSource, keyDate, memberStore);
        if (!mdxQueryReferencedMeasures.isEmpty()) {
            this.setMeasureInfo(mdxQueryReferencedMeasures);
        }
    }

    @Override
    public void initialiseDimensions() {
        if (!this.dimsInitialised) {
            List<IDimension> otherDims = this.modelCube.getDimensions();
            for (int i = 0; i < otherDims.size(); ++i) {
                IDimension dim = otherDims.get(i);
                String name = dim.getUniqueName();
                if (name.charAt(0) == '[') {
                    name = name.substring(1, name.length() - 1);
                }
                LOLAPSAPDimension newDim = new LOLAPSAPDimension(name, this, dim);
                newDim.initialiseHierarchies();
            }
            this.dimsInitialised = true;
        }
    }

    @Override
    public String getMDXMemberUniqueName(IMember member) {
        return member.getUniqueName();
    }

    public String getCubicsMUN(String providerMUN, Map<String, String> essMemberNameToUName) {
        return providerMUN;
    }

    @Override
    public String getMDXAxisAttributes(int axisNum) {
        String axisName;
        switch (axisNum) {
            case 0: {
                axisName = "COLUMNS";
                break;
            }
            case 1: {
                axisName = "ROWS";
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "LOLAPSAPCube.getMDXAxisAttribues - bad axisNum");
            }
        }
        return " ON " + axisName;
    }

    @Override
    public String getMDXFromClause() {
        return " FROM [" + this.getName() + "]";
    }

    @Override
    public String getMDXQueryAttributes() {
        return " CELL PROPERTIES CELL_ORDINAL, VALUE, FORMAT_STRING";
    }

    @Override
    public void updateMeasuresLevelInfo(LOLAPLevel level) {
    }

    @Override
    public int getCorrespondingLOLAPLevelIndex(IHierarchy hierarchy, int providerLevelIndex) {
        return providerLevelIndex;
    }

    @Override
    public void loadMemberProperties(LOLAPLevel level) {
    }

    @Override
    public void resetDefaultMember(LOLAPHierarchy hierarchy) {
        LOLAPDimension dim = (LOLAPDimension)hierarchy.getDimension();
        if (dim.isMeasuresDimension() || dim.isKeyFigureStructure()) {
            IMember member = hierarchy.getDefaultMember();
            ILevel level = null;
            level = member != null ? member.getLevel() : hierarchy.getLevel(0);
            LOLAPMeasure member1 = new LOLAPMeasure("DummyMeasure", level);
            hierarchy.setDefaultMember(member1);
        }
    }

    @Override
    public void addProviderSpecificRestrictions(IRestrictions restrictions) {
        String sapVariables;
        restrictions.add(RestrictionType.CUBE_OBJECT, this.modelCube);
        Boolean useMetadataCall = this.getUseMetadataCallOnly();
        if (useMetadataCall != null) {
            restrictions.add(RestrictionType.USE_METADATA_CALL_ONLY, useMetadataCall);
        }
        if ((sapVariables = this.getSAPVariables()) != null) {
            restrictions.add(RestrictionType.VARIABLES_VALUE, sapVariables);
        }
        if (this.getKeyDate() != null) {
            restrictions.add(RestrictionType.KEY_DATE, this.getKeyDate());
        }
        restrictions.add(RestrictionType.SUPRESS_NULLS, this.getSupressNulls());
    }

    @Override
    public String getMemberName(ICacheKey memberKey) {
        String name = null;
        try {
            name = this.getSAL().getMemberUniqueNameFromCache(memberKey);
            if (name.length() != 0 && name.lastIndexOf(91) != -1) {
                name = name.substring(name.lastIndexOf(91) + 1, name.length() - 1);
            }
        }
        catch (Exception e) {
            String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo(this);
            if (msTsInfo != null) {
                StringBuilder strBldr = new StringBuilder("SAL exception encountered during member name retrieval");
                strBldr.append(msTsInfo);
                mMSErrorLogger.log(strBldr.toString());
            }
            throw XQERuntimeException.wrap(e);
        }
        return name;
    }

    @Override
    public String getCachedMUNPropName() {
        return "SAP_BUSINESS_KEY";
    }

    @Override
    protected boolean hasInconsistentMeasureValues() {
        return true;
    }

    @Override
    protected boolean supportsPartialLoadingOfPropertiesForCachedMembers() {
        return true;
    }

    @Override
    public boolean addToWhereCondition(IDimension dim, IMember member) {
        if (!dim.isMeasuresDimension()) {
            IMember m1 = null;
            IHierarchy hier = ((LOLAPHierarchy)member.getHierarchy()).getModelHierarchy();
            if (hier.getUniqueName().equals(dim.getUniqueName()) && (m1 = hier.getRootMember()) == null) {
                m1 = hier.getDefaultMember();
            }
            String uniqueName = member.getUniqueName();
            if (m1 != null) {
                if (uniqueName.equals(m1.getUniqueName())) {
                    return false;
                }
                m1 = hier.getDefaultMember();
                if (uniqueName.equals(m1.getUniqueName())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ICacheKey getSingleMemberFromCache(LOLAPDimension dim, LOLAPHierarchy hier, String mun) {
        IRestrictions restrictions = this.getCubeRestrictions();
        String dun = null;
        String hun = null;
        if (hier == null) {
            int memberNameEndNdx = mun.indexOf("].[") + 1;
            if (memberNameEndNdx <= 2) {
                return null;
            }
            hun = mun.substring(0, memberNameEndNdx);
        } else {
            hun = hier.getExternalName();
        }
        if (dim == null) {
            IHierarchy iHierarchy = null;
            int dimCnt = this.getDimensionCount();
            for (int i = 0; i < dimCnt && iHierarchy == null; ++i) {
                iHierarchy = this.getDimension(i).getHierarchy(hun);
            }
            if (iHierarchy == null) {
                return null;
            }
            dun = ((LOLAPDimension)iHierarchy.getDimension()).getExternalName();
        } else {
            dun = dim.getExternalName();
        }
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hun);
        restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, mun);
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMSELFANCESTORS);
        return this.getSecuredMetadataProvider().collectSingleMemberInCache(restrictions);
    }

    @Override
    public boolean isCubeExistOnDataSource() {
        List<CubeRecord> cubes;
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, this.getCatalogName());
        restrictions.add(RestrictionType.CUBE, this.getName());
        if (this.getKeyDate() != null) {
            restrictions.add(RestrictionType.KEY_DATE, this.getKeyDate());
        }
        return (cubes = this.getSecuredMetadataProvider().getCubes(restrictions)).size() != 0;
    }

    @Override
    protected IHierarchy getDefaultHierarchy(IDimension dimension) {
        IDimension modelDimension = ((LOLAPDimension)dimension).getModelDimension();
        List<IHierarchy> hierarchies = dimension.getHierarchies();
        if (!modelDimension.isMeasuresDimension()) {
            Hierarchy h;
            int i;
            IHierarchy hierarchy = modelDimension.getDefaultHierarchy();
            for (i = 0; i < hierarchies.size(); ++i) {
                h = (Hierarchy)hierarchies.get(i);
                if (!h.getUniqueName().equals(hierarchy.getUniqueName())) continue;
                if (h.isMultiRoot() || h.getLevels().size() > 2) break;
                return h;
            }
            for (i = 0; i < hierarchies.size(); ++i) {
                h = (Hierarchy)hierarchies.get(i);
                if (!h.getUniqueName().equals(dimension.getUniqueName())) continue;
                if (h.isMultiRoot() || h.getLevels().size() > 2) break;
                return h;
            }
        }
        if (hierarchies.size() > 0) {
            return hierarchies.get(0);
        }
        return null;
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        return ICube.CubeTypeEnum.SAP;
    }

    @Override
    public String getCubeCurrentPeriod() {
        return null;
    }
}

