/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMDXQuery;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Dimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.OrderedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;

public class LOLAPTM1Cube
extends LOLAPCube {
    private static final String RUN_LOCALE = "runLocale";
    private static final String VALUE = "value";
    private static final String COMMA_OPEN_BRACKET_STR = ", [";
    private static final String DOT_OPEN_BRACKET_STR = ".[";
    protected static final String NEWLINE_STR = "\n";
    public static final String PROPERTY_TM1RULEDERIVED = "TM1RULEDERIVED";
    private static final String CONFIG_FLAG_USE_NULL_SUPPRESSION = "queryExecution.useSuppressionInTM1LOLAPDataQueries[@value]";
    private static final String IS_UNDERFED_PROPERTY = "IsUnderFed";
    private static final String TM1_SERVER_VERSION = "TM1ServerVersion";
    private Map<String, String> mDimensionProperties;
    private String mdxDefaultDimensionPropsClause;
    private boolean nullSuppressionAllowed;
    private boolean cubeIsUnderFed = false;
    private static final String PROP_STRING_NONE = "none";
    private List<String> mProjectLocales = null;
    private CubeRecord mModelCubeRecord;
    private String mTM1ServerVersion = null;

    public LOLAPTM1Cube(ICatalog catalog, ICube modelCube, IDataSource dataSource, String keyDate, MemberStorage memberStore, List<IMeasure> mdxQueryReferencedMeasures, String suppressQueryhint) throws ProviderException {
        super(catalog, modelCube, dataSource, keyDate, memberStore);
        this.setDimensionPropList();
        if (!mdxQueryReferencedMeasures.isEmpty()) {
            this.setMeasureInfo(mdxQueryReferencedMeasures);
        }
        this.resolveNullSuppressionAllowed(suppressQueryhint);
        this.mProjectLocales = this.getProjectLocales(dataSource);
    }

    private void resolveNullSuppressionAllowed(String suppressQueryhint) {
        this.nullSuppressionAllowed = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBooleanProperty(CONFIG_FLAG_USE_NULL_SUPPRESSION, true);
        if (!this.nullSuppressionAllowed) {
            return;
        }
        Boolean checkSuppressQueryHint = LOLAPTM1QueryStrategy.checkSuppressQueryHintForTMR();
        if (checkSuppressQueryHint.booleanValue() && PROP_STRING_NONE.equalsIgnoreCase(suppressQueryhint)) {
            this.nullSuppressionAllowed = false;
            return;
        }
        if (DataSourceTypeEnum.isTMR(this.getDatasourceType())) {
            CubeRecord cubeRecord = this.getModelCubeRecord();
            if (cubeRecord != null) {
                if (cubeRecord.getDynamicField(IS_UNDERFED_PROPERTY) != null && cubeRecord.getDynamicFieldAsBoolean(IS_UNDERFED_PROPERTY).booleanValue()) {
                    this.cubeIsUnderFed = true;
                }
                return;
            }
        } else {
            IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(this.runtreeDataSource.getType());
            MetadataQueryArguments metadataArgs = new MetadataQueryArguments(this.runtreeDataSource, this.getExecutionEnvironment(), null);
            IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(metadataArgs);
            MetadataRestriction restrictions = new MetadataRestriction();
            restrictions.add(RestrictionType.CATALOG, this.getName());
            List<CubeRecord> cubeRecords = metadataProvider.getCubes(restrictions);
            for (CubeRecord cubeRecord : cubeRecords) {
                if (!cubeRecord.getName().equals(this.modelCube.getName())) continue;
                if (cubeRecord.getDynamicField(IS_UNDERFED_PROPERTY) != null && cubeRecord.getDynamicFieldAsBoolean(IS_UNDERFED_PROPERTY).booleanValue()) {
                    this.cubeIsUnderFed = true;
                }
                return;
            }
        }
        throw new InternalError("Cube \"" + this.modelCube.getName() + "\" not found when checking for IsUnderFed cube attribute.");
    }

    @Override
    public QueryStrategy getQueryStrategy() {
        return new LOLAPTM1QueryStrategy(this);
    }

    @Override
    public void initialiseDimensions() {
        if (!this.dimsInitialised) {
            List<IDimension> otherDims = this.modelCube.getDimensions();
            for (int i = 0; i < otherDims.size(); ++i) {
                IDimension dim = otherDims.get(i);
                String name = dim.getUniqueName();
                if (name.charAt(0) == '[') {
                    name = name.substring(1, name.length() - 1);
                }
                LOLAPTM1Dimension newDim = new LOLAPTM1Dimension(name, this, dim);
                newDim.initialiseHierarchies();
            }
            this.dimsInitialised = true;
        }
    }

    public boolean isNullSuppressionAllowed() {
        return this.nullSuppressionAllowed;
    }

    @Override
    public String getMDXMemberUniqueName(IMember member) {
        return member.getUniqueName();
    }

    public String getCubicsMUN(String providerMUN, Map<String, String> essMemberNameToUName) {
        return providerMUN;
    }

    @Override
    public String getMDXAxisAttributes(int axisNum) {
        StringBuilder axisName = new StringBuilder();
        axisName.append(" DIMENSION PROPERTIES ");
        axisName.append(this.mdxDefaultDimensionPropsClause);
        axisName.append(" ON Axis(");
        axisName.append(axisNum);
        axisName.append(")");
        return axisName.toString();
    }

    @Override
    public String getMDXFromClause() {
        return " FROM [" + this.getName() + "]";
    }

    @Override
    public String getMDXQueryAttributes() {
        return " CELL PROPERTIES CELL_ORDINAL, VALUE, FORMAT_STRING";
    }

    @Override
    public void updateMeasuresLevelInfo(LOLAPLevel level) {
    }

    @Override
    public int getCorrespondingLOLAPLevelIndex(IHierarchy hierarchy, int providerLevelIndex) {
        return providerLevelIndex;
    }

    @Override
    public void loadMemberProperties(LOLAPLevel level) {
    }

    @Override
    public IRestrictions getCubeRestrictions() {
        IRestrictions restrictions = super.getCubeRestrictions();
        this.addProjectLocalesRestriction(restrictions);
        return restrictions;
    }

    @Override
    public void addProviderSpecificRestrictions(IRestrictions restrictions) {
        restrictions.add(RestrictionType.CUBE_OBJECT, this.modelCube);
        Boolean useMetadataCall = this.getUseMetadataCallOnly();
        if (useMetadataCall != null) {
            restrictions.add(RestrictionType.USE_METADATA_CALL_ONLY, useMetadataCall);
        }
        if (this.getKeyDate() != null) {
            restrictions.add(RestrictionType.KEY_DATE, this.getKeyDate());
        }
        restrictions.add(RestrictionType.SUPRESS_NULLS, this.getSupressNulls());
        this.addProjectLocalesRestriction(restrictions);
    }

    @Override
    public String getMemberName(ICacheKey memberKey) {
        String name = null;
        try {
            name = this.getSAL().getMemberNameFromCache(memberKey, this.getCubeRestrictionsReference());
        }
        catch (Exception e) {
            String msTsInfo = LOLAPMemberProxy.gatherMemberStorageTimestampInfo(this);
            if (msTsInfo != null) {
                StringBuilder strBldr = new StringBuilder("SAL exception encountered during member name retrieval");
                strBldr.append(msTsInfo);
                mMSErrorLogger.log(strBldr.toString());
            }
            throw XQERuntimeException.wrap(e);
        }
        return name;
    }

    @Override
    public ICacheKey getSingleMemberFromCache(LOLAPDimension dim, LOLAPHierarchy hier, String mun) {
        IRestrictions restrictions = this.getCubeRestrictions();
        String dun = null;
        String hun = null;
        if (dim == null) {
            int dimNameEndNdx = mun.indexOf("]");
            if (dimNameEndNdx <= 0) {
                return null;
            }
            dun = mun.substring(0, dimNameEndNdx + 1);
        } else {
            dun = dim.getExternalName();
        }
        if (hier == null) {
            int memberNameStartNdx = mun.lastIndexOf(DOT_OPEN_BRACKET_STR);
            if (memberNameStartNdx <= 2) {
                return null;
            }
            hun = mun.substring(0, memberNameStartNdx);
            int atMemberIdx = hun.indexOf(".[@MEMBER]");
            if (atMemberIdx != -1) {
                hun = hun.substring(0, atMemberIdx);
            }
        } else {
            hun = hier.getExternalName();
        }
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dun);
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, hun);
        restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, mun);
        this.addProjectLocalesRestriction(restrictions);
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMSELFANCESTORS);
        return this.getSecuredMetadataProvider().collectSingleMemberInCache(restrictions);
    }

    @Override
    public String prepareMDXMemberName(LOLAPHierarchy hier, String memberName) {
        if (memberName.length() == 0 || memberName.trim().length() == 0) {
            return null;
        }
        String datasourceType = this.getDatasourceType();
        StringBuilder mdxMemberName = new StringBuilder();
        mdxMemberName.append(hier.getExternalName());
        if (DataSourceTypeEnum.isTM1(datasourceType)) {
            mdxMemberName.append(".[@MEMBER]");
        }
        mdxMemberName.append(DOT_OPEN_BRACKET_STR);
        mdxMemberName.append(memberName);
        mdxMemberName.append("]");
        return mdxMemberName.toString();
    }

    @Override
    protected boolean hasInconsistentMeasureValues() {
        return true;
    }

    @Override
    protected boolean supportsPartialLoadingOfPropertiesForCachedMembers() {
        return true;
    }

    @Override
    public boolean addToWhereCondition(IDimension dim, IMember member) {
        String defaultMemberUniqueName;
        IHierarchy hier;
        if (member.getHierarchy().isMultiRoot()) {
            return true;
        }
        IHierarchy defaultHierarchy = dim.getDefaultHierarchy();
        if (!defaultHierarchy.equals(hier = member.getHierarchy())) {
            return true;
        }
        String uniqueName = member.getUniqueName();
        return !uniqueName.equals(defaultMemberUniqueName = defaultHierarchy.getDefaultMember().getUniqueName()) || defaultHierarchy.getRootMember() == null || !defaultHierarchy.getRootMember().getUniqueName().equals(defaultMemberUniqueName);
    }

    @Override
    public boolean isCubeExistOnDataSource() {
        CubeRecord cubeRecord = this.getModelCubeRecord();
        return cubeRecord != null;
    }

    @Override
    protected IHierarchy getDefaultHierarchy(IDimension dimension) {
        IDimension modelDimension = ((LOLAPDimension)dimension).getModelDimension();
        List<IHierarchy> hierarchies = dimension.getHierarchies();
        if (!modelDimension.isMeasuresDimension()) {
            Hierarchy h;
            int i;
            IHierarchy hierarchy = modelDimension.getDefaultHierarchy();
            for (i = 0; i < hierarchies.size(); ++i) {
                h = (Hierarchy)hierarchies.get(i);
                if (!h.getUniqueName().equals(hierarchy.getUniqueName())) continue;
                if (h.isMultiRoot() || h.getLevels().size() > 2) break;
                return h;
            }
            for (i = 0; i < hierarchies.size(); ++i) {
                h = (Hierarchy)hierarchies.get(i);
                if (!h.getUniqueName().equals(dimension.getUniqueName())) continue;
                if (h.isMultiRoot() || h.getLevels().size() > 2) break;
                return h;
            }
        }
        if (hierarchies.size() > 0) {
            return hierarchies.get(0);
        }
        return null;
    }

    @Override
    public boolean isMemberAnAttribute(String propertyName, ILevel level) {
        LOLAPLevel levelLOLAP = (LOLAPLevel)level;
        String propName = propertyName;
        if (propertyName.contains("[")) {
            propName = propName.substring(propName.lastIndexOf("[") + 1, propName.length() - 1);
        }
        return levelLOLAP.isValidPropertyName(propName);
    }

    @Override
    public String getAttributeUniqueName(String propertyName, ILevel level) {
        if (!propertyName.startsWith("[")) {
            return level.getDimension().getUniqueName() + DOT_OPEN_BRACKET_STR + propertyName + "]";
        }
        return propertyName;
    }

    @Override
    public boolean supportAttributeDimensionProperties() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, Object> getAttributeValuesForMembers(String propertyName, IMember[] mArray) {
        String uniqueName;
        int i;
        int len;
        LOLAPLevel level = (LOLAPLevel)mArray[0].getLevel();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, IMember> memberMap = new HashMap<String, IMember>();
        String propUniqueName = this.getAttributeUniqueName(propertyName, level);
        Boolean useNativeEngine = LOLAPTM1QueryStrategy.useNativeTM1Engine(this.getDatasourceType());
        StringBuilder mdx = new StringBuilder();
        if (!useNativeEngine.booleanValue()) {
            mdx.append("<md:MDQuerySpec xmlns:md=\"http://developer.cognos.com/schemas/mds/1/\" xmlns:xsi=\"http://www. w3.org/2001/XMLSchema-instance\"> \t \n");
            len = mArray.length;
            mdx.append(" <edge edgeID=\"1\" name=\"axis(0)\"> ");
            mdx.append("<apply>\t<set/>");
            for (i = 0; i < len; ++i) {
                memberMap.put(Integer.toString(i), mArray[i]);
                mdx.append("<ci type=\"qs:member\">");
                uniqueName = this.getMDXMemberUniqueName(mArray[i]);
                mdx.append(uniqueName);
                mdx.append("</ci>");
            }
            mdx.append("</apply> ");
            mdx.append("\t<dimensionProperties>\t<ci type=\"qs:property\">" + propUniqueName + "</ci>\t</dimensionProperties>\t</edge>");
            mdx.append("<ci type=\"qs:catalog\">" + this.getCatalogName() + "</ci>  ");
            mdx.append("<ci type=\"qs:cube\">" + this.getName() + "</ci></md:MDQuerySpec>");
        } else {
            mdx.append("NativeTM1Query:");
            mdx.append(NEWLINE_STR);
            mdx.append("SELECT");
            mdx.append(NEWLINE_STR);
            mdx.append("{");
            mdx.append(" ");
            len = mArray.length;
            for (i = 0; i < len; ++i) {
                memberMap.put(Integer.toString(i), mArray[i]);
                uniqueName = this.getMDXMemberUniqueName(mArray[i]);
                mdx.append(uniqueName);
                if (i >= len - 1) continue;
                mdx.append(", ");
                mdx.append(" ");
            }
            mdx.append(" ");
            mdx.append("}");
            mdx.append(" ");
            mdx.append("DIMENSION PROPERTIES");
            mdx.append(" ");
            mdx.append("PARENT_UNIQUE_NAME");
            mdx.append(", ");
            mdx.append("PARENT_LEVEL");
            mdx.append(" ");
            mdx.append("ON AXIS");
            mdx.append("(");
            mdx.append(0);
            mdx.append(")");
            mdx.append(NEWLINE_STR);
            mdx.append("FROM");
            mdx.append(" ");
            mdx.append("[");
            mdx.append(this.getName());
            mdx.append("]");
        }
        OrderedMap<String> properties = new OrderedMap<String>();
        properties.put("Format", "Multidimensional");
        properties.put("AxisFormat", "TupleFormat");
        properties.put("Content", "Data");
        XQEDebugLog.out.println("MDX: " + mdx.toString());
        ArrayList<IHierarchy> hierarchySet = new ArrayList<IHierarchy>();
        LOLAPMDXQuery mdxQuery = new LOLAPMDXQuery(mdx.toString(), this, hierarchySet);
        ICubeResultSet cubeResult = this.performExecuteRequest(mdxQuery, properties, this);
        int tupCnt = 0;
        if (propUniqueName.contains("[")) {
            propUniqueName = propUniqueName.substring(propUniqueName.lastIndexOf("[") + 1, propUniqueName.length() - 1);
        }
        XIterator it = cubeResult.getAxisIterator(0);
        try {
            ITuple tuple = null;
            while ((tuple = (ITuple)it.next()) != null) {
                IMember member = tuple.getMember(0);
                Object val = member.getProperty(propUniqueName);
                String memberUniqueName = null;
                memberUniqueName = tuple.getMember(0).getUniqueName().equalsIgnoreCase(tuple.getMember(0).getDimension().getUniqueName()) ? tuple.getMember(0).getUniqueName() : ((IMember)memberMap.get(Integer.toString(tupCnt))).getUniqueName();
                resultMap.put(memberUniqueName, val);
                ++tupCnt;
            }
        }
        finally {
            if (it != null) {
                it.release();
            }
            if (cubeResult != null) {
                cubeResult.release();
            }
        }
        return resultMap;
    }

    public List<IAliasEntry> getAliasTableEntries() {
        IAlias alias = this.modelCube.getModelDataSource().getAlias();
        List<IAliasEntry> aliasentries = alias.getAliasEntries();
        Iterator<IAliasEntry> it = aliasentries.iterator();
        String runLocaleString = null;
        String runLocaleLanguage = null;
        ExecutionEnvironment environment = this.getExecutionEnvironment();
        Element connectionElement = environment.getConnectionElement();
        if (connectionElement != null) {
            Element runLocaleElement = null;
            runLocaleElement = connectionElement.element(RUN_LOCALE);
            if (runLocaleElement != null) {
                runLocaleString = runLocaleElement.attributeValue(VALUE);
                int i = runLocaleString.indexOf(45);
                runLocaleLanguage = i >= 0 ? runLocaleString.substring(0, i) : runLocaleString;
            }
        }
        if (runLocaleString == null) {
            runLocaleString = LocaleConverter.getLanguage(((RequestEnvironment)environment.getRequestEnvironment()).getRunLocale());
        }
        ArrayList<IAliasEntry> aliasTable = new ArrayList<IAliasEntry>();
        IAliasEntry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            if (!entry.getKey().equalsIgnoreCase(runLocaleLanguage)) continue;
            aliasTable.add(entry);
        }
        return aliasTable;
    }

    private void setDimensionPropList() {
        IAlias alias = this.modelCube.getModelDataSource().getAlias();
        IAliasEntry entry = null;
        this.mDimensionProperties = new HashMap<String, String>();
        String[] propsToAdd = new String[]{"ANCESTOR_NAMES", "LEVEL_NUMBER", "GEN_NUMBER", "MEMBER_ALIAS"};
        this.mdxDefaultDimensionPropsClause = "[" + propsToAdd[0] + "]";
        for (int i = 0; i < propsToAdd.length; ++i) {
            this.mDimensionProperties.put(propsToAdd[i], propsToAdd[i]);
            if (i <= 0) continue;
            this.mdxDefaultDimensionPropsClause = this.mdxDefaultDimensionPropsClause + COMMA_OPEN_BRACKET_STR + propsToAdd[i] + "]";
        }
        if (alias != null) {
            List<IAliasEntry> aliasentries = alias.getAliasEntries();
            Iterator<IAliasEntry> it = aliasentries.iterator();
            LinkedHashMap<String, String> aliasTableMap = new LinkedHashMap<String, String>();
            if (ICube.CubeTypeEnum.TM1 == this.getType()) {
                while (it.hasNext()) {
                    entry = it.next();
                    if (!aliasTableMap.containsKey(entry.getKey())) {
                        aliasTableMap.put(entry.getKey(), entry.getValue());
                    } else {
                        aliasTableMap.put(entry.getKey(), (String)aliasTableMap.get(entry.getKey()) + ";" + entry.getValue());
                    }
                    if (this.mDimensionProperties.containsKey(entry.getValue().toUpperCase())) continue;
                    this.mDimensionProperties.put(entry.getValue().toUpperCase(), entry.getValue());
                }
            } else if (ICube.CubeTypeEnum.TMR == this.getType()) {
                for (String locale : this.getProjectLocales(this.runtreeDataSource)) {
                    aliasTableMap.put(locale, "");
                }
            }
            if (this.getSAL().getMemberStorage().getSupportedLocales() == null) {
                this.getSAL().getMemberStorage().initSupportedLocales(aliasTableMap);
            }
        }
    }

    @Override
    public boolean trustProviderCaption() {
        return true;
    }

    @Override
    public IDimension queryDimension(String dimensionUName) {
        return null;
    }

    @Override
    public boolean hasSAPReplacementVariable() {
        return false;
    }

    @Override
    public boolean isReplacementVariableUsed(IDimension dimension) {
        return false;
    }

    @Override
    public ICube.CubeTypeEnum getType() {
        if (DataSourceTypeEnum.isTMR(this.getDatasourceType())) {
            return ICube.CubeTypeEnum.TMR;
        }
        return ICube.CubeTypeEnum.TM1;
    }

    @Override
    public boolean multipleHierarchySupport() {
        return DataSourceTypeEnum.isTMR(this.getDatasourceType());
    }

    @Override
    public String getCubeCurrentPeriod() {
        return null;
    }

    public boolean isCubeUnderFed() {
        return this.cubeIsUnderFed;
    }

    public String getTM1ServerVersion() {
        if (this.mTM1ServerVersion != null) {
            return this.mTM1ServerVersion;
        }
        CubeRecord cubeRecord = this.getModelCubeRecord();
        if (cubeRecord != null && cubeRecord.getDynamicField(TM1_SERVER_VERSION) != null) {
            this.mTM1ServerVersion = cubeRecord.getDynamicFieldAsString(TM1_SERVER_VERSION);
        }
        return this.mTM1ServerVersion;
    }

    private List<String> getProjectLocales(IDataSource dataSource) {
        if (null == dataSource) {
            return null;
        }
        Map<String, Object> metadataProperties = dataSource.getMetadataProperties();
        Set projectLocales = (Set)metadataProperties.get("project_locales");
        if (projectLocales != null && !projectLocales.isEmpty()) {
            ArrayList<String> locales = new ArrayList<String>(projectLocales);
            return locales;
        }
        return null;
    }

    private void addProjectLocalesRestriction(IRestrictions restrictions) {
        if (null == this.mProjectLocales) {
            this.mProjectLocales = this.getProjectLocales(this.runtreeDataSource);
        }
        if (null == this.mProjectLocales || this.mProjectLocales.isEmpty()) {
            return;
        }
        restrictions.add(RestrictionType.PROJECT_LOCALES, this.mProjectLocales);
    }

    private CubeRecord getModelCubeRecord() {
        List<CubeRecord> cubes;
        if (this.mModelCubeRecord != null) {
            return this.mModelCubeRecord;
        }
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, this.getCatalogName());
        restrictions.add(RestrictionType.CUBE, this.modelCube.getName());
        this.addProjectLocalesRestriction(restrictions);
        if (this.getKeyDate() != null) {
            restrictions.add(RestrictionType.KEY_DATE, this.getKeyDate());
        }
        if ((cubes = this.getSecuredMetadataProvider().getCubes(restrictions)).isEmpty()) {
            return null;
        }
        this.mModelCubeRecord = cubes.get(0);
        return this.mModelCubeRecord;
    }
}

