/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1;

import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.securecache.SecurityAwareLayer;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class LOLAPTM1Hierarchy
extends LOLAPHierarchy {
    private List<IMember> rootMembers;
    private HashMap<String, IMember[]> subsets = new HashMap();
    private static final String CACHE_TM1_SUBSETS = "queryExecution.cacheTM1Subsets[@value]";

    public LOLAPTM1Hierarchy(String name, LOLAPDimension dimension, IHierarchy theModelHierarchy) {
        super(name, dimension, theModelHierarchy, false);
    }

    public LOLAPTM1Hierarchy(String name, LOLAPDimension dimension, IHierarchy theModelHierarchy, boolean setHierarchyWithDefaultHierarchy) {
        super(name, dimension, theModelHierarchy, setHierarchyWithDefaultHierarchy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initDefaultMember() throws MetadataException {
        IMember member = null;
        if (this.getDimension().getType() == DimensionTypeEnum.INTERNAL) {
            this.setDefaultMember(((Level)this.getLevel(0)).getMember(0));
            return;
        }
        LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
        IMember mfwDefaultMem = this.modelHierarchy.getDefaultMember();
        ICacheKey memberKey = null;
        String mdxName = mfwDefaultMem.getUniqueName();
        memberKey = cube.getSingleMemberFromCache((LOLAPDimension)this.getDimension(), this, mdxName);
        if (memberKey == null) {
            mfwDefaultMem = this.modelHierarchy.getDefaultMemberFromProvider();
            memberKey = cube.getSingleMemberFromCache((LOLAPDimension)this.getDimension(), this, mfwDefaultMem.getUniqueName());
        }
        if (memberKey == null) {
            throw new InternalError("Error retrieving default member. Hierarchy: " + this.getExternalName());
        }
        SecurityAwareLayer sal = cube.getSAL();
        Level level = (Level)this.getLevel(sal.getMemberLevelIndexFromCache(memberKey));
        String memberName = cube.getMemberName(memberKey);
        int memberId = sal.getMemberIdFromCache(memberKey);
        Level level2 = level;
        synchronized (level2) {
            member = level.getMember(memberName, memberId);
            if (member == null) {
                if (this.getDimension().isMeasuresDimension()) {
                    member = new LOLAPMeasure((IMeasure)mfwDefaultMem, (ILevel)level);
                    cube.cacheLOLAPMeasure((LOLAPMeasure)member);
                } else {
                    member = LOLAPMemberProxy.initMemberProxy(memberKey, level);
                }
            }
        }
        this.setDefaultMember(member);
    }

    @Override
    public void initializeLevels() {
        LOLAPDimension dim = (LOLAPDimension)this.getDimension();
        if (!dim.isDefaultHierarchyExistInModel()) {
            this.modelHierarchy.getLevels();
        }
        int levelCount = this.modelHierarchy.getLevelCount();
        for (int i = 0; i < levelCount; ++i) {
            ILevel level = this.modelHierarchy.getLevel(i);
            new LOLAPTM1Level(level.getName(), this, level);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<IMember> getVisibleRoots() {
        if (this.getDimension().isMeasuresDimension()) {
            return super.getVisibleRoots();
        }
        if (this.rootMembers == null) {
            ArrayList<IMember> roots = new ArrayList<IMember>();
            if (this.modelHierarchy.getRootMember() != null) {
                IMember member;
                Level level;
                ICacheKey memberKey = null;
                IMember mfwRootMem = this.modelHierarchy.getRootMember();
                String mdxName = mfwRootMem.getUniqueName();
                LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
                memberKey = cube.getSingleMemberFromCache((LOLAPDimension)this.getDimension(), this, mdxName);
                SecurityAwareLayer sal = cube.getSAL();
                int memberId = sal.getMemberIdFromCache(memberKey);
                String memberName = cube.getMemberName(memberKey);
                Level level2 = level = (Level)this.getLevel(sal.getMemberLevelIndexFromCache(memberKey));
                synchronized (level2) {
                    member = level.getMember(memberName, memberId);
                    if (member == null) {
                        member = LOLAPMemberProxy.initMemberProxy(memberKey, level);
                    }
                }
                roots.add(member);
            } else {
                LOLAPDimension dim = (LOLAPDimension)this.getDimension();
                LOLAPCube cube = (LOLAPCube)dim.getCube();
                IRestrictions restrictions = cube.getCubeRestrictions();
                String dimName = dim.getExternalName();
                restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, dimName);
                restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getExternalName());
                List<MemberRecord> rootRecords = cube.getSecuredMetadataProvider().getSAL().getHierarchyVisibleRoots(cube.getSecuredMetadataProvider().getUserId(), restrictions);
                for (MemberRecord record : rootRecords) {
                    IMember member;
                    Level level;
                    ICacheKey memberKey = null;
                    String mdxName = record.getUniqueName();
                    memberKey = cube.getSingleMemberFromCache((LOLAPDimension)this.getDimension(), this, mdxName);
                    SecurityAwareLayer sal = cube.getSAL();
                    int memberId = sal.getMemberIdFromCache(memberKey);
                    String memberName = cube.getMemberName(memberKey);
                    Level level3 = level = (Level)this.getLevel(record.getLevelNumber());
                    synchronized (level3) {
                        member = level.getMember(memberName, memberId);
                        if (member == null) {
                            member = LOLAPMemberProxy.initMemberProxy(memberKey, level);
                        }
                    }
                    roots.add(member);
                }
            }
            this.rootMembers = roots;
        }
        return this.rootMembers;
    }

    @Override
    public boolean isMultiRoot() {
        if (this.isMultiRoot == null) {
            this.isMultiRoot = this.modelHierarchy.isMultiRoot();
        }
        return this.isMultiRoot;
    }

    @Override
    public IMember[] getMembers() {
        if (this.allMembers == null) {
            for (ILevel level : this.getLevels()) {
                level.getMembers();
            }
        }
        return super.getMembers();
    }

    @Override
    public IMember[] getHierarchyNamedSetMembers(String[] identifiers) {
        IMember[] propertiesList;
        LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
        if (!DataSourceTypeEnum.isTMR(cube.getDatasourceType()) || this.getDimension().isMeasuresDimension()) {
            return null;
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean bCacheTM1Subsets = configuration.getBooleanProperty(CACHE_TM1_SUBSETS, false);
        String namedSetName = "";
        if (bCacheTM1Subsets) {
            propertiesList = LOLAPMemberProxy.getDimenstionProperties(this.getDimension().getUniqueName());
            StringBuilder properties = new StringBuilder();
            if (propertiesList != null) {
                for (String string : propertiesList) {
                    if (properties.length() == 0) {
                        properties.append(string);
                        continue;
                    }
                    properties.append(",");
                    properties.append(string);
                }
            }
            namedSetName = UniqueNameGenerator.createUniqueName(identifiers) + properties.toString();
        }
        this.membersLock.writeLock().lock();
        try {
            if (bCacheTM1Subsets && this.subsets.containsKey(namedSetName)) {
                propertiesList = this.subsets.get(namedSetName);
                return propertiesList;
            }
            IMember[] members = this.initHierarchyNamedSetMembers(cube, identifiers);
            if (bCacheTM1Subsets) {
                this.subsets.put(namedSetName, members);
            }
            IMember[] iMemberArray = members;
            return iMemberArray;
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        finally {
            this.membersLock.writeLock().unlock();
        }
    }

    private IMember[] initHierarchyNamedSetMembers(LOLAPCube cube, String[] identifiers) {
        List<HierarchyNamedSetRecord> namedSets;
        String namedSetUniqueName = UniqueNameGenerator.createUniqueName(identifiers);
        IRestrictions restrictions = cube.getCubeRestrictions();
        restrictions.add(RestrictionType.DATA_QUERY, true);
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        restrictions.add(RestrictionType.SET, namedSetUniqueName);
        Set<String> propertiesList = LOLAPMemberProxy.getDimenstionProperties(this.getDimension().getUniqueName());
        if (propertiesList != null) {
            StringBuilder properties = new StringBuilder();
            for (String prop : propertiesList) {
                if (properties.length() == 0) {
                    properties.append(prop);
                    continue;
                }
                properties.append(", ");
                properties.append(prop);
            }
            restrictions.add(RestrictionType.DIMENSION_PROPERTIES, properties.toString());
        }
        if ((namedSets = cube.getSecuredMetadataProvider().getHierarchyNamedSets(restrictions)).isEmpty()) {
            return null;
        }
        List<MemberRecord> memberRecords = cube.getSecuredMetadataProvider().getNamedSetMembers(restrictions);
        IMember[] members = new IMember[memberRecords.size()];
        int memIndex = 0;
        SecurityAwareLayer sal = cube.getSAL();
        boolean loadAncestors = false;
        for (MemberRecord record : memberRecords) {
            LOLAPMemberProxy member;
            int memberId;
            ICacheKey key;
            Level level = (Level)this.getLevel(record.getLevelNumber());
            String retrievedDimProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
            TreeSet<String> retrievedPropNames = null;
            if (retrievedDimProperties != null) {
                retrievedPropNames = sal.getProperties(retrievedDimProperties);
            }
            if ((key = sal.getCachedKey(record.getUniqueName())) != null) {
                sal.updateCachedMemberProperties(retrievedPropNames, record);
                memberId = sal.getMemberIdFromCache(key);
                String name = cube.getMemberName(key);
                member = (LOLAPMemberProxy)level.getMember(name, memberId);
                if (member != null) {
                    members[memIndex++] = member;
                    continue;
                }
            }
            loadAncestors = true;
            member = new LOLAPMemberProxy(record, (ILevel)level);
            members[memIndex++] = member;
            ICacheKey cacheKey = LOLAPMemberProxy.cacheAlreadyRetrievedMember(member, cube, record);
            member.setCacheKey(cacheKey);
            memberId = sal.getMemberIdFromCache(cacheKey);
            member.setMemberId(memberId);
            level.addMember(member);
        }
        if (loadAncestors) {
            this.fetchNamedSetAncestors(members, restrictions);
        }
        return members;
    }

    private void fetchNamedSetAncestors(IMember[] members, IRestrictions restrictions) {
        LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
        SecurityAwareLayer sal = cube.getSAL();
        restrictions.add(RestrictionType.TREEOP, MetadataUtil.TREEOPENUMANCESTORS);
        List<MemberRecord> ancestorMemberRecords = cube.getSecuredMetadataProvider().getNamedSetMembers(restrictions);
        if (ancestorMemberRecords.isEmpty()) {
            return;
        }
        HashMap<String, MemberRecord> mapAncestorRecords = new HashMap<String, MemberRecord>();
        for (MemberRecord member : ancestorMemberRecords) {
            mapAncestorRecords.put(member.getUniqueName(), member);
        }
        HashMap<String, IMember> mapAncestorMembers = new HashMap<String, IMember>();
        String retrievedDimProperties = restrictions.getValueOf(RestrictionType.DIMENSION_PROPERTIES, null);
        TreeSet<String> retrievedPropNames = null;
        if (retrievedDimProperties != null) {
            retrievedPropNames = sal.getProperties(retrievedDimProperties);
        }
        this.updateParentRecords(members, mapAncestorRecords, mapAncestorMembers, retrievedPropNames);
    }

    private void updateParentRecords(IMember[] members, HashMap<String, MemberRecord> mapAncestorRecords, HashMap<String, IMember> mapAncestorMembers, TreeSet<String> retrievedPropNames) {
        LOLAPCube cube = (LOLAPCube)this.getDimension().getCube();
        SecurityAwareLayer sal = cube.getSAL();
        for (IMember member : members) {
            String parentUniqueName = member.getParentUniqueName();
            MemberRecord parent = mapAncestorRecords.get(parentUniqueName);
            if (parent == null) continue;
            LOLAPMemberProxy parentMember = (LOLAPMemberProxy)mapAncestorMembers.get(parent.getUniqueName());
            if (parentMember == null) {
                ICacheKey key = sal.getCachedKey(parentUniqueName);
                Level level = (Level)this.getLevel(parent.getLevelNumber());
                if (key != null) {
                    sal.updateCachedMemberProperties(retrievedPropNames, parent);
                    int memberId = sal.getMemberIdFromCache(key);
                    String name = cube.getMemberName(key);
                    parentMember = (LOLAPMemberProxy)level.getMember(name, memberId);
                }
                if (parentMember == null) {
                    parentMember = new LOLAPMemberProxy(parent, (ILevel)level);
                    ICacheKey cacheKey = LOLAPMemberProxy.cacheAlreadyRetrievedMember(parentMember, cube, parent);
                    parentMember.setCacheKey(cacheKey);
                    int memberId = sal.getMemberIdFromCache(cacheKey);
                    parentMember.setMemberId(memberId);
                    level.addMember(parentMember);
                }
                IMember[] parentMembers = new IMember[]{parentMember};
                mapAncestorMembers.put(parentMember.getUniqueName(), parentMember);
                this.updateParentRecords(parentMembers, mapAncestorRecords, mapAncestorMembers, retrievedPropNames);
            }
            LOLAPMemberProxy currentMemberItr = (LOLAPMemberProxy)member;
            currentMemberItr.setParentMember(parentMember);
        }
    }
}

