/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.CacheMetricsTracker;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.runtree.olap.mdx.interpreter.LevelCombinationsManager;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberResolver;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.platform.Environment;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.FileUtil;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.SequencedHashMap;

public abstract class Cube
extends Metadata
implements ICube {
    private static final String MEMBER_SEARCH_RESULT = "Member search result = ";
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Cube.class);
    private static final String TRUE = "true";
    public static final int CUBE_CACHEUPDATE_NEVERFLUSH = -1;
    public static final int CUBE_CACHEUPDATE_NEVERCACHE = 0;
    private static final int MEMBER_ID_NEGATIVE_1000000 = -1000000;
    private static final int NUMBER_999999 = 999999;
    protected OrderedMap<IDimension> dimensions;
    private HashMap<String, Hashtable<String, Object>> measureQueryCache;
    private int queryCount;
    private String catalogName;
    private CacheMetricsTracker tupleStorageMetrics;
    private AtomicBoolean temporaryTupleStorageInitialized = new AtomicBoolean(false);
    private AtomicBoolean nullTupleStorageInitialized = new AtomicBoolean(false);
    private ICacheEngine metadataStorage = null;
    private AtomicInteger nextSessionCalculatedMemberID = new AtomicInteger();
    private LevelCombinationsManager levelCombinationsManager;
    private long timestamp;
    private long cacheUpdateInterval = -1L;
    private long cacheTimestamp = System.currentTimeMillis();
    private AtomicLong initializeTimeStamp = new AtomicLong(0L);
    private SecurityManagerInterface securityManager;
    private SequencedHashMap uniqueNameToNamedSet;
    private MemberResolver memberResolver;
    private boolean checkedForSecurityManager = false;
    private Boolean ignoreSingleAxisQueries;
    private static HashMap<String, Provider> cubeClassToProvider = new HashMap();
    protected DateTimeValue schemaUpdatedDate = null;
    protected DateTimeValue dataUpdatedDate = null;
    protected DateTimeValue createdDate = null;
    protected String schemaName = null;
    protected IMeasure defaultMeasure = null;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private AtomicInteger queryId = new AtomicInteger(0);
    private boolean removeNonExistentTuples = false;

    public void lock() {
    }

    public void unlock() {
    }

    @Override
    public boolean getPropagateNulls() {
        return false;
    }

    public synchronized void flushCube(long newCacheTimestamp) {
    }

    @Override
    public String getUniqueName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        String name = this.getName();
        buffer.append(name);
        buffer.append("]");
        return buffer.toString();
    }

    public Object getParent() {
        return null;
    }

    @Override
    public DateTimeValue getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(DateTimeValue theDate) {
        this.createdDate = theDate;
    }

    @Override
    public DateTimeValue getUpdatedDate() {
        return this.dataUpdatedDate;
    }

    @Override
    public final MetadataType getObjectType() {
        return MetadataType.CUBE;
    }

    public void setUpdatedDate(DateTimeValue theDate) {
        this.dataUpdatedDate = theDate;
    }

    public boolean ignoreSingleAxisQueries() {
        if (this.ignoreSingleAxisQueries == null) {
            String ignoreSingleAxisQuery = Environment.getEnvironmentVariable("ignoreSingleAxisQuery");
            String ignoreSingleAxisQuery2 = Environment.getEnvironmentVariable("DigitalAspects/IgnoreSingleAxisQuery");
            this.ignoreSingleAxisQueries = ignoreSingleAxisQuery != null && ignoreSingleAxisQuery.equals(TRUE) || ignoreSingleAxisQuery2 != null && ignoreSingleAxisQuery2.equals(TRUE);
        }
        return this.ignoreSingleAxisQueries;
    }

    public void setTimestamp(long timeStamp) {
        this.timestamp = timeStamp;
    }

    public boolean isSecurityManagerLoaded() {
        return this.securityManager != null;
    }

    public Map<String, INamedSet> getNamedSets() {
        return new SequencedHashMap((Map)this.uniqueNameToNamedSet);
    }

    public Map getCalculatedMembers() {
        return new SequencedHashMap();
    }

    public void addNamedSet(INamedSet ns) {
        this.uniqueNameToNamedSet.put((Object)ns.getName(), (Object)ns);
    }

    public void createMemberResolver(Provider provider) {
        this.memberResolver = new MemberResolver(provider, this);
    }

    public MemberResolver getMemberResolver() {
        return this.memberResolver;
    }

    public void clearMemberResolver() {
        this.memberResolver = null;
    }

    public SecurityManagerInterface getSecurityManager() {
        return this.securityManager;
    }

    public SecurityManagerInterface getSecurityManager(Provider provider) {
        if (!this.checkedForSecurityManager() && !this.isSecurityManagerLoaded()) {
            this.setCheckedForSecurityManager(true);
        }
        return this.securityManager;
    }

    public void setSecurityManager(SecurityManagerInterface securityMgr) {
        this.securityManager = securityMgr;
    }

    public long getCacheTimestamp() {
        return this.cacheTimestamp;
    }

    public void setCacheTimestamp(long cacheTimeStamp) {
        this.cacheTimestamp = cacheTimeStamp;
    }

    public long getCacheUpdateInterval() {
        return this.cacheUpdateInterval;
    }

    public void setCacheUpdateInterval(long cacheUpdateInterv) {
        this.cacheUpdateInterval = cacheUpdateInterv;
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void incrementQueryCount() {
        ++this.queryCount;
    }

    public HashMap<String, Hashtable<String, Object>> getMeasureQueryCache() {
        return this.measureQueryCache;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void initialize() throws ProviderException {
        if (!this.isInitialized()) {
            this.initializeTimeStamp.set(System.currentTimeMillis());
        }
    }

    public boolean isInitialized() {
        return this.initializeTimeStamp.get() != 0L;
    }

    public long getinitializeTimestamp() {
        return this.initializeTimeStamp.get();
    }

    public void printMeasureQueryCache() {
        Set<String> set = this.measureQueryCache.keySet();
        Iterator<String> it = set.iterator();
        XQEDebugLog.out.println("Measure cache :");
        while (it.hasNext()) {
            String s = it.next();
            XQEDebugLog.out.println("\tTuple :" + s + ", value :" + this.measureQueryCache.get(s));
        }
    }

    public void setMeasureQueryCache(String measureName, Hashtable<String, Object> h) {
        this.measureQueryCache.put(measureName, h);
    }

    protected Cube(String n, String catName, long timeStamp) throws ProviderException {
        super(n);
        this.timestamp = timeStamp;
        this.catalogName = catName;
        this.measureQueryCache = new HashMap();
        this.dimensions = new OrderedMap();
        this.cacheTimestamp = System.currentTimeMillis();
        this.tupleStorageMetrics = null;
        this.uniqueNameToNamedSet = new SequencedHashMap();
        this.resetSessionCalculatedMemberIDCounter();
    }

    protected void createCubeDirectory() throws ProviderException {
        File f = new File(this.getCubePath());
        if (!(f.exists() || f.mkdirs() || f.exists())) {
            throw new ProviderException("X01500", new String[]{this.getCubePath() + ", " + this.getName()});
        }
    }

    public static String getStoragePath() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String tempDirectory = configuration.getXqeTempDirectory();
        StringBuilder strBuf = new StringBuilder(tempDirectory);
        strBuf.append(File.separator);
        strBuf.append("tupleStorage");
        strBuf.append(File.separator);
        return strBuf.toString();
    }

    public String getCubePath() {
        StringBuilder sb = new StringBuilder(Cube.getStoragePath());
        sb.append(FileUtil.makeJavaIdentifier(this.name));
        sb.append(File.separator);
        return sb.toString();
    }

    public String getAggregationPath() {
        return this.getCubePath() + this.timestamp + File.separator;
    }

    public CacheMetricsTracker getTupleStorageMetrics() {
        return this.tupleStorageMetrics;
    }

    public IBlockTupleStorage getBlockTupleStorage() {
        return null;
    }

    public ICacheEngine getMetadataStorage() {
        return this.metadataStorage;
    }

    public void setMetadataStorage(ICacheEngine cacheEngine) {
        this.metadataStorage = cacheEngine;
    }

    protected abstract IBlockTupleStorage createBlockTupleStorage() throws ProviderException;

    protected void setDefaultProperties() {
        this.setProperty("description", "");
    }

    public LevelCombinationsManager getLevelCombinationsManager() {
        if (this.levelCombinationsManager == null) {
            this.levelCombinationsManager = new LevelCombinationsManager(this);
        }
        return this.levelCombinationsManager;
    }

    public abstract void addMeasuresDimension() throws ProviderException;

    public IMember[] getMeasures() throws MetadataException {
        IMember[] result = new IMember[]{};
        IDimension dim = this.getMeasuresDimension();
        if (dim == null) {
            throw new MetadataException("X01501", new String[]{this.getName()});
        }
        ILevel measuresLevel = dim.getLevel(0);
        result = measuresLevel.getMembers().toArray(new IMember[0]);
        return result;
    }

    protected IDimension getMeasuresDimension() {
        IDimension dim = this.getDimension("Measures");
        return dim;
    }

    public abstract IMember getMeasure(String var1) throws MetadataException;

    @Override
    public IDimension getDimension(String dimName) {
        return this.dimensions.get(dimName);
    }

    public List<IHierarchy> getHierarchies() {
        return this.getHierarchies(this.multipleHierarchySupport());
    }

    public List<IHierarchy> getHierarchies(List<IHierarchy> defaultHierarchy) {
        boolean mhSupport = this.multipleHierarchySupport();
        List<IHierarchy> hierarchies = this.getHierarchies(mhSupport);
        if (mhSupport) {
            return hierarchies;
        }
        IHierarchy[] cubeHierachies = hierarchies.toArray(new IHierarchy[0]);
        hierarchies.clear();
        int hierIdx = 0;
        for (IHierarchy cubeHierarchy : cubeHierachies) {
            for (IHierarchy queryHierarchy : defaultHierarchy) {
                if (cubeHierarchy.getDimension() != queryHierarchy.getDimension()) continue;
                cubeHierachies[hierIdx] = queryHierarchy;
                break;
            }
            hierarchies.add(cubeHierachies[hierIdx]);
            ++hierIdx;
        }
        return hierarchies;
    }

    public List<IHierarchy> getHierarchies(boolean allHierarchies) {
        OrderedMap<IHierarchy> dimHierarchies = new OrderedMap<IHierarchy>();
        List<IDimension> dims = this.getDimensions();
        for (int dimIdx = 0; dimIdx < dims.size(); ++dimIdx) {
            IDimension dim = dims.get(dimIdx);
            if (allHierarchies) {
                for (int hierIdx = 0; hierIdx < dim.getHierarchyCount(); ++hierIdx) {
                    dimHierarchies.add(dim.getHierarchy(hierIdx));
                }
                continue;
            }
            dimHierarchies.add(dim.getDefaultHierarchy());
        }
        return dimHierarchies.toArrayList();
    }

    @Override
    public IHierarchy getHierarchy(String hierName) {
        IHierarchy result = null;
        List<IDimension> dims = this.getDimensions();
        for (int i = 0; i < dims.size() && result == null; ++i) {
            IDimension dim = dims.get(i);
            result = dim.getHierarchy(hierName);
        }
        return result;
    }

    @Override
    public IHierarchy getMeasuresHierarchy() {
        List<IDimension> cubeDimensions = this.getDimensions();
        for (int i = 0; i < cubeDimensions.size(); ++i) {
            if (!((Dimension)cubeDimensions.get(i)).isMeasuresDimension()) continue;
            return ((Dimension)cubeDimensions.get(i)).getDefaultHierarchy();
        }
        return null;
    }

    @Override
    public IDimension getDimension(int index) {
        return this.dimensions.get(index);
    }

    public IDimension getDimension(DimensionTypeEnum dimType) {
        IDimension dimension = null;
        for (int i = 0; i < this.dimensions.size(); ++i) {
            IDimension dim = this.dimensions.get(i);
            if (dim.getType() != dimType) continue;
            dimension = dim;
            break;
        }
        return dimension;
    }

    @Override
    public List<IDimension> getDimensions() {
        return this.dimensions.toArrayList();
    }

    public Object[] getDimensionsToArray(Object[] o) {
        return this.dimensions.toArray(o);
    }

    @Override
    public int getDimensionIndex(IDimension d) {
        return this.dimensions.indexOf(d);
    }

    @Override
    public int getDimensionCount() {
        return this.dimensions.size();
    }

    public void addDimension(IDimension dim) {
        this.dimensions.put(dim);
    }

    public void flushDimensions() {
        this.dimensions = new OrderedMap();
    }

    public IDimension getTimeDimension() {
        IDimension result = null;
        int i = 0;
        do {
            IDimension dim;
            if (!(dim = this.getDimension(i)).isTimeDimension()) continue;
            result = dim;
        } while (++i < this.getDimensionCount() && result == null);
        return result;
    }

    public boolean hasTimeDimension() {
        return this.getTimeDimension() != null;
    }

    public IMember resolveProviderSpecificRootMember(Dimension dim, String memberNamePart) throws MetadataException {
        return null;
    }

    public IMember findMember(String memberNamePart) throws MetadataException {
        if (memberNamePart == null || memberNamePart.isEmpty()) {
            return null;
        }
        IMember result = null;
        List<IDimension> dimsList = this.getDimensions();
        Dimension[] dims = dimsList.toArray(new Dimension[0]);
        if (memberNamePart.length() <= 0 || memberNamePart.trim().length() != 0) {
            memberNamePart = memberNamePart.trim();
        }
        for (int i = 0; result == null && i < dims.length; ++i) {
            result = dims[i].findMember(memberNamePart);
        }
        XQEDebugLog.out.println(MEMBER_SEARCH_RESULT + result);
        return result;
    }

    public IMember findMemberOfHierarchy(String memberNamePart, IHierarchy hierarchy) throws MetadataException {
        if (memberNamePart == null || memberNamePart.isEmpty()) {
            return null;
        }
        IMember result = null;
        List<IDimension> dimsList = this.getDimensions();
        Dimension[] dims = dimsList.toArray(new Dimension[0]);
        if (memberNamePart.length() <= 0 || memberNamePart.trim().length() != 0) {
            memberNamePart = memberNamePart.trim();
        }
        for (int i = 0; result == null && i < dims.length; ++i) {
            if (dims[i].getHierarchies() == null || !dims[i].getHierarchies().contains(hierarchy)) continue;
            result = dims[i].findMember(memberNamePart);
        }
        XQEDebugLog.out.println(MEMBER_SEARCH_RESULT + result);
        return result;
    }

    public boolean checkedForSecurityManager() {
        return this.checkedForSecurityManager;
    }

    public void setCheckedForSecurityManager(boolean checkedForSecurityMgr) {
        this.checkedForSecurityManager = checkedForSecurityMgr;
    }

    public synchronized void initialise() {
        this.setDefaultProperties();
    }

    @Override
    public ICatalog getCatalog() {
        return null;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String theSchemaName) {
        this.schemaName = theSchemaName;
    }

    @Override
    public DateTimeValue getSchemaUpdatedDate() {
        return this.schemaUpdatedDate;
    }

    public void setSchemaUpdatedDate(DateTimeValue theSchemaUpdatedDate) {
        this.schemaUpdatedDate = theSchemaUpdatedDate;
    }

    @Override
    public IMeasure getDefaultMeasure() {
        return this.defaultMeasure;
    }

    public void setDefaultMeasure(IMeasure theDefaultMeasure) {
        this.defaultMeasure = theDefaultMeasure;
    }

    @Override
    public ICube.CubeSuppressionTypeEnum getSuppressionType() {
        return ICube.CubeSuppressionTypeEnum.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryStrategy getQueryStrategy() {
        QueryStrategy qs = null;
        HashMap<String, Provider> hashMap = cubeClassToProvider;
        synchronized (hashMap) {
            String className = this.getClass().getName();
            Provider p = cubeClassToProvider.get(className);
            if (p != null) {
                return p.getQueryStrategy();
            }
            className = className.substring(className.indexOf("Cube"));
            className = className + "Provider";
            try {
                Class<?> cl = Class.forName(className);
                try {
                    Object inst = cl.newInstance();
                    if (inst instanceof Provider) {
                        p = (Provider)inst;
                        cubeClassToProvider.put(className, p);
                        qs = p.getQueryStrategy();
                    }
                }
                catch (Exception e) {
                    mErrorLogger.log(e);
                }
            }
            catch (ClassNotFoundException e1) {
                mErrorLogger.log(e1);
            }
        }
        return qs;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public INamespace getNamespace() {
        return null;
    }

    @Override
    public IModelDataSource getModelDataSource() {
        return null;
    }

    public long getNextSessionCalculatedMemberID() {
        if (this.nextSessionCalculatedMemberID.get() <= -1000000) {
            throw new MetadataException("X01502", new String[]{this.getName(), "999999"});
        }
        return this.nextSessionCalculatedMemberID.decrementAndGet();
    }

    public int getNextQueryId() {
        if (this.queryId.get() >= Integer.MAX_VALUE) {
            this.queryId = new AtomicInteger(0);
        }
        return this.queryId.getAndIncrement();
    }

    protected void close(boolean closeStorage) throws CacheException {
        if (closeStorage) {
            ICacheEngine cacheEngine = this.getMetadataStorage();
            if (cacheEngine != null) {
                cacheEngine.clear();
            }
            File f = new File(this.getCubePath());
            f.delete();
        }
        this.defaultMeasure = null;
        this.dimensions.clear();
        this.levelCombinationsManager = null;
        this.measureQueryCache.clear();
        this.securityManager = null;
        this.uniqueNameToNamedSet.clear();
        this.metadataStorage = null;
        this.childMetadataObjects = null;
        this.implementationObject = null;
        this.resetSessionCalculatedMemberIDCounter();
    }

    public void resetSessionCalculatedMemberIDCounter() {
        this.nextSessionCalculatedMemberID.set(-1);
    }

    public void close() throws CacheException {
        this.close(true);
    }

    public boolean isProviderSpecificProperty(String propertyName) {
        return false;
    }

    public void setRemoveNonExistentTuples() {
        this.removeNonExistentTuples = true;
    }

    public boolean isRemoveNonExistentTuplesEnabled() {
        return this.removeNonExistentTuples;
    }

    public void setInitializedTimeStamp(long timeStamp) {
        this.initializeTimeStamp.set(timeStamp);
    }

    public boolean isMemberAnAttribute(String memberName, ILevel level) {
        return false;
    }

    public String getAttributeUniqueName(String propertyName, ILevel level) {
        return null;
    }

    public HashMap<String, Object> getAttributeValuesForMembers(String propertyName, IMember[] mArray) {
        return null;
    }

    public boolean isMemberNameSupported(String propName) {
        return false;
    }

    public boolean supportAttributeDimensionProperties() {
        return false;
    }

    public boolean isAttributeDimensionMember(IDimension dim) throws MetadataException {
        return false;
    }

    public IMember getDummyMember(IHierarchy hierarchy) {
        return null;
    }

    public boolean isOfTypeAggregateUnknown(AggregateTypeEnum memberAggrType) {
        return false;
    }

    public boolean isProviderEssbase() {
        return false;
    }

    public boolean isDummyMember(IMember mem) {
        return false;
    }

    public int getMemberIndex(IMember member) {
        return -1;
    }

    @Override
    public IDimension getMeasureDimension() {
        List<IDimension> dimension = this.getDimensions();
        if (dimension == null) {
            return null;
        }
        int dimCnt = dimension.size();
        for (int i = 0; i < dimCnt; ++i) {
            IDimension dim = dimension.get(i);
            if (!dim.isMeasuresDimension()) continue;
            return dim;
        }
        return null;
    }

    public void forceRecreateTupleStorage() {
        this.temporaryTupleStorageInitialized.set(false);
        this.nullTupleStorageInitialized.set(false);
    }

    public IMember getExistingMemberFromId(IDimension dimension, int memberId) {
        return null;
    }

    public boolean multipleHierarchySupport() {
        return false;
    }

    @Override
    public List<IVariable> getVariables() {
        return null;
    }

    @Override
    public IDimension queryDimension(String dimensionUName) {
        return null;
    }

    @Override
    public boolean hasSAPReplacementVariable() {
        return false;
    }

    @Override
    public boolean isReplacementVariableUsed(IDimension dimension) {
        return false;
    }
}

