/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.SecuredOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.LOLAPEssbaseCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.sapbw.LOLAPSAPCube;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Catalog;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.CubeCacheKey;
import com.cognos.xqe.runtree.olap.mdx.metadata.IReusableCube;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.AbstractCubeManager;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.SingletonHelper;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class CubeManager
extends AbstractCubeManager<CubeCacheKey, Cube> {
    private static final int LOCK_WAIT_DELAY = 10;
    private static SingletonHelper<CubeManager> singletonHelper = new SingletonHelper<CubeManager>(){

        @Override
        protected CubeManager newInstance() {
            return new CubeManager();
        }

        @Override
        protected void initializeImpl(CubeManager theInstance) {
        }

        @Override
        protected void releaseImpl(CubeManager theInstance) {
            theInstance.release();
        }
    };
    protected final Lock readLock;
    protected final Lock writeLock;
    private List<Cube> cubeList = new ArrayList<Cube>();

    public static CubeManager getCubeManager() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    public CubeManager() {
        ReentrantReadWriteLock reRwLock = new ReentrantReadWriteLock();
        this.readLock = reRwLock.readLock();
        this.writeLock = reRwLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintain() {
        this.readLock.lock();
        try {
            for (SoftReference cubeRef : this.cubeMap.values()) {
                Cube aCube;
                if (cubeRef == null || (aCube = (Cube)cubeRef.get()) == null) continue;
                this.cubeList.add(aCube);
            }
        }
        finally {
            this.readLock.unlock();
        }
        for (Cube cube : this.cubeList) {
            IBlockTupleStorage storage = cube.getBlockTupleStorage();
            if (storage == null) continue;
            storage.maintain(0.0);
        }
        this.cubeList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void release() {
        block8: {
            try {
                if (!this.writeLock.tryLock(10L, TimeUnit.SECONDS)) break block8;
                try {
                    XQEDebugLog.out.println("Number of reusable cubes created & managed by CubeManager = " + this.cubeMap.size());
                    for (SoftReference cubeRef : this.cubeMap.values()) {
                        Cube cube;
                        if (cubeRef == null || (cube = (Cube)cubeRef.get()) == null) continue;
                        try {
                            cube.close();
                        }
                        catch (Throwable e) {
                            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CubeReuse", LogLevel.WARN).log(e);
                        }
                    }
                    this.cubeMap.clear();
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.errorLogger.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cube getCube(IDataSource dataSource, ExecutionEnvironment exeEnvironment, ICube modelCube, String additionalContext, XMdxLocal xmdxLocal) {
        SoftReference<Cube> cubeRef;
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String datasourceType = dataSource.getType();
        String cubeName = LOLAPCube.removeBrackets(modelCube.getUniqueName());
        String catalogName = (String)dataSource.getMetadataProperties().get("catalog");
        MDXQuery mdxQuery = xmdxLocal.getMDXQuery();
        String keyDate = this.getKeyDate(dataSource, mdxQuery, exeEnvironment);
        Boolean useMetadataCallOnly = mdxQuery.getBooleanPropertyValue("useMetadataCallOnly");
        Boolean supressNulls = mdxQuery.getSuppressNulls();
        String suppressQueryhint = mdxQuery.getSuppressNullsQueryHint();
        Boolean checkQueryHintSuppress = configuration.getBooleanProperty("queryExecution.checkSuppressQueryHintForTMR[@enabled]", false);
        List<IMeasure> mdxQueryReferencedMeasures = mdxQuery.getInvolvedMeasures();
        if (supressNulls == null) {
            supressNulls = Boolean.TRUE;
        }
        String localeStr = LocaleConverter.localeToStr(((RequestEnvironment)exeEnvironment.getRequestEnvironment()).getRunLocale());
        MemberStorage.MemberStorageIdentifier memberProviderMRCKey = MemberStorage.buildMemberStorageIdentifier(datasourceType, CubeManager.getDataSourceName(dataSource), catalogName, cubeName, modelCube.getConnection().getModelName(), true, localeStr);
        SecuredOLAPMetadataProvider securedMetadataProvider = exeEnvironment.getMultiRequestContext().getSecuredOLAPMetadataProvider(memberProviderMRCKey);
        if (securedMetadataProvider == null) {
            IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(dataSource.getType());
            MetadataQueryArguments metadataArgs = new MetadataQueryArguments(dataSource, exeEnvironment, null);
            IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(metadataArgs);
            securedMetadataProvider = new SecuredOLAPMetadataProvider(metadataProvider, metadataArgs);
            securedMetadataProvider.initSAL(catalogName, cubeName, modelCube, localeStr);
            exeEnvironment.getMultiRequestContext().setSecuredOLAPMetadataProvider(memberProviderMRCKey, securedMetadataProvider);
        }
        if (datasourceType.equals("TMR")) {
            securedMetadataProvider.setMetadataCubeTimestaps(exeEnvironment);
        }
        String cubeContextId = this.getLOLAPCubeContext(securedMetadataProvider, catalogName, cubeName, modelCube, keyDate, useMetadataCallOnly, supressNulls);
        MemberStorage requestContextMemberStorage = securedMetadataProvider.getSAL().getMemberStorage();
        CubeCacheKey key = CubeCacheKey.buildCubeCacheKey(requestContextMemberStorage, cubeName, catalogName, modelCube.getConnection().getModelName(), datasourceType, cubeContextId, additionalContext, checkQueryHintSuppress);
        Cube cube = null;
        this.readLock.lock();
        try {
            cubeRef = (SoftReference<Cube>)this.cubeMap.get(key);
            if (cubeRef != null) {
                cube = (Cube)cubeRef.get();
            }
            if (null != cube) {
                if (cube instanceof LOLAPCube && !mdxQueryReferencedMeasures.isEmpty()) {
                    ((LOLAPCube)cube).setMeasureInfo(mdxQueryReferencedMeasures);
                }
                if (CubeManager.isLOLAPMemberStorageDifferent(securedMetadataProvider, cube)) {
                    cube = null;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (cube == null) {
            this.writeLock.lock();
            try {
                cubeRef = (SoftReference)this.cubeMap.get(key);
                if (cubeRef != null && null != (cube = (Cube)cubeRef.get()) && !CubeManager.isLOLAPMemberStorageDifferent(securedMetadataProvider, cube)) {
                    Cube cube2 = cube;
                    return cube2;
                }
                Catalog catalog = new Catalog(catalogName);
                if (datasourceType.equals("TM") || datasourceType.equals("TMR")) {
                    cube = new LOLAPTM1Cube(catalog, modelCube, dataSource, keyDate, requestContextMemberStorage, mdxQueryReferencedMeasures, suppressQueryhint);
                    ((LOLAPCube)cube).setUseMetadataCallOnly(useMetadataCallOnly);
                    ((LOLAPCube)cube).setSupressNulls(supressNulls);
                } else if (datasourceType.equals("BW")) {
                    cube = new LOLAPSAPCube(catalog, modelCube, dataSource, keyDate, requestContextMemberStorage, mdxQueryReferencedMeasures);
                    ((LOLAPCube)cube).setUseMetadataCallOnly(useMetadataCallOnly);
                    ((LOLAPCube)cube).setSupressNulls(supressNulls);
                } else if (DataSourceTypeEnum.isEssbase(datasourceType)) {
                    cube = new LOLAPEssbaseCube((ICatalog)catalog, modelCube, dataSource, requestContextMemberStorage, mdxQueryReferencedMeasures);
                    ((LOLAPCube)cube).setUseMetadataCallOnly(useMetadataCallOnly);
                } else {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "CubeManager.addCube - unsupported provider");
                }
                ((IReusableCube)((Object)cube)).setContextId(cubeContextId);
                ((IReusableCube)((Object)cube)).setAdditionalContext(additionalContext);
                catalog.addCube(cube);
                cube.initialize();
                ((LOLAPCube)cube).setCachingCubeRestrictionsIsAllowed();
                cubeRef = new SoftReference<Cube>(cube);
                this.cubeMap.put(key, cubeRef);
            }
            finally {
                this.writeLock.unlock();
            }
        }
        return cube;
    }

    private static boolean isLOLAPMemberStorageDifferent(SecuredOLAPMetadataProvider securedMetadataProvider, Cube cube) {
        MemberStorage cubeMemberStorage;
        MemberStorage requestContextMemberStorage;
        boolean result = false;
        if (cube instanceof LOLAPCube && !(requestContextMemberStorage = securedMetadataProvider.getSAL().getMemberStorage()).equals(cubeMemberStorage = ((LOLAPCube)cube).getMemberStorage())) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberStorageCubes(MemberStorage memberStorage) {
        this.writeLock.lock();
        try {
            ArrayList entriesToRemove = new ArrayList();
            Set entries = this.cubeMap.entrySet();
            for (Map.Entry entry : entries) {
                Cube cube;
                SoftReference cubeRef = (SoftReference)entry.getValue();
                if (cubeRef == null || (cube = (Cube)cubeRef.get()) == null || !(cube instanceof LOLAPCube) || !((LOLAPCube)cube).getMemberStorage().equals(memberStorage)) continue;
                try {
                    cube.close();
                    entriesToRemove.add(entry.getKey());
                }
                catch (Throwable e) {
                    this.errorLogger.log("Unable to close LOLAP cube.", e);
                }
            }
            for (CubeCacheKey cubeMapKey : entriesToRemove) {
                this.cubeMap.remove(cubeMapKey);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private String getLOLAPCubeContext(SecuredOLAPMetadataProvider securedMetadataProvider, String catalogName, String cubeName, ICube modelCube, String keyDate, Boolean useMetadataCallOnly, Boolean supressNulls) {
        String contextId = null;
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, catalogName);
        restrictions.add(RestrictionType.CUBE, cubeName);
        restrictions.add(RestrictionType.CUBE_OBJECT, modelCube);
        restrictions.add(RestrictionType.SUPRESS_NULLS, supressNulls);
        if (keyDate != null) {
            restrictions.add(RestrictionType.KEY_DATE, keyDate);
        }
        contextId = securedMetadataProvider.getCubeContext(restrictions);
        if (useMetadataCallOnly != null) {
            contextId = useMetadataCallOnly != false ? contextId + " UMCO=1" : contextId + " UMCO=0";
        }
        contextId = supressNulls != false ? contextId + " SNULLS=1" : contextId + " SNULLS=0";
        return contextId;
    }

    private static String getDataSourceName(IDataSource dataSource) {
        String dataSourceName = dataSource.getCMDataSourceName();
        if (dataSourceName == null) {
            dataSource.getName();
            if (dataSourceName == null) {
                dataSourceName = dataSource.getDataSourceConnection().getConnectionString();
            }
        }
        return dataSourceName;
    }
}

