/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderDefaultMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Hierarchy
extends Metadata
implements IHierarchy {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Hierarchy.class);
    private static final String LEFT_BRACE = "[";
    private static final String DOT_LEFT_BRACE = ".[";
    private long flushTime;
    private IDimension dimension;
    private int hierarchyIndex;
    private int hierarchyOrdinal;
    private OrderedMap<ILevel> levels;
    protected IMember defaultMember;
    protected IMember[] allMembers;
    private boolean isUnbalanced;
    private boolean isRagged;
    private boolean isParentChild;
    protected Boolean isMultiRoot;
    private IMember nullMember = null;
    private IMember providerDefaultMember = null;
    private IMember highestLevelRollup = null;
    protected ReadWriteLock membersLock = new ReentrantReadWriteLock();
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public Hierarchy(String name, Dimension d, boolean setHierarchyWithDefaultHierarchy) {
        super(name);
        this.initializeHierarchy(d, setHierarchyWithDefaultHierarchy);
    }

    public Hierarchy(String name, Dimension d) {
        super(name);
        this.initializeHierarchy(d, true);
    }

    protected void initializeHierarchy(Dimension theDimension, boolean setHierarchyWithDefaultHierarchy) {
        this.dimension = theDimension;
        this.levels = new OrderedMap();
        this.allMembers = null;
        theDimension.setHierarchy(this, setHierarchyWithDefaultHierarchy);
        this.hierarchyIndex = this.dimension.getHierarchyIndex(this);
        this.computeOrdinal();
    }

    protected int computeOrdinal(ICube cube) {
        int ordinal;
        if (this.dimension.isMeasuresDimension()) {
            ordinal = 0;
        } else {
            ordinal = 1;
            List<IDimension> dimList = cube.getDimensions();
            Dimension[] dims = dimList.toArray(new Dimension[0]);
            int maxIndex = this.dimension.getIndex(cube.getName());
            for (int i = 0; i < dims.length && i < maxIndex; ++i) {
                Dimension dim = dims[i];
                if (dim.isMeasuresDimension()) continue;
                ordinal += dim.getHierarchyOrdinalCounter();
            }
            ordinal += this.hierarchyIndex;
        }
        return ordinal;
    }

    public void computeOrdinal() {
        this.hierarchyOrdinal = this.computeOrdinal(this.getDimension().getCube());
    }

    @Override
    public IDataType getDataType() {
        return HierarchyType.HIERARCHYTYPE;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public boolean isRagged() {
        return this.isRagged;
    }

    protected void setRagged(boolean ragged) {
        this.isRagged = ragged;
    }

    @Override
    public boolean isUnbalanced() {
        return this.isUnbalanced;
    }

    protected void setUnbalanced(boolean unbalanced) {
        this.isUnbalanced = unbalanced;
    }

    @Override
    public boolean isParentChild() {
        return this.isParentChild;
    }

    protected void setParentChild(boolean parentChild) {
        this.isParentChild = parentChild;
    }

    @Override
    public String createCalculatedMemberUniqueName(String suffix) {
        return UniqueNameGenerator.appendUniqueName(this.getUniqueName(), suffix);
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    protected void setDefaultProperties() {
        this.setProperty("all level", "No");
        this.setProperty("all caption", "");
        this.setProperty("default member", "");
    }

    public void flushHierarchy() {
        XQEDebugLog.out.println("Flushing Hierarchy :" + this.getName());
        this.membersLock.writeLock().lock();
        try {
            this.allMembers = null;
            this.defaultMember = null;
        }
        finally {
            this.membersLock.writeLock().unlock();
        }
        for (int i = 0; i < this.levels.size(); ++i) {
            Level l = (Level)this.levels.get(i);
            l.flushLevel();
        }
        this.flushTime = System.currentTimeMillis();
    }

    public long getFlushTime() {
        return this.flushTime;
    }

    public void setLevel(ILevel l) {
        this.levels.put(l);
    }

    public int getIndex() {
        return this.hierarchyIndex;
    }

    public int getOrdinal() {
        return this.hierarchyOrdinal;
    }

    public int getOrdinal(String cubeName) {
        return this.getOrdinal();
    }

    @Override
    public int getLevelCount() {
        return this.levels.size();
    }

    @Override
    public List<ILevel> getLevels() {
        return this.levels.toArrayList();
    }

    @Override
    public ILevel getLevel(String levName) {
        if (levName.indexOf(DOT_LEFT_BRACE) != -1) {
            levName = com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser.parseLastIdentifier(levName);
        }
        levName = UniqueNameParser.undoEscapedSquareBracket(levName);
        return this.levels.get(levName);
    }

    @Override
    public int getLevelIndex(ILevel l) {
        return this.levels.indexOf(l);
    }

    @Override
    public ILevel getLevel(int index) {
        ILevel level = null;
        if (this.levels != null && index >= 0 && index < this.levels.size()) {
            level = this.levels.get(index);
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IMember[] getMembers() {
        this.membersLock.readLock().lock();
        try {
            if (this.allMembers != null) {
                IMember[] iMemberArray = this.allMembers;
                return iMemberArray;
            }
        }
        finally {
            this.membersLock.readLock().unlock();
        }
        this.membersLock.writeLock().lock();
        try {
            if (this.allMembers == null) {
                ArrayList<IMember> al = new ArrayList<IMember>();
                List<IMember> mems = this.getVisibleRoots();
                for (int i = 0; i < mems.size(); ++i) {
                    if (((IMemberCubics)mems.get(i)).isFillerMember()) {
                        al.addAll(((IMemberCubics)mems.get(i)).getDescendants(this.getLevelCount() - 1, 1));
                        continue;
                    }
                    al.addAll(((IMemberCubics)mems.get(i)).getDescendants(this.getLevelCount() - 1, 5));
                }
                this.allMembers = al.toArray(new IMember[0]);
            }
        }
        finally {
            this.membersLock.writeLock().unlock();
        }
        return this.allMembers;
    }

    protected List<IMember> getVisibleRoots() {
        Level l = (Level)this.getLevel(0);
        return l.getMembers(true, false);
    }

    @Override
    public IMember[] getMembers(InterpreterContext interpreterContext) {
        IMember[] members = null;
        ArrayList<IMember> al = new ArrayList<IMember>();
        Level l = (Level)this.getLevel(0);
        List<IMember> mems = l.getMembersWithSecurity(interpreterContext, null, null, l);
        for (int i = 0; i < mems.size(); ++i) {
            ArrayList<IMember> results;
            if (((IMemberCubics)mems.get(i)).isFillerMember()) {
                results = new ArrayList<IMember>();
                MemberOperations.getDescendantsOp((IMemberCubics)mems.get(i), this.getLevelCount(), 1, false, results, interpreterContext);
                al.addAll(results);
                continue;
            }
            results = new ArrayList();
            MemberOperations.getDescendantsOp((IMemberCubics)mems.get(i), this.getLevelCount(), 5, false, results, interpreterContext);
            al.addAll(results);
        }
        members = al.toArray(new IMember[0]);
        return members;
    }

    @Override
    public String getUniqueName() {
        String dimensionName = this.dimension.getName();
        if (this.dimension.getHierarchyCount() == 1) {
            return UniqueNameGenerator.createUniqueName(this.getName());
        }
        return UniqueNameGenerator.createEscapedUniqueName(dimensionName, this.getName());
    }

    public IOrderedMap<IMember> fetchFirstLevelMembers() throws MetadataException, ProviderException {
        return ((Dimension)this.dimension).fetchFirstLevelMembers();
    }

    @Override
    public IMember getDefaultMember() throws MetadataException {
        this.membersLock.readLock().lock();
        try {
            if (this.defaultMember != null) {
                IMember iMember = this.defaultMember;
                return iMember;
            }
        }
        finally {
            this.membersLock.readLock().unlock();
        }
        this.membersLock.writeLock().lock();
        try {
            if (this.defaultMember == null) {
                this.initDefaultMember();
            }
        }
        finally {
            this.membersLock.writeLock().unlock();
        }
        return this.defaultMember;
    }

    protected void initDefaultMember() throws MetadataException {
        this.defaultMember = ((Level)this.getLevel(0)).getMember(0);
    }

    public void setDefaultMember(IMember mem) {
        this.membersLock.writeLock().lock();
        try {
            this.defaultMember = mem;
        }
        finally {
            this.membersLock.writeLock().unlock();
        }
    }

    public IMember getDefaultMemberWithSecurity() throws MetadataException {
        return this.getDefaultMemberWithSecurity(this.dimension.getCube());
    }

    public IMember getDefaultMemberWithSecurity(ICube cube) throws MetadataException {
        SecurityManagerInterface sec = ((Cube)cube).getSecurityManager();
        if (sec != null) {
            return sec.getDefaultMember(this);
        }
        return this.getDefaultMember();
    }

    public IMember findDescendant(IMember parent, String memberNamePart, Level level, boolean caseSensitive) {
        IMember result = null;
        try {
            List<IMember> childList = MemberOperations.getChildrenOp((IMemberCubics)parent, false, true, null, false, null, null);
            IMember[] members = childList.toArray(new IMember[childList.size()]);
            for (int i = 0; result == null && i < members.length; ++i) {
                IMember member = members[i];
                if (member.getLevel().getIndex() == level.getIndex()) {
                    String memberName = member.getName();
                    if (caseSensitive) {
                        if (!memberName.equals(memberNamePart)) continue;
                        result = member;
                        continue;
                    }
                    if (!memberName.equalsIgnoreCase(memberNamePart)) continue;
                    result = member;
                    continue;
                }
                if (((Level)member.getLevel()).getIndex() >= level.getIndex()) continue;
                result = this.findDescendant(member, memberNamePart, level, caseSensitive);
            }
        }
        catch (MetadataException e) {
            mErrorLogger.log(e);
        }
        if (result == null && ((IMemberCubics)parent).isPopulateChildrenRequired()) {
            ((IMemberCubics)parent).populateChildren();
            return this.findDescendant(parent, memberNamePart, level, caseSensitive);
        }
        return result;
    }

    public IMember findDescendant(IMember parent, String memberNamePart, boolean caseSensitive) {
        IMember result = null;
        for (Level l = (Level)parent.getLevel().getNextLevel(); result == null && l != null; l = (Level)l.getNextLevel()) {
            result = this.findDescendant(parent, memberNamePart, l, caseSensitive);
        }
        return result;
    }

    public IMember findMember(String memberNamePart) throws MetadataException {
        return this.findMember(memberNamePart, true);
    }

    public IMember findMember(String memberNamePart, boolean caseSensitive) throws MetadataException {
        IMember result = null;
        if (memberNamePart == null || memberNamePart.isEmpty()) {
            return result;
        }
        String trimmedName = memberNamePart.trim();
        if (trimmedName.startsWith(LEFT_BRACE)) {
            com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser parser = new com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser();
            try {
                String[] parts = parser.parse(trimmedName);
                if (parts.length > 0) {
                    int idx = 0;
                    String uniqueName = this.getUniqueName();
                    String[] hierarchyUniqueNameParts = parser.parse(uniqueName);
                    if (hierarchyUniqueNameParts.length > 1 && (idx += hierarchyUniqueNameParts.length - 1) > parts.length - 1) {
                        idx = parts.length - 1;
                    }
                    String name = uniqueName.substring(uniqueName.lastIndexOf(LEFT_BRACE) + 1, uniqueName.length() - 1);
                    if (caseSensitive) {
                        if (parts[idx].equals(name) && ++idx == parts.length) {
                            result = this.getDefaultMember();
                        }
                    } else if (parts[idx].equalsIgnoreCase(name) && ++idx == parts.length) {
                        result = this.getDefaultMember();
                    }
                    if (result == null && idx < parts.length) {
                        result = this.findMember(parts[idx], caseSensitive);
                        ++idx;
                        while (result != null && idx < parts.length) {
                            result = this.findDescendant(result, parts[idx], true);
                            ++idx;
                        }
                    }
                }
            }
            catch (Exception e) {
                result = null;
                mErrorLogger.log(e);
            }
        }
        if (result == null) {
            IMember member;
            int i;
            List<ILevel> levelsList = this.getLevels();
            Level[] levelsArr = levelsList.toArray(new Level[0]);
            Level base = levelsArr[0];
            List<IMember> membersList = base.getMembers();
            IMember[] members = membersList.toArray(new IMember[0]);
            for (i = 0; result == null && i < members.length; ++i) {
                member = members[i];
                String memberUniqueName = member.getUniqueName();
                String memberName = member.getName();
                if (caseSensitive) {
                    if (!memberName.equals(memberNamePart)) continue;
                    result = member;
                    continue;
                }
                if (!memberName.equalsIgnoreCase(memberNamePart)) continue;
                result = member;
            }
            for (i = 0; result == null && i < members.length; ++i) {
                member = members[i];
                for (int j = 1; result == null && j < levelsArr.length; ++j) {
                    Level onLevel = levelsArr[j];
                    result = this.findDescendant(member, memberNamePart, onLevel, caseSensitive);
                }
            }
        }
        return result;
    }

    @Override
    public IMember getMember(String memberName) throws MetadataException {
        Level l = (Level)this.getLevel(0);
        IMember result = l.getMember(memberName);
        return result;
    }

    public synchronized void initialise() {
        this.setDefaultProperties();
    }

    @Override
    public int compareTo(Object pObject) {
        int ret = -1;
        if (pObject instanceof Hierarchy) {
            if (this == pObject) {
                ret = 0;
            }
        } else if (pObject instanceof IHierarchy) {
            ret = super.compareTo(pObject);
        }
        return ret;
    }

    @Override
    public boolean isMultiRoot() {
        if (this.isMultiRoot == null) {
            this.isMultiRoot = Boolean.valueOf((String)this.getProperty("multiRoot"));
        }
        return this.isMultiRoot;
    }

    @Override
    public synchronized List<String> getRelatedHierarchyNames(ILevel lowestLevel) {
        return null;
    }

    public boolean isAttributeHierarchy() {
        return false;
    }

    @Override
    public IMember getRootMember() {
        return null;
    }

    public String getRootCaption() {
        return null;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    @Override
    public String getV5UniqueName() {
        if (null == this.getConnection()) {
            return this.dimension.getV5UniqueName();
        }
        return UniqueNameGenerator.createUniqueName(this.dimension.getCube().getName(), this.dimension.getName(), this.getName());
    }

    @Override
    public IMember getHighestLevelRollup() {
        return this.highestLevelRollup;
    }

    public void setHighestLevelRollup(IMember theHighestLevelRollup) {
        this.highestLevelRollup = theHighestLevelRollup;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.HIERARCHY;
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    public IMember getNullMember() {
        this.membersLock.readLock().lock();
        try {
            if (this.nullMember != null) {
                IMember iMember = this.nullMember;
                return iMember;
            }
        }
        finally {
            this.membersLock.readLock().unlock();
        }
        this.membersLock.writeLock().lock();
        try {
            if (this.nullMember == null) {
                ILevel rootLevel = this.getLevel(0);
                this.nullMember = new NullMember(rootLevel);
            }
        }
        finally {
            this.membersLock.writeLock().unlock();
        }
        return this.nullMember;
    }

    public IMember getProviderDefaultMember() {
        this.membersLock.readLock().lock();
        try {
            if (this.providerDefaultMember != null) {
                IMember iMember = this.providerDefaultMember;
                return iMember;
            }
        }
        finally {
            this.membersLock.readLock().unlock();
        }
        this.membersLock.writeLock().lock();
        try {
            if (this.providerDefaultMember == null) {
                ILevel rootLevel = this.getLevel(0);
                this.providerDefaultMember = new ProviderDefaultMember(rootLevel);
            }
        }
        finally {
            this.membersLock.writeLock().unlock();
        }
        return this.providerDefaultMember;
    }

    public void initializeLevelMembers() {
        Level leafLevel = (Level)this.getLevel(this.getLevelCount() - 1);
        if (leafLevel != null && !leafLevel.hasGotAllMembers()) {
            leafLevel.getMembers();
        }
    }

    public IMember[] getHierarchyNamedSetMembers(String[] identifiers) {
        return null;
    }

    @Override
    public List<IMember> getCalculatedMembers() {
        return null;
    }

    @Override
    public String getValidFrom() {
        return null;
    }

    @Override
    public String getValidTo() {
        return null;
    }

    @Override
    public IMember getDefaultMemberFromProvider() {
        return null;
    }
}

