/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.ExactMatchValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueMethodNotImplementedException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.resultsets.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.data.IXmlSerializable;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.SimpleMember;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.map.LRUMap;

public abstract class Member
extends Metadata
implements IMemberCubics,
IXmlSerializable {
    private static final int MAGIC_PRIME_1031 = 1031;
    private static final int NUMBER_17 = 17;
    private static final int NUMBER_61 = 61;
    public static final int FIRST_CALCULATED_MEMBER_ID = -1000;
    public static final int NULL_MEMBER_ID = -999;
    public static final int PROVIDER_DEFAULT_MEMBER_ID = -998;
    public static final int VIRTUAL_MEMBER_ID = -997;
    public static final String CLOSE_BRACKET = "]";
    public static final String AT_MEMBER = "@MEMBER";
    public static final String DOT_OPEN_BRACKET = ".[";
    public static final String OPEN_BRACKET = "[";
    public static final String DOT_AT_MEMBER_PART = ".[@MEMBER]";
    public static final String DOT_AT_MEMBER_PART_REG_EXPR = "\\.\\[@MEMBER\\]";
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(Member.class);
    private final Dimension dimension;
    private final Hierarchy hierarchy;
    private final Level level;
    private IMember parentMember;
    protected IOrderedMap<IMember> children;
    protected boolean gotAllChildren;
    private long memberId = 0L;
    protected volatile int hashCode = -1;
    private static LRUMap propertyInternalizer = new LRUMap(1031);
    private static Lock propertyInitializerLock = new ReentrantLock();
    private boolean isFillerMember = false;
    protected boolean isProviderDefaultMember = false;
    private boolean isHidden = false;
    protected int numberOfParents = 0;
    protected MemberTypeEnum type = MemberTypeEnum.UNKNOWN;
    protected RollupTypeEnum rollupType = RollupTypeEnum.ROLLUP;
    protected int parentLevelNumber = -1;
    protected int indexInParentsChildrenList = -1;
    protected boolean suppressed = false;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public Member(String s, ILevel l) {
        super(s);
        this.level = (Level)l;
        this.dimension = (Dimension)l.getDimension();
        this.hierarchy = (Hierarchy)l.getHierarchy();
        this.setConnection(this.dimension.getConnection());
    }

    @Override
    public boolean isMeasure() {
        return false;
    }

    @Override
    public boolean isCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMember() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberTypeChildRef() {
        return false;
    }

    @Override
    public boolean isExtendedCalculatedMemberWithFormula() {
        return false;
    }

    @Override
    public boolean isDataBaseCalculation() {
        return false;
    }

    @Override
    public boolean isProviderDefaultMember() {
        return false;
    }

    @Override
    public long getMemberId() {
        if (this.memberId < 0L && !this.isCalculatedMember()) {
            this.memberId = this.dimension.getmaxMemberId();
        }
        return this.memberId;
    }

    @Override
    public void setMemberId(long i) {
        this.memberId = i < 0L ? i : (long)this.dimension.getmaxMemberId();
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    public void setHidden(boolean hidden) {
        this.isHidden = hidden;
    }

    @Override
    public ArrayList<IMember> getChildFillerMembers() {
        return null;
    }

    @Override
    public boolean isFillerMember() {
        return this.isFillerMember;
    }

    public void setFillerMember(boolean isFillerMem) {
        this.isFillerMember = isFillerMem;
    }

    @Override
    public IMember getParent() {
        return MemberOperations.getParentOp(this.parentMember, false);
    }

    @Override
    public IMember getParent(boolean includeFillerMembers) {
        return MemberOperations.getParentOp(this.parentMember, includeFillerMembers);
    }

    @Override
    public String getParentUniqueName() {
        if (this.parentMember != null) {
            return this.parentMember.getUniqueName();
        }
        return null;
    }

    @Override
    public void setParentMember(IMember parent) {
        this.parentMember = parent;
    }

    @Override
    public String getCaption() {
        if (this.caption != null) {
            return this.caption;
        }
        return this.getName();
    }

    @Override
    public IMember getDataMember() {
        return this;
    }

    @Override
    public List<IMember> getChildren() {
        return this.getChildren(false);
    }

    @Override
    public List<IMember> getChildren(boolean includeFillerMembers) {
        if (this.isPopulateChildrenRequired()) {
            this.populateChildren();
        }
        return MemberOperations.getChildrenOp(this, includeFillerMembers);
    }

    @Override
    public List<IMember> getChildren(boolean includeFillerMembers, int maxLevelIndex) {
        return this.getChildren(includeFillerMembers);
    }

    @Override
    public int getChildrenCardinality() {
        if (this.children == null) {
            return 1;
        }
        return this.children.size();
    }

    protected IOrderedMap<IMember> createOrderedMap() {
        return new OrderedMap<IMember>();
    }

    @Override
    public synchronized void setGotAllChildren() {
        this.gotAllChildren = true;
    }

    public void fixChildren() {
        this.setGotAllChildren();
        if (this.children != null) {
            this.children.fixate();
        }
    }

    @Override
    public boolean hasGotAllChildren() {
        return this.gotAllChildren;
    }

    @Override
    public IMember[] getChildMembers() throws MetadataException {
        return this.getChildMembers(false);
    }

    @Override
    public IMember[] getChildMembers(boolean includeFillerMembers) throws MetadataException {
        IMember[] result;
        if (this.isPopulateChildrenRequired()) {
            this.populateChildren();
        }
        if (this.getChildrenOrderedMapSize() > 0) {
            if (includeFillerMembers) {
                result = (IMember[])this.children.toArray(new IMember[this.children.size()]);
            } else {
                List<IMember> childs = MemberOperations.getChildrenOp(this, false);
                result = childs.toArray(new IMember[childs.size()]);
            }
        } else {
            result = new IMember[]{};
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateChildren() {
        block16: {
            if (!this.gotAllChildren) {
                ILevel childLevel = this.getLevel().getNextLevel();
                if (childLevel == null) {
                    this.setGotAllChildren();
                } else {
                    try {
                        if (((Level)childLevel).hasGotAllMembers()) {
                            List<IMember> mems = childLevel.getMembers();
                            Member member = this;
                            synchronized (member) {
                                if (!this.gotAllChildren) {
                                    this.children = this.createOrderedMap();
                                    ArrayList<IMember> filteredChildList = new ArrayList<IMember>();
                                    for (IMember mem : mems) {
                                        if (mem.getParent() != this) continue;
                                        filteredChildList.add(mem);
                                    }
                                    if (filteredChildList.size() != 0) {
                                        this.children.putAll(filteredChildList);
                                    }
                                    this.gotAllChildren = true;
                                }
                                break block16;
                            }
                        }
                        IOrderedMap<IMember> childMembers = this.fetchChildMembers();
                        Member member = this;
                        synchronized (member) {
                            if (!this.gotAllChildren) {
                                this.children = childMembers;
                                this.gotAllChildren = true;
                            }
                        }
                    }
                    catch (ProviderException e) {
                        throw new MetadataException("X01493", new String[]{this.getName(), e.toString()}, e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initChildrenOrderedMap() {
        if (this.children != null) {
            return;
        }
        Member member = this;
        synchronized (member) {
            if (this.children == null) {
                this.children = this.createOrderedMap();
            }
        }
    }

    @Override
    public boolean isPopulateChildrenRequired() {
        return !this.hasGotAllChildren();
    }

    @Override
    public IMember searchChildrenOrderedMap(String memberKey) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(memberKey);
    }

    @Override
    public int getChildrenOrderedMapSize() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public void addMemberToChildrenOrderedMap(IMember childMember) {
        this.initChildrenOrderedMap();
        this.children.put(childMember);
    }

    @Override
    public void removeMember(IMember childMember) {
        this.initChildrenOrderedMap();
        this.children.remove(childMember);
    }

    @Override
    public IMember getChildMember(String memberName) throws MetadataException {
        return MemberOperations.getChildMemberOp(this, memberName);
    }

    @Override
    public int estimateChildCount() {
        if (!this.gotAllChildren) {
            if (((Level)this.getLevel()).isBottomLevel()) {
                return 0;
            }
            return 1;
        }
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public abstract IOrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException;

    public synchronized void setChildren(OrderedMap<IMember> aChildren) {
        this.children = aChildren;
    }

    @Override
    public int getIndexInParentsChildren() {
        if (this.indexInParentsChildrenList == -1) {
            try {
                IMember parent = this.getParent();
                this.indexInParentsChildrenList = parent == null ? this.getIndex() : parent.getChildIndex(this);
            }
            catch (MetadataException e) {
                mErrorLogger.log(e);
            }
        }
        return this.indexInParentsChildrenList;
    }

    @Override
    public synchronized void resetIndexInParentsChildren() {
        this.indexInParentsChildrenList = -1;
    }

    @Override
    public void setIndexInParentsChildren(int index) {
        this.indexInParentsChildrenList = index;
    }

    @Override
    public int getChildIndex(IMember child) throws MetadataException {
        int result = ((Member)child).indexInParentsChildrenList;
        if (result == -1) {
            if (!this.gotAllChildren) {
                this.getChildMembers();
            }
            if (this.children != null) {
                ((Member)child).indexInParentsChildrenList = result = this.children.indexOf(child);
            }
        }
        return result;
    }

    @Override
    public ArrayList<IMember> getDescendants() throws MetadataException {
        return this.getDescendants(true);
    }

    public ArrayList<IMember> getDescendants(boolean includeFillerMembers) throws MetadataException {
        ArrayList<IMember> result = new ArrayList<IMember>();
        MemberOperations.getDescendantsOp(this, 0, 4, includeFillerMembers, result, null);
        return result;
    }

    @Override
    public int[] getDescendantsIds(ILevel l) throws MetadataException {
        return MemberOperations.getDescendantsIdsOp(this, l);
    }

    @Override
    public IOrderedMap<IMember> getDescendantsOrderedMap(int depth, int descRangeFlag) {
        return null;
    }

    @Override
    public IMember getPreviousMember() throws MetadataException {
        return MemberOperations.getPreviousMemberOp(this, false);
    }

    @Override
    public IMember getPreviousMember(boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getPreviousMemberOp(this, includeFillerMembers);
    }

    @Override
    public IMember getNextMember() throws MetadataException {
        return MemberOperations.getNextMemberOp(this, false);
    }

    @Override
    public IMember getNextMember(boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getNextMemberOp(this, includeFillerMembers);
    }

    @Override
    public ArrayList<IMember> getDescendants(int distance, int descRangeflagEnum) throws MetadataException {
        return this.getDescendants(distance, descRangeflagEnum, false);
    }

    public ArrayList<IMember> getDescendants(int distance, int descRangeflagEnum, boolean includeFillerMembers) throws MetadataException {
        ArrayList<IMember> results = new ArrayList<IMember>();
        if (descRangeflagEnum == -1) {
            descRangeflagEnum = 0;
        }
        MemberOperations.getDescendantsOp(this, distance, descRangeflagEnum, includeFillerMembers, results, null);
        return results;
    }

    @Override
    public ArrayList<IMember> getDescendants(ILevel l, int descRangeflagEnum) throws MetadataException {
        return MemberOperations.getDescendantsOp((IMemberCubics)this, l, descRangeflagEnum, true);
    }

    @Override
    public ArrayList<IMember> getDescendants(ILevel l, int descRangeflagEnum, boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getDescendantsOp((IMemberCubics)this, l, descRangeflagEnum, includeFillerMembers);
    }

    @Override
    public ArrayList<IMember> getDescendants(ILevel l) throws MetadataException {
        return MemberOperations.getDescendantsOp(this, l, false);
    }

    @Override
    public ArrayList<IMember> getDescendants(ILevel l, boolean includeFillerMembers) throws MetadataException {
        return MemberOperations.getDescendantsOp(this, l, includeFillerMembers);
    }

    @Override
    public IMember[] getSiblings(boolean includeSelf) throws MetadataException {
        return MemberOperations.getSiblingsOp(this, includeSelf);
    }

    @Override
    public ILevel getLevel() {
        return this.level;
    }

    @Override
    public int getIndex() throws MetadataException {
        if (this.memberId != -1L) {
            return (int)this.memberId;
        }
        return this.level.getMemberIndex(this);
    }

    @Override
    public String getUniqueName() {
        String result = this.uniqueName;
        if (result == null) {
            result = "";
            IMember parent = this.getParent();
            result = parent == null ? this.hierarchy.getUniqueName() : parent.getUniqueName();
            if (!this.isFillerMember()) {
                result = result + DOT_OPEN_BRACKET + this.getName() + CLOSE_BRACKET;
            }
            this.uniqueName = result;
        }
        return result;
    }

    @Override
    public void setUniqueName(String s) {
        this.uniqueName = s;
    }

    @Override
    public String getMUNPropValue() {
        return this.getUniqueName();
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    @Override
    public IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public IMember createNotSpecifiedChild() throws MetadataException {
        return this.createChild("(Not Specified)");
    }

    @Override
    public IOrderedMap<IMember> getChildrenOrderedMap() {
        if (this.isPopulateChildrenRequired()) {
            this.populateChildren();
        }
        return this.children;
    }

    @Override
    public IOrderedMap<IMember> getChildrenOrderedMap(int maxLevelIndex) {
        return this.getChildrenOrderedMap();
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.MEMBER;
    }

    public void addChildMember(IMember child) {
        if (this.gotAllChildren) {
            this.initChildrenOrderedMap();
            this.children.put(child);
            ((Level)this.level.getNextLevel()).memberAddedNotification(child);
        }
    }

    @Override
    public IMember createChild(String childName) throws MetadataException {
        if (!this.gotAllChildren) {
            this.getChildMembers();
        }
        SimpleMember child = new SimpleMember(this, childName);
        this.addChildMember(child);
        return child;
    }

    @Override
    public String toString() {
        return this.getUniqueName();
    }

    public int hierarchyCompare(IMember b) throws MetadataException {
        return MemberOperations.hierarchyCompare(this, b, false);
    }

    @Override
    public int hierarchyCompare(IMember b, boolean postOrder) throws MetadataException {
        return MemberOperations.hierarchyCompare(this, b, postOrder);
    }

    @Override
    public IMember cousin(IMember ancestor) {
        return MemberOperations.cousin(this, ancestor);
    }

    public synchronized void initialise() {
        this.setDefaultProperties();
    }

    @Override
    public boolean isContextMember() {
        return false;
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        return AggregateTypeEnum.UNKNOWN;
    }

    @Override
    public AggregateTypeEnum getSemiAggregate() {
        return AggregateTypeEnum.UNKNOWN;
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object copy() {
        return this;
    }

    @Override
    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement(this.getClass().getSimpleName(), -1);
        xmlWriter.attribute("Hierarchy", this.level.getHierarchy().getUniqueName());
        xmlWriter.beginElement("UName", -1);
        xmlWriter.data(this.getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("Caption", -1);
        xmlWriter.data(this.getCaption());
        xmlWriter.endElement();
        xmlWriter.beginElement("LName", -1);
        xmlWriter.data(this.level.getUniqueName());
        xmlWriter.endElement();
        xmlWriter.beginElement("LNum", -1);
        xmlWriter.data(String.valueOf(this.level.getIndex()));
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    @Override
    @Deprecated
    public Object getBusinessKey() {
        return this.getProperty("KEY");
    }

    @Override
    public Value getBusinessKeyValue() {
        StringValue result = DataValueFactory.createStringValue();
        if (this instanceof DMRMeasure) {
            result.setNull();
            return result;
        }
        Object key = this.getBusinessKey();
        if (null == key) {
            result.setNull();
        } else {
            result.set(key.toString());
        }
        return result;
    }

    @Override
    public int getNumberOfParents() {
        return this.numberOfParents;
    }

    public void setNumberOfParents(int theNumberOfParents) {
        this.numberOfParents = theNumberOfParents;
    }

    @Override
    public MemberTypeEnum getType() {
        return this.type;
    }

    public void setType(MemberTypeEnum theType) {
        this.type = theType;
    }

    @Override
    public RollupTypeEnum getRollupType() {
        return this.rollupType;
    }

    public void setRollupType(RollupTypeEnum theRollupType) {
        this.rollupType = theRollupType;
    }

    @Override
    public boolean isSuppressed() {
        return this.suppressed;
    }

    public void setSuppressed(boolean theSuppressed) {
        this.suppressed = theSuppressed;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public int getParentLevelNumber() {
        return this.parentLevelNumber;
    }

    public void setParentLevelNumber(int theParentLevelNumber) {
        this.parentLevelNumber = theParentLevelNumber;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void setNull() {
        throw new ValueMethodNotImplementedException(this.getClass().getName() + ".setNull()");
    }

    @Override
    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return -1;
        }
        int result = 0;
        IMetadata otherMetadata = (IMetadata)other;
        result = this.getObjectType().ordinal() - otherMetadata.getObjectType().ordinal();
        if (result == 0) {
            result = this.hashCode() - otherMetadata.hashCode();
            if (result == 0) {
                result = this.getUniqueName().compareTo(otherMetadata.getUniqueName());
            } else if (otherMetadata instanceof MemberProxy) {
                result = this.getUniqueName().compareTo(otherMetadata.getUniqueName());
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            this.calcHashCode();
        }
        return this.hashCode;
    }

    private synchronized void calcHashCode() {
        if (this.hashCode == -1) {
            int tempHashCode;
            if (this.memberId != -1L) {
                tempHashCode = (int)this.memberId;
                tempHashCode *= 61;
                tempHashCode += this.getHierarchy().getUniqueName().hashCode();
            } else {
                tempHashCode = this.getName().hashCode();
                for (IMember parent = this.getParent(); parent != null; parent = parent.getParent()) {
                    tempHashCode *= 17;
                    tempHashCode += this.parentMember.getName().hashCode();
                }
                tempHashCode *= 61;
                tempHashCode += this.getHierarchy().getUniqueName().hashCode();
            }
            this.hashCode = tempHashCode;
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Member)) {
            return false;
        }
        if (this.hashCode() != ((Member)other).hashCode()) {
            return false;
        }
        if (this.parentMember != ((Member)other).parentMember) {
            return false;
        }
        return this.getUniqueName().equals(((Member)other).getUniqueName());
    }

    protected void setDefaultProperties() {
    }

    @Override
    public Object getProperty(String propName) {
        return MemberOperations.getPropertyOp(this, propName);
    }

    @Override
    public Object getMetadataProperty(String propName) {
        return super.getProperty(propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String propertyName, Object value) {
        Object internedValue;
        propertyInitializerLock.lock();
        try {
            Object keyValue = value;
            if (value instanceof Value) {
                keyValue = new ExactMatchValue((Value)value);
            }
            if ((internedValue = propertyInternalizer.get(keyValue)) == null) {
                propertyInternalizer.put(keyValue, value);
                internedValue = value;
            }
        }
        finally {
            propertyInitializerLock.unlock();
        }
        super.setProperty(propertyName, internedValue);
    }

    @Override
    public boolean isLeaf() {
        return MemberOperations.isLeaf(this, null);
    }

    @Override
    public boolean isDummyMember() {
        return false;
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isRelational() {
        return false;
    }

    @Override
    public Value getCaptionValue() {
        StringValue v = DataValueFactory.createStringValue();
        ((Value)v).set(this.getCaption());
        return v;
    }

    @Override
    public Value getDescriptionValue() {
        return this.getCaptionValue();
    }

    @Override
    public String getV5MUN() {
        return null;
    }
}

