/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.mdx.parser.ASTMDXStatement;
import com.cognos.xqe.ast.mdx.parser.MDXParser;
import com.cognos.xqe.ast.mdx.parser.MDXParserVisitorBase;
import com.cognos.xqe.ast.mdx.parser.ParseException;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.cubingservices.CommonClassesFactory;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.resultsets.md.CubicsDimensionalResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxCreate;
import com.cognos.xqe.runtree.olap.mdx.XMdxDrop;
import com.cognos.xqe.runtree.olap.mdx.XMdxSelect;
import com.cognos.xqe.runtree.olap.mdx.data.cache.ICubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.values.CubicsValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.DDLResult;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IExternalAggregateStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IStatementResult;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Interpreter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NamedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ParseTreePrinter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Query;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SelectQuery;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Session;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class Provider {
    private static final String COMMA_SPACE = ", ";
    private static final String UTF_8 = "UTF-8";
    private static final String PARSER = "parser : ";
    private static final String PRINTING_PARSE_TREE = "Printing parse tree ...";
    private static final String PROFILE = "Profile";
    private static final String PROVIDER_RUNQUERY = "Provider.runQuery";
    public static final long MAXCELLS_LOW = -1L;
    public static final long DEFAULT_MAX_CELLS = 1000000L;
    public static final long MAXNONEMPTYCELLS_LOW = -1L;
    private static XQELogger mErrorLogger;
    private long maxQueryCells = 1000000L;
    private long maxQueryNonEmptyCells = 1000000L;
    private static HashMap<String, Provider> providerNameToProvider;
    private OrderedMap<OrderedMap<Cube>> profileToCubes = new OrderedMap();
    private final HashMap<String, String> properties = new HashMap();
    private boolean mXQEConfigInitialized;
    private QueryContext mQueryContext;

    public void lockCube(ICube cube) {
        ((Cube)cube).lock();
    }

    public void unlockCube(ICube cube) {
        ((Cube)cube).unlock();
    }

    public QueryContext getQueryContext() {
        return this.mQueryContext;
    }

    public void setQueryContext(QueryContext qc) {
        this.mQueryContext = qc;
    }

    public long getMaxQueryCells() {
        return this.maxQueryCells;
    }

    public void setMaxQueryCells(long maxQryCells) {
        this.maxQueryCells = maxQryCells;
    }

    public long getMaxQueryNonEmptyCells() {
        return this.maxQueryNonEmptyCells;
    }

    public void setMaxQueryNonEmptyCells(long maxQryNonEmptyCells) {
        this.maxQueryNonEmptyCells = maxQryNonEmptyCells;
    }

    public static synchronized Provider getProvider(String providerName) throws ProviderException {
        Provider provider;
        if (providerNameToProvider == null) {
            providerNameToProvider = new HashMap();
        }
        if (providerNameToProvider.get(providerName) == null) {
            Class<?> c;
            try {
                c = Class.forName(providerName);
            }
            catch (ClassNotFoundException e) {
                throw new ProviderException("X99004", new String[]{providerName, ""}, e);
            }
            try {
                provider = (Provider)c.newInstance();
                providerNameToProvider.put(providerName, provider);
            }
            catch (InstantiationException e) {
                throw new ProviderException("X01504", new String[]{providerName + COMMA_SPACE + e.toString()}, e);
            }
            catch (IllegalAccessException e) {
                throw new ProviderException("X01504", new String[]{providerName + COMMA_SPACE + e.toString()}, e);
            }
        }
        provider = providerNameToProvider.get(providerName);
        return provider;
    }

    public static synchronized Provider getNewProvider(String providerName) throws ProviderException {
        Provider provider;
        Class<?> c;
        try {
            c = Class.forName(providerName);
        }
        catch (ClassNotFoundException e) {
            throw new ProviderException("X99004", new String[]{providerName, ""}, e);
        }
        try {
            provider = (Provider)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new ProviderException("X01504", new String[]{providerName + COMMA_SPACE + e.toString()}, e);
        }
        catch (IllegalAccessException e) {
            throw new ProviderException("X01504", new String[]{providerName + COMMA_SPACE + e.toString()}, e);
        }
        return provider;
    }

    public abstract void connect() throws ProviderException;

    public abstract String[] getCatalogs() throws ProviderException;

    public abstract String[] getCubeNames(String var1) throws ProviderException;

    public void startRequest(QueryContext info) {
    }

    public void endRequest() {
    }

    public void refreshCube(Cube c) {
        Cube cube;
        OrderedMap<Cube> cubes = this.profileToCubes.get(c.getCatalogName());
        if (cubes != null && (cube = cubes.get(c.getName())) != null) {
            cubes.remove(c);
        }
    }

    public Cube getCube(String cubeName) throws ProviderException {
        return this.getCube(this.getProperty(PROFILE), cubeName);
    }

    public Cube getCube(String catalogName, String cubeName) throws ProviderException {
        Cube c;
        OrderedMap<Cube> cubes = this.profileToCubes.get(catalogName);
        if (cubes == null) {
            cubes = new OrderedMap();
            this.profileToCubes.put(catalogName, cubes);
        }
        if ((c = cubes.get(cubeName = cubeName.toUpperCase())) == null) {
            c = this.retrieveCube(catalogName, cubeName);
            cubes.put(cubeName, c);
        }
        return c;
    }

    public abstract Cube retrieveCube(String var1, String var2) throws ProviderException;

    public abstract QueryStrategy getQueryStrategy();

    public QueryStrategy getQueryStrategy(ICube cube) {
        return this.getQueryStrategy();
    }

    public boolean isResultSetCacheEnabled(ICube cube) {
        return false;
    }

    public boolean isResultSetCacheable(MDXQuery mdxQuery, XDataContext dataContext, ICubeResultSet executedResultSet, long elapsedQueryTime) {
        return true;
    }

    public ICubeResultSetCache getResultSetCache(ICube cube) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "com.cognos.xqe.runtree.olap.mdx.metadata.Provider.getResultSetCache(ICube)");
    }

    public IExternalAggregateStrategy getExternalAggregateStrategy() {
        return null;
    }

    public void resetCubeReferences() {
        this.profileToCubes = new OrderedMap();
    }

    public Cube[] getCubes() throws ProviderException {
        String profileName = this.getProperty(PROFILE);
        String[] cubeNames = this.getCubeNames(profileName);
        Cube[] cubes = new Cube[cubeNames.length];
        for (int i = 0; i < cubeNames.length; ++i) {
            String cubeName = cubeNames[i];
            cubes[i] = this.getCube(profileName, cubeName);
        }
        return cubes;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String runDrillThrough(InputStream ioStream, Session session) throws MetadataException {
        String result = null;
        Query query = null;
        XQEDebugLog.out.println(PROVIDER_RUNQUERY);
        MDXParser parser = new MDXParser(ioStream, UTF_8);
        XQEDebugLog.out.println(PARSER + parser);
        try {
            XQEDebugLog.out.println("Parsing ...");
            parser.MDX_statement();
        }
        catch (ParseException e) {
            throw new MetadataException("X01499", new String[]{e.toString()}, e);
        }
        InterpreterContext context = new InterpreterContext(this);
        try {
            XQEDebugLog.out.println(PRINTING_PARSE_TREE);
            ParseTreePrinter printer = new ParseTreePrinter(parser);
            printer.print();
            XQEDebugLog.out.println(" runQuery setting session to " + session);
            context.setSession(session);
            Interpreter interpreter = new Interpreter(context, parser);
            interpreter.setInterpreterSubject("DrillThrough Statement");
            query = interpreter.interpretQuery();
        }
        catch (InterpreterException e) {
            throw new MetadataException("X01499", new String[]{e.toString()}, e);
        }
        XQEDebugLog.out.println("runDrillThrough");
        ITuple t = ((SelectQuery)query).getWhereTuple();
        XQEDebugLog.out.println("WhereTuple = " + t);
        ((SelectQuery)query).getCube();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatementResult runQuery(MDXParser parser, String mdxStr, Session session, QueryContext info) throws MetadataException {
        IStatementResult resultSet;
        block43: {
            Query query = null;
            resultSet = null;
            InterpreterContext interpreterContext = new InterpreterContext(this);
            interpreterContext.setQueryContext(info);
            interpreterContext.setSession(session);
            RequestEnvironment reqEnv = null;
            ExecutionEnvironment execEnv = null;
            MultiRequestContext multiRequestContext = null;
            try {
                this.constructXQEConfiguration();
                try {
                    if (!XQEService.isInitialized()) {
                        XQEService.initialize();
                    }
                }
                catch (XQERuntimeException ex) {
                    Provider.getLogger().log(ex);
                    XQEDebugLog.err.printStackTrace(ex);
                }
                reqEnv = Provider.getOrCreateRequestEnvironment(this.getQueryContext());
                Element commandElement = DocumentHelper.createElement((String)"prepare");
                String requestId = Provider.setUpRequestID(commandElement);
                reqEnv.setRequestID(requestId);
                reqEnv.extractParametersFromCommand(commandElement);
                if (null == reqEnv.getSessionContextID()) {
                    reqEnv.setSessionContextID(requestId);
                }
                QueryEngine.getInstance().configureRequestEnvironment(reqEnv);
                execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
                multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(reqEnv, null);
            }
            catch (Throwable e) {
                throw new MetadataException("X01505", new String[]{e.toString()}, e);
            }
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(execEnv);
            multiRequestContext.incrementRefCount();
            try {
                Object result;
                XMdxLocal xmdxlocal;
                XDataContext dataContext = execEnv.pushDataContext();
                try {
                    dataContext.setInterpreterContext(interpreterContext);
                    xmdxlocal = this.generateRuntree(parser, reqEnv, info);
                    result = this.executeRuntree(xmdxlocal, reqEnv, dataContext);
                    interpreterContext = dataContext.getInterpreterContext();
                    if (result instanceof CubeHybridResultSet) {
                        CubeHybridResultSet hybridResultSet = (CubeHybridResultSet)result;
                        CubicsDimensionalResultSet cubicsResultSet = (CubicsDimensionalResultSet)hybridResultSet.getDimensionalResult();
                        resultSet = (IStatementResult)((Object)cubicsResultSet.getResultSet());
                        cubicsResultSet.release();
                        hybridResultSet.release();
                    }
                }
                catch (ProviderException e) {
                    throw e;
                }
                catch (ParseException e) {
                    throw new MetadataException("X01499", new String[]{e.toString()}, e);
                }
                catch (MDXEngineException e) {
                    throw new MetadataException("X01505", new String[]{e.toString()}, e);
                }
                catch (Throwable e) {
                    throw new MetadataException("X01505", new String[]{e.toString()}, e);
                }
                finally {
                    execEnv.popDataContext(dataContext);
                }
                try {
                    IXQEQueryNode queryNode = xmdxlocal.getChild(0);
                    if (queryNode instanceof XMdxSelect) {
                        XMdxSelect selectNode = (XMdxSelect)queryNode;
                        SelectQuery selectQuery = selectNode.getSelectQuery(dataContext);
                        boolean isNonEmptyQuery = false;
                        try {
                            isNonEmptyQuery = selectQuery.isNonEmptyQuery();
                            if (!isNonEmptyQuery && this.maxQueryCells > -1L) {
                                ISet[] axisSets = selectQuery.getAxes();
                                long predictedCells = 1L;
                                for (int i = 0; i < axisSets.length; ++i) {
                                    long newCellCount = predictedCells * axisSets[i].size();
                                    if (newCellCount != 0L && newCellCount < predictedCells) {
                                        throw new MetadataException("X01487", new String[]{newCellCount + "", Long.toString(this.maxQueryCells)});
                                    }
                                    predictedCells = newCellCount;
                                }
                                if (predictedCells > this.maxQueryCells) {
                                    throw new MetadataException("X01487", new String[]{Long.toString(predictedCells), Long.toString(this.maxQueryCells)});
                                }
                            }
                            this.initializeMetrics(query, info, mdxStr);
                        }
                        catch (MetadataException e) {
                            throw new MetadataException("X01505", e);
                        }
                        if (isNonEmptyQuery) {
                            long actualCellCount = ((ResultSet)resultSet).cellCount();
                            ISet[] axisSets = ((ResultSet)resultSet).getAxes();
                            long predictedCells = 1L;
                            for (int i = 0; i < axisSets.length; ++i) {
                                long newCellCount = predictedCells * axisSets[i].size();
                                if (newCellCount != 0L && newCellCount < predictedCells) {
                                    throw new MetadataException("X01488", new String[]{"> ", Long.toString(this.maxQueryNonEmptyCells)});
                                }
                                predictedCells = newCellCount;
                            }
                            if (this.maxQueryNonEmptyCells > -1L) {
                                if (predictedCells > this.maxQueryNonEmptyCells) {
                                    throw new MetadataException("X01488", new String[]{Long.toString(predictedCells), Long.toString(this.maxQueryNonEmptyCells)});
                                }
                                if (actualCellCount > this.maxQueryNonEmptyCells) {
                                    throw new MetadataException("X01488", new String[]{Long.toString(actualCellCount), Long.toString(this.maxQueryNonEmptyCells)});
                                }
                            }
                        }
                        break block43;
                    }
                    if (queryNode instanceof XMdxCreate || queryNode instanceof XMdxDrop) {
                        boolean isCreate = false;
                        boolean isDrop = false;
                        if (queryNode instanceof XMdxCreate) {
                            isCreate = true;
                        }
                        if (queryNode instanceof XMdxDrop) {
                            isDrop = true;
                        }
                        result = ((CubicsValue)result).getCubicsObject();
                        DDLResult ddlResult = new DDLResult(isCreate, isDrop, result);
                        if (isCreate && (ddlResult.getCSOperationType() == 3 || ddlResult.getCSOperationType() == 4)) {
                            Block setsB;
                            Set set;
                            NamedSet namedSet = (NamedSet)result;
                            String asKey = "AS";
                            String searchStr = "[" + namedSet.getCubeName() + "]." + namedSet.getUniqueName();
                            int searchIndx = mdxStr.indexOf(searchStr);
                            int startIndx = mdxStr.indexOf(asKey, searchIndx + searchStr.length() + 1);
                            if (startIndx <= 0) {
                                asKey = "as";
                                startIndx = mdxStr.indexOf(asKey, searchIndx + searchStr.length() + 1);
                            }
                            if ((set = (Set)(setsB = (Block)namedSet.getSet1(interpreterContext)).first()) != null) {
                                set = set.removeNullMembers();
                                if (setsB.cellSetSize() == 1) {
                                    ddlResult.setNamedSetContents(set);
                                }
                            }
                            if (startIndx > 0) {
                                String namedSetExpr = mdxStr.substring(startIndx + asKey.length());
                                namedSet.setExpression(namedSetExpr.trim());
                            }
                        }
                        resultSet = ddlResult;
                    }
                }
                catch (MetadataException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new MetadataException("X01499", new String[]{e.toString()}, e);
                }
            }
            finally {
                multiRequestContext.decrementRefCount();
                executionEnvironmentContext.exit();
            }
        }
        XQEDebugLog.out.println("returning from Provider.runQuery() ");
        return resultSet;
    }

    public static RequestEnvironment getOrCreateRequestEnvironment(QueryContext infoData) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null != execEnv) {
            return (RequestEnvironment)execEnv.getRequestEnvironment();
        }
        BIBusEnvelope requestEnvelope = new BIBusEnvelope();
        RequestEnvironment reqEnv = new RequestEnvironment(requestEnvelope);
        reqEnv.setEnvFactory(QueryEngine.getInstance().getBaseEnvironmentFactory());
        return reqEnv;
    }

    public void initializeMetrics(Query query, QueryContext info, String mdx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMdxLocal generateRuntree(MDXParser parser, RequestEnvironment reqEnv, QueryContext infoData) throws ParseException {
        XMdxLocal xNode;
        PlanningEnvironment planEnv;
        Writer logWriter;
        block15: {
            logWriter = TraceLogManager.getInstance().createPlanningTraceWriter(reqEnv);
            planEnv = QueryPlanner.setupEnvironment(reqEnv);
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            xNode = (XMdxLocal)nodeFactory.createNode(501053);
            xNode.addToIndex();
            xNode.setCatalog(infoData.getCatalogName());
            parser.setNodeFactory(planEnv.getNodeFactory());
            if (XQEDebugLog.out.isEnabled()) {
                Timer timer = new Timer();
                try {
                    XQEDebugLog.out.println(PROVIDER_RUNQUERY);
                    XQEDebugLog.out.println(PARSER + parser);
                    timer.start();
                    parser.MDXStatement();
                    if (XQEDebugLog.out.isEnabled()) {
                        infoData.setParseDuration(timer.getElapsedTimeInMilliseconds());
                        XQEDebugLog.out.println("Parsing took: " + infoData.getParseDuration() + "ms");
                    }
                    XQEDebugLog.out.println(PRINTING_PARSE_TREE);
                    break block15;
                }
                finally {
                    timer.stop();
                }
            }
            parser.MDXStatement();
        }
        try {
            ParseTreePrinter printer = new ParseTreePrinter(parser);
            printer.print();
        }
        catch (InterpreterException e) {
            Provider.getLogger().log(e);
        }
        MDXParserVisitor v = new MDXParserVisitor(parser);
        IXQEQueryNode[] children = v.getMDXStatement().getChildren();
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode childNode = children[i];
            childNode.setParent(null);
            xNode.addChild(childNode);
        }
        try {
            TransformationEngine.getInstance().applyTransformations(xNode, planEnv);
        }
        catch (MetadataException e) {
            String str = e.getCause().toString().replaceFirst("com.cognos.xqe.ast.mdx.parser.ParseException: ", "");
            throw new ParseException(str);
        }
        if (logWriter != null) {
            try {
                logWriter.close();
            }
            catch (IOException e) {
                Provider.getLogger().log(e);
            }
        }
        return xNode;
    }

    public Object executeRuntree(XMdxLocal xmdxlocal, RequestEnvironment reqEnv, XDataContext context) throws Throwable {
        XQETrace trace = new XQETrace();
        QueryEngineLoggingUtils.addExecutionTraceLevels(trace, reqEnv);
        Writer logWriter = TraceLogManager.getInstance().createRuntreeTraceWriter(reqEnv);
        if (logWriter != null) {
            trace.addStream(logWriter);
        }
        IValue result = null;
        try {
            trace.beginElement("execution", -1);
            if ((trace.getTraceLevel() & 0x80) != 0) {
                trace.beginElement("runtree", -1);
                xmdxlocal.dump(trace);
                trace.endElement();
            }
            if ((trace.getTraceLevel() & 0x800) != 0) {
                trace.beginElement("executionLog", -1);
            }
            context.getEnvironment().setTrace(trace);
            xmdxlocal.setProviderName(this.getClass().getName());
            result = xmdxlocal.execute(context);
            if ((trace.getTraceLevel() & 0x800) != 0) {
                trace.endElement();
            }
            trace.endElement();
        }
        catch (MDXEngineException e) {
            throw e;
        }
        catch (MetadataException e) {
            throw e;
        }
        catch (ProviderException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new MetadataException("X01505", e);
        }
        finally {
            if (logWriter != null) {
                try {
                    logWriter.close();
                }
                catch (IOException e) {
                    Provider.getLogger().log(e);
                }
                TraceLogManager.getInstance().closeTrace(reqEnv);
            }
        }
        return result;
    }

    public static String setUpRequestID(Element commandElement) {
        String requestID = Provider.createFakeRequestID();
        boolean foundRequestIDElementInCommand = Provider.setUpRequestIDValue(commandElement, requestID);
        if (!foundRequestIDElementInCommand) {
            Element requestIDElement = commandElement.addElement("requestID");
            requestIDElement.addAttribute("value", requestID);
        }
        for (Element element : commandElement.elements()) {
            Provider.removeRequestIDValue(element);
        }
        return requestID;
    }

    private static String createFakeRequestID() {
        return new UID().toString();
    }

    private static boolean setUpRequestIDValue(Element element, String requestID) {
        Element subrequestIDElement;
        Provider.removeDuplicateChildren(element, "requestID");
        Provider.removeDuplicateChildren(element, "subRequestID");
        Element requestIDElement = element.element("requestID");
        if (null != requestIDElement) {
            requestIDElement.addAttribute("value", requestID);
        }
        if (null != (subrequestIDElement = element.element("subRequestID"))) {
            subrequestIDElement.addAttribute("value", requestID);
        }
        return null != requestIDElement;
    }

    private static void removeDuplicateChildren(Element element, String childName) {
        boolean first = true;
        for (Element child : element.elements(childName)) {
            if (first) {
                first = false;
                continue;
            }
            child.detach();
        }
    }

    private static void removeRequestIDValue(Element element) {
        Element subrequestIDElement;
        Element requestIDElement = element.element("requestID");
        if (null != requestIDElement) {
            requestIDElement.detach();
        }
        if (null != (subrequestIDElement = element.element("subRequestID"))) {
            subrequestIDElement.detach();
        }
        for (Element child : element.elements()) {
            Provider.removeRequestIDValue(child);
        }
    }

    public void constructXQEConfiguration() {
        if (this.mXQEConfigInitialized) {
            return;
        }
        if (XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE) != null) {
            this.mXQEConfigInitialized = true;
            return;
        }
        ICCLConfiguration ccl = XQECCLConfigurationFactory.getInstance();
        String effectivePath = ccl.resolveEffectivePath("../configuration");
        if ("../configuration".equals(effectivePath)) {
            XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQE, CommonClassesFactory.createXQEConfiguration(ServiceEnumeration.XQE, Provider.createProperties()));
        } else {
            XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQE, XQECCLConfigurationAdapter.createDefaultConfiguration());
        }
        this.mXQEConfigInitialized = true;
    }

    private static Properties createProperties() {
        Properties properties = new Properties();
        String userDirectory = System.getProperty("cog.dir") + File.separator;
        properties.setProperty("tempDirectory", userDirectory + "../temp");
        properties.setProperty("dataDirectory", userDirectory + "../data");
        properties.setProperty("configDirectory", userDirectory + "../configuration");
        properties.setProperty("binDirectory", userDirectory + ".");
        properties.setProperty("logsDirectory", userDirectory + "../logs");
        return properties;
    }

    private static synchronized XQELogger getLogger() {
        if (mErrorLogger == null) {
            mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
        }
        return mErrorLogger;
    }

    public boolean isRemoveNonExistentTuplesEnabled(ExecutionEnvironment executionEnv) {
        IDataSource dataSource = executionEnv.getDataSource();
        return dataSource != null && Boolean.valueOf(dataSource.getCapabilities().getStringValue("mdx.set.removeNonExistentTuples", Boolean.FALSE.toString())) != false;
    }

    public Object getKeyBlockingSameMDXExecution(ICube cube, MDXQuery mdxQuery, XDataContext dataContext) {
        return null;
    }

    public CountDownLatch getExistingGate(ICube cube, Object cacheKey, CountDownLatch newGate) {
        return null;
    }

    public boolean waitForCompleteOrTimeout(CountDownLatch gate) {
        return false;
    }

    public void preLoadCellValues(SelectQuery query, InterpreterContext interpreterContext, MDXQuery mdxQuery) {
    }

    public boolean isInProcessOfPreCellLoading() {
        return false;
    }

    private static class MDXParserVisitor
    extends MDXParserVisitorBase {
        MDXParserVisitor(MDXParser p) {
            super(p);
        }

        public ASTMDXStatement getMDXStatement() {
            return (ASTMDXStatement)this.getRootNode();
        }
    }
}

