/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.IMDXParameterValue;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.providers.olap.securecache.DMRMemberStorage;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.data.cache.AbstractCubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IResultSetCacheKeyMaker;
import com.cognos.xqe.runtree.olap.mdx.data.cache.SimpleCubeResultSetCache;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCubeWithCaching;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.ReusableDMRDimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Catalog;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContextKey;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorageManager;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.eviction.ConcurrentSimpleDLinkLRUMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CubeContext {
    private static final int MDXEXEC_CACHE_SIZE = 100;
    private static final int NUMBER_31 = 31;
    private static final int M = 0x100000;
    private Map<String, ReusableDMRDimension> dimensions;
    private Lock dimensionsReadLock;
    private Lock dimensionsWriteLock;
    protected CubeContextKey key;
    private final DMRMemberStorage memberStorage;
    private MemberStorage.MemberStorageIdentifier memberProviderMRCKey = null;
    private AdaptiveCubeletStorageManager cubeletStorageManager;
    private AbstractCubeResultSetCache resultSetCache = null;
    protected int keyId = 0;
    private DMRResultSetCacheKeyMaker keyMaker = null;
    protected final ConcurrentSimpleDLinkLRUMap<DMRResultSetCacheKey, CountDownLatch> mdxExecCache = new ConcurrentSimpleDLinkLRUMap(100);

    public CubeContext(CubeContextKey contextKey, DMRMemberStorage memberStore, int resultSetCacheSize, int id) {
        this.key = contextKey;
        this.cubeletStorageManager = new AdaptiveCubeletStorageManager(this);
        this.dimensions = new LinkedHashMap<String, ReusableDMRDimension>();
        this.memberStorage = memberStore;
        ReentrantReadWriteLock dimensionsLock = new ReentrantReadWriteLock();
        this.dimensionsReadLock = dimensionsLock.readLock();
        this.dimensionsWriteLock = dimensionsLock.writeLock();
        if (resultSetCacheSize > 0) {
            this.keyMaker = new DMRResultSetCacheKeyMaker();
            this.resultSetCache = new SimpleCubeResultSetCache(this.key.getModelPath(), this.keyMaker);
            this.resultSetCache.setMaxCacheSize(0x100000 * resultSetCacheSize);
        }
        this.keyId = id;
    }

    public CubeContextKey getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DMRDimension getDimension(DMRCube cube, IDimension wrappedDimension, ExecutionEnvironment execEnvironment) {
        if (wrappedDimension.isMeasuresDimension() || wrappedDimension.getName().startsWith("TBdimension_")) {
            DMRDimension dim = new DMRDimension(wrappedDimension.getName(), cube, wrappedDimension);
            dim.setCube(cube);
            return dim;
        }
        ReusableDMRDimension dim = null;
        this.dimensionsReadLock.lock();
        try {
            dim = this.dimensions.get(wrappedDimension.getUniqueName());
        }
        finally {
            this.dimensionsReadLock.unlock();
        }
        if (dim != null) {
            cube.addDimension(dim);
            dim.setWrappedDimension(wrappedDimension);
            dim.setCube(cube);
            return dim;
        }
        this.dimensionsWriteLock.lock();
        try {
            dim = this.dimensions.get(wrappedDimension.getUniqueName());
            if (dim != null) {
                cube.addDimension(dim);
                dim.setWrappedDimension(wrappedDimension);
                dim.setCube(cube);
                ReusableDMRDimension reusableDMRDimension = dim;
                return reusableDMRDimension;
            }
            dim = new ReusableDMRDimension(wrappedDimension.getName(), cube, wrappedDimension, execEnvironment);
            this.dimensions.put(dim.getUniqueName(), dim);
            dim.getDefaultHierarchy().getDefaultMember();
        }
        finally {
            this.dimensionsWriteLock.unlock();
        }
        dim.setCube(cube);
        return dim;
    }

    public static String buildStorageFilePath(String cubePath, String fileName, long cacheTimestamp) {
        StringBuilder strBuf = new StringBuilder(cubePath);
        strBuf.append(cacheTimestamp);
        strBuf.append(fileName);
        return strBuf.toString();
    }

    DMRCubeWithCaching buildDMRCube(CubeWrapper cubeWrapper, ExecutionEnvironment execEnvironment) {
        Catalog catalog = new Catalog(this.key.getModelPath());
        DMRCubeWithCaching cube = new DMRCubeWithCaching(catalog, cubeWrapper, this);
        for (IDimension dim : cubeWrapper.getDimensions()) {
            DMRDimension dmrDimension = this.getDimension(cube, dim, execEnvironment);
            if (dmrDimension != null) continue;
            throw new XQERuntimeException();
        }
        return cube;
    }

    public void close() {
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == env) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        return env;
    }

    public MemberStorage getMemberStorage() {
        return this.memberStorage;
    }

    public long getModelModificationTime() {
        return this.key.getModelModificationTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IHierarchy> getHierarchies(boolean bAll) {
        ArrayList<IHierarchy> r = new ArrayList<IHierarchy>();
        this.dimensionsReadLock.lock();
        try {
            Collection<ReusableDMRDimension> dims = this.dimensions.values();
            for (ReusableDMRDimension dim : dims) {
                if (bAll) {
                    r.addAll(dim.getHierarchies());
                    continue;
                }
                r.add(dim.getDefaultHierarchy());
            }
        }
        finally {
            this.dimensionsReadLock.unlock();
        }
        return r;
    }

    public AdaptiveCubeletStorageManager getCubeletStorageManager() {
        return this.cubeletStorageManager;
    }

    public void updateCubeContextKey(CubeContextKey cubeContextKey) {
        this.key.keyMap.putAll(cubeContextKey.keyMap);
    }

    public AbstractCubeResultSetCache getResultSetCache() {
        return this.resultSetCache;
    }

    public int getUniqueId() {
        return this.keyId;
    }

    public boolean checkParametersForResultCache(MDXQuery mdxQuery, XDataContext dataContext) {
        if (this.keyMaker == null) {
            return false;
        }
        return this.keyMaker.checkParametersForResultCache(mdxQuery, dataContext);
    }

    public Object makeCacheKey(ICube cube, MDXQuery mdxQuery, XDataContext dataContext) {
        if (!this.checkParametersForResultCache(mdxQuery, dataContext)) {
            return null;
        }
        return this.keyMaker.makeKey(cube, mdxQuery, dataContext);
    }

    public CountDownLatch getExistingGate(Object cacheKey, CountDownLatch newGate) {
        return this.mdxExecCache.putIfAbsent((DMRResultSetCacheKey)cacheKey, newGate);
    }

    protected final class DMRResultSetCacheKey {
        private String mdxString = null;
        private TreeSet<String> paramNames = null;
        private ArrayList<String> paramValues = null;

        protected DMRResultSetCacheKey() {
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("mdx=");
            if (this.mdxString != null) {
                buffer.append(this.mdxString);
            }
            buffer.append(", mdxParameterNames=");
            if (this.paramNames != null) {
                buffer.append(this.paramNames.toString());
            }
            buffer.append(", mdxParameterValues=");
            if (this.paramValues != null) {
                buffer.append(this.paramValues.toString());
            }
            return buffer.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DMRResultSetCacheKey)) {
                return false;
            }
            DMRResultSetCacheKey other = (DMRResultSetCacheKey)o;
            boolean b = false;
            b = this.mdxString == null && other.mdxString == null ? true : (this.mdxString == null || other.mdxString == null ? false : this.mdxString.equals(other.mdxString));
            if (!b) {
                return false;
            }
            b = this.paramNames == null && other.paramNames == null ? true : (this.paramNames == null || other.paramNames == null ? false : this.paramNames.equals(other.paramNames));
            if (!b) {
                return false;
            }
            if (this.paramValues == null && other.paramValues == null) {
                return true;
            }
            if (this.paramValues == null || other.paramValues == null) {
                return false;
            }
            return this.paramValues.equals(other.paramValues);
        }

        public int hashCode() {
            int hc = 1;
            if (this.mdxString != null) {
                hc = hc * 31 + this.mdxString.hashCode();
            }
            if (this.paramNames != null) {
                hc = hc * 31 + this.paramNames.hashCode();
            }
            if (this.paramValues != null) {
                hc = hc * 31 + this.paramValues.hashCode();
            }
            return hc;
        }
    }

    protected final class DMRResultSetCacheKeyMaker
    implements IResultSetCacheKeyMaker {
        private final ConcurrentMap<DMRResultSetCacheKey, DMRResultSetCacheKey> keyForParams = new ConcurrentHashMap<DMRResultSetCacheKey, DMRResultSetCacheKey>();

        protected DMRResultSetCacheKeyMaker() {
        }

        private boolean checkParametersForResultCache(MDXQuery mdxQuery, XDataContext dataContext) {
            List<IXQEQueryNode> params = mdxQuery.getMDXParameters();
            if (params.isEmpty()) {
                return true;
            }
            TreeSet<String> names = new TreeSet<String>();
            ArrayList<String> values = new ArrayList<String>();
            this.getParametersValues(dataContext, params, names, values);
            DMRResultSetCacheKey k1 = this.makeCacheKey(mdxQuery.getMDX(), names, null);
            DMRResultSetCacheKey k2 = this.makeCacheKey(null, null, values);
            DMRResultSetCacheKey k = this.keyForParams.putIfAbsent(k1, k2);
            return k == null || k.equals(k2);
        }

        @Override
        public Object makeKey(ICube cube, MDXQuery mdxQuery, XDataContext dataContext) {
            List<IXQEQueryNode> params = mdxQuery.getMDXParameters();
            if (params.isEmpty()) {
                return this.makeCacheKey(mdxQuery.getMDX(), null, null);
            }
            TreeSet<String> names = new TreeSet<String>();
            ArrayList<String> values = new ArrayList<String>();
            this.getParametersValues(dataContext, params, names, values);
            return this.makeCacheKey(mdxQuery.getMDX(), names, values);
        }

        private void getParametersValues(XDataContext dataContext, List<IXQEQueryNode> params, TreeSet<String> pnames, ArrayList<String> values) {
            TreeMap<String, String> keyValues = new TreeMap<String, String>();
            for (IXQEQueryNode node : params) {
                if (node instanceof IMDXParameterValue) {
                    IMDXParameterValue param = (IMDXParameterValue)((Object)node);
                    keyValues.put(param.getName(), param.getExternalValues().toString());
                    continue;
                }
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected type for MDX parameter: " + node.getClass().toString());
            }
            pnames.addAll(keyValues.keySet());
            values.addAll(keyValues.values());
        }

        private DMRResultSetCacheKey makeCacheKey(String mdx, TreeSet<String> names, ArrayList<String> values) {
            DMRResultSetCacheKey k = new DMRResultSetCacheKey();
            k.mdxString = mdx;
            k.paramNames = names;
            k.paramValues = values;
            return k;
        }
    }
}

