/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache;

import com.cognos.xqe.cache.ICacheFaultHandler;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.storage.BTreeCacheStorage;
import com.cognos.xqe.cache.util.CacheableNameValueBasedArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MetadataCacheKey
implements ICacheKey {
    private static int maxMembers = Integer.MAX_VALUE;
    private static final long serialVersionUID = 4369142657662043463L;
    private static final int KEY_ID = 0xFFFFFFF;
    private static final long KEYLONG_ID = 0xFFFFFFF00000000L;
    private static final int NUMBER_61 = 61;
    private long keyValue;
    private static final long MEMBER_KEY = 0x1000000000000000L;
    private static final long LEVEL_KEY = 0x2000000000000000L;
    private static Class<?> cachedClass;

    public MetadataCacheKey() {
        this.keyValue = -1L;
    }

    public MetadataCacheKey(long aKeyValue) {
        this.keyValue = aKeyValue;
    }

    public MetadataCacheKey(int metadataParentId, int metadataChildId) {
        this.keyValue = (long)metadataParentId << 32 & 0xFFFFFFF00000000L | (long)metadataChildId | 0x1000000000000000L;
    }

    public MetadataCacheKey(int levelId) {
        this.keyValue = (long)levelId | 0x2000000000000000L;
    }

    public int getMetadataParentId() {
        return (int)(this.keyValue >> 32) & 0xFFFFFFF;
    }

    public int getMetadataChildId() {
        return (int)this.keyValue & 0xFFFFFFFF;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        try {
            return this.keyValue == ((MetadataCacheKey)obj).keyValue;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        return (int)this.keyValue * 61;
    }

    @Override
    public void writeToStream(ObjectOutputStream out) throws IOException {
        out.writeLong(this.keyValue);
    }

    @Override
    public void readFromStream(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.keyValue = in.readLong();
    }

    public long getKeyValue() {
        return this.keyValue;
    }

    @Override
    public ICacheKey cloneKey() {
        return this;
    }

    @Override
    public ICacheFaultHandler getFaultHandler() {
        return null;
    }

    @Override
    public byte[] getBytes() {
        return BTreeCacheStorage.convertLong(this.keyValue);
    }

    @Override
    public Class<?> getCacheableObjectClass() {
        return cachedClass;
    }

    public static void setCachedClass(Class<?> clazz) {
        cachedClass = clazz;
    }

    @Override
    public int compareTo(ICacheKey o) {
        if (o.getClass() != this.getClass()) {
            return 1;
        }
        Long value = new Long(this.keyValue);
        return value.compareTo(((MetadataCacheKey)o).keyValue);
    }

    @Override
    public long getLong() {
        return this.keyValue;
    }

    @Override
    public Object getPartition() {
        String partition = Integer.toString(this.getMetadataParentId());
        int subPartition = this.getMetadataChildId() / maxMembers;
        if (subPartition == 0) {
            return partition;
        }
        return partition + "." + subPartition;
    }

    static {
        String max = System.getProperty("MAX_MEMBERS_PER_CACHE_FILE");
        if (max != null) {
            maxMembers = Integer.parseInt(max);
        }
        cachedClass = CacheableNameValueBasedArray.class;
    }
}

