/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.platform;

import com.cognos.xqe.runtree.olap.mdx.platform.StringReplacer;
import com.cognos.xqe.runtree.olap.mdx.util.VersionInformation;
import com.cognos.xqe.trace.XQEDebugLog;
import java.io.File;
import java.util.HashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Environment {
    static String webContext = null;
    static Boolean compressXMLAResponses;
    static Boolean infoCubeLogging;
    static boolean cognosEnvironment;
    static String cognosDataPath;
    static String cognosTempPath;
    static HashMap<String, Object> configuration;
    public static final String PERIOD = ".";
    public static final String INIT_CTXT_KEY = "java:comp/env";
    public static final String TRUE = "true";
    public static final String DIGITALASPECTS = "DigitalAspects/";
    public static final String WEB_CONTEXT = "$WEB-CONTEXT$";

    public static String getVersion() {
        return VersionInformation.majorVersion() + PERIOD + VersionInformation.minorVersion() + PERIOD + VersionInformation.revision() + " build: " + VersionInformation.buildId();
    }

    public static Object getConfigurationItem(String key) {
        if (configuration == null) {
            configuration = new HashMap();
        }
        return configuration.get(key);
    }

    public static void setConfigurationItem(String key, Object item) {
        if (configuration == null) {
            configuration = new HashMap();
        }
        configuration.put(key, item);
    }

    public static void setCognosDataPath(String dataPath) {
        cognosEnvironment = true;
        cognosDataPath = dataPath;
    }

    public static void setCognosTempPath(String tempPath) {
        cognosEnvironment = true;
        cognosTempPath = tempPath;
    }

    public static boolean isCognosEnvironment() {
        return cognosEnvironment;
    }

    public static void setWebContext(String context) {
        webContext = context;
    }

    public static String getSentencesServerLocation() {
        String path = null;
        try {
            Context env = (Context)new InitialContext().lookup(INIT_CTXT_KEY);
            path = (String)env.lookup("DigitalAspects/SentencesServerLocation");
            XQEDebugLog.out.println("DigitalAspects/SentencesServerLocation = " + path);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return path;
    }

    public static boolean getBooleanEnvironmentVariable(String name) {
        String strVar = Environment.getEnvironmentVariable(name);
        return strVar != null && strVar.equalsIgnoreCase(TRUE);
    }

    public static String getEnvironmentVariable(String name) {
        String path = null;
        if (cognosEnvironment) {
            if (name.startsWith(DIGITALASPECTS)) {
                name = name.substring(DIGITALASPECTS.length());
                name = name.substring(0, 1).toLowerCase() + name.substring(1);
            }
            path = (String)Environment.getConfigurationItem(name);
        } else {
            try {
                Context env = (Context)new InitialContext().lookup(INIT_CTXT_KEY);
                path = env.lookup(name).toString();
                XQEDebugLog.out.println(name + " = " + path);
            }
            catch (NamingException e) {
                return "";
            }
        }
        return path;
    }

    public static boolean getDebugging() {
        boolean debugging = true;
        if (!cognosEnvironment) {
            try {
                Context env = (Context)new InitialContext().lookup(INIT_CTXT_KEY);
                debugging = (Boolean)env.lookup("DigitalAspects/Debugging");
                XQEDebugLog.out.println("DigitalAspects/Debugging = " + debugging);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return debugging;
    }

    public static String getDataPath() {
        return Environment.getDataPath(false);
    }

    public static String getDataPath(boolean quietly) {
        String path = null;
        if (cognosEnvironment) {
            path = cognosDataPath;
            if (path == null) {
                path = "c:\\Cubics\\data";
            }
        } else {
            try {
                Context env = (Context)new InitialContext().lookup(INIT_CTXT_KEY);
                path = (String)env.lookup("DigitalAspects/DataDir");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (path == null) {
                path = System.getProperty("user.dir");
            }
            if (path == null) {
                path = System.getProperty("user.home");
            }
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (webContext != null && path.indexOf(WEB_CONTEXT) >= 0) {
                path = StringReplacer.substitute(path, WEB_CONTEXT, webContext);
            }
        }
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        return path;
    }

    public static String getTempPath() {
        String tempPath = null;
        if (cognosEnvironment) {
            tempPath = cognosTempPath;
        }
        if (tempPath == null) {
            tempPath = "c:\\Cubics\\temp";
        }
        return tempPath;
    }

    public static boolean getCompressXMLAResponses() {
        if (compressXMLAResponses == null) {
            compressXMLAResponses = Boolean.FALSE;
            if (cognosEnvironment) {
                String value = (String)Environment.getConfigurationItem("CompressXMLAResponses");
                if (value != null && value.equalsIgnoreCase(TRUE)) {
                    compressXMLAResponses = Boolean.TRUE;
                }
            } else {
                try {
                    Context env = (Context)new InitialContext().lookup(INIT_CTXT_KEY);
                    compressXMLAResponses = (boolean)((Boolean)env.lookup("DigitalAspects/CompressXMLAResponses"));
                    XQEDebugLog.out.println("DigitalAspects/CompressXMLAResponses = " + compressXMLAResponses);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return compressXMLAResponses;
    }

    public static boolean getXMLALogging() {
        boolean saveRequestAndResponses = false;
        if (cognosEnvironment) {
            String value = (String)Environment.getConfigurationItem("XMLALogging");
            saveRequestAndResponses = value != null && value.equalsIgnoreCase(TRUE);
        } else {
            try {
                Context env = (Context)new InitialContext().lookup(INIT_CTXT_KEY);
                saveRequestAndResponses = (Boolean)env.lookup("DigitalAspects/XMLALogging");
                XQEDebugLog.out.println("DigitalAspects/XMLALogging = " + saveRequestAndResponses);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return saveRequestAndResponses;
    }

    public static void setInfoCubeLogging(boolean b) {
        infoCubeLogging = b;
    }

    public static boolean getInfoCubeLogging() {
        if (infoCubeLogging == null) {
            infoCubeLogging = Boolean.FALSE;
            if (cognosEnvironment) {
                String value = (String)Environment.getConfigurationItem("InfoCubeLogging");
                if (value != null && value.equalsIgnoreCase(TRUE)) {
                    infoCubeLogging = Boolean.TRUE;
                }
            } else {
                try {
                    Context env = (Context)new InitialContext().lookup(INIT_CTXT_KEY);
                    infoCubeLogging = (Boolean)env.lookup("DigitalAspects/InfoCubeLogging");
                    XQEDebugLog.out.println("DigitalAspects/InfoCubeLogging = " + infoCubeLogging);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return infoCubeLogging;
    }

    static {
        cognosEnvironment = false;
        cognosDataPath = null;
        cognosTempPath = null;
    }
}

