/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import java.util.StringTokenizer;

public class ExecuteQueryStrategyLogMsg {
    private static final int TOTAL_TUPLE_POSITION = 0;
    private static final int DATA_CACHE_TUPLE_POSITION = 1;
    private static final int AGGR_CUBE_TUPLE_POSITION = 2;
    private static final int DB_TUPLE_POSITION = 3;
    private static final int PUSHDOWN_TUPLE_POSITION = 4;
    private static final int AGGR_CACHE_TUPLE_POSITION = 5;
    private static final int AGGR_CACHE_TIME_POSITION = 6;
    private static final int AGGR_CACHE_NUM_TASKS_POSITION = 7;
    private static final int AGGR_CACHE_CELLS_POSITION = 8;
    private static final int AGGR_CACHE_ROLLUP_LOCATIONS_POSITION = 9;
    private static final int EXPECTED_NUMBERS = 10;
    private static final String REQUESTED_TEXT = "Requested";
    private static final String REPORT_TEXT = "report";
    private long totalTuples = 0L;
    private int dataCacheTuples = 0;
    private int aggregateCubeTuples = 0;
    private int databaseTuples = 0;
    private int pushdownTuples = 0;
    private int aggregateCacheTuples = 0;
    private long aggregateCacheTime = 0L;
    private long numAggregateCacheCells = 0L;
    private int numAggregateCacheRollupLocations = 0;
    private int numAggregateCacheTasks = 0;
    private String reportName = null;

    public ExecuteQueryStrategyLogMsg(long aTotalTuples, ROLAPQueryExecuteMetrics queryMetrics) {
        this.totalTuples = aTotalTuples;
        this.dataCacheTuples = queryMetrics.getDataCacheHits();
        this.aggregateCubeTuples = queryMetrics.getAggrCubeHits();
        this.databaseTuples = queryMetrics.getFetchCount();
        this.pushdownTuples = queryMetrics.getPushdownHits();
        this.aggregateCacheTuples = queryMetrics.getAggrCacheHits();
        this.aggregateCacheTime = queryMetrics.getTotalInMemoryAggregateTime();
        this.numAggregateCacheCells = queryMetrics.getAggregateQueryCellCount();
        this.numAggregateCacheRollupLocations = queryMetrics.getAggregateQueryCellRollupLocations();
        this.numAggregateCacheTasks = queryMetrics.getNumAggregateQueryTasks();
    }

    public String toString() {
        String msg = String.format("Finished execution of Query Strategy for report " + this.reportName + "\n   " + REQUESTED_TEXT + " %d tuples\n   Found %d tuples in data cache\n   Found %d tuples in aggregate cubes\n   Fetched %d tuples from database\n   %d of the tuples were from pushdown queries\n   Created %d tuples from the aggregate cache\n      Total time processing aggregates : %d (ms) using %d tasks\n            %d aggregate cells rolled up into %d separate locations\n", this.totalTuples, this.dataCacheTuples, this.aggregateCubeTuples, this.databaseTuples, this.pushdownTuples, this.aggregateCacheTuples, this.aggregateCacheTime, this.numAggregateCacheTasks, this.numAggregateCacheCells, this.numAggregateCacheRollupLocations);
        return msg;
    }

    public static ExecuteQueryStrategyLogMsg fromString(String text) {
        ExecuteQueryStrategyLogMsg logMsg = new ExecuteQueryStrategyLogMsg();
        StringTokenizer st = new StringTokenizer(text);
        int foundNumberCount = 0;
        boolean foundRequestedText = false;
        boolean foundReportText = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.charAt(0) >= '0' && token.charAt(0) <= '9' && foundRequestedText) {
                try {
                    long numericValue = Long.valueOf(token);
                    ExecuteQueryStrategyLogMsg.saveValue(numericValue, logMsg, foundNumberCount);
                    ++foundNumberCount;
                }
                catch (NumberFormatException numericValue) {}
                continue;
            }
            if (REQUESTED_TEXT.equals(token)) {
                foundRequestedText = true;
                continue;
            }
            if (REPORT_TEXT.equals(token)) {
                foundReportText = true;
                continue;
            }
            if (!foundReportText || foundRequestedText) continue;
            String reportName = logMsg.getReportName();
            if (reportName == null) {
                logMsg.setReportName(token);
                continue;
            }
            reportName = reportName + " " + token;
            logMsg.setReportName(reportName);
        }
        if (foundNumberCount != 10) {
            logMsg = null;
        }
        return logMsg;
    }

    public final long getAggregateCacheCellFetchTime() {
        return 0L;
    }

    public final long getAggregateCacheCellRollupTime() {
        return 0L;
    }

    public final long getTotalTuples() {
        return this.totalTuples;
    }

    public final int getDataCacheTuples() {
        return this.dataCacheTuples;
    }

    public final int getAggregateCubeTuples() {
        return this.aggregateCubeTuples;
    }

    public final int getDatabaseTuples() {
        return this.databaseTuples;
    }

    public final int getPushdownTuples() {
        return this.pushdownTuples;
    }

    public final int getAggregateCacheTuples() {
        return this.aggregateCacheTuples;
    }

    public final long getAggregateCacheTime() {
        return this.aggregateCacheTime;
    }

    public final long getNumAggregateCacheCells() {
        return this.numAggregateCacheCells;
    }

    public final int getNumAggregateCacheRollupLocations() {
        return this.numAggregateCacheRollupLocations;
    }

    public final String getReportName() {
        return this.reportName;
    }

    public final void setReportName(String aReportName) {
        this.reportName = aReportName;
    }

    private ExecuteQueryStrategyLogMsg() {
    }

    private static void saveValue(long numericValue, ExecuteQueryStrategyLogMsg logMsg, int foundNumberCount) {
        switch (foundNumberCount) {
            case 0: {
                logMsg.totalTuples = numericValue;
                break;
            }
            case 1: {
                logMsg.dataCacheTuples = (int)numericValue;
                break;
            }
            case 2: {
                logMsg.aggregateCubeTuples = (int)numericValue;
                break;
            }
            case 3: {
                logMsg.databaseTuples = (int)numericValue;
                break;
            }
            case 4: {
                logMsg.pushdownTuples = (int)numericValue;
                break;
            }
            case 5: {
                logMsg.aggregateCacheTuples = (int)numericValue;
                break;
            }
            case 6: {
                logMsg.aggregateCacheTime = numericValue;
                break;
            }
            case 7: {
                logMsg.numAggregateCacheTasks = (int)numericValue;
                break;
            }
            case 8: {
                logMsg.numAggregateCacheCells = numericValue;
                break;
            }
            case 9: {
                logMsg.numAggregateCacheRollupLocations = (int)numericValue;
                break;
            }
        }
    }
}

