/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.i18n.NumericFormat;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MemberOperations;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDataMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchyMemberLoader;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCustomBaseRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCustomPTDRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCustomRollingTotalRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCustomSimpleRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.V5ExpressionUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.DummyVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMemberDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class ROLAPAbstractHierarchy
extends Hierarchy
implements IROLAPHierarchy {
    public static final String SPACE = " ";
    private static final String COMMA = ",";
    public static final String DOT_LEFT_BRACKET = ".[";
    public static final String RIGHT_BRACKET = "]";
    public static final String LEFT_PARENTHESIS = "(";
    public static final String RIGHT_PARENTHESIS = ")";
    public static final String TO_SPACE_DATE = "to Date";
    public static final String ZERO = "0";
    public static final String RIGHT_PAREN_MINUS_LEFT_PARENT = ") - (";
    public static final String DIVISION_SYMBOL = "/";
    public static final String AGGREGATE_CURRENTMEMBER = "AGGREGATE(CURRENTMEMBER( ";
    public static final String WITHIN_SET_SET = ") WITHIN SET SET( ";
    public static final String WITHIN_SET_PERIODSTODATE = ") WITHIN SET PERIODSTODATE( ";
    public static final String RIGHT_RIGHT_PARENTHESIS = ")) ";
    public static final int MIN_PARENT_NAME_PARTS = 2;
    private HashMapObjectInt<String> sharedOrdinalMap = new HashMapObjectInt(-1);
    private HierarchyCalculatedMembersContainer hierarchyCalculatedMembersContainer = new HierarchyCalculatedMembersContainer();

    public ROLAPAbstractHierarchy(String name, Dimension d) {
        super(name, d);
    }

    protected abstract IMember createCalculatedMember(IROLAPCube var1, String var2, IMember var3, int var4, IMember var5, String var6, ROLAPMetaObject var7, Set<String> var8);

    protected boolean isRelativeTimeEnabled() {
        return false;
    }

    public boolean shouldShowRelativeTimePriorPeriodMembers() {
        return true;
    }

    public boolean shouldShowRelativeTimeNextPeriodMembers() {
        return true;
    }

    public boolean shouldShowRelativeTimeSubtreeMembers() {
        return true;
    }

    public void createRelativeTimeMembers(IROLAPCube cube) {
        if (!this.isRelativeTimeEnabled()) {
            return;
        }
        IMember refMember = this.getLeafLevelCurrentPeriodMember();
        if (refMember != null) {
            HashMap<ILevel, IMember> currentPeriodMemberToLevelMap = new HashMap<ILevel, IMember>();
            HashMap<ILevel, IMember> rtCurrentPeriodMemberToLevelMap = new HashMap<ILevel, IMember>();
            HashMap<ILevel, IMember> rtCurrentPTDMemberToLevelMap = new HashMap<ILevel, IMember>();
            this.addRelativeTimeMembersRecursive(cube, refMember, currentPeriodMemberToLevelMap, rtCurrentPeriodMemberToLevelMap);
            this.addRelativeTimePTDMembersRecursive(cube, refMember, currentPeriodMemberToLevelMap, rtCurrentPTDMemberToLevelMap);
            this.addCustomRelativeTimeMembers(cube, currentPeriodMemberToLevelMap, rtCurrentPeriodMemberToLevelMap, rtCurrentPTDMemberToLevelMap);
        }
    }

    public IMember getLeafLevelCurrentPeriodMember() {
        IMember member = this.getCurrentPeriodMember();
        if (member != null) {
            List<IMember> members;
            int childrenCount;
            int levelCount = this.getLevelCount();
            ILevel leafLevel = this.getLevel(levelCount - 1);
            for (ILevel level = member.getLevel(); level != leafLevel && (childrenCount = (members = member.getChildren()).size()) > 0; level = level.getNextLevel()) {
                member = members.get(childrenCount - 1);
            }
        }
        return member;
    }

    public IMember getCurrentPeriodMember() {
        ILevel level = this.getLevel(0);
        List<IMember> levelMembers = level.getMembers();
        return levelMembers.get(0);
    }

    private IMember addRelativeTimeMembersRecursive(IROLAPCube cube, IMember refCurrentPeriodMember, Map<ILevel, IMember> currentPeriodMemberToLevelMap, Map<ILevel, IMember> rtCurrentPeriodMemberToLevelMap) {
        if (refCurrentPeriodMember == null) {
            return null;
        }
        if (((Level)refCurrentPeriodMember.getLevel()).isAllLevel()) {
            return refCurrentPeriodMember;
        }
        currentPeriodMemberToLevelMap.put(refCurrentPeriodMember.getLevel(), refCurrentPeriodMember);
        IMember refCurrentPeriodParent = refCurrentPeriodMember.getParent();
        IMember parent = null;
        parent = refCurrentPeriodParent == this.getRootMember() ? refCurrentPeriodParent : this.addRelativeTimeMembersRecursive(cube, refCurrentPeriodParent, currentPeriodMemberToLevelMap, rtCurrentPeriodMemberToLevelMap);
        ROLAPCalculatedMember currentPeriodMember = this.addRelativeTimeMemberAndChildrenRecursive(cube, 1, parent, refCurrentPeriodMember, 0, null);
        rtCurrentPeriodMemberToLevelMap.put(refCurrentPeriodMember.getLevel(), currentPeriodMember);
        if (this.shouldShowRelativeTimePriorPeriodMembers()) {
            IMember refPriorPeriodMember = MemberOperations.getPreviousMemberOp(refCurrentPeriodMember, false);
            this.addRelativeTimeMemberAndChildrenRecursive(cube, 2, parent, refPriorPeriodMember, 0, null);
        }
        if (this.shouldShowRelativeTimeNextPeriodMembers()) {
            IMember refNextPeriodMember = MemberOperations.getNextMemberOp(refCurrentPeriodMember, false);
            this.addRelativeTimeMemberAndChildrenRecursive(cube, 9, parent, refNextPeriodMember, 0, null);
        }
        return currentPeriodMember;
    }

    private ROLAPCalculatedMember addRelativeTimeMemberAndChildrenRecursive(IROLAPCube cube, int relativeMemberType, IMember parent, IMember refMember, int childPosition, Map<ILevel, IMember> cpMemberToLevelMap) {
        ROLAPCalculatedMember member;
        if (refMember == null || refMember instanceof NullMember) {
            return null;
        }
        String memberName = null;
        memberName = relativeMemberType != 7 ? ROLAPRelativeTimeMember.getMemberName(relativeMemberType, refMember.getLevel()) : Integer.toString(childPosition);
        String memberCaption = refMember.getCaption();
        if (relativeMemberType > 0) {
            memberCaption = ROLAPRelativeTimeMember.getMemberCaption(relativeMemberType, refMember.getLevel(), refMember, this.getDefaultLocale());
        }
        if ((member = (ROLAPCalculatedMember)this.createCalculatedMember(cube, memberName, parent, relativeMemberType, refMember, null, null, null)) != null) {
            member.setCaption(memberCaption);
        }
        if (relativeMemberType == 7 && parent != null && !((Level)parent.getLevel()).isAllLevel()) {
            ((ROLAPCalculatedMember)parent).addChildMember(member);
        }
        if (this.shouldShowRelativeTimeSubtreeMembers()) {
            List<IMember> members = refMember.getChildren();
            int childrenCount = members.size();
            IMember lastChild = null;
            for (int i = 0; i < childrenCount; ++i) {
                IMember child = members.get(i);
                this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, cpMemberToLevelMap);
                if (i == 0) {
                    lastChild = cpMemberToLevelMap == null ? members.get(childrenCount - 1) : cpMemberToLevelMap.get(child.getLevel());
                }
                if (child == lastChild) break;
            }
        }
        return member;
    }

    private IMember addRelativeTimePTDMembersRecursive(IROLAPCube cube, IMember refCurrentPeriodMember, Map<ILevel, IMember> currentPeriodMemberToLevelMap, Map<ILevel, IMember> rtCurrentPTDMemberToLevelMap) {
        if (refCurrentPeriodMember == null) {
            return null;
        }
        if (((Level)refCurrentPeriodMember.getLevel()).isAllLevel()) {
            return refCurrentPeriodMember;
        }
        currentPeriodMemberToLevelMap.put(refCurrentPeriodMember.getLevel(), refCurrentPeriodMember);
        IMember refCurrentPeriodParent = refCurrentPeriodMember.getParent();
        IMember parent = null;
        parent = refCurrentPeriodParent == this.getRootMember() ? refCurrentPeriodParent : this.addRelativeTimePTDMembersRecursive(cube, refCurrentPeriodParent, currentPeriodMemberToLevelMap, rtCurrentPTDMemberToLevelMap);
        IMember refPriorPeriodMember = MemberOperations.getPreviousMemberOp(refCurrentPeriodMember, false);
        IMember refNextPeriodMember = MemberOperations.getNextMemberOp(refCurrentPeriodMember, false);
        if (refCurrentPeriodMember.getLevel() == this.getLevel(this.getLevelCount() - 1)) {
            ROLAPCalculatedMember currentPeriodMember = this.addRelativeTimeMemberAndChildrenRecursive(cube, 1, parent, refCurrentPeriodMember, 0, null);
            if (this.shouldShowRelativeTimePriorPeriodMembers()) {
                this.addRelativeTimeMemberAndChildrenRecursive(cube, 2, parent, refPriorPeriodMember, 0, null);
            }
            if (this.shouldShowRelativeTimeNextPeriodMembers()) {
                this.addRelativeTimeMemberAndChildrenRecursive(cube, 9, parent, refNextPeriodMember, 0, null);
            }
            return null;
        }
        IMember currentPTD = this.addRelativeTimePeriodToDateAndDescendants(cube, 3, parent, refCurrentPeriodMember, 0, currentPeriodMemberToLevelMap);
        rtCurrentPTDMemberToLevelMap.put(refCurrentPeriodMember.getLevel(), currentPTD);
        if (refPriorPeriodMember != null && !(refPriorPeriodMember instanceof NullMember)) {
            IMember priorPTD = this.addRelativeTimePriorPeriodToDateAndDescendants(cube, parent, refPriorPeriodMember, refCurrentPeriodMember, null, currentPeriodMemberToLevelMap, this.shouldShowRelativeTimePriorPeriodMembers());
            this.addRelativeTimePeriodToDateChangeOrGrowth(cube, 5, parent, refCurrentPeriodMember, currentPTD, priorPTD);
            this.addRelativeTimePeriodToDateChangeOrGrowth(cube, 6, parent, refCurrentPeriodMember, currentPTD, priorPTD);
            if (!this.shouldShowRelativeTimePriorPeriodMembers()) {
                ArrayList<ROLAPCalculatedMember> calcsToremove = new ArrayList<ROLAPCalculatedMember>();
                calcsToremove.add((ROLAPCalculatedMember)priorPTD);
                cube.removeCalculatedMembers(calcsToremove);
            }
        }
        if (refNextPeriodMember != null && !(refNextPeriodMember instanceof NullMember) && this.shouldShowRelativeTimeNextPeriodMembers()) {
            IMember nextPTD = this.addRelativeTimeNextPeriodToDateAndDescendants(cube, parent, refNextPeriodMember, refCurrentPeriodMember, null, currentPeriodMemberToLevelMap);
            this.addRelativeTimePeriodToDateChangeOrGrowth(cube, 11, parent, refNextPeriodMember, nextPTD, currentPTD);
            this.addRelativeTimePeriodToDateChangeOrGrowth(cube, 12, parent, refNextPeriodMember, nextPTD, currentPTD);
        }
        return currentPTD;
    }

    private IMember addRelativeTimePeriodToDateAndDescendants(IROLAPCube cube, int relaTimeMemberType, IMember parent, IMember refMember, int childPosition, Map<ILevel, IMember> cpMemberToLevelMap) {
        if (refMember == null || refMember instanceof NullMember) {
            return null;
        }
        ILevel currentPeriodLeafLevel = this.getLevel(this.getLevelCount() - 1);
        String memberName = null;
        memberName = relaTimeMemberType == 8 ? Integer.toString(childPosition) : ROLAPRelativeTimeMember.getMemberName(relaTimeMemberType, refMember.getLevel());
        String v5Expression = null;
        if (!(this.getDimension().getCube() instanceof DummyVirtualCube)) {
            v5Expression = AGGREGATE_CURRENTMEMBER + this.getDimension().getCube().getMeasuresHierarchy().getV5UniqueName() + WITHIN_SET_PERIODSTODATE + ((IROLAPLevel)refMember.getLevel()).getV5UniqueName(cube.getName()) + this.getDelimiter() + ((IROLAPMember)cpMemberToLevelMap.get(currentPeriodLeafLevel)).getV5UniqueName(cube.getName()) + RIGHT_RIGHT_PARENTHESIS;
        }
        ROLAPCalculatedMember member = (ROLAPCalculatedMember)this.createCalculatedMember(cube, memberName, parent, relaTimeMemberType, refMember, v5Expression, null, null);
        String memberCaption = ROLAPRelativeTimeMember.getMemberCaption(relaTimeMemberType, refMember.getLevel(), refMember, this.getDefaultLocale());
        if (member != null) {
            member.setCaption(memberCaption);
            ((ROLAPRelativeTimeMember)member).generatePTDRuntreeNode(refMember.getLevel(), cpMemberToLevelMap.get(currentPeriodLeafLevel));
        }
        if (parent != null && !((Level)parent.getLevel()).isAllLevel()) {
            if (relaTimeMemberType == 7) {
                ((ROLAPCalculatedMember)parent).addChildMember(member);
            } else if (relaTimeMemberType == 8) {
                if (((ROLAPRelativeTimeMember)parent).isAddPeriodToDateLastChildEnabled()) {
                    ((ROLAPRelativeTimeMember)parent).addChildMember(member);
                }
                ((ROLAPRelativeTimeMember)parent).setPtdLastChild(member);
            }
        }
        if (this.shouldShowRelativeTimeSubtreeMembers()) {
            List<IMember> members = refMember.getChildren();
            int childrenCount = members.size();
            IMember lastChild = null;
            for (int i = 0; i < childrenCount; ++i) {
                IMember child = members.get(i);
                if (i == 0) {
                    lastChild = cpMemberToLevelMap == null ? members.get(childrenCount - 1) : cpMemberToLevelMap.get(child.getLevel());
                }
                if (child == lastChild) {
                    if (child.getLevel() != currentPeriodLeafLevel) {
                        this.addRelativeTimePeriodToDateAndDescendants(cube, 8, member, child, i, cpMemberToLevelMap);
                        break;
                    }
                    this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, cpMemberToLevelMap);
                    break;
                }
                this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, cpMemberToLevelMap);
            }
        }
        return member;
    }

    private IMember addRelativeTimePriorPeriodToDateAndDescendants(IROLAPCube cube, IMember parent, IMember refMember, IMember nextMember, String memberCaption, Map<ILevel, IMember> currentPeriodMemberToLevelMap, boolean includeChildren) {
        if (refMember == null || refMember instanceof NullMember) {
            return null;
        }
        ILevel currentPeriodLeafLevel = this.getLevel(this.getLevelCount() - 1);
        HashMap<ILevel, IMember> priorPeriodMemberToLevelMap = new HashMap<ILevel, IMember>();
        this.calculatePriorPeriodMemberToLevelMap(nextMember, refMember, priorPeriodMemberToLevelMap, currentPeriodMemberToLevelMap);
        String memberName = ROLAPRelativeTimeMember.getMemberName(4, refMember.getLevel());
        String v5Expression = null;
        if (!(this.getDimension().getCube() instanceof DummyVirtualCube)) {
            v5Expression = AGGREGATE_CURRENTMEMBER + this.getDimension().getCube().getMeasuresHierarchy().getV5UniqueName() + WITHIN_SET_PERIODSTODATE + ((IROLAPLevel)refMember.getLevel()).getV5UniqueName(cube.getName()) + this.getDelimiter() + ((IROLAPMember)priorPeriodMemberToLevelMap.get(currentPeriodLeafLevel)).getV5UniqueName(cube.getName()) + RIGHT_RIGHT_PARENTHESIS;
        }
        ROLAPCalculatedMember member = (ROLAPCalculatedMember)this.createCalculatedMember(cube, memberName, parent, 4, refMember, v5Expression, null, null);
        if (memberCaption == null) {
            memberCaption = ROLAPRelativeTimeMember.getMemberCaption(4, refMember.getLevel(), refMember, this.getDefaultLocale());
        }
        if (member != null) {
            member.setCaption(memberCaption);
            ((ROLAPRelativeTimeMember)member).generatePTDRuntreeNode(refMember.getLevel(), (IMember)priorPeriodMemberToLevelMap.get(currentPeriodLeafLevel));
        }
        if (includeChildren && this.shouldShowRelativeTimeSubtreeMembers()) {
            List<IMember> members = refMember.getChildren();
            int childrenCount = members.size();
            IMember lastChild = null;
            for (int i = 0; i < childrenCount; ++i) {
                IMember child = members.get(i);
                if (i == 0) {
                    lastChild = (IMember)priorPeriodMemberToLevelMap.get(child.getLevel());
                }
                if (child == lastChild) {
                    if (child.getLevel() != currentPeriodLeafLevel) {
                        this.addRelativeTimePeriodToDateAndDescendants(cube, 8, member, child, i, priorPeriodMemberToLevelMap);
                        break;
                    }
                    this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, priorPeriodMemberToLevelMap);
                    break;
                }
                this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, priorPeriodMemberToLevelMap);
            }
        }
        return member;
    }

    private IMember addRelativeTimeNextPeriodToDateAndDescendants(IROLAPCube cube, IMember parent, IMember refMember, IMember nextMember, String memberCaption, Map<ILevel, IMember> currentPeriodMemberToLevelMap) {
        if (refMember == null || refMember instanceof NullMember) {
            return null;
        }
        ILevel currentPeriodLeafLevel = this.getLevel(this.getLevelCount() - 1);
        HashMap<ILevel, IMember> nextPeriodMemberToLevelMap = new HashMap<ILevel, IMember>();
        this.calculateNextPeriodMemberToLevelMap(nextMember, refMember, nextPeriodMemberToLevelMap, currentPeriodMemberToLevelMap);
        String memberName = ROLAPRelativeTimeMember.getMemberName(10, refMember.getLevel());
        String v5Expression = null;
        if (!(this.getDimension().getCube() instanceof DummyVirtualCube)) {
            v5Expression = AGGREGATE_CURRENTMEMBER + this.getDimension().getCube().getMeasuresHierarchy().getV5UniqueName() + WITHIN_SET_PERIODSTODATE + ((IROLAPLevel)refMember.getLevel()).getV5UniqueName(cube.getName()) + this.getDelimiter() + ((IROLAPMember)nextPeriodMemberToLevelMap.get(currentPeriodLeafLevel)).getV5UniqueName(cube.getName()) + RIGHT_RIGHT_PARENTHESIS;
        }
        ROLAPCalculatedMember member = (ROLAPCalculatedMember)this.createCalculatedMember(cube, memberName, parent, 10, refMember, v5Expression, null, null);
        if (memberCaption == null) {
            memberCaption = ROLAPRelativeTimeMember.getMemberCaption(10, refMember.getLevel(), refMember, this.getDefaultLocale());
        }
        if (member != null) {
            member.setCaption(memberCaption);
            ((ROLAPRelativeTimeMember)member).generatePTDRuntreeNode(refMember.getLevel(), (IMember)nextPeriodMemberToLevelMap.get(currentPeriodLeafLevel));
        }
        if (this.shouldShowRelativeTimeSubtreeMembers()) {
            List<IMember> members = refMember.getChildren();
            int childrenCount = members.size();
            IMember lastChild = null;
            for (int i = 0; i < childrenCount; ++i) {
                IMember child = members.get(i);
                if (i == 0) {
                    lastChild = (IMember)nextPeriodMemberToLevelMap.get(child.getLevel());
                }
                if (child == lastChild) {
                    if (child.getLevel() != currentPeriodLeafLevel) {
                        this.addRelativeTimePeriodToDateAndDescendants(cube, 8, member, child, i, nextPeriodMemberToLevelMap);
                        break;
                    }
                    this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, nextPeriodMemberToLevelMap);
                    break;
                }
                this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, nextPeriodMemberToLevelMap);
            }
        }
        return member;
    }

    public String getDelimiter() {
        NumericFormat f = new NumericFormat(new Locale(this.getDefaultLocale()));
        char decSP = f.getDecimalSeparator();
        if (decSP == ',' || decSP == '\u066b') {
            return ";";
        }
        return COMMA;
    }

    public String getDefaultLocale() {
        return ((IROLAPCube)((Object)this.getROLAPDimension().getCube())).getDefaultLocale();
    }

    private void calculatePriorPeriodMemberToLevelMap(IMember refMember, IMember prevMember, Map<ILevel, IMember> ppMemberToLevelMap, Map<ILevel, IMember> cpMemberToLevelMap) {
        List<IMember> refMemberChildren = refMember.getChildren();
        List<IMember> prevMemberChildren = prevMember.getChildren();
        int refChildrenCount = refMemberChildren.size();
        int prevChildrenCount = prevMemberChildren.size();
        IMember lastRefChild = null;
        IMember child = null;
        IMember prevChild = null;
        for (int i = 0; i < refChildrenCount; ++i) {
            child = refMemberChildren.get(i);
            if (i == 0) {
                lastRefChild = cpMemberToLevelMap == null ? refMemberChildren.get(refChildrenCount - 1) : cpMemberToLevelMap.get(child.getLevel());
            }
            if (i < prevChildrenCount) {
                prevChild = prevMemberChildren.get(i);
                if (child != lastRefChild) continue;
                ppMemberToLevelMap.put(child.getLevel(), prevChild);
                this.calculatePriorPeriodMemberToLevelMap(child, prevChild, ppMemberToLevelMap, cpMemberToLevelMap);
                break;
            }
            ILevel currentPeriodLeafLevel = this.getLevel(this.getLevelCount() - 1);
            while (prevChild.getLevel() != currentPeriodLeafLevel) {
                ppMemberToLevelMap.put(prevChild.getLevel(), prevChild);
                List<IMember> prevChildChildren = prevChild.getChildren();
                int prevChildChildrenCount = prevChildChildren.size();
                if (prevChildChildrenCount < 1) break;
                prevChild = prevChildChildren.get(prevChildChildrenCount - 1);
            }
            ppMemberToLevelMap.put(prevChild.getLevel(), prevChild);
            break;
        }
    }

    private void calculateNextPeriodMemberToLevelMap(IMember refMember, IMember nextMember, Map<ILevel, IMember> ppMemberToLevelMap, Map<ILevel, IMember> cpMemberToLevelMap) {
        List<IMember> refMemberChildren = refMember.getChildren();
        List<IMember> nextMemberChildren = nextMember.getChildren();
        int refChildrenCount = refMemberChildren.size();
        int nextChildrenCount = nextMemberChildren.size();
        IMember lastRefChild = null;
        IMember child = null;
        IMember prevChild = null;
        for (int i = 0; i < refChildrenCount; ++i) {
            child = refMemberChildren.get(i);
            if (i == 0) {
                lastRefChild = cpMemberToLevelMap == null ? refMemberChildren.get(refChildrenCount - 1) : cpMemberToLevelMap.get(child.getLevel());
            }
            if (i < nextChildrenCount) {
                prevChild = nextMemberChildren.get(i);
                if (child != lastRefChild) continue;
                ppMemberToLevelMap.put(child.getLevel(), prevChild);
                this.calculateNextPeriodMemberToLevelMap(child, prevChild, ppMemberToLevelMap, cpMemberToLevelMap);
                break;
            }
            ILevel currentPeriodLeafLevel = this.getLevel(this.getLevelCount() - 1);
            while (prevChild.getLevel() != currentPeriodLeafLevel) {
                ppMemberToLevelMap.put(prevChild.getLevel(), prevChild);
                List<IMember> prevChildChildren = prevChild.getChildren();
                int prevChildChildrenCount = prevChildChildren.size();
                if (prevChildChildrenCount < 1) break;
                prevChild = prevChildChildren.get(prevChildChildrenCount - 1);
            }
            ppMemberToLevelMap.put(prevChild.getLevel(), prevChild);
            break;
        }
    }

    private void addRelativeTimePeriodToDateChangeOrGrowth(IROLAPCube cube, int relaTimeMemberType, IMember parent, IMember refMember, IMember currentPTD, IMember priorPTD) {
        ROLAPCalculatedMember member;
        if (refMember == null || refMember instanceof NullMember || currentPTD == null) {
            return;
        }
        String memberName = ROLAPRelativeTimeMember.getMemberName(relaTimeMemberType, refMember.getLevel());
        String memberCaption = ROLAPRelativeTimeMember.getMemberCaption(relaTimeMemberType, refMember.getLevel(), refMember, this.getDefaultLocale());
        String v5Expression = ZERO;
        if (priorPTD != null) {
            String currentPTDExp = ((ROLAPRelativeTimeMember)currentPTD).getV5UniqueName(cube.getName());
            String priorPTDExp = ((ROLAPRelativeTimeMember)priorPTD).getV5UniqueName(cube.getName());
            v5Expression = LEFT_PARENTHESIS + currentPTDExp + RIGHT_PAREN_MINUS_LEFT_PARENT + priorPTDExp + RIGHT_PARENTHESIS;
            if (relaTimeMemberType == 6 || relaTimeMemberType == 12) {
                v5Expression = LEFT_PARENTHESIS + v5Expression + RIGHT_PARENTHESIS + DIVISION_SYMBOL + priorPTDExp;
            }
        }
        if ((member = (ROLAPCalculatedMember)this.createCalculatedMember(cube, memberName, parent, relaTimeMemberType, refMember, v5Expression, null, null)) != null) {
            member.setCaption(memberCaption);
            ((ROLAPRelativeTimeMember)member).generateChangeOrGrowthRuntreeNode(currentPTD, priorPTD);
        }
    }

    @Override
    public List<IMember> getOptimalPeriodsToDateMembers(ILevel level, IMember member) {
        ArrayList<IMember> result = new ArrayList<IMember>();
        if (level == null || member == null) {
            return result;
        }
        IMember last = null;
        IMember ancestor = member;
        IMember parent = null;
        while (ancestor != null && ancestor.getLevel() != level) {
            parent = ancestor.getParent();
            List<IMember> members = parent.getChildren();
            int childrenCount = members.size();
            if (last == null && members.get(childrenCount - 1) != ancestor) {
                last = ancestor;
                result.add(last);
            }
            if (last != null) {
                IMember child;
                int i;
                int iStop = 0;
                for (i = 0; i < childrenCount; ++i) {
                    child = members.get(i);
                    if (child != ancestor) continue;
                    iStop = i;
                    break;
                }
                for (i = iStop; i > 0 && (child = members.get(i - 1)) != ancestor; --i) {
                    result.add(0, child);
                }
            }
            ancestor = parent;
        }
        if (ancestor == null) {
            result.clear();
            return result;
        }
        if (last == null) {
            result.add(ancestor);
        }
        return result;
    }

    @Override
    public boolean isShared() {
        return this.getDimension().isShareable();
    }

    @Override
    public int getOrdinal(String cubeName) {
        if (this.isShared()) {
            int localOrdinal = this.sharedOrdinalMap.get(cubeName);
            if (localOrdinal == -1) {
                ROLAPCube cube = ((ShareableROLAPDimension)this.getROLAPDimension()).getCube(cubeName);
                localOrdinal = this.computeOrdinal(cube);
                this.sharedOrdinalMap.put(cubeName, localOrdinal);
            }
            return localOrdinal;
        }
        return super.getOrdinal();
    }

    @Override
    public int getOrdinal() {
        return this.getOrdinal(this.getDimension().getCube().getName());
    }

    public IMember getDefaultMemberWithSecurity(String cubeName) throws MetadataException {
        IDimension dimension = this.getDimension();
        SecurityManagerInterface sec = dimension.isShareable() ? ((Cube)((ShareableROLAPDimension)dimension).getCube(cubeName)).getSecurityManager() : ((Cube)dimension.getCube()).getSecurityManager();
        if (sec != null) {
            return sec.getDefaultMember(this);
        }
        return this.getDefaultMember();
    }

    public void addCustomRelativeTimeMembers(IROLAPCube cube, Map<ILevel, IMember> currentPeriodMemberToLevelMap, Map<ILevel, IMember> rtCurrentPeriodMemberToLevelMap, Map<ILevel, IMember> rtCurrentPTDMemberToLevelMap) {
        IROLAPMember allMember = this.getROLAPAllMember();
        ArrayList<ROLAPMetaObject> customMembers = this.getCustomRelativeTimeMembers();
        for (ROLAPMetaObject member : customMembers) {
            String errorMessage;
            int i;
            String errorMessage2;
            String errorMessage3;
            ROLAPMetaCustomBaseRelativeTimeMember cm = (ROLAPMetaCustomBaseRelativeTimeMember)member;
            ILevel targetLevel = null;
            ROLAPMetaLevel sourceTargetLevel = cm.getTargetPeriod();
            if (sourceTargetLevel == null) {
                errorMessage3 = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberMissingTargetPeriod, XQEMessages.getCurrProductLocale(), cm.getName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage3);
                continue;
            }
            if (cube instanceof IROLAPVirtualCube) {
                for (int i2 = 0; i2 < this.getLevelCount(); ++i2) {
                    ROLAPVirtualLevel virtualLevel = (ROLAPVirtualLevel)this.getLevel(i2);
                    List<ROLAPMetaLevel> sourceLevels = virtualLevel.getSourceMetaLevels();
                    for (ROLAPMetaLevel sourceLevel : sourceLevels) {
                        if (sourceLevel == null || sourceLevel != sourceTargetLevel) continue;
                        targetLevel = virtualLevel;
                        break;
                    }
                    if (targetLevel == null) {
                        continue;
                    }
                    break;
                }
            } else {
                targetLevel = this.getLevel(sourceTargetLevel.getName());
            }
            if (targetLevel == null) {
                errorMessage3 = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberTargetPeriodNotFound, XQEMessages.getCurrProductLocale(), cm.getName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage3);
                continue;
            }
            ILevel highestTargetLevel = this.getLevel(0);
            if (allMember != null) {
                highestTargetLevel = highestTargetLevel.getNextLevel();
            }
            ILevel contextLevel = null;
            ROLAPMetaLevel sourceContextLevel = cm.getContextPeriod();
            if (sourceContextLevel == null) {
                if (targetLevel != highestTargetLevel) {
                    errorMessage2 = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberMissingContextPeriod, XQEMessages.getCurrProductLocale(), cm.getName());
                    ROLAPLog.logError("ROLAPCubes.Loader", errorMessage2);
                    continue;
                }
            } else {
                if (cube instanceof IROLAPVirtualCube) {
                    for (int i3 = 0; i3 < this.getLevelCount(); ++i3) {
                        ROLAPVirtualLevel virtualLevel = (ROLAPVirtualLevel)this.getLevel(i3);
                        List<ROLAPMetaLevel> sourceLevels = virtualLevel.getSourceMetaLevels();
                        for (ROLAPMetaLevel sourceLevel : sourceLevels) {
                            if (sourceLevel == null || sourceLevel != sourceContextLevel) continue;
                            contextLevel = virtualLevel;
                            break;
                        }
                        if (contextLevel == null) {
                            continue;
                        }
                        break;
                    }
                } else {
                    contextLevel = this.getLevel(sourceContextLevel.getName());
                }
                if (contextLevel == null) {
                    errorMessage2 = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberContextPeriodNotFound, XQEMessages.getCurrProductLocale(), cm.getName());
                    ROLAPLog.logError("ROLAPCubes.Loader", errorMessage2);
                    continue;
                }
                if (contextLevel.getIndex() > targetLevel.getIndex()) {
                    errorMessage2 = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberContextPeriodMustBeHigherThanTargetPeriod, XQEMessages.getCurrProductLocale(), cm.getName());
                    ROLAPLog.logError("ROLAPCubes.Loader", errorMessage2);
                    continue;
                }
            }
            IMember contextMember = null;
            if (contextLevel != null) {
                int i4;
                IMember contextLevelCurrentPeriodMember = currentPeriodMemberToLevelMap.get(contextLevel);
                int contextOffset = cm.getContextPeriodOffset();
                contextMember = contextLevelCurrentPeriodMember;
                if (contextOffset > 0) {
                    for (i4 = 0; i4 < contextOffset; ++i4) {
                        contextMember = MemberOperations.getNextMemberOp(contextMember, false);
                    }
                } else {
                    for (i4 = 0; i4 < contextOffset * -1; ++i4) {
                        contextMember = MemberOperations.getPreviousMemberOp(contextMember, false);
                    }
                }
                if (contextMember == null || contextMember instanceof NullMember) {
                    String errorMessage4 = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberContextMemberNotFound, XQEMessages.getCurrProductLocale(), cm.getName());
                    ROLAPLog.logError("ROLAPCubes.Loader", errorMessage4);
                    continue;
                }
            }
            IMember targetMember = null;
            targetMember = contextMember == null ? currentPeriodMemberToLevelMap.get(targetLevel) : this.findCousin(targetLevel, contextMember, currentPeriodMemberToLevelMap);
            int targetOffset = cm.getTargetPeriodOffset();
            if (targetOffset > 0) {
                for (i = 0; i < targetOffset; ++i) {
                    targetMember = MemberOperations.getNextMemberOp(targetMember, false);
                }
            } else {
                for (i = 0; i < targetOffset * -1; ++i) {
                    targetMember = MemberOperations.getPreviousMemberOp(targetMember, false);
                }
            }
            if (targetMember == null || targetMember instanceof NullMember) {
                String errorMessage5 = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberTargetMemberNotFound, XQEMessages.getCurrProductLocale(), cm.getName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage5);
                continue;
            }
            if (member instanceof ROLAPMetaCustomSimpleRelativeTimeMember) {
                IMember parent = null;
                Level parentLevel = (Level)this.getLevel(targetLevel.getIndex() - 1);
                parent = parentLevel == null || parentLevel.isAllLevel() ? allMember : rtCurrentPeriodMemberToLevelMap.get(parentLevel);
                this.addCustomRelativeTimeMemberAndDescendants(cube, (ROLAPMetaCustomSimpleRelativeTimeMember)member, parent, targetMember, 0, null);
                continue;
            }
            if (member instanceof ROLAPMetaCustomRollingTotalRelativeTimeMember) {
                int numberOfPeriods = ((ROLAPMetaCustomRollingTotalRelativeTimeMember)member).getNumberOfPeriods();
                if (numberOfPeriods <= 0) {
                    String errorMessage6 = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberNumberOfPeriodsInvalid, XQEMessages.getCurrProductLocale(), cm.getName());
                    ROLAPLog.logError("ROLAPCubes.Loader", errorMessage6);
                    continue;
                }
                this.addCustomRollingTotalRelativeTimeMemberAndDescendants(cube, (ROLAPMetaCustomRollingTotalRelativeTimeMember)member, allMember, targetMember, 0, null, numberOfPeriods);
                continue;
            }
            if (!(member instanceof ROLAPMetaCustomPTDRelativeTimeMember)) continue;
            ROLAPMetaCustomPTDRelativeTimeMember ptdMember = (ROLAPMetaCustomPTDRelativeTimeMember)member;
            HashMap<ILevel, IMember> adjustedCurrentPeriodMemberToLevelMap = new HashMap<ILevel, IMember>();
            IMember refCurrentPeriodMember = targetMember;
            while (refCurrentPeriodMember != null) {
                adjustedCurrentPeriodMemberToLevelMap.put(refCurrentPeriodMember.getLevel(), refCurrentPeriodMember);
                IMember parentMember = refCurrentPeriodMember.getParent();
                if (parentMember == allMember) break;
                refCurrentPeriodMember = parentMember;
            }
            if (ptdMember.getIsLifeToDate()) {
                this.addCustomLTDRelativeTimeMember(cube, ptdMember, allMember, refCurrentPeriodMember, adjustedCurrentPeriodMemberToLevelMap);
                continue;
            }
            ILevel todateLevel = null;
            ROLAPMetaLevel sourceTodateLevel = ptdMember.getTodatePeriod();
            if (sourceTodateLevel == null) {
                errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberMissingTodatePeriod, XQEMessages.getCurrProductLocale(), cm.getName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage);
                continue;
            }
            if (cube instanceof IROLAPVirtualCube) {
                for (int i5 = 0; i5 < this.getLevelCount(); ++i5) {
                    ROLAPVirtualLevel virtualLevel = (ROLAPVirtualLevel)this.getLevel(i5);
                    List<ROLAPMetaLevel> sourceLevels = virtualLevel.getSourceMetaLevels();
                    for (ROLAPMetaLevel sourceLevel : sourceLevels) {
                        if (sourceLevel == null || sourceLevel != sourceTodateLevel) continue;
                        todateLevel = virtualLevel;
                        break;
                    }
                    if (todateLevel == null) {
                        continue;
                    }
                    break;
                }
            } else {
                todateLevel = this.getLevel(sourceTodateLevel.getName());
            }
            if (todateLevel == null) {
                errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberTodatePeriodNotFound, XQEMessages.getCurrProductLocale(), ptdMember.getName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage);
                continue;
            }
            if (todateLevel.getIndex() >= targetLevel.getIndex()) {
                errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_RelativeTimeMemberTodatePeriodMustBeHigherThanTargetPeriod, XQEMessages.getCurrProductLocale(), ptdMember.getName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage);
                continue;
            }
            IMember parent = null;
            Level parentLevel = (Level)this.getLevel(todateLevel.getIndex() - 1);
            parent = parentLevel == null ? null : (parentLevel.isAllLevel() ? allMember : rtCurrentPTDMemberToLevelMap.get(parentLevel));
            IMember refMember = (IMember)adjustedCurrentPeriodMemberToLevelMap.get(todateLevel);
            this.addCustomPTDRelativeTimeMemberAndDescendants(cube, ptdMember, parent, refMember, 0, adjustedCurrentPeriodMemberToLevelMap);
        }
    }

    private IMember findCousin(ILevel level, IMember ancestor, Map<ILevel, IMember> currentPeriodMemberToLevelMap) {
        IMember child2;
        if (level == null || ancestor == null || ancestor instanceof NullMember) {
            return null;
        }
        ILevel ancestorLevel = ancestor.getLevel();
        if (ancestorLevel == level) {
            return ancestor;
        }
        if (ancestorLevel.getIndex() > level.getIndex()) {
            return null;
        }
        IMember refAncestor = currentPeriodMemberToLevelMap.get(ancestorLevel);
        ILevel childrenLevel = ancestorLevel.getNextLevel();
        IMember refChild = currentPeriodMemberToLevelMap.get(childrenLevel);
        List<IMember> refChildren = refAncestor.getChildren();
        int index = 0;
        for (IMember child2 : refChildren) {
            if (refChild == child2) break;
            ++index;
        }
        List<IMember> children = ancestor.getChildren();
        if (index >= children.size()) {
            index = children.size() - 1;
        }
        child2 = children.get(index);
        if (childrenLevel != level) {
            return this.findCousin(level, child2, currentPeriodMemberToLevelMap);
        }
        return child2;
    }

    public ArrayList<ROLAPMetaObject> getCustomRelativeTimeMembers() {
        return new ArrayList<ROLAPMetaObject>();
    }

    private ROLAPCalculatedMember addCustomRelativeTimeMemberAndDescendants(IROLAPCube cube, ROLAPMetaCustomSimpleRelativeTimeMember metaMember, IMember parent, IMember refMember, int childPosition, Map<ILevel, IMember> cpMemberToLevelMap) {
        if (refMember == null || refMember instanceof NullMember) {
            return null;
        }
        int relativeMemberType = 13;
        String locale = this.getDefaultLocale();
        String memberName = metaMember.getName();
        String memberCaption = metaMember.getCaption(locale);
        if (memberCaption == null) {
            memberCaption = memberName;
        }
        memberCaption = memberCaption + " (" + refMember.getCaption() + RIGHT_PARENTHESIS;
        ROLAPCalculatedMember member = (ROLAPCalculatedMember)this.createCalculatedMember(cube, memberName, parent, relativeMemberType, refMember, null, metaMember, null);
        if (member != null) {
            member.setCaption(memberCaption);
        }
        if (relativeMemberType == 7 && parent != null && !((Level)parent.getLevel()).isAllLevel()) {
            ((ROLAPCalculatedMember)parent).addChildMember(member);
        }
        if (member != null && this.shouldShowRelativeTimeSubtreeMembers()) {
            List<IMember> members = refMember.getChildren();
            int childrenCount = members.size();
            IMember lastChild = null;
            for (int i = 0; i < childrenCount; ++i) {
                IMember child = members.get(i);
                this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, cpMemberToLevelMap);
                if (i == 0) {
                    lastChild = cpMemberToLevelMap == null ? members.get(childrenCount - 1) : cpMemberToLevelMap.get(child.getLevel());
                }
                if (child == lastChild) break;
            }
        }
        return member;
    }

    public void initializeCalculatedMembers(List<ROLAPVirtualCalculatedMemberDef> defs) {
        if (defs != null) {
            HashSet<String> existingCalcMembers = new HashSet<String>();
            for (ROLAPVirtualCalculatedMemberDef def : defs) {
                this.addROLAPVirtualCalculatedMember(def, null, existingCalcMembers, 0, null, null);
            }
        }
    }

    protected IMember addROLAPVirtualCalculatedMember(ROLAPVirtualCalculatedMemberDef def, IMember parentMember, Set<String> existingCalcMembers, int relaTimeMemberType, IMember relaTimeRefMember, ROLAPMetaObject metaMember) {
        IROLAPVirtualCube rolapCube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        if (relaTimeMemberType == 0) {
            try {
                V5ExpressionUtils.checkV5ExpressionSyntax(def.getV5Expression());
            }
            catch (XQERuntimeException e) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), def.getName(), this.getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, e);
                rolapCube.addInvalidCalculatedMember(this, def.getName());
                return null;
            }
        }
        String[] identifiers = null;
        ILevel calcLevel = null;
        IMember calcParent = null;
        String parent = def.getParentUniqueName();
        String parentName = def.getParentUniqueName();
        IROLAPMember allMember = this.getROLAPAllMember();
        if (parent == null && allMember == null) {
            calcLevel = this.getLevel(0);
        } else {
            if (def.getParentUniqueName() == null && allMember != null) {
                ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, def.getName(), parent, XQEMessageKeys.ROL_InvalidRootCalculatedMember);
                return null;
            }
            int cubeLastIdx = parent.indexOf(DOT_LEFT_BRACKET);
            if (cubeLastIdx == -1) {
                ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, def.getName(), parent, XQEMessageKeys.ROL_CalculatedMemberParentInvalidCubeNamePart);
                return null;
            }
            if (parent.substring(1, cubeLastIdx - 1).equals(rolapCube.getName())) {
                parentName = parent.substring(cubeLastIdx + 1);
            }
            try {
                identifiers = UniqueNameParser.parse(parentName);
            }
            catch (UniqueNameParserException e1) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), def.getName(), this.getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(XQEMessageKeys.ROL_CalculatedMemberParentInvalidIdentifier, (Throwable)e1, parent));
                rolapCube.addInvalidCalculatedMember(this, def.getName());
                return null;
            }
            if (identifiers.length < 2) {
                ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, def.getName(), parent, XQEMessageKeys.ROL_CalculatedMemberParentInvalidIdentifier);
                return null;
            }
            try {
                if (relaTimeMemberType == 0) {
                    try {
                        calcParent = this.findMember(parentName);
                    }
                    catch (Exception e) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_UnexpectedException, (Throwable)e, e.toString());
                    }
                    if (calcParent == null) {
                        ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, def.getName(), parent, XQEMessageKeys.ROL_CalculatedMemberParentNotExist);
                        return null;
                    }
                    if (calcParent instanceof ROLAPDataMember) {
                        ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, def.getName(), parent, XQEMessageKeys.ROL_DataMemberCannotBeCalculatedMemberParent);
                        return null;
                    }
                } else {
                    calcParent = parentMember;
                }
                if ((calcLevel = calcParent.getLevel().getNextLevel()) == null) {
                    ROLAPHierarchyMemberLoader.logInvalidCalculatedMemberError(rolapCube, (IROLAPHierarchy)this, def.getName(), calcParent.getUniqueName(), XQEMessageKeys.ROL_CalculatedMemberParentInvalidLevel);
                    return null;
                }
            }
            catch (MetadataException e) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), def.getName(), this.getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, e);
                rolapCube.addInvalidCalculatedMember(this, def.getName());
                return null;
            }
        }
        ROLAPCalculatedMember calcMem = null;
        try {
            calcMem = relaTimeMemberType != 0 ? new ROLAPRelativeTimeMember(def.getName(), calcLevel, def.getV5Expression(), identifiers, relaTimeMemberType, relaTimeRefMember, metaMember) : (calcLevel.getDimension().isMeasuresDimension() ? new ROLAPVirtualCalculatedMeasure(def.getName(), calcLevel, (Object)def.getV5Expression(), identifiers, def) : new ROLAPVirtualCalculatedMember(def.getName(), calcLevel, (Object)def.getV5Expression(), identifiers, def));
            if (!this.addCalculatedMemberToHierarchy(def, existingCalcMembers, rolapCube, calcMem, calcParent, parentName)) {
                calcMem = null;
            }
        }
        catch (MetadataException e) {
            throw new RuntimeException("Error creating " + def.getName() + " Calculated Member.", e);
        }
        return calcMem;
    }

    private boolean addCalculatedMemberToHierarchy(ROLAPVirtualCalculatedMemberDef def, Set<String> existingCalcMembers, IROLAPVirtualCube rolapCube, ROLAPCalculatedMember calcMem, IMember calcParent, String parentName) {
        if (calcParent != null) {
            calcMem.setParentMember(calcParent);
            calcMem.setParentLevelNumber(calcParent.getLevel().getIndex());
            StringBuilder givenName = new StringBuilder(parentName);
            givenName.append(DOT_LEFT_BRACKET).append(def.getName()).append(RIGHT_BRACKET);
            calcMem.setProperty("DefinitionUniqueName", givenName.toString());
            calcMem.setUniqueName(calcParent.getUniqueName() + DOT_LEFT_BRACKET + def.getName() + RIGHT_BRACKET);
        } else {
            calcMem.setUniqueName(this.getUniqueName() + DOT_LEFT_BRACKET + def.getName() + RIGHT_BRACKET);
        }
        calcMem.setType(MemberTypeEnum.GLOBAL_CALCULATION);
        String v5Name = UniqueNameGenerator.createMemberV5UniqueName(calcMem.getLevel(), calcMem.getUniqueName());
        calcMem.setV5UniqueName(v5Name);
        if (!(calcMem instanceof ROLAPRelativeTimeMember) && this.findMember(calcMem.getUniqueName()) != null) {
            String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_DuplicateCalculatedMemberNameWithNonCalcMember, XQEMessages.getCurrProductLocale(), calcMem.getName(), this.getUniqueName());
            ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, errorMessage);
            return false;
        }
        if (existingCalcMembers != null && !existingCalcMembers.add(calcMem.getUniqueName())) {
            String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_DuplicateCalculatedMemberName, XQEMessages.getCurrProductLocale(), calcMem.getUniqueName());
            ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, errorMessage);
            return false;
        }
        calcMem.setMemberId(rolapCube.getNextSessionCalculatedMemberID());
        rolapCube.addCalculatedMemberToMemberCacheInContent(calcMem);
        this.addROLAPCalculatedMembers(rolapCube, calcMem);
        return true;
    }

    public void addROLAPCalculatedMembers(IROLAPCube cube, ROLAPCalculatedMember calculatedMember) {
        this.hierarchyCalculatedMembersContainer.addROLAPCalculatedMembers(cube, calculatedMember);
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(String cubeName) {
        return this.hierarchyCalculatedMembersContainer.getROLAPCalculatedMembers(cubeName);
    }

    public void validateCalculatedMembers(ROLAPCube cube) {
        ListIterator<ROLAPCalculatedMember> iterator = this.hierarchyCalculatedMembersContainer.getROLAPCalculatedMembers(cube.getName()).listIterator();
        ArrayList<ROLAPCalculatedMember> calcsToRemove = new ArrayList<ROLAPCalculatedMember>();
        while (iterator.hasNext()) {
            ROLAPCalculatedMember calcMember = iterator.next();
            if (calcMember.isExtendedCalculatedMember()) continue;
            String calcMemberName = calcMember.getUniqueName();
            IMember m = this.findMember(calcMemberName);
            if (m == null) {
                if (V5ExpressionUtils.validateCalculatedMemberDefinition(this, cube, calcMember, calcMember.getName())) continue;
                calcsToRemove.add(calcMember);
                iterator.remove();
                continue;
            }
            String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_DuplicateCalculatedMemberNameWithNonCalcMember, XQEMessages.getCurrProductLocale(), calcMember.getName(), this.getUniqueName());
            ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, errorMessage);
            cube.addInvalidCalculatedMember(this, calcMember.getName());
            calcsToRemove.add(calcMember);
            iterator.remove();
        }
        cube.removeCalculatedMembers(calcsToRemove);
        if (calcsToRemove.size() > 0) {
            TimestampValue t = DataValueFactory.createTimestampValue();
            t.set(System.currentTimeMillis());
            cube.setSchemaUpdatedDate(t);
        }
    }

    public void validateCalculatedMembers(IROLAPVirtualCube cube) {
        ListIterator<ROLAPCalculatedMember> iterator = this.hierarchyCalculatedMembersContainer.getROLAPCalculatedMembers(cube.getName()).listIterator();
        ArrayList<ROLAPCalculatedMember> calcsToRemove = new ArrayList<ROLAPCalculatedMember>();
        while (iterator.hasNext()) {
            ROLAPCalculatedMember calcMember = iterator.next();
            if (calcMember instanceof ROLAPRelativeTimeMember) continue;
            String calcMemberName = calcMember.getUniqueName();
            IMember m = this.findMember(calcMemberName);
            if (m == null) {
                if (V5ExpressionUtils.validateCalculatedMemberDefinition(this, cube, calcMember, calcMember.getName())) continue;
                calcsToRemove.add(calcMember);
                iterator.remove();
                continue;
            }
            String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_DuplicateCalculatedMemberNameWithNonCalcMember, XQEMessages.getCurrProductLocale(), calcMember.getName(), this.getUniqueName());
            ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, errorMessage);
            cube.addInvalidCalculatedMember(this, calcMember.getName());
            calcsToRemove.add(calcMember);
            iterator.remove();
        }
        cube.removeCalculatedMembers(calcsToRemove);
    }

    private IMember addCustomLTDRelativeTimeMember(IROLAPCube cube, ROLAPMetaCustomPTDRelativeTimeMember metaMember, IMember parent, IMember refMember, Map<ILevel, IMember> currentPeriodMemberToLevelMap) {
        ROLAPCalculatedMember member;
        if (refMember == null || refMember instanceof NullMember) {
            return null;
        }
        ILevel currentPeriodTargetLevel = this.getLevel(currentPeriodMemberToLevelMap.size() - 1);
        if (parent != null) {
            currentPeriodTargetLevel = currentPeriodTargetLevel.getNextLevel();
        }
        IMember targetMember = currentPeriodMemberToLevelMap.get(currentPeriodTargetLevel);
        int relativeMemberType = 14;
        String locale = this.getDefaultLocale();
        String memberName = metaMember.getName();
        String memberCaption = metaMember.getCaption(locale);
        if (memberCaption == null) {
            memberCaption = memberName;
        }
        memberCaption = memberCaption + " (" + targetMember.getCaption() + RIGHT_PARENTHESIS;
        IMember[] siblings = refMember.getSiblings(true);
        StringBuilder prevMembersSetStr = new StringBuilder();
        for (IMember mem : siblings) {
            if (mem == refMember) break;
            if (prevMembersSetStr.length() > 0) {
                prevMembersSetStr.append(this.getDelimiter());
            }
            prevMembersSetStr.append(mem.getV5UniqueName());
        }
        String v5Expression = null;
        if (!(this.getDimension().getCube() instanceof DummyVirtualCube)) {
            v5Expression = AGGREGATE_CURRENTMEMBER + this.getDimension().getCube().getMeasuresHierarchy().getV5UniqueName() + ") WITHIN SET ";
            if (prevMembersSetStr.length() > 0) {
                v5Expression = v5Expression + "UNION( SET( " + prevMembersSetStr + RIGHT_PARENTHESIS + COMMA;
            }
            v5Expression = v5Expression + "PERIODSTODATE(" + ((IROLAPLevel)refMember.getLevel()).getV5UniqueName(cube.getName()) + this.getDelimiter() + ((IROLAPMember)targetMember).getV5UniqueName(cube.getName()) + RIGHT_PARENTHESIS;
            if (prevMembersSetStr.length() > 0) {
                v5Expression = v5Expression + RIGHT_PARENTHESIS;
            }
            v5Expression = v5Expression + RIGHT_PARENTHESIS;
        }
        if ((member = (ROLAPCalculatedMember)this.createCalculatedMember(cube, memberName, parent, relativeMemberType, targetMember, v5Expression, metaMember, null)) != null) {
            member.setCaption(memberCaption);
            ((ROLAPRelativeTimeMember)member).generateLTDRuntreeNode(refMember, targetMember, siblings);
        }
        return member;
    }

    private IMember addCustomPTDRelativeTimeMemberAndDescendants(IROLAPCube cube, ROLAPMetaCustomPTDRelativeTimeMember metaMember, IMember parent, IMember refMember, int childPosition, Map<ILevel, IMember> currentPeriodMemberToLevelMap) {
        ROLAPCalculatedMember member;
        if (refMember == null || refMember instanceof NullMember) {
            return null;
        }
        ILevel currentPeriodTargetLevel = this.getLevel(currentPeriodMemberToLevelMap.size() - 1);
        if (this.getROLAPAllMember() != null) {
            currentPeriodTargetLevel = currentPeriodTargetLevel.getNextLevel();
        }
        int relaTimeMemberType = 14;
        String locale = this.getDefaultLocale();
        String memberName = null;
        String memberCaption = null;
        if (metaMember == null) {
            relaTimeMemberType = 8;
            memberName = Integer.toString(childPosition);
            memberCaption = ROLAPRelativeTimeMember.getMemberCaption(relaTimeMemberType, refMember.getLevel(), refMember, locale);
        } else {
            memberName = metaMember.getName();
            memberCaption = metaMember.getCaption(locale);
            if (memberCaption == null) {
                memberCaption = memberName;
            }
            memberCaption = memberCaption + " (" + refMember.getCaption() + RIGHT_PARENTHESIS;
        }
        String v5Expression = null;
        if (!(this.getDimension().getCube() instanceof DummyVirtualCube)) {
            v5Expression = AGGREGATE_CURRENTMEMBER + this.getDimension().getCube().getMeasuresHierarchy().getV5UniqueName() + WITHIN_SET_PERIODSTODATE + ((IROLAPLevel)refMember.getLevel()).getV5UniqueName(cube.getName()) + this.getDelimiter() + ((IROLAPMember)currentPeriodMemberToLevelMap.get(currentPeriodTargetLevel)).getV5UniqueName(cube.getName()) + RIGHT_RIGHT_PARENTHESIS;
        }
        if ((member = (ROLAPCalculatedMember)this.createCalculatedMember(cube, memberName, parent, relaTimeMemberType, refMember, v5Expression, metaMember, null)) != null) {
            member.setCaption(memberCaption);
            ((ROLAPRelativeTimeMember)member).generatePTDRuntreeNode(refMember.getLevel(), currentPeriodMemberToLevelMap.get(currentPeriodTargetLevel));
        }
        if (parent != null && !((Level)parent.getLevel()).isAllLevel()) {
            if (relaTimeMemberType == 7) {
                ((ROLAPCalculatedMember)parent).addChildMember(member);
            } else if (relaTimeMemberType == 8) {
                if (((ROLAPRelativeTimeMember)parent).isAddPeriodToDateLastChildEnabled()) {
                    ((ROLAPRelativeTimeMember)parent).addChildMember(member);
                }
                ((ROLAPRelativeTimeMember)parent).setPtdLastChild(member);
            }
        }
        if (member != null && this.shouldShowRelativeTimeSubtreeMembers()) {
            List<IMember> members = refMember.getChildren();
            int childrenCount = members.size();
            IMember lastChild = null;
            for (int i = 0; i < childrenCount; ++i) {
                IMember child = members.get(i);
                if (i == 0) {
                    lastChild = currentPeriodMemberToLevelMap == null ? members.get(childrenCount - 1) : currentPeriodMemberToLevelMap.get(child.getLevel());
                }
                if (child == lastChild) {
                    if (child.getLevel() != currentPeriodTargetLevel) {
                        this.addCustomPTDRelativeTimeMemberAndDescendants(cube, null, member, child, i, currentPeriodMemberToLevelMap);
                        break;
                    }
                    this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, currentPeriodMemberToLevelMap);
                    break;
                }
                this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, currentPeriodMemberToLevelMap);
            }
        }
        return member;
    }

    private ROLAPCalculatedMember addCustomRollingTotalRelativeTimeMemberAndDescendants(IROLAPCube cube, ROLAPMetaCustomRollingTotalRelativeTimeMember metaMember, IMember parent, IMember refMember, int childPosition, Map<ILevel, IMember> cpMemberToLevelMap, int numberOfPeriods) {
        ROLAPCalculatedMember member;
        if (refMember == null || refMember instanceof NullMember) {
            return null;
        }
        int relativeMemberType = 15;
        String locale = this.getDefaultLocale();
        String memberName = metaMember.getName();
        String memberCaption = metaMember.getCaption(locale);
        if (memberCaption == null) {
            memberCaption = memberName;
        }
        memberCaption = memberCaption + " (" + refMember.getCaption() + RIGHT_PARENTHESIS;
        ArrayList<IMember> members = new ArrayList<IMember>();
        this.addRollingPeriodsMembersRecursive(refMember, numberOfPeriods, members);
        String v5Expression = null;
        if (!(this.getDimension().getCube() instanceof DummyVirtualCube)) {
            v5Expression = AGGREGATE_CURRENTMEMBER + this.getDimension().getCube().getMeasuresHierarchy().getV5UniqueName() + WITHIN_SET_SET;
            for (IMember mem : members) {
                v5Expression = v5Expression + mem.getV5UniqueName();
                if (mem == refMember) continue;
                v5Expression = v5Expression + this.getDelimiter() + SPACE;
            }
            v5Expression = v5Expression + RIGHT_RIGHT_PARENTHESIS;
        }
        if ((member = (ROLAPCalculatedMember)this.createCalculatedMember(cube, memberName, parent, relativeMemberType, refMember, v5Expression, metaMember, null)) != null) {
            member.setCaption(memberCaption);
            ((ROLAPRelativeTimeMember)member).generateRollingTotalRuntreeNode(members);
        }
        if (relativeMemberType == 7 && parent != null && !((Level)parent.getLevel()).isAllLevel()) {
            ((ROLAPCalculatedMember)parent).addChildMember(member);
        }
        if (member != null && this.shouldShowRelativeTimeSubtreeMembers()) {
            int childrenCount = members.size();
            IMember lastChild = null;
            ROLAPCalculatedMember parentMember = null;
            for (int i = 0; i < childrenCount; ++i) {
                IMember child = (IMember)members.get(i);
                if (member.getLevel().getNextLevel() != child.getLevel()) {
                    if (i == 0) {
                        parentMember = this.addCalculatedMemberParentAndChildrenRecursive(cube, metaMember, member, child, cpMemberToLevelMap);
                    } else {
                        this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, parentMember, child, i, cpMemberToLevelMap);
                    }
                } else {
                    this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, member, child, i, cpMemberToLevelMap);
                }
                if (i == 0) {
                    lastChild = cpMemberToLevelMap == null ? (IMember)members.get(childrenCount - 1) : cpMemberToLevelMap.get(child.getLevel());
                }
                if (child == lastChild) break;
            }
        }
        return member;
    }

    private void addRollingPeriodsMembersRecursive(IMember refMember, int numberOfPeriods, List<IMember> rollingPeriodsMembers) {
        if (refMember == null || refMember instanceof NullMember || numberOfPeriods <= 0) {
            return;
        }
        IMember prevMember = MemberOperations.getPreviousMemberOp(refMember, false);
        this.addRollingPeriodsMembersRecursive(prevMember, numberOfPeriods - 1, rollingPeriodsMembers);
        rollingPeriodsMembers.add(refMember);
    }

    private ROLAPCalculatedMember addCalculatedMemberParentAndChildrenRecursive(IROLAPCube cube, ROLAPMetaObject metaMember, IMember member, IMember child, Map<ILevel, IMember> cpMemberToLevelMap) {
        ROLAPCalculatedMember parentMember = null;
        if (member.getLevel().getNextLevel().getIndex() < child.getLevel().getIndex()) {
            parentMember = (ROLAPCalculatedMember)this.createCalculatedMember(cube, metaMember.getName(), member, 7, child.getParent(), null, metaMember, null);
            ((ROLAPCalculatedMember)member).addChildMember(parentMember);
            parentMember.setFillerMember(true);
            if (parentMember.getLevel().getNextLevel().getIndex() == child.getLevel().getIndex()) {
                this.addRelativeTimeMemberAndChildrenRecursive(cube, 7, parentMember, child, 0, cpMemberToLevelMap);
            } else {
                return this.addCalculatedMemberParentAndChildrenRecursive(cube, metaMember, parentMember, child, cpMemberToLevelMap);
            }
        }
        return parentMember;
    }

    class HierarchyCalculatedMembersContainer {
        Map<String, List<ROLAPCalculatedMember>> calculatedMembersByCubeMap = new HashMap<String, List<ROLAPCalculatedMember>>();

        HierarchyCalculatedMembersContainer() {
        }

        public void addROLAPCalculatedMembers(IROLAPCube cube, ROLAPCalculatedMember calculatedMember) {
            String cubeName = cube.getName();
            List<ROLAPCalculatedMember> list = this.calculatedMembersByCubeMap.get(cubeName);
            if (list == null) {
                list = new ArrayList<ROLAPCalculatedMember>();
                this.calculatedMembersByCubeMap.put(cubeName, list);
            }
            list.add(calculatedMember);
        }

        public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(String cubeName) {
            List<ROLAPCalculatedMember> list = this.calculatedMembersByCubeMap.get(cubeName);
            if (list == null) {
                list = new ArrayList<ROLAPCalculatedMember>();
                this.calculatedMembersByCubeMap.put(cubeName, list);
            }
            return list;
        }
    }
}

