/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LightweightOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ROLAPAllLevel
extends ROLAPLevel {
    private IMember allMember;
    private ROLAPMetaHierarchy metaHierarchy = null;

    private ROLAPMetaHierarchy getMetaHierarchy() {
        return this.metaHierarchy;
    }

    public ROLAPAllLevel(String cubeName, String name, ROLAPHierarchy hierarchy, String allMemberName, ILocalizedString allMemberCaptions, boolean hasBottomLevel) {
        super(name, hierarchy, hasBottomLevel);
        this.metaHierarchy = hierarchy.getMetaHierarchy();
        LightweightOrderedMap<IMember> memberMap = new LightweightOrderedMap<IMember>();
        ArrayList<IMember> memberList = new ArrayList<IMember>(1);
        ROLAPDimension d = (ROLAPDimension)this.getROLAPDimension();
        ROLAPCacheEngine storage = d.getMetadataStorage();
        try {
            MetadataCacheKey cachedMemberKey = d.isShareable() ? new MetadataCacheKey(0, d.getmaxMemberId()) : new MetadataCacheKey(d.getIndex(), d.getmaxMemberId());
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("NAME", allMemberName);
            props.put("MEMBER_UNIQUE_NAME", null);
            if (((ROLAPHierarchy)this.getHierarchy()).isRecursive()) {
                props.put("MEMBER_ORDINAL", null);
            }
            ICacheableNameValueBasedContent cachedMemberContent = ROLAPCacheEngine.createCacheableObject(cachedMemberKey, props);
            storage.cacheMember(cachedMemberContent);
            storage.addMemberToCachedLevel(this, cachedMemberKey);
            this.allMember = new ROLAPMemberProxy(cachedMemberKey, allMemberName, allMemberCaptions, this, null);
            memberList.add(this.allMember);
            memberMap.retainAll(memberList);
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCachePutException(e, cubeName, d.getName());
        }
        this.setMembers(memberMap);
        this.setGotAllMembers();
    }

    public IMember getAllMember() {
        return this.allMember;
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public List<IMember> getMembers() throws MetadataException {
        ArrayList<IMember> output = new ArrayList<IMember>();
        output.add(this.allMember);
        return output;
    }

    @Override
    public boolean isAllLevel() {
        return true;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        return this.getLocalizedName();
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ILocalizedString names = null;
        if (this.getMetaHierarchy() != null) {
            names = this.getMetaHierarchy().getAllLevelNames();
        }
        if (names == null) {
            names = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPDimension().getROLAPCube().getDefaultLocale(), this.getName());
        }
        return names;
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        return this.getLocalizedName();
    }

    @Override
    public String getCaption() {
        String runLocaleCaption = null;
        if (this.getMetaHierarchy() != null) {
            Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            String locale = LocaleConverter.localeToStr(runLocale);
            runLocaleCaption = this.getMetaHierarchy().getAllLevelName(locale);
            if (runLocaleCaption == null) {
                runLocaleCaption = this.getMetaHierarchy().getAllLevelName(this.getMetaHierarchy().getDefaultLocale());
            }
        }
        if (runLocaleCaption == null) {
            runLocaleCaption = super.getCaption();
        }
        return runLocaleCaption;
    }

    @Override
    public String getName(String locale) {
        String localizedName = null;
        if (this.getMetaHierarchy() != null) {
            localizedName = this.getMetaHierarchy().getAllLevelName(locale);
        }
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        return UniqueNameGenerator.createROLAPV5UniqueName(cubeName, ROLAPUtilities.getExpressionLocale(this), this);
    }
}

