/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.Metadata;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.util.ILocalizedString;
import java.util.ArrayList;
import java.util.List;

public abstract class ROLAPFolder
extends Metadata
implements IROLAPFolder {
    private List<IMetadata> childItems = new ArrayList<IMetadata>();
    private final IROLAPFolder parentFolder;
    private final IROLAPCube cube;
    private final ILocalizedString localizedCaption;

    public ROLAPFolder(IROLAPFolder theParentFolder, IROLAPCube parentCube, String folderName, ILocalizedString locCaption) {
        super(folderName);
        this.parentFolder = theParentFolder;
        this.cube = parentCube;
        this.localizedCaption = locCaption;
    }

    protected void addChild(IMetadata child) {
        this.childItems.add(child);
    }

    protected void addChildren(List<IMetadata> children) {
        this.childItems.addAll(children);
    }

    public boolean removeChild(String childUniqueName) {
        IMetadata itemToRemove = null;
        boolean isEmpty = false;
        for (IMetadata childItem : this.childItems) {
            if (childUniqueName.equals(childItem.getUniqueName())) {
                itemToRemove = childItem;
                break;
            }
            if (!(childItem instanceof ROLAPFolder) || !((ROLAPFolder)childItem).removeChild(childUniqueName)) continue;
            itemToRemove = childItem;
            break;
        }
        if (itemToRemove != null) {
            if (this.childItems.size() == 1) {
                isEmpty = true;
            } else {
                ArrayList<IMetadata> tempItems = new ArrayList<IMetadata>();
                for (IMetadata childItem : this.childItems) {
                    if (itemToRemove == childItem) continue;
                    tempItems.add(childItem);
                }
                this.childItems.clear();
                this.childItems.addAll(tempItems);
            }
        }
        return isEmpty;
    }

    @Override
    public List<IMetadata> getChildren() {
        return this.childItems;
    }

    @Override
    public IMetadata findChild(String childUniqueName) {
        IMetadata retItem = null;
        for (IMetadata childItem : this.childItems) {
            if (childUniqueName.equals(childItem.getUniqueName())) {
                retItem = childItem;
            } else if (childItem instanceof IROLAPFolder) {
                retItem = ((IROLAPFolder)childItem).findChild(childUniqueName);
            }
            if (retItem == null) continue;
            break;
        }
        return retItem;
    }

    @Override
    public IROLAPFolder findParent(IMetadata parent) {
        IROLAPFolder retFolder = null;
        for (IMetadata childItem : this.childItems) {
            if (childItem instanceof IROLAPFolder) {
                retFolder = ((IROLAPFolder)childItem).findParent(parent);
            } else if (parent == childItem) {
                retFolder = this;
            }
            if (retFolder == null) continue;
            break;
        }
        return retFolder;
    }

    @Override
    public IROLAPFolder getParent() {
        return this.parentFolder;
    }

    @Override
    public IROLAPCube getCube() {
        return this.cube;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        return this.localizedCaption;
    }
}

