/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.util.CacheableNameValueBasedArrayImmutableKeys;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAllLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDataMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchyBalancer;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryAttributesToColumnsHandler;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaOrderAttributeRef;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.DefaultENUSLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.Pipe;
import com.cognos.xqe.util.PipeConsumerEndedException;
import com.cognos.xqe.util.concurrent.UnboundedThreadPool;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class ROLAPHierarchyMemberLoader {
    public static final String RECURSIVEHIER_LEVEL_NAME_PREFIX = "Level ";
    Map<ILevel, Map<ROLAPMember.LevelKeys, ICacheKey>> levelToLevelKeysToMemberKeyMap = new HashMap<ILevel, Map<ROLAPMember.LevelKeys, ICacheKey>>();
    Map<ICacheKey, ROLAPMember.LevelKeys> cacheKeyToLevelKeyMap;
    Map<ILevel, int[]> levelToLevelMemberCachedPropertyIds = new HashMap<ILevel, int[]>();
    private static boolean useBulkCaching;
    private static final int ONE_THOUSAND = 1000;
    private static int maxBulkListSize;
    private static final int NUM_ROWS_IN_ONE_BLOCK = 500;
    private static final int NUM_BLOCKS_IN_QUEUE = 30;
    private static final int CAPACITY = 100;
    private static boolean disableDuplicateLevelCheck;
    private final int mDimensionIndexInCube;
    private final ROLAPHierarchy mHierarchy;
    private final ROLAPBaseCube mCube;
    private final ROLAPCacheEngine mStorage;
    private int numOfMembersLoaded = 0;
    private final Set<String> existingCalcMembers = new HashSet<String>();
    private final ROLAPQueryAttributesToColumnsHandler queryAttributesColumn;
    private final Map<ICacheKey, List<ICacheKey>> memberChildMap = new HashMap<ICacheKey, List<ICacheKey>>();
    private final Map<ICacheKey, List<ICacheKey>> levelChildMap = new HashMap<ICacheKey, List<ICacheKey>>();
    private final ROLAPHierarchyBalancer mBalancer;
    private final boolean mPrimeLevelMembers;
    private Map<ILevel, List<HashMap<String, String>>> levelToAttributeStringCache = new HashMap<ILevel, List<HashMap<String, String>>>();
    private CancelManager cancelManager;
    Map<ICacheKey, ICacheableObject> membersToCache = null;
    public static final String DOT_LEFT_BRACKET = ".[";
    public static final String RIGHT_BRACKET = "]";
    public static final int MIN_PARENT_NAME_PARTS = 2;
    private static final String DUMMY = "Dummy";
    private volatile boolean mDoneFlag;
    private volatile boolean completed;

    public ROLAPHierarchyMemberLoader(ROLAPCube cube, ROLAPHierarchy hier, ROLAPCacheEngine memberStorage, boolean primeLevelMembers) {
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        this.cancelManager = execEnv.getCancelManager();
        this.mHierarchy = hier;
        this.mPrimeLevelMembers = primeLevelMembers;
        this.mDoneFlag = false;
        this.completed = false;
        IDimension dim = hier.getDimension();
        this.mDimensionIndexInCube = cube.getDimensionIndex(dim);
        this.mStorage = memberStorage;
        this.mCube = (ROLAPBaseCube)cube;
        this.mBalancer = new ROLAPHierarchyBalancer(this.mHierarchy, this.mCube);
        if (this.mHierarchy != null && this.mHierarchy.metaHierarchy != null && this.mHierarchy.metaHierarchy.hasAllLevel()) {
            ++this.numOfMembersLoaded;
        }
        this.queryAttributesColumn = new ROLAPQueryAttributesToColumnsHandler(this.mCube.getModelCube().getDefaultLocale());
        if (this.mPrimeLevelMembers) {
            this.cacheKeyToLevelKeyMap = new HashMap<ICacheKey, ROLAPMember.LevelKeys>();
        }
    }

    private void addSortAttributes(IROLAPQuery query, ROLAPMetaLevel metaLevel) {
        List<ROLAPMetaOrderAttributeRef> sortAttribs;
        ROLAPMetaAttribute localizedQueryItem = metaLevel.getLocaleQueryItem();
        boolean bByRow = ((ROLAPDimension)this.mHierarchy.getDimension()).isLocalizationMethodByRow();
        if (bByRow && localizedQueryItem != null) {
            query.addSortAttribute(localizedQueryItem);
        }
        if ((sortAttribs = metaLevel.getSortAttributes()) != null && sortAttribs.size() > 0) {
            for (int ix = 0; ix < sortAttribs.size(); ++ix) {
                ROLAPMetaOrderAttributeRef sortAttrib = sortAttribs.get(ix);
                query.addSortAttribute(sortAttrib);
                ROLAPMetaAttribute attribute = sortAttrib.getAttribute(metaLevel.getParent());
                ((ROLAPMemberQuery)query).addAttribute(attribute);
            }
        } else {
            ROLAPMetaAttribute caption = metaLevel.getCaption();
            if (caption != null) {
                query.addSortAttribute(caption);
            } else {
                query.addSortAttribute(metaLevel.getLastLevelKey());
            }
        }
    }

    private void addSortAttributes(IROLAPQuery query, List<ROLAPMetaLevel> metaLevelsToQuery) {
        int numLevels = metaLevelsToQuery.size();
        for (int i = numLevels - 1; i >= 0; --i) {
            ROLAPMetaLevel metaLevel = metaLevelsToQuery.get(i);
            List<ROLAPMetaOrderAttributeRef> sortAttribs = metaLevel.getSortAttributes();
            if (sortAttribs != null && sortAttribs.size() > 0) {
                for (int ix = 0; ix < sortAttribs.size(); ++ix) {
                    ROLAPMetaOrderAttributeRef sortAttrib = sortAttribs.get(ix);
                    query.addSortAttribute(sortAttrib);
                    ROLAPMetaAttribute attribute = sortAttrib.getAttribute(metaLevel.getParent());
                    query.addAttributeAvoidingDuplicates(attribute, IROLAPQuery.QueryTarget.COMMON);
                }
            } else {
                ROLAPMetaAttribute caption = metaLevel.getCaption();
                if (caption != null) {
                    query.addSortAttribute(caption);
                } else {
                    query.addSortAttribute(metaLevel.getLastLevelKey());
                }
            }
            List<ROLAPMetaAttribute> levelKeys = metaLevel.getLevelKeys();
            int numKeys = levelKeys.size();
            for (int keyIdx = 0; keyIdx < numKeys; ++keyIdx) {
                ROLAPMetaAttribute keyExpr = levelKeys.get(keyIdx);
                query.addSortAttribute(keyExpr);
            }
        }
    }

    public void resolveAttributeDataTypes(ROLAPHierarchy hierarchy) {
        if (hierarchy.isRecursive()) {
            this.resolveAttributeDataTypesForPCH(hierarchy);
        } else {
            ArrayList<ROLAPLevel> levelsToQuery = new ArrayList<ROLAPLevel>();
            ArrayList<ROLAPMetaLevel> metaLevelsToQuery = new ArrayList<ROLAPMetaLevel>();
            this.getLevelsToQuery(hierarchy, levelsToQuery, metaLevelsToQuery, "Loading attribute data types for level called ");
            this.resolveAttributeDataTypes(levelsToQuery, metaLevelsToQuery);
        }
    }

    private void resolveAttributeDataTypes(List<ROLAPLevel> levelsToQuery, List<ROLAPMetaLevel> metaLevelsToQuery) {
        MetadataConnection mdConnection = levelsToQuery.size() > 0 ? levelsToQuery.get(0).getConnection() : null;
        for (ROLAPMetaLevel metaLevel : metaLevelsToQuery) {
            if (null == metaLevel) continue;
            if (null != metaLevel.getBusinessKey()) {
                this.resolveAttributeDataType(metaLevel.getBusinessKey(), mdConnection);
            }
            if (null != metaLevel.getCaption()) {
                this.resolveAttributeDataType(metaLevel.getCaption(), mdConnection);
            }
            List<ROLAPMetaAttribute> levelKeys = metaLevel.getLevelKeys();
            for (int index = 0; index < levelKeys.size(); ++index) {
                this.resolveAttributeDataType(levelKeys.get(index), mdConnection);
            }
            List<ROLAPMetaAttribute> relatedAttributes = metaLevel.getRelatedAttributes();
            for (int index = 0; index < relatedAttributes.size(); ++index) {
                this.resolveAttributeDataType(relatedAttributes.get(index), mdConnection);
            }
        }
    }

    private void resolveAttributeDataType(ROLAPMetaAttribute metaAttr, MetadataConnection mdConnection) {
        IMetadata metadata;
        if (null != metaAttr.getDataType()) {
            return;
        }
        IDataType dataType = null;
        if (mdConnection != null && (metadata = mdConnection.bindMetadataReference(metaAttr.getQueryItem())) != null && (dataType = metadata.getDataType()) != null && dataType.isTextType()) {
            dataType = DataTypeFactory.getStringType();
        }
        if (null != dataType) {
            metaAttr.setDataType(dataType);
        } else {
            metaAttr.setDataType(DataTypeFactory.getStringType());
        }
    }

    private void addRelatedAttributesRecursive(IROLAPQuery query, ROLAPMetaLevel levelToQuery) {
        List<ROLAPMetaAttribute> relatedAttributes = levelToQuery.getRelatedAttributes();
        int numRelatedAttributes = relatedAttributes.size();
        for (int propIdx = 0; propIdx < numRelatedAttributes; ++propIdx) {
            ROLAPMetaAttribute keyExpr = relatedAttributes.get(propIdx);
            this.queryAttributesColumn.addPropertyColumn(query, keyExpr, 0);
        }
    }

    private void addRelatedAttributesStandard(IROLAPQuery query, List<ROLAPMetaLevel> metaLevelsToQuery) {
        int numLevels = metaLevelsToQuery.size();
        for (int levelToQueryIdx = numLevels - 1; levelToQueryIdx >= 0; --levelToQueryIdx) {
            int levelIdx = numLevels - 1 - levelToQueryIdx;
            ROLAPMetaLevel rolapMetaLevel = metaLevelsToQuery.get(levelToQueryIdx);
            List<ROLAPMetaAttribute> relatedAttributes = rolapMetaLevel.getRelatedAttributes();
            for (ROLAPMetaAttribute attribute : relatedAttributes) {
                this.queryAttributesColumn.addPropertyColumn(query, attribute, levelIdx);
            }
        }
    }

    private void addLevelExpressions(IROLAPQuery query, List<ROLAPMetaLevel> metaLevelsToQuery) {
        int numLevels = metaLevelsToQuery.size();
        for (int levelToQueryIdx = numLevels - 1; levelToQueryIdx >= 0; --levelToQueryIdx) {
            int levelIdx = numLevels - 1 - levelToQueryIdx;
            ROLAPMetaLevel level = metaLevelsToQuery.get(levelToQueryIdx);
            ROLAPMetaAttribute nameExpr = level.getCaption();
            if (nameExpr == null) {
                nameExpr = level.getLastLevelKey();
            }
            this.queryAttributesColumn.addNameColumn(query, nameExpr, levelIdx);
            ROLAPMetaAttribute caption = level.getCaption();
            if (caption != null) {
                this.queryAttributesColumn.addCaptionColumn(query, caption, levelIdx);
            } else if (!this.isCubingServicesCompatible()) {
                this.queryAttributesColumn.addCaptionColumn(query, nameExpr, levelIdx);
            } else {
                this.queryAttributesColumn.addAttributeColumn("caption", levelIdx, -1);
            }
            ROLAPMetaAttribute description = level.getDescription();
            if (description != null) {
                this.queryAttributesColumn.addDescriptionColumn(query, description, levelIdx);
            } else {
                this.queryAttributesColumn.addAttributeColumn("description", levelIdx, -1);
            }
            ROLAPMetaAttribute businessKey = level.getBusinessKey();
            if (businessKey != null) {
                this.queryAttributesColumn.addBusinessKeyColumn(query, businessKey, levelIdx);
            } else {
                this.queryAttributesColumn.addAttributeColumn("business_key", levelIdx, -1);
            }
            List<ROLAPMetaAttribute> levelKeys = level.getLevelKeys();
            int numKeys = levelKeys.size();
            for (int keyIdx = 0; keyIdx < numKeys; ++keyIdx) {
                ROLAPMetaAttribute keyExpr = levelKeys.get(keyIdx);
                this.queryAttributesColumn.addLevelKeyColumn(query, keyExpr, levelIdx);
            }
            ROLAPMetaAttribute localeQueryItem = level.getLocaleQueryItem();
            if (localeQueryItem != null) {
                this.queryAttributesColumn.addLocaleLookupColumn(query, localeQueryItem, levelIdx);
                continue;
            }
            this.queryAttributesColumn.addAttributeColumn("localeQueryItem", levelIdx, -1);
        }
    }

    private void buildRecursive() {
        ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Loader", "Started populating level members for parent-child hierarchy " + this.mHierarchy.getUniqueName());
        HashMap<IValue, List<IValue[]>> localizedMemberRecord = new HashMap<IValue, List<IValue[]>>();
        HashMap<IValue, IValue[]> memberKeyToMemberValueMap = this.readParentChildHierarchyMembers(localizedMemberRecord);
        Map<IValue, List<IValue>> parentToChildMap = this.createParentToChildrenMap(memberKeyToMemberValueMap);
        this.addMembersToCache(memberKeyToMemberValueMap, parentToChildMap, localizedMemberRecord);
        parentToChildMap.clear();
        memberKeyToMemberValueMap.clear();
        for (List values : localizedMemberRecord.values()) {
            values.clear();
        }
        localizedMemberRecord.clear();
        parentToChildMap = null;
        memberKeyToMemberValueMap = null;
        localizedMemberRecord = null;
        this.resolveAttributeDataTypesForPCH(this.mHierarchy);
        ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Loader", "Finished populating level members for parent-child hierarchy " + this.mHierarchy.getUniqueName());
    }

    private void resolveAttributeDataTypesForPCH(ROLAPHierarchy hierarchy) {
        ArrayList<ROLAPLevel> levelsToQuery = new ArrayList<ROLAPLevel>();
        ArrayList<ROLAPMetaLevel> metaLevelsToQuery = new ArrayList<ROLAPMetaLevel>();
        for (ILevel level : hierarchy.getLevels()) {
            levelsToQuery.add((ROLAPLevel)level);
            metaLevelsToQuery.add(((ROLAPLevel)level).getMetaLevel());
        }
        this.resolveAttributeDataTypes(levelsToQuery, metaLevelsToQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<IValue, IValue[]> readParentChildHierarchyMembers(Map<IValue, List<IValue[]>> localizedMemberRecords) {
        String allowNetworkPCHStr = System.getProperty("allowNetworkPCH");
        boolean allowNetworkPCH = allowNetworkPCHStr != null && allowNetworkPCHStr.equals("true");
        LinkedHashMap<IValue, IValue[]> memberKeyToMemberValueMap = new LinkedHashMap<IValue, IValue[]>();
        LinkedHashMap<IValue, IValue[]> localizedMemberKeyToMemberValueMap = new LinkedHashMap<IValue, IValue[]>();
        ROLAPMemberQuery query = (ROLAPMemberQuery)this.getQuery();
        this.generateQueryToReadParentChildHierarchyMembers(query);
        IROLAPQueryResultIterator resultIterator = null;
        try {
            resultIterator = query.execute();
            FormatId[] formatIds = resultIterator.getColumnFormat();
            int numCols = formatIds.length;
            int rowCounter = 0;
            while (resultIterator.hasNext() && !this.isCancelled()) {
                IValue[] values = resultIterator.next().getColumns();
                IValue[] row = new IValue[numCols];
                if (values.length > 0) {
                    for (int j = 0; j < numCols; ++j) {
                        IValue v = values[j];
                        row[j] = (IValue)v.copy();
                        if (!(row[j] instanceof TextValue)) continue;
                        ((TextValue)row[j]).setCollator(null);
                    }
                }
                IValue memberKey = this.getMemberKey(row, query);
                boolean bByRow = ((ROLAPDimension)this.mHierarchy.getDimension()).isLocalizationMethodByRow();
                if (bByRow) {
                    IValue localeValue = this.queryAttributesColumn.getLocaleQueryItemValue(0, row);
                    String locale = null;
                    if (localeValue.getDataType().isTextType()) {
                        locale = localeValue.toString();
                    }
                    if (locale != null && locale.equalsIgnoreCase(this.queryAttributesColumn.getDefaultLocale())) {
                        this.checkForDuplicateMemberKey(memberKeyToMemberValueMap, row, memberKey, rowCounter, allowNetworkPCH);
                    } else {
                        this.checkForDuplicateMemberKey(localizedMemberKeyToMemberValueMap, row, memberKey, rowCounter, allowNetworkPCH);
                    }
                } else {
                    this.checkForDuplicateMemberKey(memberKeyToMemberValueMap, row, memberKey, rowCounter, allowNetworkPCH);
                }
                ++rowCounter;
            }
            if (rowCounter == 0) {
                this.mCube.getMessages().addMessage(XQEMessageKeys.RLU_HierarchyLoadNoRows, this.mHierarchy.getUniqueName());
            }
            for (Map.Entry entry : localizedMemberKeyToMemberValueMap.entrySet()) {
                if (memberKeyToMemberValueMap.containsKey(entry.getKey())) {
                    List<Object> memberRecords = null;
                    if (localizedMemberRecords.containsKey(entry.getKey())) {
                        memberRecords = localizedMemberRecords.get(entry.getKey());
                        memberRecords.add(entry.getValue());
                        continue;
                    }
                    memberRecords = new ArrayList();
                    memberRecords.add(entry.getValue());
                    localizedMemberRecords.put((IValue)entry.getKey(), (List<IValue[]>)memberRecords);
                    continue;
                }
                memberKeyToMemberValueMap.put((IValue)entry.getKey(), (IValue[])entry.getValue());
            }
        }
        finally {
            if (resultIterator != null) {
                resultIterator.close();
                resultIterator = null;
            }
        }
        return memberKeyToMemberValueMap;
    }

    private IValue getMemberKey(IValue[] row, ROLAPMemberQuery query) {
        int memberKeyIndex = 2 + (row.length - query.getAttributeSelections().size());
        return row[memberKeyIndex];
    }

    private void checkForDuplicateMemberKey(LinkedHashMap<IValue, IValue[]> memberKeyToMemberValueMap, IValue[] row, IValue memberKey, int rowCounter, boolean allowNetworkPCH) {
        IValue[] previousRow = memberKeyToMemberValueMap.put(memberKey, row);
        if (!allowNetworkPCH && previousRow != null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_NetworkHierarchyNotSupported, (Object)row[1].toString(), (Object)this.mHierarchy.getName(), (Object)rowCounter);
        }
    }

    void generateQueryToReadParentChildHierarchyMembers(ROLAPMemberQuery query) {
        ROLAPMetaAttribute key = null;
        List<ROLAPMetaAttribute> levelKeys = null;
        ROLAPMetaLevel parentLevel = this.mHierarchy.getRecursiveParentMetaLevel();
        levelKeys = parentLevel.getLevelKeys();
        key = levelKeys.get(0);
        query.addAttribute(key);
        query.addParentKey(key);
        ROLAPMetaLevel memberMetaLevel = this.mHierarchy.getRecursiveMemberMetaLevel();
        key = memberMetaLevel.getCaption();
        if (key != null) {
            query.addAttribute(key);
        } else {
            query.addAttribute(memberMetaLevel.getLastLevelKey());
        }
        levelKeys = memberMetaLevel.getLevelKeys();
        key = levelKeys.get(0);
        query.addAttribute(key);
        query.addMemberKey(key);
        this.addRelatedAttributesRecursive(query, memberMetaLevel);
        this.addSortAttributes((IROLAPQuery)query, memberMetaLevel);
        int levelIdx = 0;
        ROLAPMetaAttribute caption = memberMetaLevel.getCaption();
        if (caption != null) {
            this.queryAttributesColumn.addCaptionColumn(query, caption, levelIdx);
        } else if (!this.isCubingServicesCompatible()) {
            ROLAPMetaAttribute nameExpr = memberMetaLevel.getCaption();
            if (nameExpr == null) {
                nameExpr = memberMetaLevel.getLastLevelKey();
            }
            this.queryAttributesColumn.addCaptionColumn(query, nameExpr, levelIdx);
        } else {
            this.queryAttributesColumn.addAttributeColumn("caption", levelIdx, -1);
        }
        ROLAPMetaAttribute description = memberMetaLevel.getDescription();
        if (description != null) {
            this.queryAttributesColumn.addDescriptionColumn(query, description, levelIdx);
        } else {
            this.queryAttributesColumn.addAttributeColumn("description", levelIdx, -1);
        }
        ROLAPMetaAttribute businessKey = memberMetaLevel.getBusinessKey();
        if (businessKey != null) {
            this.queryAttributesColumn.addBusinessKeyColumn(query, businessKey, levelIdx);
        } else {
            this.queryAttributesColumn.addAttributeColumn("business_key", levelIdx, -1);
        }
        boolean bByRow = ((ROLAPDimension)this.mHierarchy.getDimension()).isLocalizationMethodByRow();
        ROLAPMetaAttribute localeQueryItem = memberMetaLevel.getLocaleQueryItem();
        if (bByRow && localeQueryItem != null) {
            this.queryAttributesColumn.addLocaleLookupColumn(query, localeQueryItem, levelIdx);
        } else {
            this.queryAttributesColumn.addAttributeColumn("localeQueryItem", levelIdx, -1);
        }
    }

    private void addMembersToCache(Map<IValue, IValue[]> memberKeyToMemberValueMap, Map<IValue, List<IValue>> parentToChildMap, Map<IValue, List<IValue[]>> localizedMemberRecords) {
        ROLAPMemberProxy rootParentMember = null;
        ROLAPLevel prevLevel = null;
        Level rootLevel = (Level)this.mHierarchy.getLevel(0);
        if (rootLevel != null && rootLevel.hasGotAllMembers() && rootLevel.getMembers().size() == 1) {
            rootParentMember = (ROLAPMemberProxy)rootLevel.getMembers().get(0);
            prevLevel = (ROLAPLevel)rootLevel;
        }
        ROLAPMetaLevel memberMetaLevel = this.mHierarchy.getRecursiveMemberMetaLevel();
        HashMap<ROLAPMember.LevelKeys, MetadataCacheKey> recursiveLevelKeysToMemberMap = new HashMap<ROLAPMember.LevelKeys, MetadataCacheKey>();
        HashSet<IValue> currentParents = ROLAPHierarchyMemberLoader.getTopLevelMemberKeys(memberKeyToMemberValueMap);
        boolean[] bKeys = new boolean[]{true};
        int levelIdx = 0;
        while (currentParents.size() > 0 && !this.isCancelled()) {
            List<ICacheKey> prevMembers;
            HashSet<IValue> children = new HashSet<IValue>();
            children.addAll(this.getChildren(parentToChildMap, currentParents));
            ROLAPLevel rolapLevel = new ROLAPLevel(RECURSIVEHIER_LEVEL_NAME_PREFIX + ++levelIdx, this.mHierarchy, memberMetaLevel, this.mCube.getName(), children.size() == 0);
            rolapLevel.setMUNKeys(bKeys);
            ICacheKey currentCachedParent = null;
            for (IValue memberKey : memberKeyToMemberValueMap.keySet()) {
                if (!currentParents.contains(memberKey)) continue;
                MetadataCacheKey currentCachedMember = null;
                IValue[] values = memberKeyToMemberValueMap.get(memberKey);
                IValue parentKey = values[0];
                IValue memberName = values[1];
                ROLAPMember.LevelKeys parentLevelKey = new ROLAPMember.LevelKeys(new IValue[]{parentKey}, rolapLevel);
                ROLAPMember.LevelKeys memberLevelKey = new ROLAPMember.LevelKeys(new IValue[]{memberKey}, rolapLevel);
                Map<String, Object> memberProperties = this.prepareMemberProperties(memberName.toString(), memberName, memberLevelKey, values, 0, rolapLevel, memberMetaLevel, false);
                if (localizedMemberRecords.containsKey(memberKey)) {
                    this.updateMemberProperties(localizedMemberRecords.get(memberKey), memberProperties, 0, rolapLevel, memberMetaLevel);
                }
                if (levelIdx == 1) {
                    if (rootParentMember != null) {
                        currentCachedParent = rootParentMember.getCacheKey();
                    }
                } else {
                    currentCachedParent = (ICacheKey)recursiveLevelKeysToMemberMap.get(parentLevelKey);
                }
                currentCachedMember = this.cacheMember(memberProperties, currentCachedParent, rolapLevel);
                if (recursiveLevelKeysToMemberMap.get(memberLevelKey) != null) {
                    this.reportDuplicateKeys(rolapLevel, memberLevelKey);
                } else {
                    recursiveLevelKeysToMemberMap.put(memberLevelKey, currentCachedMember);
                    if (this.cacheKeyToLevelKeyMap != null) {
                        this.cacheKeyToLevelKeyMap.put(currentCachedMember, memberLevelKey);
                    }
                }
                ++this.numOfMembersLoaded;
            }
            if (!this.mHierarchy.isDataMemberHidden() && prevLevel != null && (prevMembers = this.levelChildMap.get(prevLevel.getCacheKey())) != null) {
                for (int i = 0; i < prevMembers.size(); ++i) {
                    MetadataCacheKey prevMemberKey = (MetadataCacheKey)prevMembers.get(i);
                    try {
                        List<ICacheKey> memberChildren;
                        Object isDataMember = this.mStorage.getMemberPropValueFromCache(prevMemberKey, "IS_DATA_MEMBER");
                        if (levelIdx <= 1 || isDataMember != null || (memberChildren = this.memberChildMap.get(prevMemberKey)) == null || memberChildren.size() <= 0) continue;
                        String dmName = "";
                        if (this.isCubingServicesCompatible()) {
                            dmName = this.mStorage.getMemberNameFromCache(prevMemberKey);
                        } else {
                            Object caption = this.mStorage.getMemberPropValueFromCache(prevMemberKey, "CAPTION");
                            if (caption == null && (caption = this.mStorage.getMemberNameFromCache(prevMemberKey)) != null) {
                                ROLAPLog.log("ROLAPCubes.Loader", "Member caption has null value, using member name '" + caption.toString() + "' for data member");
                            }
                            if (caption instanceof ILocalizedString) {
                                dmName = ((ILocalizedString)caption).toString();
                            } else if (caption == null) {
                                dmName = "";
                                ROLAPLog.log("ROLAPCubes.Loader", "Both member caption and member name are null, using empty string for data member");
                            } else {
                                dmName = caption.toString();
                            }
                        }
                        ROLAPMember.LevelKeys dmLevelKeys = this.cacheKeyToLevelKeyMap != null ? this.cacheKeyToLevelKeyMap.get(prevMemberKey) : new ROLAPMember.LevelKeys(((List)this.mStorage.getMemberPropValueFromCache(prevMemberKey, "LEVEL_KEYS")).toArray(new IValue[0]), rolapLevel);
                        IValue dmBusinessKey = (IValue)this.mStorage.getMemberPropValueFromCache(prevMemberKey, "BUSINESS_KEY");
                        Map<String, Object> props = this.prepareMemberProperties(dmName, dmBusinessKey, dmLevelKeys, null, 0, rolapLevel, memberMetaLevel, true);
                        this.cacheMember(props, prevMemberKey, rolapLevel);
                        ++this.numOfMembersLoaded;
                        continue;
                    }
                    catch (CacheException e) {
                        ROLAPCacheBase.throwCacheGetException(e, this.mCube.getName(), this.mHierarchy.getDimension().getName());
                    }
                }
            }
            currentParents.clear();
            currentParents.addAll(children);
            prevLevel = rolapLevel;
        }
        currentParents.clear();
        currentParents = null;
        ROLAPHierarchyMemberLoader.logNumberOfMembersLoadedMsg(this.mHierarchy, this.numOfMembersLoaded, true);
        this.assignMemberOrdinals(rootLevel);
    }

    Map<IValue, List<IValue>> createParentToChildrenMap(Map<IValue, IValue[]> memberKeyToMemberValueMap) {
        HashMap<IValue, List<IValue>> parentToChildrenMap = new HashMap<IValue, List<IValue>>();
        for (IValue member : memberKeyToMemberValueMap.keySet()) {
            List<Object> children;
            IValue parent = memberKeyToMemberValueMap.get(member)[0];
            if (parentToChildrenMap.containsKey(parent)) {
                children = parentToChildrenMap.get(parent);
                children.add(member);
                parentToChildrenMap.put(parent, children);
                continue;
            }
            children = new ArrayList();
            children.add(member);
            parentToChildrenMap.put(parent, children);
        }
        return parentToChildrenMap;
    }

    HashSet<IValue> getChildren(Map<IValue, List<IValue>> parentToChildMap, HashSet<IValue> parents) {
        HashSet<IValue> children = new HashSet<IValue>();
        for (IValue parent : parents) {
            List<IValue> parentChildren = parentToChildMap.get(parent);
            if (parentChildren == null) continue;
            for (IValue child : parentChildren) {
                children.add(child);
            }
        }
        return children;
    }

    public static HashSet<IValue> getTopLevelMemberKeys(Map<IValue, IValue[]> memberKeyToMemberValueMap) {
        HashSet<IValue> topMemberKeys = new HashSet<IValue>();
        for (Map.Entry<IValue, IValue[]> entry : memberKeyToMemberValueMap.entrySet()) {
            IValue parent = entry.getValue()[0];
            if (!parent.isNull() && memberKeyToMemberValueMap.containsKey(parent)) continue;
            topMemberKeys.add(entry.getKey());
        }
        return topMemberKeys;
    }

    private void assignMemberOrdinals(Level rootLevel) {
        block4: {
            block3: {
                if (rootLevel != null) break block3;
                ROLAPLevel topLevel = (ROLAPLevel)this.mHierarchy.getLevel(0);
                List<ICacheKey> topMembersCacheKeys = this.levelChildMap.get(topLevel.getCacheKey());
                if (topMembersCacheKeys.size() <= 0) break block4;
                int currentOrdinal = ((MetadataCacheKey)topMembersCacheKeys.get(0)).getMetadataChildId();
                for (ICacheKey cacheKey : topMembersCacheKeys) {
                    currentOrdinal = this.setMemberOrdinalProp(cacheKey, currentOrdinal);
                }
                break block4;
            }
            IMember[] rootMembers = rootLevel.getMembers().toArray(new IMember[0]);
            if (rootMembers.length > 0) {
                int currentOrdinal = ((MetadataCacheKey)((ROLAPMemberProxy)rootMembers[0]).getCacheKey()).getMetadataChildId();
                for (int i = 0; i < rootMembers.length; ++i) {
                    ICacheKey cacheKey = ((ROLAPMemberProxy)rootMembers[i]).getCacheKey();
                    currentOrdinal = this.setMemberOrdinalProp(cacheKey, currentOrdinal);
                }
            }
        }
    }

    private int setMemberOrdinalProp(ICacheKey memberCacheKey, int memberOrdinal) {
        int currentOrdinal = memberOrdinal;
        this.mStorage.setPropValueInCache(memberCacheKey, "MEMBER_ORDINAL", currentOrdinal++, this.mHierarchy.getDimension(), this.mCube);
        List<ICacheKey> cachedChildren = this.memberChildMap.get(memberCacheKey);
        if (cachedChildren != null) {
            for (int i = 0; i < cachedChildren.size(); ++i) {
                ICacheKey childMemberCacheKey = cachedChildren.get(i);
                currentOrdinal = this.setMemberOrdinalProp(childMemberCacheKey, currentOrdinal);
            }
        }
        return currentOrdinal;
    }

    private void updateMemberPropertiesInBulk(ICacheKey memberKey, ROLAPLevel currentLevel, ROLAPMetaLevel currentMetaLevel, int levelIdx, IValue[] row) {
        Map<String, Object> cacheMap = null;
        try {
            ICacheableNameValueBasedContent memberCache = (ICacheableNameValueBasedContent)this.membersToCache.get(memberKey);
            if (memberCache != null) {
                cacheMap = memberCache.getContent();
            }
            Object value = null;
            if (cacheMap != null) {
                value = cacheMap.get("CAPTION");
            }
            if (value == null) {
                value = this.mStorage.getMemberPropValueFromCache(memberKey, "CAPTION");
            }
            ILocalizedString caption = null;
            if (value != null && value instanceof ILocalizedString) {
                caption = (ILocalizedString)value;
            }
            Object rowValue = this.queryAttributesColumn.getCaptionValue(currentMetaLevel, levelIdx, row);
            ILocalizedString rowCaption = null;
            if (rowValue != null && rowValue instanceof ILocalizedString) {
                rowCaption = (ILocalizedString)rowValue;
            }
            if (caption != null && rowCaption != null && !caption.isLocaleExist(rowCaption.getDefaultLocale())) {
                caption.put(rowCaption.getDefaultLocale(), rowCaption.toString());
            }
            List<IProperty> memberProperties = currentLevel.getMemberProperties();
            for (int propIdx = 0; propIdx < memberProperties.size(); ++propIdx) {
                ROLAPProperty property = (ROLAPProperty)memberProperties.get(propIdx);
                if (cacheMap != null) {
                    value = cacheMap.get(property.getName());
                }
                if (value == null) {
                    value = this.mStorage.getMemberPropValueFromCache(memberKey, property.getName());
                }
                ILocalizedString propValue = null;
                if (value != null && value instanceof ILocalizedString) {
                    propValue = (ILocalizedString)value;
                }
                Object rowProp = this.queryAttributesColumn.getPropertyValue(property, levelIdx, propIdx, row);
                ILocalizedString rowPropValue = null;
                if (rowProp != null && rowProp instanceof ILocalizedString) {
                    rowPropValue = (ILocalizedString)rowProp;
                }
                if (propValue == null || rowPropValue == null || propValue.isLocaleExist(rowPropValue.getDefaultLocale())) continue;
                propValue.put(rowPropValue.getDefaultLocale(), rowPropValue.toString());
            }
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCacheGetException(e, this.mCube.getName(), this.mHierarchy.getDimension().getName());
        }
    }

    private void updateMemberProperties(List<IValue[]> rows, Map<String, Object> memberProperties, int leveIdx, ROLAPLevel level, ROLAPMetaLevel metaLevel) {
        Object value = memberProperties.get("CAPTION");
        ILocalizedString localizedCaption = null;
        if (value != null && value instanceof ILocalizedString) {
            localizedCaption = (ILocalizedString)value;
        }
        for (IValue[] rowValues : rows) {
            if (localizedCaption == null) continue;
            Object captionObject = this.queryAttributesColumn.getCaptionValue(metaLevel, leveIdx, rowValues);
            if (captionObject != null && captionObject instanceof ILocalizedString) {
                ILocalizedString caption = (ILocalizedString)captionObject;
                if (localizedCaption != null && !localizedCaption.isLocaleExist(caption.getDefaultLocale())) {
                    localizedCaption.put(caption.getDefaultLocale(), caption.toString());
                }
            }
            List<IProperty> properties = level.getMemberProperties();
            for (int propIdx = 0; propIdx < properties.size(); ++propIdx) {
                ROLAPProperty property = (ROLAPProperty)properties.get(propIdx);
                Object propObject = memberProperties.get(property.getName());
                ILocalizedString propValue = null;
                if (propObject != null && propObject instanceof ILocalizedString) {
                    propValue = (ILocalizedString)propObject;
                }
                Object rowPropObject = this.queryAttributesColumn.getPropertyValue(property, leveIdx, propIdx, rowValues);
                ILocalizedString rowPropValue = null;
                if (rowPropObject == null || !(rowPropObject instanceof ILocalizedString)) continue;
                rowPropValue = (ILocalizedString)rowPropObject;
                if (propValue == null || propValue.isLocaleExist(rowPropValue.getDefaultLocale())) continue;
                propValue.put(rowPropValue.getDefaultLocale(), rowPropValue.toString());
            }
        }
    }

    private void updateMemberProperties(ICacheKey memberKey, ROLAPLevel currentLevel, ROLAPMetaLevel currentMetaLevel, int levelIdx, IValue[] row) {
        try {
            Object value = this.mStorage.getMemberPropValueFromCache(memberKey, "CAPTION");
            ILocalizedString caption = null;
            if (value != null && value instanceof ILocalizedString) {
                caption = (ILocalizedString)value;
            }
            Object rowValue = this.queryAttributesColumn.getCaptionValue(currentMetaLevel, levelIdx, row);
            ILocalizedString rowCaption = null;
            if (rowValue != null && rowValue instanceof ILocalizedString) {
                rowCaption = (ILocalizedString)rowValue;
            }
            if (caption != null && rowCaption != null && !caption.isLocaleExist(rowCaption.getDefaultLocale())) {
                caption.put(rowCaption.getDefaultLocale(), rowCaption.toString());
            }
            List<IProperty> memberProperties = currentLevel.getMemberProperties();
            for (int propIdx = 0; propIdx < memberProperties.size(); ++propIdx) {
                ROLAPProperty property = (ROLAPProperty)memberProperties.get(propIdx);
                Object prop = this.mStorage.getMemberPropValueFromCache(memberKey, property.getName());
                ILocalizedString propValue = null;
                if (prop != null && prop instanceof ILocalizedString) {
                    propValue = (ILocalizedString)prop;
                }
                Object rowProp = this.queryAttributesColumn.getPropertyValue(property, levelIdx, propIdx, row);
                ILocalizedString rowPropValue = null;
                if (rowProp != null && rowProp instanceof ILocalizedString) {
                    rowPropValue = (ILocalizedString)rowProp;
                }
                if (propValue == null || rowPropValue == null || propValue.isLocaleExist(rowPropValue.getDefaultLocale())) continue;
                propValue.put(rowPropValue.getDefaultLocale(), rowPropValue.toString());
            }
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCacheGetException(e, this.mCube.getName(), currentLevel.getDimension().getName());
        }
    }

    private Map<String, Object> prepareMemberProperties(String name, IValue defaultBusinessKey, ROLAPMember.LevelKeys levKeys, IValue[] rowValues, int levelIndex, ROLAPLevel level, ROLAPMetaLevel metaLevel, boolean isDataMember) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this.isCubingServicesCompatible()) {
            if (name != null) {
                props.put("NAME", level.cacheObjectString(name));
            }
        } else {
            String munKeyIdentifier = levKeys.getMUNKeyIdentifier(level.getMUNKeys());
            if (munKeyIdentifier != null) {
                if (isDataMember) {
                    munKeyIdentifier = ROLAPDataMember.generateMUNKeyIdentifier(munKeyIdentifier);
                }
                props.put("NAME", level.cacheObjectString(munKeyIdentifier));
            }
        }
        if (levKeys != null && !this.mPrimeLevelMembers) {
            props.put("LEVEL_KEYS", Arrays.asList(levKeys.mKeyValues));
        }
        if (isDataMember) {
            props.put("IS_DATA_MEMBER", 1);
            String caption = ROLAPDataMember.generateCaption(name, this.mHierarchy.getFillerCaptionType());
            String locale = this.mCube.getDefaultLocale();
            if (locale.equals(DefaultENUSLocaleString.getStaticLocale())) {
                props.put("CAPTION", level.cacheObjectString(caption));
            } else {
                ILocalizedString localizedCaption = AbstractSingleLocaleString.getSingleLocaleString(locale, caption);
                props.put("CAPTION", localizedCaption);
            }
            props.put("BUSINESS_KEY", level.cacheObjectString(defaultBusinessKey));
        }
        props.put("MEMBER_UNIQUE_NAME", null);
        if (this.mHierarchy.isRecursive()) {
            props.put("MEMBER_ORDINAL", null);
        }
        if (rowValues != null) {
            int businessKeyColIdx;
            IValue businessKeyValue;
            IValue descValue;
            int descColIdx;
            List<IProperty> memberProperties = level.getMemberProperties();
            List<HashMap<String, String>> stringCaches = this.levelToAttributeStringCache.get(level);
            if (stringCaches == null && !AbstractSingleLocaleString.hasInternString()) {
                stringCaches = new ArrayList<HashMap<String, String>>(memberProperties.size());
                for (int i = 0; i < memberProperties.size(); ++i) {
                    stringCaches.add(new HashMap());
                }
                this.levelToAttributeStringCache.put(level, stringCaches);
            }
            for (int propIdx = 0; propIdx < memberProperties.size(); ++propIdx) {
                ROLAPProperty property = (ROLAPProperty)memberProperties.get(propIdx);
                Object propValue = this.queryAttributesColumn.getPropertyValue(property, levelIndex, propIdx, rowValues);
                if (propValue == null) continue;
                if (propValue.getClass() == String.class && !AbstractSingleLocaleString.hasInternString()) {
                    String cachedString = stringCaches.get(propIdx).get(propValue);
                    if (cachedString == null) {
                        cachedString = propValue.toString();
                        stringCaches.get(propIdx).put(cachedString, cachedString);
                    }
                    props.put(property.getName(), cachedString);
                    continue;
                }
                props.put(property.getName(), level.cacheObjectString(propValue));
            }
            Object caption = this.queryAttributesColumn.getCaptionValue(metaLevel, levelIndex, rowValues);
            if (caption != null) {
                props.put("CAPTION", level.cacheObjectString(caption));
            }
            if ((descColIdx = this.queryAttributesColumn.getAttributeColumn("description", levelIndex)) != -1 && (descValue = rowValues[descColIdx]) != null && !descValue.isNull()) {
                props.put("DESCRIPTION", level.cacheObjectString(descValue));
            }
            if ((businessKeyValue = (businessKeyColIdx = this.queryAttributesColumn.getAttributeColumn("business_key", levelIndex)) != -1 ? rowValues[businessKeyColIdx] : defaultBusinessKey) != null) {
                props.put("BUSINESS_KEY", level.cacheObjectString(businessKeyValue));
            }
        }
        return props;
    }

    public boolean hasRecursiveHierarchy() {
        return this.mHierarchy.isRecursive();
    }

    private boolean insertRow(IValue[] row, IValue[] prevRow, ICacheKey[] path, List<ROLAPLevel> levelsToQuery, List<ROLAPMetaLevel> metaLevelsToQuery) {
        if (path[0] == null && this.queryAttributesColumn.getAttributeColumn("name", 0) == -1) {
            return false;
        }
        if (this.mCube.isCubingServicesCompatible()) {
            return this.processCSCompatibleInsertRow(row, prevRow, path, levelsToQuery, metaLevelsToQuery);
        }
        IValue colValue = null;
        int numLevels = levelsToQuery.size();
        ROLAPMember.LevelKeys thisRowKeys = null;
        ROLAPMember.LevelKeys prevRowKeys = null;
        for (int levelToQueryIdx = numLevels - 1; levelToQueryIdx >= 0; --levelToQueryIdx) {
            ICacheKey memberKey;
            ROLAPDimension dimension;
            ICacheKey iCacheKey;
            int levelIdx = numLevels - 1 - levelToQueryIdx;
            boolean gotDuplicateValue = false;
            ROLAPLevel currentLevel = levelsToQuery.get(levelToQueryIdx);
            ROLAPMetaLevel currentMetaLevel = metaLevelsToQuery.get(levelToQueryIdx);
            Map<ROLAPMember.LevelKeys, ICacheKey> currentLevelKeysToMemberKeyMap = this.getLevelKeysToMemberKeyMap(currentLevel);
            String memberName = null;
            thisRowKeys = currentLevel.getMemberKeys(row, this.queryAttributesColumn.getAttributeColumns("level_key", levelIdx));
            if (prevRow != null && thisRowKeys.equals(prevRowKeys = currentLevel.getMemberKeys(prevRow, this.queryAttributesColumn.getAttributeColumns("level_key", levelIdx)))) {
                gotDuplicateValue = true;
            }
            if ((iCacheKey = currentLevelKeysToMemberKeyMap.get(thisRowKeys)) == null || this.mBalancer.needsPaddingMember(thisRowKeys, path[levelIdx])) {
                ++this.numOfMembersLoaded;
                IValue businessKey = null;
                ICacheKey cachedParentMemberKey = path[levelIdx];
                ICacheKey lastCachedSiblingMemberKey = null;
                List<ICacheKey> cachedSiblings = null;
                if (cachedParentMemberKey != null) {
                    cachedSiblings = this.memberChildMap.get(cachedParentMemberKey);
                    if (cachedSiblings != null && cachedSiblings.size() > 0) {
                        lastCachedSiblingMemberKey = cachedSiblings.get(cachedSiblings.size() - 1);
                    }
                } else {
                    cachedSiblings = this.levelChildMap.get(currentLevel.getCacheKey());
                    if (cachedSiblings != null && cachedSiblings.size() > 0) {
                        lastCachedSiblingMemberKey = cachedSiblings.get(cachedSiblings.size() - 1);
                    }
                }
                if ((colValue = this.queryAttributesColumn.getNameValue(levelIdx, row)) instanceof Value && ((Value)colValue).isNull()) {
                    colValue = null;
                }
                if (colValue == null) {
                    memberName = "";
                    businessKey = null;
                } else {
                    memberName = colValue instanceof IValue && colValue.isNull() ? "" : colValue.toString();
                    businessKey = colValue;
                    if (!useBulkCaching) {
                        try {
                            if (lastCachedSiblingMemberKey != null && memberName.equals(this.mStorage.getMemberNameFromCache(lastCachedSiblingMemberKey)) && gotDuplicateValue) {
                                this.reportDuplicateRow(row, levelIdx, this.queryAttributesColumn, levelsToQuery.get(levelToQueryIdx).getName());
                            }
                        }
                        catch (CacheException e) {
                            ROLAPCacheBase.throwCacheGetException(e, this.mCube.getName(), this.mHierarchy.getDimension().getName());
                        }
                    }
                }
                Map<String, Object> props = this.prepareMemberProperties(memberName, businessKey, thisRowKeys, row, levelIdx, currentLevel, currentMetaLevel, false);
                MetadataCacheKey currentCachedMemberKey = null;
                if (useBulkCaching) {
                    currentCachedMemberKey = this.createKey();
                    path[levelIdx + 1] = currentCachedMemberKey;
                    this.mBalancer.collectHierarchyPaddingMembers(currentCachedMemberKey, props, currentLevel, (ICacheKey[])path.clone(), levelIdx);
                    this.membersToCache.put(currentCachedMemberKey, this.createCacheObject(currentCachedMemberKey, props, cachedParentMemberKey, currentLevel));
                    if (this.membersToCache.size() >= maxBulkListSize) {
                        this.bulkCacheMembers(this.membersToCache);
                        this.membersToCache.clear();
                    }
                } else {
                    currentCachedMemberKey = this.cacheMember(props, cachedParentMemberKey, currentLevel);
                    path[levelIdx + 1] = currentCachedMemberKey;
                    this.mBalancer.collectHierarchyPaddingMembers(currentCachedMemberKey, props, currentLevel, (ICacheKey[])path.clone(), levelIdx);
                }
                if (currentLevelKeysToMemberKeyMap.get(thisRowKeys) != null) {
                    this.reportDuplicateKeys(currentLevel, thisRowKeys);
                }
                currentLevelKeysToMemberKeyMap.put(thisRowKeys, currentCachedMemberKey);
                if (this.cacheKeyToLevelKeyMap == null) continue;
                this.cacheKeyToLevelKeyMap.put(currentCachedMemberKey, thisRowKeys);
                continue;
            }
            if (iCacheKey != null && !disableDuplicateLevelCheck) {
                ICacheKey parentMemberKey = path[levelIdx];
                ICacheableNameValueBasedContent iCacheableNameValueBasedContent = (ICacheableNameValueBasedContent)this.membersToCache.get(iCacheKey);
                if (iCacheableNameValueBasedContent != null) {
                    ICacheKey parentMemberKeyFromCacheKey = (ICacheKey)iCacheableNameValueBasedContent.get("PARENT_MEMBER_CACHE_KEY");
                    if (parentMemberKey != null) {
                        if (parentMemberKey.compareTo(parentMemberKeyFromCacheKey) != 0) {
                            this.reportDuplicateKeys(currentLevel, thisRowKeys);
                        }
                    } else if (parentMemberKeyFromCacheKey != null) {
                        this.reportDuplicateKeys(currentLevel, thisRowKeys);
                    }
                }
            }
            if (!(dimension = (ROLAPDimension)this.mHierarchy.getDimension()).isLocalizationMethodByRow()) continue;
            path[levelIdx + 1] = memberKey = currentLevelKeysToMemberKeyMap.get(thisRowKeys);
            if (useBulkCaching) {
                this.updateMemberPropertiesInBulk(memberKey, currentLevel, currentMetaLevel, levelIdx, row);
                continue;
            }
            this.updateMemberProperties(memberKey, currentLevel, currentMetaLevel, levelIdx, row);
        }
        return true;
    }

    private boolean processCSCompatibleInsertRow(IValue[] row, IValue[] prevRow, ICacheKey[] path, List<ROLAPLevel> levelsToQuery, List<ROLAPMetaLevel> metaLevelsToQuery) {
        IValue colValue = null;
        boolean newMember = false;
        int numLevels = levelsToQuery.size();
        ROLAPMember.LevelKeys thisRowKeys = null;
        ROLAPMember.LevelKeys prevRowKeys = null;
        for (int levelToQueryIdx = numLevels - 1; levelToQueryIdx >= 0; --levelToQueryIdx) {
            Map<ROLAPMember.LevelKeys, ICacheKey> currentLevelKeysToMemberKeyMap;
            int levelIdx = numLevels - 1 - levelToQueryIdx;
            boolean memberKeyCreated = false;
            boolean gotDuplicateValue = false;
            ROLAPLevel currentLevel = levelsToQuery.get(levelToQueryIdx);
            ROLAPMetaLevel currentMetaLevel = metaLevelsToQuery.get(levelToQueryIdx);
            colValue = this.queryAttributesColumn.getNameValue(levelIdx, row);
            if (colValue instanceof Value && ((Value)colValue).isNull()) {
                colValue = null;
            }
            if (!newMember) {
                if (prevRow == null) {
                    newMember = true;
                } else {
                    int column = this.queryAttributesColumn.getAttributeColumn("name", levelIdx);
                    IValue prevColValue = prevRow[column];
                    if (prevColValue instanceof Value && ((Value)prevColValue).isNull()) {
                        prevColValue = null;
                    }
                    if (prevColValue == null) {
                        if (colValue != null) {
                            newMember = true;
                        }
                    } else if (colValue == null) {
                        newMember = true;
                    } else if (!colValue.equals(prevColValue)) {
                        newMember = true;
                    } else {
                        thisRowKeys = currentLevel.getMemberKeys(row, this.queryAttributesColumn.getAttributeColumns("level_key", levelIdx));
                        memberKeyCreated = true;
                        prevRowKeys = currentLevel.getMemberKeys(prevRow, this.queryAttributesColumn.getAttributeColumns("level_key", levelIdx));
                        if (!thisRowKeys.equals(prevRowKeys)) {
                            newMember = true;
                        } else {
                            gotDuplicateValue = true;
                        }
                    }
                }
            }
            if (!newMember) continue;
            ++this.numOfMembersLoaded;
            String memberName = null;
            IValue businessKey = null;
            ICacheKey cachedParentMemberKey = path[levelIdx];
            ICacheKey lastCachedSiblingMemberKey = null;
            List<ICacheKey> cachedSiblings = null;
            if (cachedParentMemberKey != null) {
                cachedSiblings = this.memberChildMap.get(cachedParentMemberKey);
                if (cachedSiblings != null && cachedSiblings.size() > 0) {
                    lastCachedSiblingMemberKey = cachedSiblings.get(cachedSiblings.size() - 1);
                }
            } else {
                cachedSiblings = this.levelChildMap.get(currentLevel.getCacheKey());
                if (cachedSiblings != null && cachedSiblings.size() > 0) {
                    lastCachedSiblingMemberKey = cachedSiblings.get(cachedSiblings.size() - 1);
                }
            }
            if (colValue == null) {
                memberName = "";
                businessKey = null;
            } else {
                memberName = colValue instanceof IValue && colValue.isNull() ? "" : colValue.toString();
                businessKey = colValue;
                if (!useBulkCaching) {
                    try {
                        if (lastCachedSiblingMemberKey != null && memberName.equals(this.mStorage.getMemberNameFromCache(lastCachedSiblingMemberKey)) && gotDuplicateValue) {
                            this.reportDuplicateRow(row, levelIdx, this.queryAttributesColumn, levelsToQuery.get(levelToQueryIdx).getName());
                        }
                    }
                    catch (CacheException e) {
                        ROLAPCacheBase.throwCacheGetException(e, this.mCube.getName(), this.mHierarchy.getDimension().getName());
                    }
                }
            }
            if (!memberKeyCreated) {
                thisRowKeys = currentLevel.getMemberKeys(row, this.queryAttributesColumn.getAttributeColumns("level_key", levelIdx));
            }
            Map<String, Object> props = this.prepareMemberProperties(memberName, businessKey, thisRowKeys, row, levelIdx, currentLevel, currentMetaLevel, false);
            MetadataCacheKey currentCachedMemberKey = null;
            if (useBulkCaching) {
                currentCachedMemberKey = this.createKey();
                path[levelIdx + 1] = currentCachedMemberKey;
                this.mBalancer.collectHierarchyPaddingMembers(currentCachedMemberKey, props, currentLevel, (ICacheKey[])path.clone(), levelIdx);
                this.membersToCache.put(currentCachedMemberKey, this.createCacheObject(currentCachedMemberKey, props, cachedParentMemberKey, currentLevel));
                if (this.membersToCache.size() >= maxBulkListSize) {
                    this.bulkCacheMembers(this.membersToCache);
                    this.membersToCache.clear();
                }
            } else {
                currentCachedMemberKey = this.cacheMember(props, cachedParentMemberKey, currentLevel);
                path[levelIdx + 1] = currentCachedMemberKey;
                this.mBalancer.collectHierarchyPaddingMembers(currentCachedMemberKey, props, currentLevel, (ICacheKey[])path.clone(), levelIdx);
            }
            if ((currentLevelKeysToMemberKeyMap = this.getLevelKeysToMemberKeyMap(currentLevel)).get(thisRowKeys) != null) {
                this.reportDuplicateKeys(currentLevel, thisRowKeys);
            }
            currentLevelKeysToMemberKeyMap.put(thisRowKeys, currentCachedMemberKey);
            if (this.cacheKeyToLevelKeyMap == null) continue;
            this.cacheKeyToLevelKeyMap.put(currentCachedMemberKey, thisRowKeys);
        }
        return true;
    }

    private boolean isCubingServicesCompatible() {
        return this.mCube.isCubingServicesCompatible();
    }

    protected IROLAPQuery getQuery() {
        ROLAPMemberQuery query = new ROLAPMemberQuery(this.mCube.getSchema(), this.mCube);
        if (query instanceof ROLAPMemberQuery) {
            query.setHierarchy(this.mHierarchy);
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateLevelMembers(IROLAPQueryResultIterator resultIterator, List<ROLAPLevel> levelsToQuery, List<ROLAPMetaLevel> metaLevelsToQuery, ICacheKey[] path) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCPopulatingLevelMembersForHierarchy");
        try {
            this.tryToPopulateLevelMembers(resultIterator, levelsToQuery, metaLevelsToQuery, path);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToPopulateLevelMembers(IROLAPQueryResultIterator resultIterator, List<ROLAPLevel> levelsToQuery, List<ROLAPMetaLevel> metaLevelsToQuery, ICacheKey[] path) {
        ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Loader", "Started populating level members for hierarchy " + this.mHierarchy.getUniqueName());
        Future<Void> rowFetchTaskResult = null;
        Pipe<IValue[]> rowQueue = null;
        boolean operationCancelExceptionThrown = false;
        XQERuntimeException exception = null;
        try {
            boolean moreRows = false;
            FormatId[] formatIds = resultIterator.getColumnFormat();
            int numCols = formatIds.length;
            rowQueue = new Pipe<IValue[]>(500, 30);
            HierarchyIteratorFetchTask fetchTask = new HierarchyIteratorFetchTask(this.mCube, this.mHierarchy, rowQueue, resultIterator);
            Callable<Void> wrappedTask = ROLAPCallable.decorateCallable(fetchTask);
            rowFetchTaskResult = UnboundedThreadPool.getThreadPool().submit(wrappedTask);
            Iterator<IValue[]> rowIterator = rowQueue.iterator();
            IValue[] row = new IValue[numCols];
            IValue[] prevRow = null;
            IValue[] nextRow = null;
            int counter = 0;
            if (rowIterator.hasNext()) {
                row = rowIterator.next();
                moreRows = true;
            }
            if (!moreRows) {
                this.mCube.getMessages().addMessage(XQEMessageKeys.RLU_HierarchyLoadNoRows, this.mHierarchy.getUniqueName());
            }
            if (useBulkCaching) {
                this.membersToCache = new HashMap<ICacheKey, ICacheableObject>();
            }
            while (moreRows && !this.getDone()) {
                boolean inserted = this.insertRow(row, prevRow, path, levelsToQuery, metaLevelsToQuery);
                ++counter;
                if (rowIterator.hasNext()) {
                    nextRow = rowIterator.next();
                } else {
                    nextRow = null;
                    moreRows = false;
                }
                if (!moreRows) continue;
                if (inserted) {
                    prevRow = row;
                }
                row = nextRow;
            }
            rowFetchTaskResult.get();
            if (useBulkCaching && this.membersToCache != null && !this.membersToCache.isEmpty()) {
                this.bulkCacheMembers(this.membersToCache);
                this.membersToCache.clear();
                this.membersToCache = null;
            }
            ROLAPHierarchyMemberLoader.logNumberOfMembersLoadedMsg(this.mHierarchy, this.numOfMembersLoaded, true);
            ROLAPLog.log("ROLAPCubes.Loader", String.format("%,d enqueues when pipe full out of %,d total enqueues for hier %s.", rowQueue.getNumEnquesWhenFull(), rowQueue.getNumEnques(), this.mHierarchy.getName()));
        }
        catch (InterruptedException e) {
            exception = new XQERuntimeException(e);
        }
        catch (ExecutionException e) {
            exception = new XQERuntimeException(e);
        }
        catch (OperationCanceledException e) {
            operationCancelExceptionThrown = true;
            exception = e;
        }
        finally {
            block37: {
                if (rowFetchTaskResult != null && !rowFetchTaskResult.isDone()) {
                    rowQueue.setError(new PipeConsumerEndedException());
                    try {
                        rowFetchTaskResult.get();
                    }
                    catch (ExecutionException e) {
                        if (exception == null && !(e.getCause() instanceof PipeConsumerEndedException)) {
                            exception = new XQERuntimeException(e);
                        }
                    }
                    catch (Throwable e) {
                        if (exception != null) break block37;
                        exception = new XQERuntimeException(e);
                    }
                }
            }
            ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Loader", "Finished populating level members for hierarchy " + this.mHierarchy.getUniqueName());
        }
        if (exception != null) {
            if (operationCancelExceptionThrown) {
                throw exception;
            }
            throw (XQERuntimeException)exception;
        }
    }

    public static void logNumberOfMembersLoadedMsg(ROLAPHierarchy hier, int numberOfMembers, boolean cached) {
        String msg = hier.getUniqueName() + " loaded " + numberOfMembers + " members";
        if (!cached) {
            msg = msg + " (not in member cache)";
        }
        XQEDebugLog.out.println(msg);
        ROLAPLog.log("ROLAPCubes.Loader", msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStandard(List<ROLAPLevel> levelsToQuery, List<ROLAPMetaLevel> metaLevelsToQuery) {
        IROLAPQuery query = this.getQuery();
        this.resolveAttributeDataTypes(levelsToQuery, metaLevelsToQuery);
        this.addLevelExpressions(query, metaLevelsToQuery);
        this.addRelatedAttributesStandard(query, metaLevelsToQuery);
        this.addSortAttributes(query, metaLevelsToQuery);
        try (IROLAPQueryResultIterator resultIterator = query.execute();){
            ICacheKey[] path = new ICacheKey[levelsToQuery.size() + 1];
            Level rootLevel = (Level)this.mHierarchy.getLevel(0);
            if (rootLevel instanceof ROLAPAllLevel) {
                MemberProxy allMember = (MemberProxy)((ROLAPAllLevel)rootLevel).getAllMember();
                path[0] = allMember.getCacheKey();
            } else {
                path[0] = null;
            }
            this.populateLevelMembers(resultIterator, levelsToQuery, metaLevelsToQuery, path);
        }
        this.mBalancer.removeExtraneousPaddingMembers(this.memberChildMap, this.levelChildMap, this.mStorage);
        this.mBalancer.adjustPaddingMemberCaption();
    }

    private void primeLevelMembers() {
        if (this.mPrimeLevelMembers && !this.mHierarchy.getDimension().isMeasuresDimension()) {
            if (ROLAPLog.isOn("ROLAPCubes.Loader", LogLevel.TRACE)) {
                ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Loader", "Started priming level members for hierarchy " + this.mHierarchy.getUniqueName());
            }
            this.mHierarchy.setCacheKeyToLevelKeyMap(this.cacheKeyToLevelKeyMap);
            this.mHierarchy.initializeLevelMembers();
            this.mHierarchy.setCacheKeyToLevelKeyMap(null);
            if (ROLAPLog.isOn("ROLAPCubes.Loader", LogLevel.TRACE)) {
                ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Loader", "Finished priming level members for hierarchy " + this.mHierarchy.getUniqueName());
            }
            if (ROLAPLog.isOn("ROLAPCubes.Loader", LogLevel.TRACE)) {
                ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Loader", "Started builing level keys to member map for hierarchy " + this.mHierarchy.getUniqueName());
            }
            for (ILevel level : this.mHierarchy.getLevels()) {
                ((ROLAPLevel)level).getMember(new ROLAPMember.LevelKeys(null), false);
            }
            if (ROLAPLog.isOn("ROLAPCubes.Loader", LogLevel.TRACE)) {
                ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Loader", "Finished builing level keys to member map for hierarchy " + this.mHierarchy.getUniqueName());
            }
            for (ILevel level : this.mHierarchy.getLevels()) {
                this.mStorage.setPropValueInCache(((ROLAPLevel)level).getCacheKey(), "LEVEL_MEMBERS_CACHE_KEYS", null, this.mHierarchy.getDimension(), this.mCube);
            }
        }
    }

    private void reportDuplicateRow(IValue[] row, int level, ROLAPQueryAttributesToColumnsHandler queryColumnHandler, String levelName) {
        String[] qualifiers = new String[level];
        for (int i = 0; i < level; ++i) {
            IValue colValue = queryColumnHandler.getNameValue(i, row);
            qualifiers[i] = colValue == null ? "NULL" : colValue.toString();
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_DimHierAddMemberDuplicateMemberException, ROLAPHierarchyMemberLoader.quoteIdentifier(qualifiers), levelName);
    }

    private Map<ROLAPMember.LevelKeys, ICacheKey> getLevelKeysToMemberKeyMap(ILevel level) {
        Map<ROLAPMember.LevelKeys, ICacheKey> levelKeysToMemberKeyMap = this.levelToLevelKeysToMemberKeyMap.get(level);
        if (levelKeysToMemberKeyMap == null) {
            levelKeysToMemberKeyMap = new HashMap<ROLAPMember.LevelKeys, ICacheKey>();
            this.levelToLevelKeysToMemberKeyMap.put(level, levelKeysToMemberKeyMap);
        }
        return levelKeysToMemberKeyMap;
    }

    private int[] getLevelMemberCachedPropertyIds(ILevel level) {
        int[] levelMemberCachedPropertyIds = this.levelToLevelMemberCachedPropertyIds.get(level);
        if (levelMemberCachedPropertyIds == null) {
            String[] levelMemberCachedProperties = ((ROLAPLevel)level).getLevelMemberCachedProperties();
            levelMemberCachedPropertyIds = CacheableNameValueBasedArrayImmutableKeys.getIdsForProps(levelMemberCachedProperties);
            this.levelToLevelMemberCachedPropertyIds.put(level, levelMemberCachedPropertyIds);
        }
        return levelMemberCachedPropertyIds;
    }

    private void reportDuplicateKeys(ROLAPLevel level, ROLAPMember.LevelKeys keys) {
        String parentMemberName = "";
        ICacheKey cacheKey = this.getLevelKeysToMemberKeyMap(level).get(keys);
        try {
            ICacheKey parentKey;
            if (this.mCube != null && cacheKey != null && (parentKey = this.mStorage.getMemberParentFromCache(cacheKey)) != null) {
                parentMemberName = this.mStorage.getMemberNameFromCache(parentKey);
            }
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCacheGetException(e, this.mCube.getName(), this.mHierarchy.getDimension().getName());
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_DimLevelAddMemberDuplicateMemberKeysException, (Object)ROLAPHierarchyMemberLoader.quoteIdentifier(keys.getStringValues()), (Object)level.getUniqueName(), (Object)ROLAPHierarchyMemberLoader.quoteIdentifier(parentMemberName));
    }

    private void loadLevelMembers() {
        if (this.mHierarchy.isRecursive()) {
            this.buildRecursive();
        } else if (this.mHierarchy.getDimension().isMeasuresDimension()) {
            List<IMember> measuresList = ((ROLAPLevel)this.mHierarchy.getLevel(0)).getMembers(false, true);
            ROLAPHierarchyMemberLoader.logNumberOfMembersLoadedMsg(this.mHierarchy, measuresList.size(), false);
        } else {
            ArrayList<ROLAPLevel> levelsToQuery = new ArrayList<ROLAPLevel>();
            ArrayList<ROLAPMetaLevel> metaLevelsToQuery = new ArrayList<ROLAPMetaLevel>();
            this.getLevelsToQuery(this.mHierarchy, levelsToQuery, metaLevelsToQuery, "Loading level members for ");
            if (this.mCube.isValidateCube()) {
                this.buildValidate(levelsToQuery, metaLevelsToQuery);
            } else {
                this.buildStandard(levelsToQuery, metaLevelsToQuery);
            }
        }
        this.populateParents();
    }

    private void getLevelsToQuery(ROLAPHierarchy hierarchy, ArrayList<ROLAPLevel> levelsToQuery, ArrayList<ROLAPMetaLevel> metaLevelsToQuery, String msgHead) {
        ROLAPLevel currentLevel;
        ROLAPMetaLevel currentMetaLevel = currentLevel.getMetaLevel();
        for (currentLevel = (ROLAPLevel)hierarchy.getLevels().get(hierarchy.getLevelCount() - 1); currentLevel != null && currentMetaLevel != null && !currentLevel.isAllLevel(); currentLevel = (ROLAPLevel)currentLevel.getPreviousLevel()) {
            levelsToQuery.add(currentLevel);
            metaLevelsToQuery.add(currentLevel.getMetaLevel());
            String levelMsg = msgHead + currentLevel.getUniqueName();
            ROLAPLog.log("ROLAPCubes.Loader", levelMsg);
        }
    }

    private void populateParents() {
        try {
            for (Map.Entry<ICacheKey, List<ICacheKey>> entry : this.memberChildMap.entrySet()) {
                this.mStorage.addChildrenToCachedParent(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<ICacheKey, List<ICacheKey>> entry : this.levelChildMap.entrySet()) {
                this.mStorage.addMembersToCachedLevel(this.mHierarchy, entry.getKey(), entry.getValue());
            }
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCachePutException(e, this.mCube.getName(), this.mHierarchy.getDimension().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            this.mHierarchy.setLoadStatus(ROLAPHierarchy.LoadStatusEnum.started);
            if (this.getDone()) {
                return;
            }
            this.loadLevelMembers();
            this.primeLevelMembers();
            this.loadCalculatedMembers(this.mHierarchy.getMetaHierarchy());
            this.mHierarchy.createRelativeTimeMembers(this.mCube);
            this.mHierarchy.loadMeasureFolders();
            this.completed = true;
            this.mHierarchy.setLoadStatus(ROLAPHierarchy.LoadStatusEnum.finished_success);
            StringBuilder sb = new StringBuilder("Hier cache info for " + this.mHierarchy.getName() + "\n");
            for (Map.Entry<ILevel, List<HashMap<String, String>>> entries : this.levelToAttributeStringCache.entrySet()) {
                sb.append("  Level " + entries.getKey().getName() + ":  ");
                List<HashMap<String, String>> attributeCacheList = entries.getValue();
                for (int i = 0; i < attributeCacheList.size(); ++i) {
                    sb.append("#" + i + ": ");
                    sb.append(attributeCacheList.get(i).size() + " entries,  ");
                }
                sb.append('\n');
            }
            ROLAPLog.log("ROLAPCubes.Loader", sb.toString());
        }
        finally {
            if (this.mHierarchy.getLoadStatus() != ROLAPHierarchy.LoadStatusEnum.finished_success) {
                this.mHierarchy.setLoadStatus(ROLAPHierarchy.LoadStatusEnum.finished_failure);
            }
        }
    }

    public void loadCalculatedMembers(ROLAPMetaHierarchy metaHierarchy) {
        if (metaHierarchy != null) {
            int ct = metaHierarchy.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaObject obj = metaHierarchy.getChild(i);
                if (!(obj instanceof ROLAPMetaCalculatedMember)) continue;
                this.addModelDefinedCalculation(this.mCube, (ROLAPMetaCalculatedMember)obj);
            }
        }
    }

    private void addModelDefinedCalculation(ROLAPCube cube, ROLAPMetaCalculatedMember metaCalcMember) {
        String name = metaCalcMember.getName();
        String expression = metaCalcMember.getV5Expression();
        if (name != null && expression != null) {
            this.mHierarchy.createCalculatedMember(cube, name, null, 0, null, null, metaCalcMember, this.existingCalcMembers);
        }
    }

    public static void logInvalidCalculatedMemberError(ROLAPCube rolapCube, IROLAPHierarchy rolapHierarchy, String memberName, String parentName, IMessageKey.Param1 errorKey) {
        String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), memberName, rolapHierarchy.getUniqueName());
        if (errorKey == XQEMessageKeys.ROL_InvalidRootCalculatedMember) {
            ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(errorKey, memberName));
        } else {
            ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(errorKey, parentName));
        }
        rolapCube.addInvalidCalculatedMember(rolapHierarchy, memberName);
    }

    public static void logInvalidCalculatedMemberError(IROLAPVirtualCube rolapCube, IROLAPHierarchy rolapHierarchy, String memberName, String parentName, IMessageKey.Param1 errorKey) {
        String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), memberName, rolapHierarchy.getUniqueName());
        if (errorKey == XQEMessageKeys.ROL_InvalidRootCalculatedMember) {
            ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(errorKey, memberName));
        } else {
            ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(errorKey, parentName));
        }
        rolapCube.addInvalidCalculatedMember(rolapHierarchy, memberName);
    }

    public boolean getDone() {
        return this.mDoneFlag || this.isCancelled();
    }

    public void setDone(boolean flag) {
        this.mDoneFlag = flag;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isCancelled() {
        if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
            throw new OperationCanceledException();
        }
        return false;
    }

    private MetadataCacheKey createKey() {
        ROLAPDimension d = (ROLAPDimension)this.mHierarchy.getROLAPDimension();
        if (d.isShareable()) {
            return new MetadataCacheKey(0, d.getmaxMemberId());
        }
        return new MetadataCacheKey(this.mDimensionIndexInCube, d.getmaxMemberId());
    }

    private ICacheableObject createCacheObject(MetadataCacheKey cachedMemberKey, Map<String, Object> props, ICacheKey cachedParentMemberKey, ROLAPLevel level) {
        if (cachedParentMemberKey != null) {
            props.put("PARENT_MEMBER_CACHE_KEY", cachedParentMemberKey);
            this.addChildToParentList(this.memberChildMap, cachedMemberKey, cachedParentMemberKey);
        }
        this.addChildToParentList(this.levelChildMap, cachedMemberKey, level.getCacheKey());
        return new CacheableNameValueBasedArrayImmutableKeys(cachedMemberKey, this.getLevelMemberCachedPropertyIds(level), props);
    }

    private void bulkCacheMembers(Map<ICacheKey, ICacheableObject> members) {
        try {
            ArrayList<ICacheableObject> bulkMemberCache = new ArrayList<ICacheableObject>(members.values());
            this.mStorage.bulkCacheMembers(bulkMemberCache);
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCachePutException(e, this.mCube.getName(), this.mHierarchy.getDimension().getName());
        }
    }

    private MetadataCacheKey cacheMember(Map<String, Object> props, ICacheKey cachedParentMemberKey, ROLAPLevel level) {
        MetadataCacheKey cachedMemberKey = this.createKey();
        ICacheableObject cachedMemberContent = this.createCacheObject(cachedMemberKey, props, cachedParentMemberKey, level);
        try {
            this.mStorage.cacheMember(cachedMemberContent);
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCachePutException(e, this.mCube.getName(), this.mHierarchy.getDimension().getName());
        }
        return cachedMemberKey;
    }

    private void addChildToParentList(Map<ICacheKey, List<ICacheKey>> parentChildMap, ICacheKey child, ICacheKey parent) {
        List<ICacheKey> children = parentChildMap.get(parent);
        if (children == null) {
            children = new ArrayList<ICacheKey>();
            children.add(child);
            parentChildMap.put(parent, children);
        } else {
            children.add(child);
        }
    }

    public ROLAPHierarchy getLoadedHierarchy() {
        return this.mHierarchy;
    }

    public static String quoteIdentifier(String[] ident) {
        StringBuilder sb = new StringBuilder(100);
        ROLAPHierarchyMemberLoader.quoteIdentifier(ident, sb);
        return sb.toString();
    }

    public static void quoteIdentifier(String[] ident, StringBuilder sb) {
        for (int idx = 0; idx < ident.length; ++idx) {
            ROLAPHierarchyMemberLoader.quoteIdentifier(ident[idx], sb);
            if (idx >= ident.length - 1) continue;
            sb.append('.');
        }
    }

    public static String quoteIdentifier(String ident) {
        int identlen = ident.length();
        StringBuilder sb = new StringBuilder(identlen + 2);
        ROLAPHierarchyMemberLoader.quoteIdentifier(ident, sb);
        return sb.toString();
    }

    public static void quoteIdentifier(String ident, StringBuilder sb) {
        sb.append('[');
        for (int idx = 0; idx < ident.length(); ++idx) {
            char ch = ident.charAt(idx);
            if (ch == ']') {
                sb.append(']');
            }
            sb.append(ch);
        }
        sb.append(']');
    }

    private String valuesToString(IValue[] values) {
        String str = "";
        str = str + '[';
        for (IValue value : values) {
            if (str.length() > 1) {
                str = str + ", ";
            }
            str = str + value;
        }
        str = str + ']';
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildValidate(List<ROLAPLevel> levelsToQuery, List<ROLAPMetaLevel> metaLevelsToQuery) {
        IROLAPQuery query = this.getQuery();
        this.resolveAttributeDataTypes(levelsToQuery, metaLevelsToQuery);
        this.addLevelExpressions(query, metaLevelsToQuery);
        this.addRelatedAttributesStandard(query, metaLevelsToQuery);
        this.addSortAttributes(query, metaLevelsToQuery);
        try (IROLAPQueryResultIterator resultIterator = query.execute();){
            ICacheKey[] path = new ICacheKey[levelsToQuery.size() + 1];
            Level rootLevel = (Level)this.mHierarchy.getLevel(0);
            if (rootLevel instanceof ROLAPAllLevel) {
                MemberProxy allMember = (MemberProxy)((ROLAPAllLevel)rootLevel).getAllMember();
                path[0] = allMember.getCacheKey();
            } else {
                path[0] = null;
            }
            int numLevels = levelsToQuery.size();
            String memberName = DUMMY;
            for (int levelToQueryIdx = numLevels - 1; levelToQueryIdx >= 0; --levelToQueryIdx) {
                int levelIdx = numLevels - 1 - levelToQueryIdx;
                ROLAPLevel currentLevel = levelsToQuery.get(levelToQueryIdx);
                ICacheKey cachedParentMemberKey = path[levelIdx];
                MetadataCacheKey currentCachedMemberKey = this.createKey();
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("NAME", memberName);
                props.put("MEMBER_UNIQUE_NAME", null);
                if (this.mHierarchy.isRecursive()) {
                    props.put("MEMBER_ORDINAL", null);
                }
                currentCachedMemberKey = this.cacheMember(props, cachedParentMemberKey, currentLevel);
                path[levelIdx + 1] = currentCachedMemberKey;
            }
        }
    }

    static {
        String disableDuplicateLevelCheckProperty;
        useBulkCaching = true;
        maxBulkListSize = 1000;
        disableDuplicateLevelCheck = false;
        String bulkProperty = System.getProperty("CACHE_USE_BULK");
        if (bulkProperty != null) {
            useBulkCaching = Boolean.parseBoolean(bulkProperty);
        }
        if ((bulkProperty = System.getProperty("MAX_BULK_LIST_SIZE")) != null) {
            maxBulkListSize = Integer.parseInt(bulkProperty);
        }
        if ((disableDuplicateLevelCheckProperty = System.getProperty("disableDuplicateLevelCheck")) != null) {
            disableDuplicateLevelCheck = Boolean.parseBoolean(disableDuplicateLevelCheckProperty);
        }
    }

    private static class HierarchyIteratorFetchTask
    extends ROLAPCallable<Void> {
        private final Pipe<IValue[]> pipe;
        private final IROLAPQueryResultIterator resultIterator;
        private final ROLAPHierarchy hier;

        HierarchyIteratorFetchTask(ROLAPCube cube, ROLAPHierarchy hierarchy, Pipe<IValue[]> thePipe, IROLAPQueryResultIterator theResultIterator) {
            super(cube);
            this.pipe = thePipe;
            this.resultIterator = theResultIterator;
            this.hier = hierarchy;
        }

        @Override
        public Void callImpl() throws Exception {
            int rowCount = 0;
            int colNumber = -1;
            IValue[] values = null;
            try {
                FormatId[] formatIds = this.resultIterator.getColumnFormat();
                int numCols = formatIds.length;
                while (this.resultIterator.hasNext()) {
                    ++rowCount;
                    IValue[] row = new IValue[numCols];
                    values = this.resultIterator.next().getColumns();
                    if (values.length > 0) {
                        for (colNumber = 0; colNumber < numCols; ++colNumber) {
                            IValue v = values[colNumber];
                            row[colNumber] = (IValue)v.copy();
                            if (!(row[colNumber] instanceof TextValue)) continue;
                            ((TextValue)row[colNumber]).setCollator(null);
                        }
                    }
                    values = null;
                    this.pipe.add(row);
                }
            }
            catch (PipeConsumerEndedException formatIds) {
            }
            catch (Throwable ex) {
                if (values != null) {
                    String rowData = this.formatValues(values);
                    throw new XQERuntimeException(XQEMessageKeys.ROL_HierarchyLoadErrorAccessingValues, ex, (Object)this.hier.getName(), (Object)(colNumber + 1), (Object)rowCount, (Object)rowData);
                }
                throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
            }
            finally {
                this.pipe.producerFinished();
            }
            return null;
        }

        private String formatValues(IValue[] values) {
            StringBuilder sb = new StringBuilder();
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    try {
                        sb.append(values[i].toString());
                    }
                    catch (Throwable t) {
                        sb.append("<?>");
                    }
                    sb.append(',');
                }
            }
            return sb.toString();
        }
    }
}

