/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.VarcharValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.INameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.NameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.NameCacheNameProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAllLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDataMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.SharedDimNameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCurrentPeriodExpression;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.V5ExpressionUtils;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.DefaultENUSLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.LightweightOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ROLAPLevel
extends Level
implements IROLAPLevel,
NameCacheNameProvider {
    private static final int ONE_THOUSAND = 1000;
    private static final int FIVE = 5;
    private static final double EIGHT = 8.0;
    private static final int MEMBER_CACHEIDS_CONSTANT = 11;
    int levelType = -1;
    ConcurrentHashMap<String, ROLAPMetaLevel> cubeNameToMetaLevel;
    ROLAPMetaLevel singleMetaLevel;
    private ICacheKey cacheKey = null;
    private boolean[] munKeys = null;
    private final INameCache v5UniqueNameCache;
    private volatile Map<ROLAPMember.LevelKeys, IMember> levelKeysToMemberMap;
    private final boolean isBottomLevel;

    public void removeSharedCube(String cubeName) {
        if (this.cubeNameToMetaLevel != null) {
            this.cubeNameToMetaLevel.remove(cubeName);
        }
    }

    public ROLAPLevel(String s, Hierarchy hierarchy, ROLAPMetaLevel level, String cubeName, boolean isBottom) {
        super(s, hierarchy);
        if (((IROLAPDimension)hierarchy.getDimension()).isShareable()) {
            this.cubeNameToMetaLevel = new ConcurrentHashMap(1);
            this.cubeNameToMetaLevel.put(cubeName, level);
        } else {
            this.singleMetaLevel = level;
        }
        this.v5UniqueNameCache = this.createNameCache();
        this.initialiseLevelProperties();
        ROLAPCacheEngine storage = ((IROLAPDimension)this.getDimension()).getMetadataStorage();
        this.cacheKey = storage.createLevelCacheKey();
        this.addLevelToCache(storage);
        this.isBottomLevel = isBottom;
        this.setMembers(new LightweightOrderedMap<IMember>());
    }

    public ROLAPLevel(String s, Hierarchy hierarchy, boolean isBottom) {
        super(s, hierarchy);
        this.v5UniqueNameCache = this.createNameCache();
        this.singleMetaLevel = null;
        this.cubeNameToMetaLevel = null;
        if (!s.equalsIgnoreCase("Values")) {
            ROLAPCacheEngine storage = ((IROLAPDimension)this.getDimension()).getMetadataStorage();
            this.cacheKey = storage.createLevelCacheKey();
            this.addLevelToCache(storage);
        }
        this.isBottomLevel = isBottom;
    }

    private INameCache createNameCache() {
        if (this.getDimension().isShareable()) {
            return new SharedDimNameCache(this);
        }
        return new NameCache(this);
    }

    void addLevelToCache(ICacheEngine storage) {
        try {
            ICacheableNameValueBasedContent levelCacheData = (ICacheableNameValueBasedContent)storage.get(this.getCacheKey());
            if (levelCacheData == null) {
                HashMap<String, Object> props = new HashMap<String, Object>(1, 1.0f);
                levelCacheData = ROLAPCacheEngine.createCacheableObject((MetadataCacheKey)this.getCacheKey(), props);
                storage.cacheObject(levelCacheData);
            }
        }
        catch (CacheException ce) {
            ROLAPCacheBase.throwCachePutException(ce, this.getROLAPDimension().getCube().getName(), this.getDimension().getName());
        }
    }

    @Override
    public MetadataConnection getConnection() {
        return this.getHierarchy().getConnection();
    }

    public ICacheKey getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        return this.v5UniqueNameCache.getV5UniqueName(cubeName, ROLAPUtilities.getExpressionLocale(this));
    }

    @Override
    public String getName(String locale) {
        String localizedName = null;
        ROLAPMetaLevel theMetaLevel = this.getMetaLevel();
        if (theMetaLevel != null) {
            localizedName = theMetaLevel.getName(locale);
        }
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    @Override
    public ROLAPMetaLevel getMetaLevel() {
        if (this.getDimension().isShareable()) {
            if (this.cubeNameToMetaLevel != null) {
                String cubeName = ((ShareableROLAPDimension)this.getDimension()).getCube().getName();
                ROLAPMetaLevel metaLevel = this.cubeNameToMetaLevel.get(cubeName);
                if (metaLevel == null) {
                    metaLevel = ((ShareableROLAPDimension)this.getDimension()).getMetaLevel(cubeName, this.getHierarchy().getName(), this.getName());
                    this.cubeNameToMetaLevel.put(cubeName, metaLevel);
                }
                return metaLevel;
            }
            return null;
        }
        return this.singleMetaLevel;
    }

    @Override
    public int getType() {
        if (this.levelType != -1) {
            return this.levelType;
        }
        String sLevelType = null;
        ROLAPMetaLevel theMetaLevel = this.getMetaLevel();
        if (theMetaLevel != null) {
            sLevelType = theMetaLevel.getType();
        }
        this.levelType = ROLAPLevel.getType(sLevelType, ((ROLAPDimension)this.getDimension()).isTimeDimension());
        return this.levelType;
    }

    public static int getType(String sLevelType, boolean isTimeDimension) {
        int levelTypeId = sLevelType == null ? 0 : (sLevelType.equals("unknown") ? 0 : (sLevelType.equals("regular") ? 1 : (sLevelType.equals("time") ? 2 : (sLevelType.equals("time_years") ? 4 : (sLevelType.equals("time_half_years") ? 5 : (sLevelType.equals("time_quarters") ? 6 : (sLevelType.equals("time_months") ? 7 : (sLevelType.equals("time_weeks") ? 8 : (sLevelType.equals("time_days") ? 9 : (sLevelType.equals("time_hours") ? 10 : (sLevelType.equals("time_minutes") ? 11 : (sLevelType.equals("time_seconds") ? 12 : (sLevelType.equals("time_undefined") ? 3 : (sLevelType.equals("time_periods") ? 13 : (sLevelType.equals("time_seasons") ? 14 : (sLevelType.equals("time_holidays") ? 15 : (sLevelType.equals("time_semesters") ? 16 : (sLevelType.equals("time_trimesters") ? 17 : 0))))))))))))))))));
        if (levelTypeId == 0 && isTimeDimension) {
            levelTypeId = 3;
        }
        return levelTypeId;
    }

    public boolean hasRecursiveHierarchy() {
        return ((ROLAPHierarchy)this.getHierarchy()).isRecursive();
    }

    private void initialiseLevelProperties() {
        List<ROLAPMetaAttribute> relatedAttributes = this.getMetaLevel().getRelatedAttributes();
        if (relatedAttributes != null && relatedAttributes.size() > 0) {
            for (int ix = 0; ix < relatedAttributes.size(); ++ix) {
                ROLAPMetaAttribute relatedAttrib = relatedAttributes.get(ix);
                String name = relatedAttrib.getName();
                ROLAPProperty prop = new ROLAPProperty(name, relatedAttrib);
                prop.setCaption(name);
                prop.setDimension(this.getDimension());
                prop.setHierarchy(this.getHierarchy());
                prop.setLevel(this);
                prop.setInitialised();
                this.addMemberProperty(prop);
            }
        }
    }

    protected String[] getLevelMemberCachedProperties() {
        int numProperties = this.memberProperties.size() + 11;
        if (this.getHierarchy().isParentChild()) {
            ++numProperties;
        }
        String[] levelMemberCachedProperties = new String[numProperties];
        int ix = 0;
        for (String relatedAttribute : this.memberProperties.keySet()) {
            levelMemberCachedProperties[ix++] = relatedAttribute;
        }
        levelMemberCachedProperties[ix++] = "CAPTION";
        levelMemberCachedProperties[ix++] = "LEVEL_KEYS";
        levelMemberCachedProperties[ix++] = "MEMBER_UNIQUE_NAME";
        levelMemberCachedProperties[ix++] = "NAME";
        levelMemberCachedProperties[ix++] = "MEMBER_ORDINAL";
        levelMemberCachedProperties[ix++] = "BUSINESS_KEY";
        levelMemberCachedProperties[ix++] = "CHILD_MEMBERS_CACHED_KEYS";
        levelMemberCachedProperties[ix++] = "PARENT_MEMBER_CACHE_KEY";
        levelMemberCachedProperties[ix++] = "PARENT_MEMBER_CACHE_KEY";
        levelMemberCachedProperties[ix++] = "PADDING_MEMBER";
        levelMemberCachedProperties[ix++] = "DESCRIPTION";
        if (this.getHierarchy().isParentChild()) {
            levelMemberCachedProperties[ix++] = "IS_DATA_MEMBER";
        }
        return levelMemberCachedProperties;
    }

    @Override
    public boolean isValidPropertyName(String name) {
        if (super.isValidPropertyName(name)) {
            return true;
        }
        return name.equalsIgnoreCase("CAPTION") || name.equalsIgnoreCase("DESCRIPTION") || name.equalsIgnoreCase("MEMBER_KEY");
    }

    @Override
    public IROLAPProperty[] getProperties() {
        List<IProperty> props = this.getMemberProperties();
        if (props == null) {
            return new IROLAPProperty[0];
        }
        IROLAPProperty[] output = props.toArray(new IROLAPProperty[props.size()]);
        return output;
    }

    public ROLAPMember.LevelKeys getMemberKeys(IValue[] row, int[] levelKeyCols) {
        int numMemberKeys = levelKeyCols.length;
        IValue[] keyValues = new IValue[numMemberKeys];
        for (int j = 0; j < numMemberKeys; ++j) {
            keyValues[j] = row[levelKeyCols[j]];
        }
        return new ROLAPMember.LevelKeys(keyValues, this);
    }

    @Override
    protected IOrderedMap<IMember> fetchMembers() {
        LightweightOrderedMap<IMember> result = new LightweightOrderedMap();
        int firstLevel = 0;
        String propValue = (String)this.getHierarchy().getProperty("all level");
        if (propValue != null && propValue.equals("YES")) {
            ++firstLevel;
        }
        if (this.getIndex() == firstLevel) {
            result = ((Hierarchy)this.getHierarchy()).fetchFirstLevelMembers();
        } else {
            ArrayList<IMember> members = new ArrayList<IMember>();
            ILevel previousLevel = this.getPreviousLevel();
            List<IMember> lMems = ((Level)previousLevel).getMembers(true, false);
            CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
            for (int i = 0; i < lMems.size(); ++i) {
                if (cancelManager != null && cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                IMember[] childrenMems = ((IMemberCubics)lMems.get(i)).getChildMembers(true);
                for (int j = 0; j < childrenMems.length; ++j) {
                    if (cancelManager != null && cancelManager.isRequestCancelled()) {
                        throw new OperationCanceledException();
                    }
                    IMember m = childrenMems[j];
                    members.add(m);
                }
            }
            result.retainAll(members);
        }
        return result;
    }

    public IOrderedMap<IMember> fetchROLAPLevelMembers() throws MetadataException, ProviderException {
        IOrderedMap<IMember> result;
        ROLAPDimension dim = (ROLAPDimension)this.getDimension();
        ROLAPCacheEngine storage = dim.getMetadataStorage();
        if (dim.isMeasuresDimension()) {
            result = dim.fetchMeasures();
        } else {
            result = new LightweightOrderedMap<IMember>();
            ArrayList<IMember> memberCollection = new ArrayList<IMember>();
            if (this.isAllLevel() && this instanceof ROLAPAllLevel) {
                IMember allMember = ((ROLAPAllLevel)this).getAllMember();
                memberCollection.add(allMember);
                result.retainAll(memberCollection);
            } else {
                try {
                    List<ICacheKey> levelMembers = storage.getLevelMembersFromCache(this);
                    if (levelMembers != null) {
                        for (int i = 0; i < levelMembers.size(); ++i) {
                            MetadataCacheKey cachedMemberKey = (MetadataCacheKey)levelMembers.get(i);
                            String memberName = storage.getMemberNameFromCache(cachedMemberKey);
                            IMember parent = null;
                            MetadataCacheKey cachedParentMemberKey = (MetadataCacheKey)storage.getMemberParentFromCache(cachedMemberKey);
                            if (cachedParentMemberKey != null) {
                                Level parentLevel = (Level)this.getPreviousLevel();
                                parent = parentLevel.getMember(storage.getMemberNameFromCache(cachedParentMemberKey), cachedParentMemberKey.getMetadataChildId());
                            }
                            ROLAPMemberProxy memberShell = null;
                            Object isDataMember = storage.getMemberPropValueFromCache(cachedMemberKey, "IS_DATA_MEMBER");
                            if (isDataMember == null) {
                                memberShell = new ROLAPMemberProxy(cachedMemberKey, memberName, this, parent);
                            } else {
                                boolean isHidden = ((ROLAPHierarchy)this.getHierarchy()).isDataMemberHidden();
                                memberShell = new ROLAPDataMember(cachedMemberKey, memberName, this, parent, isHidden);
                                ((ROLAPMemberProxy)parent).setDataMember((ROLAPDataMember)memberShell);
                            }
                            memberCollection.add(memberShell);
                        }
                        result.retainAll(memberCollection);
                    }
                }
                catch (CacheException e) {
                    ROLAPCacheBase.throwCacheGetException(e, dim.getCube().getName(), dim.getName());
                }
            }
        }
        this.setMembers(result);
        this.setGotAllMembers();
        return result;
    }

    @Override
    public int getROLAPCardinality() {
        return this.getROLAPCardinality(true);
    }

    @Override
    public int getROLAPCardinality(boolean onlyEstimateCountWhenSecurityIsEnabled) {
        int cardinality = 0;
        List<ROLAPCalculatedMember> calcMembers = this.getROLAPCalculatedMembers(true);
        ROLAPDimension dimension = (ROLAPDimension)this.getDimension();
        ROLAPCube cube = (ROLAPCube)dimension.getROLAPCube();
        SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
        if (securityManager == null) {
            cardinality = this.getCardinality() + calcMembers.size();
        } else {
            int memberCount;
            ROLAPHierarchy hier = (ROLAPHierarchy)this.getHierarchy();
            IMember[] calculatedMembers = calcMembers.toArray(new IMember[calcMembers.size()]);
            calculatedMembers = securityManager.applySecurity(calculatedMembers, hier);
            if (onlyEstimateCountWhenSecurityIsEnabled) {
                memberCount = 1000;
                if (this.getIndex() < 5) {
                    memberCount = (int)Math.pow(8.0, this.getIndex() + 1);
                }
            } else {
                List<IMember> memberList = this.getMembers();
                IMember[] members = memberList.toArray(new IMember[memberList.size()]);
                members = securityManager.applySecurity(members, hier);
                memberCount = members.length;
            }
            cardinality = calculatedMembers.length + memberCount;
        }
        cardinality = this.getCardinality() + calcMembers.size();
        return cardinality;
    }

    @Override
    public IROLAPDimension getROLAPDimension() {
        return (IROLAPDimension)this.getDimension();
    }

    @Override
    public int getROLAPGeneration() {
        return this.getIndex();
    }

    @Override
    public IROLAPHierarchy getROLAPHierarchy() {
        return (IROLAPHierarchy)this.getHierarchy();
    }

    @Override
    public int getROLAPLevelNumber() {
        return this.getIndex();
    }

    @Override
    public IROLAPMember[] getROLAPMembers(boolean includeCalcMembers) {
        IMember[] members = null;
        if (includeCalcMembers) {
            ArrayList<IMember> allMembers = new ArrayList<IMember>();
            List<IMember> nonCalcMembers = this.getMembers();
            List<ROLAPCalculatedMember> calcMembers = this.getROLAPCalculatedMembers(true);
            if (this.getIndex() == 0) {
                allMembers.addAll(nonCalcMembers);
                allMembers.addAll(calcMembers);
                members = allMembers.toArray(new IMember[0]);
            } else {
                List<IMember> parents = null;
                ILevel parentLevel = this.getDimension().getLevel(this.getIndex() - 1);
                parents = parentLevel.getMembers();
                HashMap<IMember, ArrayList<IMember>> mapping = new HashMap<IMember, ArrayList<IMember>>();
                Iterator<IMember> it = nonCalcMembers.iterator();
                IMember parent = null;
                IMember oldParent = null;
                ArrayList childList = new ArrayList();
                if (it.hasNext()) {
                    IMember mem = it.next();
                    oldParent = parent = mem.getParent();
                    childList.add(mem);
                    while (it.hasNext()) {
                        mem = it.next();
                        parent = mem.getParent();
                        if (parent != oldParent) {
                            mapping.put(oldParent, childList);
                            childList = new ArrayList();
                        }
                        childList.add(mem);
                        oldParent = parent;
                    }
                    mapping.put(oldParent, childList);
                }
                for (IMember iMember : calcMembers) {
                    parent = iMember.getParent();
                    childList = (ArrayList)mapping.get(parent);
                    if (childList == null) {
                        childList = new ArrayList();
                    }
                    childList.add(iMember);
                    mapping.put(parent, childList);
                }
                for (IMember iMember : parents) {
                    childList = (ArrayList)mapping.get(iMember);
                    if (childList == null) continue;
                    allMembers.addAll(childList);
                }
                members = allMembers.toArray(new IMember[0]);
            }
        } else {
            members = this.getMembers().toArray(new IMember[0]);
        }
        ROLAPDimension dimension = (ROLAPDimension)this.getROLAPDimension();
        ROLAPCube cube = (ROLAPCube)dimension.getROLAPCube();
        SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
        if (securityManager != null) {
            members = securityManager.applySecurity(members, this.getHierarchy());
        }
        IROLAPMember[] serverMembers = new IROLAPMember[members.length];
        for (int i = 0; i < members.length; ++i) {
            serverMembers[i] = (IROLAPMember)members[i];
        }
        return serverMembers;
    }

    @Override
    public String getMemberKeyPropertyName() {
        return null;
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(boolean includeSessionScoped) {
        return CollectionCast.uncheckedCast(((ROLAPCube)this.getDimension().getCube()).getCalculations(this));
    }

    public void setMUNKeys(boolean[] keysToUse) {
        this.munKeys = keysToUse;
    }

    public boolean[] getMUNKeys() {
        return this.munKeys;
    }

    @Override
    public synchronized IMember getMember(String memberName) throws MetadataException {
        String[] parts;
        IMember member = super.getMember(memberName);
        if (member != null && (parts = UniqueNameParser.parseNoThrow(memberName)) != null && parts.length > 0 && !member.getUniqueName().equals(memberName)) {
            List<IMember> members = this.getMembers();
            for (IMember mem : members) {
                if (!mem.getUniqueName().equals(memberName)) continue;
                member = mem;
                break;
            }
        }
        return member;
    }

    public void validateCalculatedMeasures(ROLAPCube rolapCube) {
        if (!this.getDimension().isMeasuresDimension()) {
            return;
        }
        List<IMember> measures = this.getMembers(false, true);
        ArrayList<ROLAPCalculatedMeasure> calcMeasuresToRemove = new ArrayList<ROLAPCalculatedMeasure>(measures.size());
        ListIterator<IMember> iterator = measures.listIterator();
        while (iterator.hasNext()) {
            IMember measure = iterator.next();
            if (!measure.isCalculatedMember()) continue;
            ROLAPCalculatedMeasure calcMeasure = (ROLAPCalculatedMeasure)measure;
            IMember[] metaMeasure = (IMember[])calcMeasure.getROLAPMetaMeasure();
            String string = metaMeasure.getV5Expression();
            boolean isV5ExpressionSyntaxValid = false;
            IXQEQueryNode queryNode = null;
            try {
                queryNode = V5ExpressionUtils.checkV5ExpressionSyntax(string);
                isV5ExpressionSyntaxValid = queryNode != null;
            }
            catch (XQERuntimeException e) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), measure.getName(), this.getHierarchy().getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, e);
                rolapCube.addInvalidCalculatedMember(this.getHierarchy(), measure.getName());
            }
            if (!isV5ExpressionSyntaxValid || !V5ExpressionUtils.validateCalculatedMemberDefinition(this.getHierarchy(), rolapCube, calcMeasure, calcMeasure.getName())) {
                calcMeasuresToRemove.add(calcMeasure);
                continue;
            }
            if (metaMeasure.getFormatId() == null) {
                List<String> expressionIndentifers = V5ExpressionUtils.getExpressionIdentifiers(queryNode);
                metaMeasure.setInheritedFormatId(((ROLAPLevel)measure.getHierarchy().getLevel(0)).getMembers(false, true), expressionIndentifers);
            }
            ((ROLAPHierarchy)this.getHierarchy()).addROLAPCalculatedMeasures(calcMeasure);
        }
        if (calcMeasuresToRemove.size() > 0) {
            IMember[] origMembers = (IMember[])this.getMembersOrderedMap().toArray(new IMember[0]);
            ArrayList<IMember> mems = new ArrayList<IMember>();
            for (IMember m : origMembers) {
                mems.add(m);
            }
            for (IMember iMember : calcMeasuresToRemove) {
                mems.remove(iMember);
                rolapCube.getRootMeasureFolder().removeChild(iMember.getUniqueName());
            }
            IOrderedMap<IMember> map = this.createOrderedMap();
            map.putAll(mems);
            this.setMembers(map);
            TimestampValue timestampValue = DataValueFactory.createTimestampValue();
            timestampValue.set(System.currentTimeMillis());
            rolapCube.setSchemaUpdatedDate(timestampValue);
        }
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        ILocalizedString captions = null;
        ROLAPMetaLevel theMetaLevel = this.getMetaLevel();
        if (theMetaLevel != null && (captions = theMetaLevel.getCaptions()) == null) {
            captions = theMetaLevel.getNames();
        }
        if (captions == null) {
            captions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPDimension().getROLAPCube().getDefaultLocale(), this.getCaption());
        }
        return captions;
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ILocalizedString names = null;
        ROLAPMetaLevel theMetaLevel = this.getMetaLevel();
        if (theMetaLevel != null) {
            names = theMetaLevel.getNames();
        }
        if (names == null) {
            names = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPDimension().getROLAPCube().getDefaultLocale(), this.getName());
        }
        return names;
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        ILocalizedString descriptions = null;
        ROLAPMetaLevel theMetaLevel = this.getMetaLevel();
        if (theMetaLevel != null) {
            descriptions = theMetaLevel.getDescriptions();
        }
        if (descriptions == null) {
            descriptions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPDimension().getROLAPCube().getDefaultLocale(), this.getDescription());
        }
        return descriptions;
    }

    @Override
    public String getCaption() {
        Locale runLocale;
        String locale;
        String runLocaleCaption = null;
        ROLAPMetaLevel theMetaLevel = this.getMetaLevel();
        if (theMetaLevel != null && (runLocaleCaption = theMetaLevel.getCaption(locale = LocaleConverter.localeToStr(runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale()))) == null) {
            runLocaleCaption = theMetaLevel.getCaption(theMetaLevel.getDefaultLocale());
        }
        if (runLocaleCaption == null) {
            runLocaleCaption = super.getCaption();
        }
        return runLocaleCaption;
    }

    @Override
    public FormatId getCalculatedMeasureFormatId(String calcName) {
        ROLAPDimension rolapDimension = (ROLAPDimension)this.getDimension();
        return this.getFormatId(calcName, rolapDimension.fetchCalculatedMeasures(this));
    }

    private FormatId getFormatId(String calcName, IOrderedMap<ROLAPCalculatedMeasure> calculatedMeasures) {
        String[] identifiers;
        if (calculatedMeasures != null && (identifiers = UniqueNameParser.parseNoThrow(calcName)) != null && identifiers.length > 0) {
            for (int index = 0; index < calculatedMeasures.size(); ++index) {
                ROLAPCalculatedMeasure measure = calculatedMeasures.get(index);
                if (calcName.equals(measure.getV5UniqueName())) {
                    return measure.getFormatId();
                }
                String v5UniqueDefaultCaption = UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(identifiers[0]), measure.getUniqueDefaultCaption());
                if (v5UniqueDefaultCaption.equals(calcName)) {
                    return measure.getFormatId();
                }
                String v5UniqueRuntimeCaption = UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(identifiers[0]), measure.getUniqueRuntimeCaption());
                if (v5UniqueRuntimeCaption.equals(calcName)) {
                    return measure.getFormatId();
                }
                String v5UniqueName = UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(identifiers[0]), measure.getUniqueName());
                if (!v5UniqueName.equals(calcName)) continue;
                return measure.getFormatId();
            }
        }
        return null;
    }

    public String getCurrentPeriodExpression() {
        ROLAPMetaCurrentPeriodExpression currentPeriodExpression = (ROLAPMetaCurrentPeriodExpression)this.getMetaLevel().getChild("ROLAPMetaCurrentPeriodExpression");
        if (currentPeriodExpression == null) {
            return null;
        }
        return currentPeriodExpression.getCurrentPeriodExpression();
    }

    @Override
    public boolean isBottomLevel() {
        return this.isBottomLevel;
    }

    @Override
    public String createV5UniqueName(String cubeName, String locale) {
        return UniqueNameGenerator.createROLAPV5UniqueName(cubeName, locale, this);
    }

    @Override
    public List<IProperty> getMemberProperties(String cubeName) {
        IDimension dimension = this.getDimension();
        Cube cb = dimension.isShareable() ? ((ShareableROLAPDimension)dimension).getCube(cubeName) : (Cube)dimension.getCube();
        SecurityManagerInterface securityManager = cb.getSecurityManager();
        if (securityManager != null) {
            return this.getMemberPropertiesWithSecurity(securityManager);
        }
        return this.memberProperties.toArrayList();
    }

    @Override
    protected IOrderedMap<IMember> createOrderedMap() {
        return new LightweightOrderedMap<IMember>();
    }

    private String cacheString(String str) {
        IDimension dimension = this.getDimension();
        if (dimension instanceof ROLAPDimension) {
            return ((ROLAPDimension)dimension).cacheString(str);
        }
        return str;
    }

    public Object cacheObjectString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return this.cacheString((String)obj);
        }
        if (obj.getClass() == DefaultENUSLocaleString.class) {
            return this.cacheString(obj.toString());
        }
        if (obj.getClass() == VarcharValue.class) {
            ((VarcharValue)obj).setValue(this.cacheString(((VarcharValue)obj).toString()));
            return obj;
        }
        return obj;
    }

    public IMember getMember(ROLAPMember.LevelKeys levelKeys) {
        return this.getMember(levelKeys, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMember getMember(ROLAPMember.LevelKeys levelKeys, boolean logMsg) {
        if (this.levelKeysToMemberMap == null) {
            ROLAPLevel rOLAPLevel = this;
            synchronized (rOLAPLevel) {
                if (this.levelKeysToMemberMap == null) {
                    if (logMsg && ROLAPLog.isOn("ROLAPQuery", LogLevel.TRACE)) {
                        ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPQuery", "Started builing level keys to member map for hierarchy " + this.getUniqueName());
                    }
                    this.levelKeysToMemberMap = this.buildLevelKeysToMemberMap();
                    if (logMsg && ROLAPLog.isOn("ROLAPQuery", LogLevel.TRACE)) {
                        ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPQuery", "Finished builing level keys to member map for hierarchy " + this.getUniqueName());
                    }
                }
            }
        }
        if (levelKeys == null || levelKeys.getKeyValues() == null) {
            return null;
        }
        return this.levelKeysToMemberMap.get(levelKeys);
    }

    private Map<ROLAPMember.LevelKeys, IMember> buildLevelKeysToMemberMap() {
        HashMap<ROLAPMember.LevelKeys, IMember> lKeysMap = new HashMap<ROLAPMember.LevelKeys, IMember>();
        if (this.isAllLevel()) {
            return lKeysMap;
        }
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        boolean isPCH = this.getHierarchy().isParentChild();
        List<IMember> levelMembers = this.getMembers();
        for (IMember member : levelMembers) {
            if (cancelManager != null && cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            if (isPCH && member instanceof ROLAPDataMember) continue;
            lKeysMap.put(((ROLAPMemberProxy)member).getLevelKeys(), member);
        }
        return lKeysMap;
    }
}

