/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.List;

public class ROLAPLog {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String CUBE_EQUALS = "Cube=";
    private static final String STATE_EQUALS = "State=";
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.INFO;

    public static boolean isOn(String eventGroup) {
        return ROLAPLog.getLogger(eventGroup).isOn(DEFAULT_LOG_LEVEL);
    }

    public static boolean isOn(String eventGroup, LogLevel logLevel) {
        return ROLAPLog.getLogger(eventGroup).isOn(logLevel);
    }

    public static XQELogger getLogger(String eventGroup) {
        return XQELog.getLogger(ServiceEnumeration.XQE, "XQE", eventGroup, DEFAULT_LOG_LEVEL);
    }

    public static XQELogger getLogger(String eventGroup, LogLevel logLevel) {
        return XQELog.getLogger(ServiceEnumeration.XQE, "XQE", eventGroup, logLevel);
    }

    public static void log(String eventGroup, String message) {
        ROLAPLog.getLogger(eventGroup).log(DEFAULT_LOG_LEVEL, message);
    }

    public static void logError(String eventGroup, String message, Throwable error) {
        ROLAPLog.getLogger(eventGroup).log(LogLevel.ERROR, message, error);
    }

    public static void logError(String eventGroup, String message) {
        ROLAPLog.getLogger(eventGroup).log(LogLevel.ERROR, message);
    }

    public static void logWarn(String eventGroup, String message) {
        ROLAPLog.getLogger(eventGroup).log(LogLevel.WARN, message);
    }

    public static void logTrace(String eventGroup, String message) {
        ROLAPLog.getLogger(eventGroup).log(LogLevel.TRACE, message);
    }

    public static void logTimed(String eventGroup, String message, long milliseconds) {
        ROLAPLog.getLogger(eventGroup).log(DEFAULT_LOG_LEVEL, OperationEnum.DEFAULT, message, milliseconds);
    }

    public static void logOpStart(LogLevel level, String eventGroup, String message) {
        ROLAPLog.getLogger(eventGroup).log(level, OperationEnum.START, message);
    }

    public static void logOpEnd(LogLevel level, String eventGroup, String message) {
        ROLAPLog.getLogger(eventGroup).log(level, OperationEnum.END, message);
    }

    public static void logCubeStates(String eventGroup, List<ROLAPCube> cubes) {
        if (!ROLAPLog.isOn(eventGroup, DEFAULT_LOG_LEVEL)) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("Cube states.");
        buffer.append(NEWLINE);
        for (ROLAPCube cube : cubes) {
            buffer.append(CUBE_EQUALS);
            buffer.append(cube.getName());
            buffer.append(", ");
            buffer.append(STATE_EQUALS);
            buffer.append(cube.getStateStr());
            buffer.append(NEWLINE);
        }
        ROLAPLog.getLogger(eventGroup).log(DEFAULT_LOG_LEVEL, buffer.toString());
    }

    public static void logCubeNames(String eventGroup, String message, List<String> cubes) {
        if (!ROLAPLog.isOn(eventGroup, DEFAULT_LOG_LEVEL)) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(message);
        buffer.append(NEWLINE);
        for (String cubeName : cubes) {
            buffer.append(CUBE_EQUALS);
            buffer.append(cubeName);
            buffer.append(NEWLINE);
        }
        ROLAPLog.getLogger(eventGroup).log(DEFAULT_LOG_LEVEL, buffer.toString());
    }
}

