/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCalculatedMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDefaultMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasureFolder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ROLAPMeasureFolder
extends ROLAPFolder {
    public ROLAPMeasureFolder(IROLAPCube parentCube, List<ROLAPMetaObject> metaMeasureItems) {
        super(null, parentCube, "MeasureFolderRoot", null);
        this.setMeasureItems(metaMeasureItems);
    }

    private ROLAPMeasureFolder(ROLAPMeasureFolder parentFolder, ROLAPMetaMeasureFolder metaMeasureFolder, List<IMetadata> childObjects) {
        super(parentFolder, parentFolder.getCube(), metaMeasureFolder.getName(), metaMeasureFolder.getNames());
        this.addChildren(childObjects);
    }

    private ROLAPMeasureFolder(IROLAPFolder srcMeasureFolder, List<IMetadata> pMeasureItems) {
        super(srcMeasureFolder.getParent(), srcMeasureFolder.getCube(), srcMeasureFolder.getName(), srcMeasureFolder.getLocalizedCaption());
        this.addChildren(pMeasureItems);
    }

    private void setMeasureItems(List<ROLAPMetaObject> metaMeasureItems) {
        IMember[] measures = ((ROLAPCube)this.getCube()).getMeasures(true);
        HashMap<String, IMember> measuresMap = new HashMap<String, IMember>();
        for (int i = 0; i < measures.length; ++i) {
            measuresMap.put(measures[i].getName(), measures[i]);
        }
        List<IMetadata> childObjects = this.addAllDescendants(measuresMap, metaMeasureItems);
        this.addChildren(childObjects);
    }

    private List<IMetadata> addAllDescendants(HashMap<String, IMember> measuresMap, List<ROLAPMetaObject> metaMeasureItems) {
        IMetadata childToAdd = null;
        ArrayList<IMetadata> childList = new ArrayList<IMetadata>();
        for (ROLAPMetaObject item : metaMeasureItems) {
            childToAdd = null;
            if (item instanceof ROLAPMetaDefaultMeasureRef) continue;
            if (item instanceof ROLAPMetaCalculatedMeasureRef) {
                IMember calcMeasure = measuresMap.get(item.getName());
                if (calcMeasure instanceof ROLAPCalculatedMeasure || calcMeasure instanceof ROLAPVirtualCalculatedMeasure) {
                    childToAdd = calcMeasure;
                }
            } else if (item instanceof ROLAPMetaMeasureRef) {
                IMember measure;
                childToAdd = measure = measuresMap.get(item.getName());
            } else if (item instanceof ROLAPMetaMeasureFolder) {
                List<ROLAPMetaObject> metaChiildList = ((ROLAPMetaMeasureFolder)item).getMeasureItems();
                List<IMetadata> newFolderChildList = this.addAllDescendants(measuresMap, metaChiildList);
                ROLAPMeasureFolder measureFolder = new ROLAPMeasureFolder(this, (ROLAPMetaMeasureFolder)item, newFolderChildList);
                childToAdd = measureFolder;
            }
            if (childToAdd == null) continue;
            childList.add(childToAdd);
        }
        return childList;
    }

    @Override
    public IROLAPFolder applySecurity(SecurityManagerInterface securityManager) {
        if (securityManager == null) {
            return this;
        }
        List<IMetadata> measureItems = this.getChildren();
        ArrayList<IMetadata> tempMeasureItems = new ArrayList<IMetadata>();
        for (IMetadata measureItem : measureItems) {
            Object result;
            if (measureItem instanceof ROLAPMeasureFolder) {
                result = ((IROLAPFolder)measureItem).applySecurity(securityManager);
                if (result == null) continue;
                tempMeasureItems.add((IMetadata)result);
                continue;
            }
            result = new IMember[]{(IMember)measureItem};
            if (((IMember[])(result = securityManager.applySecurity((IMember[])result, result[0].getHierarchy()))).length == 0) continue;
            tempMeasureItems.add(measureItem);
        }
        if (tempMeasureItems.isEmpty()) {
            return null;
        }
        return new ROLAPMeasureFolder(this, tempMeasureItems);
    }

    @Override
    public boolean isVisible() {
        for (IMetadata childItem : this.getChildren()) {
            if (!(childItem instanceof IROLAPFolder ? ((IROLAPFolder)childItem).isVisible() : ((IROLAPMeasure)childItem).isVisible())) continue;
            return true;
        }
        return false;
    }
}

