/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.IOrderedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;

public final class ROLAPMemberOperations {
    private static final String AFTER = "AFTER";
    private static final String LEAVES = "LEAVES";

    public static void getRelationsOf(IMember theMember, int treeOp, boolean includeCalcMembers, ArrayList<IMember> relationList) {
        relationList.clear();
        Cube cube = (Cube)theMember.getLevel().getDimension().getCube();
        SecurityManagerInterface securityManager = cube.getSecurityManager(null);
        Set<IMember> inputList = CollectionCast.uncheckedCast(ListOrderedSet.decorate(new ArrayList()));
        Set<IMember> runningList = CollectionCast.uncheckedCast(ListOrderedSet.decorate(new ArrayList()));
        inputList.add(theMember);
        if (treeOp > 0) {
            ArrayList<IMember> descendants;
            if ((treeOp & 0x20) == 32) {
                for (IMember member : inputList) {
                    Object currentMember = member;
                    ArrayList<Object> ancestorList = new ArrayList<Object>();
                    if ((treeOp & 4) == 4) {
                        currentMember = member.getParent();
                    }
                    while (currentMember != null) {
                        if ((currentMember = currentMember.getParent()) == null) continue;
                        ancestorList.add(currentMember);
                    }
                    for (int ancestorIdx = ancestorList.size() - 1; ancestorIdx >= 0; --ancestorIdx) {
                        runningList.add((IMember)ancestorList.get(ancestorIdx));
                    }
                }
            }
            if ((treeOp & 4) == 4) {
                for (IMember member : inputList) {
                    ROLAPMemberOperations.addParent(member, runningList, securityManager);
                }
            }
            if ((treeOp & 2) == 2) {
                for (IMember member : inputList) {
                    boolean includeSelf;
                    if ((treeOp & 8) == 8) {
                        treeOp ^= 8;
                        includeSelf = true;
                    } else {
                        includeSelf = false;
                    }
                    try {
                        IMember[] a = member.getSiblings(includeSelf);
                        for (int i = 0; i < a.length; ++i) {
                            runningList.add((IMember)a[i]);
                        }
                    }
                    catch (MetadataException e) {
                        throw new XQERuntimeException(e);
                    }
                    if (!includeCalcMembers) continue;
                    IMember parentMember = member.getParent();
                    if (parentMember == null) {
                        ILevel level = member.getLevel();
                        List<ROLAPCalculatedMember> calcMembers = ((ROLAPLevel)level).getROLAPCalculatedMembers(true);
                        if (member.isCalculatedMember() && !includeSelf) {
                            calcMembers.remove(member);
                        }
                        if (level.getIndex() == 0) {
                            runningList.addAll(calcMembers);
                            continue;
                        }
                        for (CalculatedMember calculatedMember : calcMembers) {
                            if (calculatedMember.getParent() != null) continue;
                            runningList.add(calculatedMember);
                        }
                        continue;
                    }
                    List<ROLAPCalculatedMember> calcMembers = ((IROLAPMember)parentMember).getROLAPCalculatedMembers(true);
                    if (member.isCalculatedMember() && !includeSelf) {
                        calcMembers.remove(member);
                    }
                    runningList.addAll(calcMembers);
                }
            }
            if ((treeOp & 8) == 8) {
                for (IMember member : inputList) {
                    runningList.add(member);
                }
            }
            if ((treeOp & 1) == 1 && (treeOp & 0x10) != 16) {
                for (IMember member : inputList) {
                    ROLAPMemberOperations.addChildren(member, runningList, includeCalcMembers, securityManager);
                }
            }
            if ((treeOp & 0x10) == 16) {
                for (IMember member : inputList) {
                    descendants = new ArrayList<IMember>();
                    ROLAPMemberOperations.recursiveAddDescendants((IMemberCubics)member, 0, AFTER, false, includeCalcMembers, descendants);
                    for (int k = 0; k < descendants.size(); ++k) {
                        runningList.add(descendants.get(k));
                    }
                }
            } else if ((treeOp & 0x200) == 512) {
                for (IMember member : inputList) {
                    descendants = new ArrayList();
                    ROLAPMemberOperations.recursiveAddDescendants((IMemberCubics)member, -1, LEAVES, false, includeCalcMembers, descendants);
                    descendants.remove(member);
                    for (int k = 0; k < descendants.size(); ++k) {
                        runningList.add(descendants.get(k));
                    }
                }
            }
        }
        IMember[] cubicsResult = runningList.toArray(new IMember[0]);
        if (securityManager != null) {
            cubicsResult = securityManager.applySecurity(cubicsResult, theMember.getHierarchy());
        }
        for (int j = 0; j < cubicsResult.length; ++j) {
            relationList.add(cubicsResult[j]);
        }
    }

    private static void addParent(IMember child, Collection<IMember> runningList, SecurityManagerInterface securityManager) {
        IMember parent = child.getParent();
        if (parent != null) {
            if (ROLAPMemberOperations.isRestricted(parent, securityManager)) {
                ROLAPMemberOperations.addParent(parent, runningList, securityManager);
            } else {
                runningList.add(parent);
            }
        }
    }

    private static void addChildren(IMember parent, Collection<IMember> runningList, boolean includeCalculatedMembers, SecurityManagerInterface securityManager) {
        IMember[] children = parent.getChildMembers();
        for (int i = 0; i < children.length; ++i) {
            IMember child = children[i];
            if (ROLAPMemberOperations.isRestricted(child, securityManager)) {
                ROLAPMemberOperations.addChildren(child, runningList, includeCalculatedMembers, securityManager);
                continue;
            }
            runningList.add(child);
        }
        if (includeCalculatedMembers) {
            List<ROLAPCalculatedMember> calculatedChildren = ((IROLAPMember)parent).getROLAPCalculatedMembers(true);
            for (IMember iMember : calculatedChildren) {
                if (ROLAPMemberOperations.isRestricted(iMember, securityManager)) continue;
                runningList.add(iMember);
            }
        }
    }

    private static boolean isRestricted(IMember member, SecurityManagerInterface securityManager) {
        if (securityManager != null) {
            IMember[] members = new IMember[]{member};
            IHierarchy hier = null;
            if (member != null) {
                hier = member.getHierarchy();
            }
            return (members = securityManager.applySecurity(members, hier)).length == 0;
        }
        return false;
    }

    private static void recursiveAddDescendants(IMemberCubics member, int depth, String flags, boolean includeFillerMembers, boolean includeCalcMembers, ArrayList<IMember> output) {
        IOrderedMap<IMember> children;
        boolean recurse = true;
        if (flags.equalsIgnoreCase(LEAVES)) {
            List<ROLAPCalculatedMember> calcMembers;
            int childrenCount;
            if (depth == 0) {
                if (!member.isFillerMember() && !member.isHidden()) {
                    output.add(member);
                    recurse = false;
                }
            } else if (depth < 0) {
                children = member.getChildrenOrderedMap();
                childrenCount = children == null ? 0 : children.size();
                calcMembers = null;
                if (includeCalcMembers) {
                    calcMembers = ((IROLAPMember)member).getROLAPCalculatedMembers(true);
                    childrenCount += calcMembers.size();
                }
                if (childrenCount == 0 && !member.isFillerMember() && !member.isHidden()) {
                    output.add(member);
                    recurse = false;
                }
            } else if (depth > 0) {
                if (!member.hasGotAllChildren()) {
                    member.getChildMembers();
                }
                childrenCount = (children = member.getChildrenOrderedMap()) == null ? 0 : children.size();
                calcMembers = null;
                if (includeCalcMembers) {
                    calcMembers = ((IROLAPMember)member).getROLAPCalculatedMembers(true);
                    childrenCount += calcMembers.size();
                }
                if (childrenCount == 0 && !member.isFillerMember() && !member.isHidden()) {
                    output.add(member);
                    recurse = false;
                }
            }
        } else if (flags.equalsIgnoreCase(AFTER) && depth < 0 && !member.isFillerMember() && !member.isHidden()) {
            output.add(member);
        }
        if (recurse) {
            if (!member.isFillerMember() || includeFillerMembers) {
                --depth;
            }
            if (!member.hasGotAllChildren()) {
                member.getChildMembers();
            }
            if ((children = member.getChildrenOrderedMap()) != null) {
                for (IMember child : children) {
                    ROLAPMemberOperations.recursiveAddDescendants((IMemberCubics)child, depth, flags, includeFillerMembers, includeCalcMembers, output);
                }
            }
            if (includeCalcMembers) {
                output.addAll(((IROLAPMember)member).getROLAPCalculatedMembers(true));
            }
        }
    }
}

