/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPCommonMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAllLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDataMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberOperations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPSecurityPaddingMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.SecurityPaddingOrderedMap;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.DefaultENUSLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.ImmutableOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocaleUtility;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ROLAPMemberProxy
extends MemberProxy
implements IROLAPMember,
IROLAPCommonMember {
    protected byte flags;
    private static final byte COMPUTED_ROLLUP = 1;
    private static final byte HIDDEN = 2;
    protected volatile Map<String, Object> cachedMemberProps = null;
    private ROLAPDataMember dm = null;
    private long ordinal = -1L;
    private int unrestrictedChildrenCount = -1;
    private static final String OPEN_BRACE = "[";
    private static final String CLOSE_BRACE = "]";
    private static final String OPENING_MUN_PART = ".[";
    private static final String MEMBER_KEY = "MEMBER_KEY";
    private final ROLAPMember.LevelKeys levelKeys;

    public ROLAPMemberProxy(MetadataCacheKey memKey, String memName, ILevel memLevel, IMember parent) {
        super(memKey, memName, memLevel);
        this.setParentMember(parent);
        if ((memLevel instanceof ROLAPAllLevel || !((Level)memLevel).isBottomLevel() || ROLAPVirtualCube.useVirtualMemberProxy()) && !(this instanceof ROLAPSecurityPaddingMemberProxy)) {
            this.setPropValueInCache("MEMBER_UNIQUE_NAME", this.prepareUniqueName());
        }
        this.levelKeys = this.getLevelKeysFromHierarchy();
    }

    public ROLAPMemberProxy(MetadataCacheKey memKey, String defaultName, ILocalizedString memNames, ILevel memLevel, IMember parent) {
        super(memKey, defaultName, memLevel);
        this.setParentMember(parent);
        if (memLevel instanceof ROLAPAllLevel || !((Level)memLevel).isBottomLevel() || ROLAPVirtualCube.useVirtualMemberProxy()) {
            this.setPropValueInCache("MEMBER_UNIQUE_NAME", this.prepareUniqueName());
        }
        if (memNames.getClass() == DefaultENUSLocaleString.class) {
            this.setPropValueInCache("CAPTION", ((ROLAPLevel)memLevel).cacheObjectString(memNames.toString()));
        } else {
            this.setPropValueInCache("CAPTION", memNames);
        }
        this.levelKeys = this.getLevelKeysFromHierarchy();
    }

    @Override
    public String getDefaultLocale() {
        return ((ROLAPCube)this.getLevel().getDimension().getCube()).getDefaultLocale();
    }

    @Override
    public ROLAPMember.LevelKeys getLevelKeys() {
        if (this.levelKeys != null) {
            return this.levelKeys;
        }
        List levelKeysList = (List)this.retrievePropValueFromCache("LEVEL_KEYS");
        if (levelKeysList == null) {
            return null;
        }
        return new ROLAPMember.LevelKeys(levelKeysList.toArray(new IValue[levelKeysList.size()]));
    }

    protected ROLAPMember.LevelKeys getLevelKeysFromHierarchy() {
        ROLAPMember.LevelKeys lKeys = null;
        IHierarchy memHierarchy = this.getHierarchy();
        if (memHierarchy instanceof ROLAPHierarchy) {
            lKeys = ((ROLAPHierarchy)memHierarchy).getLevelKeys(this.getCacheKey());
        }
        return lKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object retrievePropValueFromCache(String propName) {
        Object result = null;
        if (this.cachedMemberProps == null) {
            ROLAPMemberProxy rOLAPMemberProxy = this;
            synchronized (rOLAPMemberProxy) {
                if (this.cachedMemberProps == null) {
                    ICacheableNameValueBasedContent cachedMemberContent;
                    IDimension dim = this.getLevel().getDimension();
                    if (!(dim instanceof IROLAPDimension)) {
                        return null;
                    }
                    ROLAPCacheEngine metadataCache = ((IROLAPDimension)dim).getMetadataStorage();
                    try {
                        cachedMemberContent = (ICacheableNameValueBasedContent)metadataCache.get(this.getCacheKey());
                    }
                    catch (CacheException e) {
                        ROLAPCacheBase.throwCacheGetException(e, this.getDimension().getCube().getName(), this.getDimension().getName());
                        return null;
                    }
                    if (cachedMemberContent != null) {
                        this.cachedMemberProps = cachedMemberContent.getContent();
                    }
                }
            }
        }
        if (this.cachedMemberProps != null) {
            result = this.cachedMemberProps.get(this.translatePropName(propName));
        }
        return result;
    }

    @Override
    public int getParentLevelNumber() {
        ILevel level = this.getLevel();
        if (level.getIndex() == 0) {
            return -1;
        }
        return super.getParentLevelNumber();
    }

    private String translatePropName(String propName) {
        if (propName.equalsIgnoreCase(MEMBER_KEY)) {
            return this.getLevel().getName() + "." + propName;
        }
        return propName;
    }

    public void setPropValueInCache(String propName, Object propValue) {
        if (this.isSecurityPaddingMember()) {
            this.cachedMemberProps.put(propName, propValue);
        } else {
            Cube cube = (Cube)this.getROLAPDimension().getCube();
            ROLAPCacheEngine storage = this.getROLAPDimension().getMetadataStorage();
            storage.setPropValueInCache(this.getCacheKey(), propName, propValue, this.getLevel().getDimension(), cube);
        }
    }

    @Override
    public IOrderedMap<IMember> fetchChildren() {
        IOrderedMap<IMember> children;
        ROLAPCacheEngine storage = this.getROLAPDimension().getMetadataStorage();
        Level childLevel = (Level)this.getLevel().getNextLevel();
        ArrayList<IMember> childrenList = new ArrayList<IMember>();
        if (childLevel == null) {
            children = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
        } else {
            children = this.createOrderedMap();
            try {
                List<ICacheKey> childKeys = storage.getMemberChildrenFromCache(this.getCacheKey());
                if (childKeys != null) {
                    CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
                    for (ICacheKey childKey : childKeys) {
                        if (cancelManager != null && cancelManager.isRequestCancelled()) {
                            throw new OperationCanceledException();
                        }
                        IMember memberShell = null;
                        String childName = storage.getMemberNameFromCache(childKey);
                        if (childLevel.hasGotAllMembers()) {
                            memberShell = childLevel.getMember(childName, ((MetadataCacheKey)childKey).getMetadataChildId());
                            if (memberShell == null) {
                                throw new ProviderException("ROLAPMemberProxy object " + childName + " expected to be present, but not found within level members list.");
                            }
                        } else {
                            Object isDataMember = storage.getMemberPropValueFromCache(childKey, "IS_DATA_MEMBER");
                            if (isDataMember == null) {
                                memberShell = new ROLAPMemberProxy((MetadataCacheKey)childKey, childName, childLevel, this);
                            } else {
                                boolean hidden = ((ROLAPHierarchy)this.getHierarchy()).isDataMemberHidden();
                                memberShell = new ROLAPDataMember((MetadataCacheKey)childKey, childName, childLevel, this, hidden);
                                this.setDataMember((ROLAPDataMember)memberShell);
                            }
                        }
                        childrenList.add(memberShell);
                    }
                }
            }
            catch (ProviderException e) {
                throw new MetadataException("la1003", e);
            }
            catch (CacheException e) {
                ROLAPCacheBase.throwCacheGetException(e, this.getDimension().getCube().getName(), this.getDimension().getName());
            }
            if (childrenList.size() == 0) {
                children = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
            } else {
                children.retainAll(childrenList);
            }
        }
        this.initUnrestrictedChildrenCount();
        this.setPropValueInCache("CHILD_MEMBERS_CACHED_KEYS", null);
        return children;
    }

    @Override
    public boolean isHidden() {
        return (this.flags & 2) != 0;
    }

    public void setHidden(boolean hidden) {
        this.flags = hidden ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public void setDataMember(ROLAPDataMember dataMember) {
        this.dm = dataMember;
    }

    @Override
    public IMember getDataMember() {
        this.getChildrenOrderedMap();
        if (this.dm == null) {
            return super.getDataMember();
        }
        return this.dm;
    }

    public String prepareUniqueName() {
        StringBuilder result = new StringBuilder();
        if (!this.getROLAPDimension().isShareable() && ((ROLAPCube)this.getROLAPDimension().getROLAPCube()).isCubingServicesCompatible()) {
            if (this.isPaddingMember()) {
                IROLAPMember paddingParent = (IROLAPMember)this.getParent();
                result.append(paddingParent.getUniqueName());
                result.append(OPENING_MUN_PART).append(CLOSE_BRACE);
            } else {
                IROLAPMember parent;
                for (parent = (IROLAPMember)this.getParent(); parent != null && parent.isPaddingMember(); parent = (IROLAPMember)parent.getParent()) {
                }
                if (parent == null) {
                    result.append(this.getHierarchy().getUniqueName());
                } else {
                    result.append(parent.getUniqueName());
                }
                result.append(OPENING_MUN_PART).append(this.getName()).append(CLOSE_BRACE);
            }
        } else {
            IROLAPMember parent = (IROLAPMember)this.getParent();
            if (parent == null) {
                if (this.getLevel().getName().equals("VL")) {
                    result.append(UniqueNameGenerator.createUniqueName(this.getHierarchy().getName()));
                    result.append(".");
                    result.append(UniqueNameGenerator.createUniqueName(this.getLevel().getName()));
                } else {
                    result.append(this.getHierarchy().getUniqueName());
                }
            } else {
                result.append(parent.getUniqueName());
            }
            result.append(OPENING_MUN_PART).append(UniqueNameParser.escapeSquareBrackets(this.getName())).append(CLOSE_BRACE);
        }
        return result.toString();
    }

    @Override
    public String getUniqueName() {
        if (((Level)this.getLevel()).isBottomLevel() && !ROLAPVirtualCube.useVirtualMemberProxy()) {
            return this.prepareUniqueName();
        }
        return (String)this.retrievePropValueFromCache("MEMBER_UNIQUE_NAME");
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(ROLAPContext.getCurrentCubeName());
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        String uniqueName = this.getUniqueName();
        return UniqueNameGenerator.createMemberV5UniqueName(cubeName, this.getLevel(), uniqueName);
    }

    @Override
    public String getCaption() {
        Object obj = this.retrievePropValueFromCache("CAPTION");
        if (obj == null) {
            return this.getName();
        }
        String runLocaleCaption = null;
        if (obj instanceof ILocalizedString) {
            Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            String locale = LocaleConverter.localeToStr(runLocale);
            runLocaleCaption = ((ILocalizedString)obj).toString(locale = LocaleUtility.getSupportedLocale(locale, (ILocalizedString)obj, this.getDefaultLocale()));
            if (runLocaleCaption == null && (runLocaleCaption = ((ILocalizedString)obj).toString(this.getDefaultLocale())) == null) {
                runLocaleCaption = this.getName();
            }
        } else {
            runLocaleCaption = obj.toString();
        }
        return runLocaleCaption;
    }

    @Override
    public String getDescription() {
        Object description = this.retrievePropValueFromCache("DESCRIPTION");
        if (description == null) {
            return null;
        }
        return description.toString();
    }

    @Override
    public Value getDescriptionValue() {
        Value description = (Value)this.retrievePropValueFromCache("DESCRIPTION");
        if (description == null || description.getDataType().isTextType()) {
            return description;
        }
        StringValue v = DataValueFactory.createStringValue();
        ((Value)v).set(description.toString());
        return v;
    }

    @Override
    public Object getBusinessKey() {
        return this.retrievePropValueFromCache("BUSINESS_KEY");
    }

    @Override
    public Value getBusinessKeyValue() {
        return (Value)this.getBusinessKey();
    }

    @Override
    public IROLAPDimension getROLAPDimension() {
        return (IROLAPDimension)this.getLevel().getDimension();
    }

    @Override
    public IROLAPHierarchy getROLAPHierarchy() {
        return (IROLAPHierarchy)this.getLevel().getHierarchy();
    }

    @Override
    public IROLAPLevel getROLAPLevel() {
        return (IROLAPLevel)this.getLevel();
    }

    @Override
    public int getROLAPOrdinal() {
        return (int)this.getOrdinal();
    }

    @Override
    public int getIndex() {
        return (int)this.getOrdinal();
    }

    @Override
    public long getMemberId() {
        return this.getOrdinal();
    }

    public long getOrdinal() {
        long memberOrdinal;
        if (this.ordinal == -1L) {
            memberOrdinal = !((ROLAPHierarchy)this.getHierarchy()).isRecursive() ? (long)((MetadataCacheKey)this.getCacheKey()).getMetadataChildId() : (long)((Integer)this.retrievePropValueFromCache("MEMBER_ORDINAL")).intValue();
            this.ordinal = memberOrdinal;
        } else {
            memberOrdinal = this.ordinal;
        }
        return memberOrdinal;
    }

    @Override
    public IROLAPMember getROLAPParent() {
        ArrayList<IMember> relationList = new ArrayList<IMember>();
        ROLAPMemberProxy member = this;
        try {
            ROLAPMemberOperations.getRelationsOf(member, 4, true, relationList);
        }
        catch (Exception ex) {
            relationList.clear();
        }
        if (relationList.isEmpty()) {
            return null;
        }
        return (IROLAPMember)relationList.get(0);
    }

    @Override
    public int getROLAPParentCount() {
        if (this.getROLAPParent() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getROLAPType() {
        if (this.isCalculatedMember()) {
            return 4;
        }
        if (this.isMeasure()) {
            return 3;
        }
        if (((ROLAPLevel)this.getLevel()).isAllLevel()) {
            return 2;
        }
        return 1;
    }

    @Override
    public Object getProperty(String propertyName) {
        Object value;
        if ("memberCaption".equals(propertyName)) {
            propertyName = "MEMBER_CAPTION";
        }
        if ((value = super.getProperty(propertyName)) != null && this.isPaddingMember() && propertyName.compareToIgnoreCase(MEMBER_KEY) == 0) {
            value = null;
        } else if (null == value && propertyName.startsWith(OPEN_BRACE) && propertyName.endsWith(CLOSE_BRACE)) {
            try {
                propertyName = UniqueNameParser.parseLastIdentifier(propertyName);
            }
            catch (UniqueNameParserException uniqueNameParserException) {
                // empty catch block
            }
            if (null != propertyName) {
                ROLAPCube cube = (ROLAPCube)this.getDimension().getCube();
                SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
                value = securityManager != null && securityManager.isAttributeSecured(propertyName, this.getHierarchy()) ? null : super.getProperty(propertyName);
            }
        }
        if (value instanceof ILocalizedString) {
            ILocalizedString property = (ILocalizedString)value;
            Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            String locale = LocaleConverter.localeToStr(runLocale);
            value = property.toString(locale = LocaleUtility.getSupportedLocale(locale, property, this.getDefaultLocale()));
            if (value == null) {
                value = property.toString(this.getDefaultLocale());
            }
        }
        return value;
    }

    @Override
    public void getRelationsOf(int treeOp, boolean includeCalcMembers, ArrayList<IMember> relationList) throws Exception {
        ROLAPMemberOperations.getRelationsOf(this, treeOp, includeCalcMembers, relationList);
    }

    private int getUnrestrictedChildrenCount() {
        if (this.unrestrictedChildrenCount == -1) {
            this.initUnrestrictedChildrenCount();
        }
        return this.unrestrictedChildrenCount;
    }

    private synchronized void initUnrestrictedChildrenCount() {
        if (this.unrestrictedChildrenCount == -1) {
            ROLAPCacheEngine storage = this.getROLAPDimension().getMetadataStorage();
            int regularChildrenCount = 0;
            try {
                List<ICacheKey> cachedChildren = storage.getMemberChildrenFromCache(this.getCacheKey());
                if (cachedChildren != null) {
                    boolean dataMembersHidden = ((ROLAPHierarchy)this.getHierarchy()).isDataMemberHidden();
                    if (dataMembersHidden) {
                        for (ICacheKey cachedMemberKey : cachedChildren) {
                            if (storage.getMemberPropValueFromCache(cachedMemberKey, "IS_DATA_MEMBER") != null) continue;
                            ++regularChildrenCount;
                        }
                    } else {
                        regularChildrenCount = cachedChildren.size();
                    }
                }
            }
            catch (CacheException e) {
                ROLAPCacheBase.throwCacheGetException(e, this.getDimension().getCube().getName(), this.getDimension().getName());
            }
            this.unrestrictedChildrenCount = regularChildrenCount;
        }
    }

    @Override
    public int getROLAPChildrenCount() {
        return this.getROLAPChildrenCount(true);
    }

    public int getROLAPChildrenCount(boolean onlyEstimateCountWhenSecurityIsEnabled) {
        int childrenCount = 0;
        ROLAPCube cube = (ROLAPCube)this.getDimension().getCube();
        SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
        if (securityManager != null) {
            if (onlyEstimateCountWhenSecurityIsEnabled) {
                childrenCount = this.getUnrestrictedChildrenCount() + this.getROLAPCalculatedMembers(true).size() == 0 ? 0 : 1;
            } else {
                ArrayList<IMember> relationList = new ArrayList<IMember>();
                try {
                    this.getRelationsOf(1, true, relationList);
                }
                catch (Exception ex) {
                    relationList.clear();
                }
                childrenCount = relationList.size();
            }
        } else {
            childrenCount = this.getUnrestrictedChildrenCount() + this.getROLAPCalculatedMembers(true).size();
        }
        return childrenCount;
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(boolean includeSessionScoped) {
        return CollectionCast.uncheckedCast(((ROLAPCube)this.getLevel().getDimension().getCube()).getCalculations(this));
    }

    @Override
    public boolean isLeaf() {
        return this.getUnrestrictedChildrenCount() == 0;
    }

    @Override
    public Pair[] getSourceMembers() {
        Pair[] result = new Pair[]{new Pair(this, XQEIntegerPool.getInteger(0))};
        return result;
    }

    @Override
    public MemberTypeEnum getType() {
        return MemberTypeEnum.REGULAR;
    }

    @Override
    public RollupTypeEnum getRollupType() {
        if ((this.flags & 1) == 1) {
            return RollupTypeEnum.COMPUTED;
        }
        return RollupTypeEnum.ROLLUP;
    }

    public void setRollupType(RollupTypeEnum theRollupType) {
        if (theRollupType == RollupTypeEnum.ROLLUP) {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
        }
        if (theRollupType == RollupTypeEnum.COMPUTED) {
            this.flags = (byte)(this.flags | 1);
        }
    }

    @Override
    public IDataType getDataType() {
        return MemberType.MEMBERTYPE;
    }

    @Override
    public boolean isPaddingMember() {
        return this.retrievePropValueFromCache("PADDING_MEMBER") != null;
    }

    @Override
    public boolean isSecurityPaddingMember() {
        return this.retrievePropValueFromCache("SECURITY_PADDING_MEMBER") != null;
    }

    @Override
    public void setSecurityPaddingMember(boolean paddingMember) {
        if (paddingMember) {
            this.cachedMemberProps.put("SECURITY_PADDING_MEMBER", "1");
        } else {
            this.cachedMemberProps.remove("SECURITY_PADDING_MEMBER");
        }
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        Object caption = this.retrievePropValueFromCache("CAPTION");
        if (caption != null && caption instanceof ILocalizedString) {
            return (ILocalizedString)caption;
        }
        if (caption != null && caption instanceof String) {
            return AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), (String)caption);
        }
        return AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), this.getCaption());
    }

    @Override
    public ILocalizedString getLocalizedName() {
        return LocalizedString.emptyString();
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        return LocalizedString.emptyString();
    }

    @Override
    public List<IMember> getAllChildren(String cubeName) throws MetadataException, ProviderException {
        throw new UnsupportedOperationException("ROLAPmember.getAllChildren not supported");
    }

    @Override
    protected IOrderedMap<IMember> createOrderedMap() {
        return new SecurityPaddingOrderedMap<IMember>();
    }

    public void setSecurityPaddingMember(ROLAPSecurityPaddingMemberProxy securityPaddingMember) {
        if (this.childrenOrderedMap == null || this.childrenOrderedMap == ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP) {
            this.childrenOrderedMap = this.createOrderedMap();
        }
        ((SecurityPaddingOrderedMap)this.childrenOrderedMap).setSecurityPaddingMember(securityPaddingMember);
    }

    public void setCaption(MemberRecord rec) {
        Object caption = this.retrievePropValueFromCache("CAPTION");
        if (caption != null && caption instanceof String) {
            rec.setCaption((String)caption);
        } else {
            rec.setCaption(this.getLocalizedCaption());
        }
    }
}

