/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryResultIteratorFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaOrderAttributeRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecurityLookupQueryCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.RolapV5Builder;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class ROLAPMemberQuery
implements IROLAPQuery {
    private static XQELogger sLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryProcessing", LogLevel.TRACE);
    private static final String QUERY_NAME = "ROLAPMemberQuery";
    public static final String DATAITEM_AGGREGATE_NONE = "none";
    public static final String CUBE_MODEL_SORT_ORDER_DESC = "desc";
    public static final String CUBE_MODEL_SORT_ORDER_ASC = "asc";
    public static final String V5_SORT_ORDER_ASCENDING = "ascending";
    public static final String V5_SORT_ORDER_DESCENDING = "descending";
    public static final String ALL_ROWS = "allRows";
    private final ROLAPMetaMdSchema metaMdSchema;
    private ArrayList<String[]> dataItemsInfo;
    private final String cubeName;
    private final List<ROLAPMetaAttribute> selectAttributes;
    private final List<ROLAPMetaObject> sortAttributes;
    private final String requestID;
    private ROLAPHierarchy mHierarchy;
    private boolean mGetRecursiveRootMbr = false;
    private ROLAPMetaAttribute mParentKey = null;
    private ROLAPMetaAttribute mMemberKey = null;
    private String mFilterExpression = null;
    private ROLAPCube cube = null;

    public ROLAPMemberQuery(ROLAPMetaMdSchema schema, ROLAPCube baseCube) {
        this.metaMdSchema = schema;
        this.cube = baseCube;
        this.cubeName = this.cube.getName();
        this.requestID = new UID().toString();
        this.selectAttributes = new ArrayList<ROLAPMetaAttribute>();
        this.sortAttributes = new ArrayList<ROLAPMetaObject>();
    }

    public List<ROLAPMetaAttribute> getAttributeSelections() {
        return this.selectAttributes;
    }

    @Override
    public List<ROLAPMetaAttribute> getAttributeSelections(IROLAPQuery.QueryTarget target) {
        return this.getAttributeSelections();
    }

    @Override
    public void addAttribute(ROLAPMetaAttribute attrib, IROLAPQuery.QueryTarget target) {
        this.addAttribute(attrib);
    }

    public void addAttribute(ROLAPMetaAttribute attrib) {
        this.selectAttributes.add(attrib);
    }

    @Override
    public int addAttributeAvoidingDuplicates(ROLAPMetaAttribute metaAttribute, IROLAPQuery.QueryTarget target) {
        return metaAttribute.addAttributeAvoidingDuplicates(this, IROLAPQuery.QueryTarget.COMMON);
    }

    @Override
    public void addSortAttribute(ROLAPMetaObject metaObject) {
        if (!this.sortAttributes.contains(metaObject)) {
            this.sortAttributes.add(metaObject);
        }
    }

    public void addParentKey(ROLAPMetaAttribute attrib) {
        this.mParentKey = attrib;
    }

    public ROLAPMetaAttribute getParentKey() {
        return this.mParentKey;
    }

    public void addMemberKey(ROLAPMetaAttribute attrib) {
        this.mMemberKey = attrib;
    }

    public ROLAPMetaAttribute getMemberKey() {
        return this.mMemberKey;
    }

    public void setRecursiveRootMbrFlag() {
        this.mGetRecursiveRootMbr = true;
    }

    public void resetRecursiveRootMbrFlag() {
        this.mGetRecursiveRootMbr = false;
    }

    public void setDataItemInfo(ArrayList<String[]> dataItems) {
        this.dataItemsInfo = dataItems;
    }

    @Override
    public IROLAPQueryResultIterator execute() {
        return this.execute(null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IROLAPQueryResultIterator execute(SecurityLookupQueryCache cache, AtomicReference<String> queryRef, AtomicReference<SecurityLookupQueryCache.MemberSetEntry> memberSetRef, String queryPrefix) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCMemberQuery", ZipiContext.getQRDName());
        try {
            IROLAPQueryResultIterator iROLAPQueryResultIterator = this.tryToExecute(cache, queryRef, memberSetRef, queryPrefix);
            return iROLAPQueryResultIterator;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IROLAPQueryResultIterator tryToExecute(SecurityLookupQueryCache cache, AtomicReference<String> queryRef, AtomicReference<SecurityLookupQueryCache.MemberSetEntry> memberSetRef, String queryPrefix) {
        block20: {
            TraceContext traceCtx = TraceContext.enter();
            try {
                RSAPIDataset dataset;
                IXQEQueryNode[] sqls;
                QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
                envHelper.setInternalUse(false);
                envHelper.setUpEnvironment(false);
                ExecutionEnvironment newExecEnv = envHelper.getExecutionEnvironment();
                RequestEnvironment newReqEnv = envHelper.getRequestEnvironment();
                newReqEnv.setCMRequestExecutor(this.cube.getAccountManager());
                ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Loader", "Started member query.");
                this.setupRequestEnvironment(newReqEnv);
                RolapV5Builder.setupConnectionElement(newExecEnv);
                newReqEnv.initializeRequestPAC(newExecEnv.getConnectionElement());
                PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(newReqEnv);
                planEnv.setMetdataConnection(this.getMetadataConnection());
                V5QuerySet querySet = this.createV5QuerySet(planEnv);
                PlannedV5QuerySet plannedQuerySet = QueryPlanner.getInstance().planQuery(querySet, planEnv);
                if (cache != null && (sqls = plannedQuerySet.getDescendantsOfType(501013, false)) != null && sqls.length > 0) {
                    String query = queryPrefix + "#" + ((XSql)sqls[0]).getSqlText();
                    queryRef.set(query);
                    SecurityLookupQueryCache.MemberSetEntry memberSet = cache.get(query);
                    if (memberSet != null) {
                        memberSetRef.set(memberSet);
                        IROLAPQueryResultIterator iROLAPQueryResultIterator = null;
                        return iROLAPQueryResultIterator;
                    }
                }
                if ((dataset = ROLAPMemberQuery.getDataset(QUERY_NAME, plannedQuerySet)) == null) break block20;
                IROLAPQueryResultIterator iROLAPQueryResultIterator = ROLAPQueryResultIteratorFactory.getIterator(dataset, newExecEnv);
                return iROLAPQueryResultIterator;
                finally {
                    try {
                        ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Loader", "Finished member query.");
                    }
                    finally {
                        envHelper.tearDownEnvironment();
                    }
                }
            }
            finally {
                traceCtx.exit();
            }
        }
        return null;
    }

    private String getModelPath() {
        return this.metaMdSchema.getCommonCubeModel().getModelPath();
    }

    @Override
    public String getName() {
        return QUERY_NAME;
    }

    private V5QuerySet createV5QuerySet(PlanningEnvironment planEnv) {
        RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
        XQETrace trace = planEnv.getTrace();
        boolean loggingOn = (trace.getTraceLevel() & 0x100) != 0;
        trace.removeTraceLevel(256);
        MetricsService.startCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        V5QuerySet v5QuerySet = (V5QuerySet)nodeFactory.createV5Node("querySet");
        planEnv.getNodeIndex().addNode(v5QuerySet);
        if (this.dataItemsInfo != null) {
            this.buildV5QuerySetFromDataItems(v5QuerySet, planEnv);
        } else {
            this.buildV5QuerySetFromMdSchema(v5QuerySet, planEnv);
        }
        planEnv.setRoot(v5QuerySet);
        MetricsService.endCollectingMetric(reqEnv, "v5QueryToBinaryTree");
        if (loggingOn) {
            trace.addTraceLevel(256);
        }
        planEnv.resetTreeHasBeenModified();
        return v5QuerySet;
    }

    private void buildV5QuerySetFromDataItems(V5QuerySet querySet, PlanningEnvironment planEnv) {
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        String modelPath = this.getModelPath();
        RolapV5Builder.setV5QuerySetProperties(planEnv, modelPath, querySet);
        boolean autoSummary = true;
        V5Query query = RolapV5Builder.addQueryNode(nodeFactory, querySet, QUERY_NAME);
        IXQEQueryNode selection = RolapV5Builder.addSelectionNode(nodeFactory, query, autoSummary);
        RolapV5Builder.addRelationalSourceNode(nodeFactory, query);
        IXQEQueryNode groupBody = RolapV5Builder.addGroupBodyNode(nodeFactory, QUERY_NAME);
        for (String[] stringArray : this.dataItemsInfo) {
            String dataItemName = stringArray[0];
            String dataItemExpression = stringArray[1];
            String aggregateType = DATAITEM_AGGREGATE_NONE;
            RolapV5Builder.addDataItem(nodeFactory, selection, groupBody, dataItemName, dataItemExpression, aggregateType);
        }
        V5ValueSet valueSet = RolapV5Builder.buildAndInsertQRD(nodeFactory, querySet, QUERY_NAME, groupBody);
        for (String[] info : this.dataItemsInfo) {
            String refDataItemName = info[0];
            String sortOrder = info[2];
            IXQEQueryNode sortItem = nodeFactory.createNode(101056);
            sortItem.setPropertyValue("refDataItem", refDataItemName);
            sortItem.setPropertyValue("sortOrder", sortOrder);
            valueSet.addChild(sortItem);
        }
        this.addFilterClause(query, nodeFactory);
        if (sLogger.isOn()) {
            String string = String.format("Built V5QuerySet from data items to fetch members for cube %s: \n%s", this.cubeName, querySet.dumpToString());
            sLogger.log(string);
        }
    }

    private void buildV5QuerySetFromMdSchema(V5QuerySet querySet, PlanningEnvironment planningEnvironment) {
        String modelPath = this.getModelPath();
        XQENodeFactory nodeFactory = planningEnvironment.getNodeFactory();
        RolapV5Builder.setV5QuerySetProperties(planningEnvironment, modelPath, querySet);
        V5Query query = RolapV5Builder.addQueryNode(nodeFactory, querySet, QUERY_NAME);
        IXQEQueryNode selection = RolapV5Builder.addSelectionNode(nodeFactory, query, true);
        RolapV5Builder.addRelationalSourceNode(nodeFactory, query);
        IXQEQueryNode groupBody = RolapV5Builder.addGroupBodyNode(nodeFactory, QUERY_NAME);
        for (ROLAPMetaAttribute rOLAPMetaAttribute : this.selectAttributes) {
            rOLAPMetaAttribute.buildMemberQuerySelection(nodeFactory, selection, groupBody);
        }
        V5ValueSet valueSet = RolapV5Builder.buildAndInsertQRD(nodeFactory, querySet, QUERY_NAME, groupBody);
        for (ROLAPMetaObject sortObject : this.sortAttributes) {
            if (!(sortObject instanceof ROLAPMetaOrderAttributeRef) && !(sortObject instanceof ROLAPMetaAttribute)) continue;
            String refDataItemName = "";
            String sortOrder = V5_SORT_ORDER_ASCENDING;
            if (sortObject instanceof ROLAPMetaOrderAttributeRef) {
                ROLAPMetaOrderAttributeRef sortOrderAttributeRef = (ROLAPMetaOrderAttributeRef)sortObject;
                refDataItemName = sortOrderAttributeRef.getName();
                String sortDirection = sortOrderAttributeRef.getSortDirection();
                if (CUBE_MODEL_SORT_ORDER_DESC.equals(sortDirection)) {
                    sortOrder = V5_SORT_ORDER_DESCENDING;
                }
            }
            if (sortObject instanceof ROLAPMetaAttribute) {
                ROLAPMetaAttribute sortAttribute = (ROLAPMetaAttribute)sortObject;
                refDataItemName = sortAttribute.getName();
            }
            IXQEQueryNode sortItem = nodeFactory.createNode(101056);
            sortItem.setPropertyValue("refDataItem", refDataItemName);
            sortItem.setPropertyValue("sortOrder", sortOrder);
            valueSet.addChild(sortItem);
        }
        this.addFilterClause(query, nodeFactory);
        if (sLogger.isOn()) {
            String string = String.format("Built V5QuerySet from MdSchema to fetch members for cube %s: \n%s", this.cubeName, querySet.dumpToString());
            sLogger.log(string);
        }
    }

    private void addFilterClause(IXQEQueryNode query, XQENodeFactory nodeFactory) {
        if (this.mFilterExpression != null) {
            IXQEQueryNode detailFilter = nodeFactory.createNode(101008);
            query.addChild(detailFilter);
            IXQEQueryNode filterExpression = nodeFactory.createNode(101013);
            filterExpression.setPropertyValue("expression", this.mFilterExpression);
            detailFilter.addChild(filterExpression);
        }
    }

    private void setupRequestEnvironment(RequestEnvironment reqEnv) {
        RolapV5Builder.setRequestEnvironmentCubeInfo(reqEnv, this.cube);
        reqEnv.setRequestID(this.requestID);
        reqEnv.setSubRequestID(null);
        reqEnv.setOperationName("command");
        if (this.mHierarchy != null) {
            String reportName = this.mHierarchy.getDimension().getName() + "_" + this.mHierarchy.getName();
            reqEnv.setReportName(reportName);
        }
    }

    public static RSAPIDataset getDataset(String queryName, PlannedV5QuerySet v5QuerySet) {
        IXQEQueryNode aDataset;
        IXQEQueryNode[] datasets = v5QuerySet.getChildrenOfType(401005);
        RSAPIDataset dataset = null;
        IXQEQueryNode[] iXQEQueryNodeArray = datasets;
        int n = iXQEQueryNodeArray.length;
        for (int i = 0; i < n && (dataset = (RSAPIDataset)(aDataset = iXQEQueryNodeArray[i])).getRefQueryName().compareTo(queryName) != 0; ++i) {
        }
        return dataset;
    }

    public void setHierarchy(ROLAPHierarchy hierarchy) {
        this.mHierarchy = hierarchy;
    }

    @Override
    public MetadataConnection getMetadataConnection() {
        return this.cube.getConnection();
    }

    public void setFilterExpression(String filter) {
        this.mFilterExpression = filter;
    }
}

