/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.data.providers.relational.jdbc.JDBCTabularResult;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metrics.IteratorProfilingManager;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngineLoggingUtils;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.xqejapi.IRSAPIHasColumns;
import com.cognos.xqe.zipi.ZipiBridge;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.concurrent.atomic.AtomicBoolean;

public class ROLAPQueryResultDirectIterator
implements IROLAPQueryResultIterator {
    private final ExecutionEnvironment execEnv;
    private final RSAPIDataset rsapiDataset;
    FormatId[] formatIds = null;
    protected final AtomicBoolean released = new AtomicBoolean(false);
    private JDBCTabularResult jr = null;
    private ITabularIterator jrt = null;
    private TabularHybridResultSet jrh = null;
    private IRSAPIHasColumns nextRow = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROLAPQueryResultDirectIterator(RSAPIDataset dataset, ExecutionEnvironment env) {
        this.rsapiDataset = dataset;
        this.execEnv = env;
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCGettingQueryResult");
        try {
            this.initializeIterator(dataset, env);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private void initializeIterator(RSAPIDataset dataset, ExecutionEnvironment env) {
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started getting direct query result iterator (fetch first rows from DB).");
        XQETrace trace = this.execEnv.getTrace();
        if (trace == null) {
            trace = new XQETrace();
            QueryEngineLoggingUtils.addExecutionTraceLevels(trace, this.execEnv.getRequestEnvironment());
            this.execEnv.setTrace(trace);
        }
        QueryEngineLoggingUtils.dumpRuntreeLog(this.execEnv, this.rsapiDataset);
        IteratorProfilingManager.getInstance().registerProfiler(trace);
        XDataContext context = this.execEnv.pushDataContext();
        try {
            RSAPIEdge edge = dataset.getEdge(0);
            RSAPIEdgeRowset rowset = edge.getRowset(0);
            this.jrh = (TabularHybridResultSet)dataset.getJDBCTabularResultSet(context);
            this.jr = (JDBCTabularResult)this.jrh.getBaseTabularResultSet();
            if (this.jr.isCaching()) {
                throw new RuntimeException("The JDBC result set is caching, no access to the raw objects allowed");
            }
            RSAPIColumn[] columns = ((RSAPIRowset)rowset).getColumns();
            FormatService formatService = FormatService.getInstance();
            this.formatIds = new FormatId[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                String format = columns[i].getFormat();
                this.formatIds[i] = format != null && format.length() > 0 ? formatService.registerV5Format(format, null) : (columns[i].getDatatype().isNumeric() ? FormatId.DEFAULT_NUMBER_FORMAT_FID : FormatId.INVALID_FORMAT_FID);
            }
            this.jrt = this.jr.getDirectTabularIterator();
        }
        catch (RuntimeException ex) {
            this.close();
            throw ex;
        }
        catch (Throwable ex) {
            this.close();
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
        }
        finally {
            ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", "Finished getting direct query result iterator (fetch first rows from DB).");
            this.execEnv.popDataContext(context);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextRow != null) {
            return true;
        }
        this.nextRow = (IRSAPIHasColumns)this.jrt.next();
        return this.nextRow != null;
    }

    @Override
    public IRSAPIHasColumns next() {
        if (this.nextRow == null) {
            return (IRSAPIHasColumns)this.jrt.next();
        }
        IRSAPIHasColumns row = this.nextRow;
        this.nextRow = null;
        return row;
    }

    @Override
    public FormatId[] getColumnFormat() {
        return this.formatIds;
    }

    @Override
    public void close() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        if (this.jrt != null) {
            this.jrt.release();
        }
        if (this.jrh != null) {
            this.jrh.release();
        }
        try {
            IteratorProfilingManager profilingMgr = IteratorProfilingManager.getInstance();
            profilingMgr.logProfiling(this.rsapiDataset, (IExecutionEnvironment)this.execEnv);
            profilingMgr.unregisterProfiler();
        }
        finally {
            this.rsapiDataset.releaseResultset(this.execEnv);
        }
    }

    @Override
    public RSAPIDataset getRSAPIDataset() {
        return this.rsapiDataset;
    }
}

