/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.cache.CacheEngineFactory;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.INameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.SharedDimNameCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;

public class ShareableROLAPDimension
extends ROLAPDimension {
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAP.MemberCache", LogLevel.TRACE);
    ConcurrentHashMap<String, ROLAPCube> sharingCubesSet = new ConcurrentHashMap();
    String shareDimUUID;
    HashMap<String, int[]> virtualCubeSharedSourceMap = new HashMap();
    ROLAPCacheEngine metadataStorage;
    private String cubeLoadingHierarchies = null;
    private CountDownLatch hierarchyLoadCountDownLatch = null;

    public ShareableROLAPDimension(String s, ROLAPCube cube, ROLAPMetaDimension dim, ROLAPMetaHierarchy metaDefaultHierarchy, DimensionTypeEnum dimensionType, String uuid) {
        super(s, cube, dim, metaDefaultHierarchy, dimensionType);
        this.shareDimUUID = uuid;
        this.setCube(null);
        TRACE_LOGGER.log("Shared dimension called " + this.getUniqueName() + " with uuid: " + uuid + " initially created for the member cache of cube: " + cube.getName());
    }

    @Override
    protected INameCache createNameCache() {
        return new SharedDimNameCache(this);
    }

    @Override
    public ICube getCube() {
        String cubeName = ROLAPContext.getCurrentCubeName();
        if (cubeName != null) {
            ROLAPCube foundCube = this.getCube(cubeName);
            if (foundCube != null) {
                return foundCube;
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cube '" + cubeName + "' in the current RolapContext not in the sharing set from shared dimension '" + this.getName() + "'.");
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "No Cubes used in context.");
    }

    public void addVirtualCubeSourceCubeIndexes(String virtualCubeName, int[] sourceDimensionCubeIndexes) {
        this.virtualCubeSharedSourceMap.put(virtualCubeName, sourceDimensionCubeIndexes);
    }

    public int[] getVirtualCubeSourceCubeIndexes(String virtualCubeName) {
        return this.virtualCubeSharedSourceMap.get(virtualCubeName);
    }

    public void addCube(ROLAPCube cube) {
        this.sharingCubesSet.put(cube.getName(), cube);
    }

    public boolean removeCube(ROLAPCube cube) {
        if (cube.isVirtual()) {
            this.virtualCubeSharedSourceMap.remove(cube.getName());
        }
        boolean removed = this.sharingCubesSet.remove(cube.getName()) != null;
        for (IROLAPHierarchy hier : this.getROLAPHierarchies()) {
            for (IROLAPLevel level : hier.getROLAPLevels()) {
                ((ROLAPLevel)level).removeSharedCube(cube.getName());
            }
        }
        if (cube.getName().equals(this.cubeLoadingHierarchies)) {
            while (this.hierarchyLoadCountDownLatch.getCount() != 0L) {
                this.hierarchyLoadCountDownLatch.countDown();
            }
        }
        return removed;
    }

    public synchronized void initCountDownLatch(String cubeName, int numHierarchies) {
        if (this.hierarchyLoadCountDownLatch == null) {
            this.hierarchyLoadCountDownLatch = new CountDownLatch(numHierarchies);
            this.cubeLoadingHierarchies = cubeName;
        }
    }

    public boolean isCubeLoadingHierarchies(String cubeName) {
        if (this.cubeLoadingHierarchies == null) {
            throw new RuntimeException("cube loading hierarchies not initialized.");
        }
        return this.cubeLoadingHierarchies.equals(cubeName);
    }

    public ROLAPCube getCubeLoadingHierarchies() {
        return this.getCube(this.cubeLoadingHierarchies);
    }

    public CountDownLatch getHierarchyLoadCountDownLatch() {
        if (this.hierarchyLoadCountDownLatch == null) {
            throw new RuntimeException("countdown latch not initialized.");
        }
        return this.hierarchyLoadCountDownLatch;
    }

    public ROLAPCube getCube(String cubeName) {
        if (this.sharingCubesSet == null) {
            return (ROLAPCube)super.getCube();
        }
        return this.sharingCubesSet.get(cubeName);
    }

    @Override
    public int getIndex(String cubeName) {
        return this.getCube(cubeName).getDimensionIndex(this);
    }

    @Override
    public int getIndex() {
        return ((ROLAPCube)this.getCube()).getDimensionIndex(this);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        return this.v5UniqueNameCache.getV5UniqueName(cubeName, ROLAPUtilities.getExpressionLocale(this));
    }

    @Override
    public String createV5UniqueName(String cubeName, String locale) {
        ICube theCube = cubeName == null ? this.getCube() : this.getCube(cubeName);
        return UniqueNameGenerator.createROLAPV5UniqueName(theCube, locale, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ROLAPCacheEngine getOrCreateMetadataStorage() {
        if (this.metadataStorage != null) {
            return this.metadataStorage;
        }
        ShareableROLAPDimension shareableROLAPDimension = this;
        synchronized (shareableROLAPDimension) {
            if (this.metadataStorage == null) {
                this.metadataStorage = new ROLAPCacheEngine(CacheEngineFactory.createStaticCache());
            }
            return this.metadataStorage;
        }
    }

    @Override
    public ROLAPCacheEngine getMetadataStorage() {
        return this.getOrCreateMetadataStorage();
    }

    public String getUUID() {
        return this.shareDimUUID;
    }

    public boolean isSharing() {
        return !this.sharingCubesSet.isEmpty();
    }

    @Override
    public boolean isShareable() {
        return true;
    }

    public void close() {
        if (this.metadataStorage != null) {
            try {
                this.metadataStorage.close();
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
            this.metadataStorage = null;
        }
    }

    public ROLAPMetaLevel getMetaLevel(String cubeName, String hierarchyName, String levelName) {
        ROLAPMetaHierarchy metaHierarchy;
        ROLAPMetaDimension metaDimension;
        ROLAPCube cube = this.getCube(cubeName);
        ROLAPMetaCube modelCube = this.getMetaCube(cube);
        if (modelCube != null && (metaDimension = this.findMetaDimension(modelCube.getDimensions())) != null && (metaHierarchy = this.findMetaHierarchy(modelCube, metaDimension, hierarchyName)) != null) {
            ROLAPMetaLevel metaLevel = this.findMetaLevel(metaHierarchy, levelName);
            if (metaLevel != null) {
                return metaLevel;
            }
            if (this.isRootLevel(hierarchyName, levelName)) {
                return null;
            }
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot find meta level for level: " + levelName);
    }

    protected ROLAPMetaCube getMetaCube(ROLAPCube cube) {
        ROLAPMetaCube modelCube;
        block1: {
            ROLAPCube sharingCube;
            modelCube = cube.getModelCube();
            if (modelCube != null || !(cube instanceof ROLAPVirtualCube)) break block1;
            Collection<ROLAPCube> sharingCubes = this.sharingCubesSet.values();
            Iterator<ROLAPCube> iterator = sharingCubes.iterator();
            while (iterator.hasNext() && (modelCube = (sharingCube = iterator.next()).getModelCube()) == null) {
            }
        }
        return modelCube;
    }

    private boolean isRootLevel(String hierarchyName, String levelName) {
        ILevel level;
        IHierarchy hierarchy = this.getHierarchy(hierarchyName);
        if (hierarchy != null && (level = hierarchy.getLevel(levelName)) != null) {
            return level.isRootLevel();
        }
        return false;
    }

    public ROLAPMetaHierarchy getMetaHierarchy(String cubeName, String hierarchyName) {
        ROLAPMetaHierarchy metaHierarchy;
        ROLAPMetaDimension metaDimension;
        ROLAPCube cube = this.getCube(cubeName);
        ROLAPMetaCube modelCube = this.getMetaCube(cube);
        if (modelCube != null && (metaDimension = this.findMetaDimension(modelCube.getDimensions())) != null && (metaHierarchy = this.findMetaHierarchy(modelCube, metaDimension, hierarchyName)) != null) {
            return metaHierarchy;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot find meta hierarchy for hierarchy: " + hierarchyName);
    }

    @Override
    public ROLAPMetaDimension getMetaDimension() {
        ROLAPCube cube;
        ROLAPMetaCube modelCube;
        String cubeName = this.getCube().getName();
        if (cubeName != null && (modelCube = this.getMetaCube(cube = this.getCube(cubeName))) != null) {
            return this.findMetaDimension(modelCube.getDimensions());
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot get meta dimension for shared dimension " + this.getName());
    }

    @Override
    public ROLAPMetaHierarchy getMetaDefaultHierarchy() {
        String cubeName = this.getCube().getName();
        if (cubeName != null) {
            return this.getMetaHierarchy(cubeName, this.defaultHierarchy.getName());
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot get meta default hierarchy for shared dimension " + this.getName());
    }

    private ROLAPMetaLevel findMetaLevel(ROLAPMetaHierarchy metaHierarchy, String levelName) {
        ROLAPMetaLevel[] levels = metaHierarchy.getLevels();
        if (metaHierarchy.isRecursive()) {
            if (levelName.indexOf("Level ") == 0) {
                int levelIndex = Integer.valueOf(levelName.substring("Level ".length()).trim());
                if (levelIndex == 1) {
                    return levels[0];
                }
                return levels[1];
            }
        } else {
            for (ROLAPMetaLevel metaLevel : levels) {
                if (!metaLevel.getName().equals(levelName)) continue;
                return metaLevel;
            }
        }
        return null;
    }

    private ROLAPMetaHierarchy findMetaHierarchy(ROLAPMetaCube modelCube, ROLAPMetaDimension metaDimension, String hierarchyName) {
        ROLAPMetaHierarchy[] hierarchies;
        for (ROLAPMetaHierarchy metaHierarchy : hierarchies = modelCube.getHierarchies(metaDimension)) {
            if (!metaHierarchy.getName().equals(hierarchyName)) continue;
            return metaHierarchy;
        }
        return null;
    }

    private ROLAPMetaDimension findMetaDimension(ROLAPMetaDimension[] dimensions) {
        for (ROLAPMetaDimension metaDimension : dimensions) {
            if (!metaDimension.getName().equals(this.getName())) continue;
            return metaDimension;
        }
        return null;
    }
}

