/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.content.CMException;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPRelativeTimeMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPAccessAccountManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeNameWrapper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadInfoLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AutonomicAggregateTaskManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.model.ROLAPMetaInMemoryAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPBaseDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPBaseMemberCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPMemberCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AbstractAggregateLoadManagerCubeTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadManagerTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateLevelKeyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateLevelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateSlice;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.DataCacheCubeletMonitor;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.dom4j.Element;

public class ROLAPBaseCube
extends ROLAPCube {
    private static final String INMEMORYAGGREGATES_PROPERTY = "aggregates";
    public static final String VALUE_ELEMENT_NAME = "value";
    public static final String EXPRESSION_ONE = "1";
    public static final String SINGLE_QUOTE = "'";
    private AggregateLoadInfoLogger aggregateLoadInfoLogger;
    private volatile boolean locked = false;
    private final XQERuntimeException ex = null;
    private ROLAPMetaCube modelCube = null;
    private ROLAPMetaInMemoryAggregate inMemoryAggregateModel = null;
    private ROLAPMetaInMemoryAggregate overrideInMemoryAggregateModel = null;
    private final AtomicInteger estimatedInMemoryAggregateCount = new AtomicInteger(-1);
    private final AtomicLong timestampEstimatedInMemoryAggregateCountRetrieved = new AtomicLong(0L);
    private static final long CONTENT_STORE_RETRIEVAL_INTERVAL = 5000L;

    @Override
    public void lock() {
        if (!this.locked) {
            this.locked = true;
        }
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    public ROLAPBaseCube(String n, ROLAPCube.ROLAPCubeInfo cubeInfo) {
        super(n, cubeInfo);
        this.mAccountManager = new ROLAPAccessAccountManager(n, this.constructDatasourceBasePath());
        if (null != this.schema) {
            this.modelCube = this.getMetaCube(this.schema.getName());
            if (this.modelCube != null) {
                this.namespace.setLocalizedName(this.modelCube.getNames());
            }
        }
        this.aggregateLoadInfoLogger = new AggregateLoadInfoLogger(this);
        this.buildJMXCacheDiagnosticInfo();
    }

    private ROLAPMetaCube getMetaCube(String cubeName) {
        if (this.schema != null) {
            ROLAPMetaCube[] cubes = this.schema.getCubes();
            for (int i = 0; i < cubes.length; ++i) {
                ROLAPMetaCube cube = cubes[i];
                if (!cube.getName().equalsIgnoreCase(cubeName)) continue;
                return cube;
            }
        }
        return null;
    }

    @Override
    public void init(ROLAPProvider provider) {
        this.setProvider(provider);
        if (this.getModelCube() == null) {
            this.modelCube = this.getMetaCube(this.getName());
        }
        this.setDescription(this.modelCube.getComments());
        this.createMemberResolver(provider);
    }

    public XQERuntimeException getInitDimError() {
        return this.ex;
    }

    @Override
    public ROLAPMetaCube getModelCube() {
        return this.modelCube;
    }

    @Override
    public ROLAPQueryStrategy getQueryStrategy() {
        return new ROLAPQueryStrategy();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    protected void startCubeImpl(boolean forceStart) {
        try {
            super.startCubeImpl(forceStart);
            QueryEnvironmentHelper envHelper = this.setUpExecutionEnvironment(true, true);
            try {
                this.mAccountManager.setUpBiBusEnvelope(true);
                ROLAPCubeManager.getInstance().initCube(this);
                this.setInMemoryAggregateModel(this.loadInMemoryAggregateSchema());
                this.estimatedInMemoryAggregateCount.set(-1);
                this.mMemberCacheManager = new ROLAPCacheManager<ROLAPMemberCache>(new ROLAPCube.MemberCacheFactory(this));
                ROLAPMemberCache.deleteCacheFolder(this.getName());
                this.buildMemberCache();
                this.workloadLogger = this.createWorkloadLogger();
                this.workloadLogger.startLogging();
                this.aggregateLoadInfoLogger.startLogging();
                AutonomicAggregateTaskManager.getInstance().handleCubeStart(this);
            }
            finally {
                envHelper.tearDownEnvironment();
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateCalculatedMembers() {
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.setCMRequestExecutor(this.getAccountManager());
        envHelper.setInternalUse(true);
        envHelper.setUpEnvironment(true);
        try {
            ROLAPCubeReservation reservation = this.reserve();
            boolean needToRemoveCurrentCubeName = ROLAPContext.setCurrentCubeName(this.getName());
            try {
                List<IDimension> dimensions = this.getDimensions();
                for (IDimension dim : dimensions) {
                    if (dim.isMeasuresDimension()) {
                        ROLAPLevel level = (ROLAPLevel)dim.getLevel(0);
                        level.validateCalculatedMeasures(this);
                        this.addMessageInvalidCalculatedMembersWereRemoved(level.getHierarchy());
                        continue;
                    }
                    List<IHierarchy> hierarchies = dim.getHierarchies();
                    for (IHierarchy hier : hierarchies) {
                        ROLAPHierarchy rolapHier = (ROLAPHierarchy)hier;
                        rolapHier.validateCalculatedMembers(this);
                        this.addMessageInvalidCalculatedMembersWereRemoved(rolapHier);
                    }
                }
                this.validateCalculatedDefaultMember();
            }
            finally {
                this.unreserve(reservation);
                ROLAPContext.removeCurrentCubeName(needToRemoveCurrentCubeName);
            }
        }
        finally {
            envHelper.tearDownEnvironment();
        }
    }

    @Override
    protected void stopCubeImpl() {
        try {
            AutonomicAggregateTaskManager.getInstance().handleCubeStop(this);
            this.aggregateLoadInfoLogger.stopLogging();
            this.workloadLogger.stopLogging();
            this.modelCube = null;
            this.setProvider(null);
            this.setDescription(null);
            this.clearMemberResolver();
            if (this.mMemberCacheManager != null) {
                this.mMemberCacheManager.release();
                this.mMemberCacheManager = null;
            }
            this.mAccountManager.logoffAccessAccount();
            super.stopCubeImpl();
            this.estimatedInMemoryAggregateCount.set(-1);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    @Override
    protected void pauseImpl() {
        AutonomicAggregateTaskManager.getInstance().handleCubePause(this);
    }

    @Override
    protected void unpauseImpl() {
        AutonomicAggregateTaskManager.getInstance().handleCubeUnpause(this);
    }

    @Override
    public int getMemberIndex(IMember member) {
        if (member.isMeasure()) {
            return ((ROLAPMeasure)member).getIndex();
        }
        return ((ROLAPMemberProxy)member).getIndex();
    }

    @Override
    public boolean isCubingServicesCompatible() {
        if (this.getModelCube() != null) {
            return this.getModelCube().isCubingServicesCompatible();
        }
        return false;
    }

    @Override
    public boolean isRemoveNonExistentTuplesEnabled() {
        boolean roProperty = super.isRemoveNonExistentTuplesEnabled();
        if (!roProperty) {
            return false;
        }
        boolean modelProperty = this.getModelCube().isRemoveNonExistentTuplesEnabled();
        return modelProperty;
    }

    @Override
    public ROLAPMemberCache createMemberCache() {
        return new ROLAPBaseMemberCache(this);
    }

    @Override
    public ROLAPDataCache createDataCache(ROLAPCacheBase memberCache) {
        return new ROLAPBaseDataCache(this, memberCache);
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        ILocalizedString captions = null;
        if (this.getModelCube() != null && (captions = this.getModelCube().getCaptions()) == null) {
            captions = this.getModelCube().getNames();
        }
        if (captions == null) {
            captions = AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), this.getCaption());
        }
        return captions;
    }

    public ILocalizedString getLocalizedName() {
        ILocalizedString names = null;
        if (this.getModelCube() != null) {
            names = this.getModelCube().getNames();
        }
        if (names == null) {
            names = AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), this.getName());
        }
        return names;
    }

    public ILocalizedString getLocalizedDescription() {
        ILocalizedString descriptions = null;
        if (this.getModelCube() != null) {
            descriptions = this.getModelCube().getDescriptions();
        }
        if (descriptions == null) {
            descriptions = AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), this.getDescription());
        }
        return descriptions;
    }

    @Override
    public String getCaption() {
        String runLocaleCaption = null;
        if (this.getModelCube() != null) {
            Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
            String locale = LocaleConverter.localeToStr(runLocale);
            runLocaleCaption = this.getModelCube().getCaption(locale);
        }
        if (runLocaleCaption == null) {
            runLocaleCaption = this.getName();
        }
        return runLocaleCaption;
    }

    public final ROLAPMetaInMemoryAggregate getInMemoryAggregateModel() {
        return this.inMemoryAggregateModel;
    }

    public void setInMemoryAggregateModel(ROLAPMetaInMemoryAggregate theInMemoryAggregateModel) {
        this.inMemoryAggregateModel = theInMemoryAggregateModel;
    }

    public ROLAPMetaInMemoryAggregate loadInMemoryAggregateSchema() throws Exception {
        ROLAPMetaInMemoryAggregate aggregateSchema = null;
        if (this.overrideInMemoryAggregateModel == null) {
            String inMemoryAggregateXML = this.getInMemoryAggregateXML();
            if (inMemoryAggregateXML != null && inMemoryAggregateXML.length() > 0) {
                aggregateSchema = new ROLAPMetaInMemoryAggregate(inMemoryAggregateXML);
                ROLAPLog.log("ROLAPCubes.AggregateCache", "Cube  " + UniqueNameGenerator.createUniqueName(this.getName()) + " loaded in memory aggregate definitions.");
            }
        } else {
            aggregateSchema = this.overrideInMemoryAggregateModel;
        }
        return aggregateSchema;
    }

    public final void setOverrideInMemoryAggregateModel(ROLAPMetaInMemoryAggregate aInMemoryAggregateModel) {
        this.overrideInMemoryAggregateModel = aInMemoryAggregateModel;
    }

    public List<AggregateDefinition> getInMemoryAggregateDefintionInContext() {
        List<AggregateDefinition> aggregateDefinitions = null;
        AggregateCubeletStorage aggregateStorage = this.getDataCacheInContext().getAggregateStorage();
        if (aggregateStorage != null) {
            aggregateDefinitions = aggregateStorage.getAvailableAggregateDefinitions(true);
        }
        return aggregateDefinitions;
    }

    private boolean validateAggregateCubeHierarchy(ROLAPMetaAggregateCube aggrCube, ROLAPMetaAggregateDimensionRef aggrDimension, ROLAPMetaAggregateHierarchyRef aggrHierarchy, IHierarchy hierarchy) {
        boolean valid = true;
        List<ILevel> levels = null;
        if (hierarchy == null) {
            String message = XQEMessages.getMessage(XQEMessageKeys.ROL_UnableToValidateAggregateCubeHierarchyReferences, XQEMessages.getCurrProductLocale(), aggrCube.getName(), aggrDimension.getName(), aggrHierarchy.getName(), this.getName());
            ROLAPLog.logError("ROLAPCubes.Info", message);
            valid = false;
        }
        if (!valid) {
            return valid;
        }
        if (!hierarchy.isParentChild()) {
            levels = new ArrayList<ILevel>();
            for (ROLAPMetaAggregateLevelRef aggrLevel : aggrHierarchy.getAggregateLevelRefs()) {
                ILevel level = hierarchy.getLevel(aggrLevel.getName());
                if (level == null) {
                    String message = XQEMessages.getMessage(XQEMessageKeys.ROL_UnableToValidateAggregateCubeLevelReferences, XQEMessages.getCurrProductLocale(), aggrCube.getName(), aggrDimension.getName(), aggrHierarchy.getName(), this.getName(), aggrLevel.getName());
                    ROLAPLog.logError("ROLAPCubes.Info", message);
                    valid = false;
                    continue;
                }
                ROLAPMetaLevel metaLevel = ((ROLAPLevel)level).getMetaLevel();
                List<ROLAPMetaAttribute> cubeLevelKeys = metaLevel.getLevelKeys();
                ROLAPMetaAggregateLevelKeyRef[] levelKeyRefs = aggrLevel.getAggregateLevelKeyRefs();
                if (cubeLevelKeys.size() != levelKeyRefs.length) {
                    String message = XQEMessages.getMessage(XQEMessageKeys.ROL_UnableToValidateAggregateCubeLevelReferences, XQEMessages.getCurrProductLocale(), aggrCube.getName(), aggrDimension.getName(), aggrHierarchy.getName(), this.getName(), aggrLevel.getName());
                    ROLAPLog.logError("ROLAPCubes.Info", message);
                    valid = false;
                    continue;
                }
                levels.add(level);
            }
        } else {
            levels = hierarchy.getLevels();
        }
        if (valid) {
            valid = this.validateAggregateCubeSlicerMembers(aggrCube, aggrDimension, aggrHierarchy, levels);
        }
        return valid;
    }

    private boolean validateAggregateCubeSlicerMembers(ROLAPMetaAggregateCube aggrCube, ROLAPMetaAggregateDimensionRef aggrDimension, ROLAPMetaAggregateHierarchyRef aggrHierarchy, List<ILevel> levels) {
        boolean valid = true;
        ROLAPMetaAggregateSlice slice = aggrHierarchy.getAggregateSlice();
        if (slice == null) {
            return valid;
        }
        ArrayList<ROLAPMetaAggregateMember> slicerMembers = slice.getAggregateMembers();
        ILevel theSlicerLevel = null;
        for (ROLAPMetaAggregateMember slicerMember : slicerMembers) {
            String message;
            ROLAPHierarchy hier;
            IMember member = null;
            ILevel memberLevel = null;
            for (ILevel level : levels) {
                member = level.getMember(slicerMember.getName());
                if (member == null || !member.getUniqueName().equals(slicerMember.getName())) continue;
                memberLevel = level;
                break;
            }
            if (member == null && !levels.isEmpty() && (hier = (ROLAPHierarchy)levels.get(0).getHierarchy()).getDimension().isTimeDimension()) {
                ListIterator<ROLAPCalculatedMember> iterator = hier.getROLAPCalculatedMembers(this.getName()).listIterator();
                while (iterator.hasNext()) {
                    ROLAPCalculatedMember calcMember = iterator.next();
                    if (!(calcMember instanceof ROLAPRelativeTimeMember) || calcMember.isExtendedCalculatedMemberWithFormula() || !calcMember.getUniqueName().equals(slicerMember.getName())) continue;
                    member = ((ROLAPRelativeTimeMember)calcMember).getReferenceMember();
                    memberLevel = member.getLevel();
                    break;
                }
            }
            if (memberLevel == null) {
                message = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidAggregateSliceMember_WrongLevel, XQEMessages.getCurrProductLocale(), aggrCube.getName(), aggrDimension.getName(), aggrHierarchy.getName(), this.getName(), slicerMember.getName());
                ROLAPLog.logError("ROLAPCubes.Info", message);
                valid = false;
                continue;
            }
            if (theSlicerLevel == null) {
                theSlicerLevel = memberLevel;
                continue;
            }
            if (theSlicerLevel == memberLevel) continue;
            message = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidAggregateSliceMember_DifferentLevels, XQEMessages.getCurrProductLocale(), aggrCube.getName(), aggrDimension.getName(), aggrHierarchy.getName(), this.getName(), slicerMember.getName());
            ROLAPLog.logError("ROLAPCubes.Info", message);
            valid = false;
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateAggregateCubes() {
        if (this.getModelCube() != null) {
            QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
            envHelper.setCMRequestExecutor(this.getAccountManager());
            envHelper.setInternalUse(true);
            envHelper.setUpEnvironment(true);
            try {
                ROLAPCubeReservation reservation = this.reserve();
                boolean needToRemoveCurrentCubeName = ROLAPContext.setCurrentCubeName(this.getName());
                try {
                    ROLAPMetaAggregateCube[] aggrCubes = this.getModelCube().getAggregateCubes();
                    ArrayList<ROLAPMetaAggregateCube> invalidCubes = new ArrayList<ROLAPMetaAggregateCube>();
                    for (ROLAPMetaAggregateCube aggrCube : aggrCubes) {
                        boolean valid = true;
                        for (ROLAPMetaAggregateDimensionRef aggrDim : aggrCube.getAggregateDimensionRefs()) {
                            IDimension dimension = this.getDimension(aggrDim.getName());
                            if (dimension == null) continue;
                            for (ROLAPMetaAggregateHierarchyRef aggrHierarchy : aggrDim.getAggregateHierarchyRefs()) {
                                IHierarchy hierarchy = dimension.getHierarchy(aggrHierarchy.getName());
                                valid &= this.validateAggregateCubeHierarchy(aggrCube, aggrDim, aggrHierarchy, hierarchy);
                            }
                        }
                        if (!valid) {
                            invalidCubes.add(aggrCube);
                            continue;
                        }
                        aggrCube.getLowestLevelsCardinality(this);
                    }
                    if (!invalidCubes.isEmpty()) {
                        StringBuilder invalidCubesMessage = new StringBuilder();
                        boolean first = true;
                        for (ROLAPMetaAggregateCube aggrCube : invalidCubes) {
                            if (first) {
                                first = false;
                            } else {
                                invalidCubesMessage.append(",");
                            }
                            invalidCubesMessage.append(" '").append(aggrCube.getName()).append(SINGLE_QUOTE);
                        }
                        this.getMessages().addMessage(XQEMessageKeys.RLU_InvalidAggregateCubesWereRemoved, invalidCubesMessage.toString(), this.getName());
                        ROLAPLog.logError("ROLAPCubes.Info", XQEMessages.getMessage(XQEMessageKeys.RLU_InvalidAggregateCubesWereRemoved, XQEMessages.getCurrProductLocale(), invalidCubesMessage.toString(), this.getName()));
                        this.getModelCube().removeAggregateCubes(invalidCubes);
                    }
                }
                catch (OperationCanceledException cancelException) {
                    throw cancelException;
                }
                catch (Exception e) {
                    String message = XQEMessages.getMessage(XQEMessageKeys.ROL_UnableToValidateAggregateCubes, XQEMessages.getCurrProductLocale(), this.getName(), e.getLocalizedMessage());
                    ROLAPLog.log("ROLAPCubes.Info", message);
                }
                finally {
                    this.unreserve(reservation);
                    ROLAPContext.removeCurrentCubeName(needToRemoveCurrentCubeName);
                }
            }
            finally {
                envHelper.tearDownEnvironment();
            }
        }
    }

    @Override
    public void loadInMemoryAggregatesAsynchronously() {
        if (this.getInMemoryAggregateModel() == null) {
            AggregateCubeletStorage aggregateCubletStorage;
            IBlockTupleStorage dataCacheStg;
            ROLAPLog.log("ROLAPCubes.AggregateCache", "No in-memory aggregates were defined.");
            ROLAPBaseDataCache baseDataCache = (ROLAPBaseDataCache)this.getCurrentDataCache();
            if (baseDataCache != null && (dataCacheStg = baseDataCache.getBlockTupleStorage()) != null && (aggregateCubletStorage = baseDataCache.createAggregateStorage(this)) != null) {
                baseDataCache.setAggregateStorage(aggregateCubletStorage);
                DataCacheCubeletMonitor cubeletMonitor = new DataCacheCubeletMonitor(aggregateCubletStorage, (CubeletStorage)dataCacheStg);
                ((CubeletStorage)dataCacheStg).setCubeletMonitor(cubeletMonitor);
            }
            this.firePostInMemoryAggrTrigger();
            return;
        }
        AggregateLoadManagerTask loadManagerTask = new AggregateLoadManagerTask(this);
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            executorService.submit(loadManagerTask);
            ROLAPLog.log("ROLAPCubes.Management", String.format("The task that manages the loading of the in-memory aggregates of the cube %s was submitted for execution.", this.getName()));
        }
        catch (Exception e) {
            ROLAPLog.logError("ROLAPCubes.Management", String.format("The task that manages the loading of the in-memory aggregates of the cube %s could not be scheduled for execution.", this.getName()), e);
            ROLAPCubeManager.handleExceptionInJMX(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInMemoryAggregates(final AbstractAggregateLoadManagerCubeTask loadManagerCubeTask) {
        block21: {
            TraceContext traceContext = TraceContext.enter();
            traceContext.addAttribute("rolapCube", this.getName());
            RuntimeException caughtException = null;
            try {
                boolean registered = false;
                try {
                    registered = this.registerCurrentThread(false);
                    this.getMessages().addMessage(XQEMessageKeys.RLU_InMemoryAggregatesLoadExecuting);
                    Runnable work = new Runnable(){

                        @Override
                        public void run() {
                            ROLAPBaseCube.this.loadInMemoryAggregatesImpl(loadManagerCubeTask);
                        }
                    };
                    HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
                    set.add(ROLAPCubeStateEnum.RUNNING);
                    set.add(ROLAPCubeStateEnum.PAUSED);
                    if (!this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this))) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, new ROLAPCubeNameWrapper(this.getName()));
                    }
                    long numLoaded = 0L;
                    long numDefined = 0L;
                    ROLAPDataCache currentDataCache = this.getCurrentDataCache();
                    if (currentDataCache != null) {
                        numLoaded = currentDataCache.getLoadedInMemoryAggregateCount();
                        numDefined = currentDataCache.getDefinedInMemoryAggregateCount();
                    }
                    if (numDefined > 0L) {
                        this.getMessages().addMessage(XQEMessageKeys.RLU_InMemoryAggregatesLoadSucceededAndLoaded, String.valueOf(numLoaded), String.valueOf(numDefined));
                    } else {
                        ROLAPLog.log("ROLAPCubes.AggregateCache", "No in-memory aggregates in the aggregate cache because loading was skipped.");
                    }
                }
                catch (Exception e) {
                    ROLAPLog.logError("ROLAPCubes.AggregateCache", "Loading the in-memory aggregates failed.", e);
                    this.getMessages().addMessage(XQEMessageKeys.RLU_InMemoryAggregatesLoadFailed);
                    throw XQERuntimeException.wrap(e);
                }
                finally {
                    this.deregisterCurrentThread(false, registered);
                    traceContext.exit();
                }
            }
            catch (Exception e) {
                caughtException = XQERuntimeException.wrap(e);
            }
            finally {
                try {
                    this.firePostInMemoryAggrTrigger();
                }
                finally {
                    if (caughtException == null) break block21;
                    throw caughtException;
                }
            }
        }
    }

    public void loadInMemoryAggregatesAutonomically(final AbstractAggregateLoadManagerCubeTask loadManagerCubeTask) {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            Runnable work = new Runnable(){

                @Override
                public void run() {
                    ROLAPBaseCube.this.loadInMemoryAggregatesImpl(loadManagerCubeTask);
                }
            };
            HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
            set.add(ROLAPCubeStateEnum.RUNNING);
            set.add(ROLAPCubeStateEnum.PAUSED);
            if (!this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this))) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, new ROLAPCubeNameWrapper(this.getName()));
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    private void loadInMemoryAggregatesImpl(AbstractAggregateLoadManagerCubeTask loadManagerCubeTask) {
        loadManagerCubeTask.loadAggregates();
    }

    public void waitForInMemoryAggregatesToLoad(long timeToWait) {
        if (this.getInMemoryAggregateModel() == null) {
            return;
        }
        ROLAPBaseDataCache dataCache = (ROLAPBaseDataCache)this.getCurrentDataCache();
        if (dataCache == null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregatesAreNotLoaded, new ROLAPCubeNameWrapper(this.getName()));
        }
        long timeLeft = timeToWait;
        while (!dataCache.isFinishedLoadingAggregates()) {
            if (timeLeft <= 0L) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_InMemoryAggregatesAreNotLoaded, new ROLAPCubeNameWrapper(this.getName()));
            }
            timeLeft = ROLAPCubeManager.adminWait(timeLeft, dataCache);
        }
    }

    public String getInMemoryAggregateXML() {
        String inMemoryAggregates = null;
        try {
            Element aggregateDefValue;
            Element item;
            Element aggregateDefElement;
            CMClass cls;
            List<CMClass> resultList = ContentManager.getProperties(this.constructDatasourceBasePath(), INMEMORYAGGREGATES_PROPERTY);
            Iterator<CMClass> it = resultList.iterator();
            if (it.hasNext() && (cls = it.next()).getCMClassName().equals("cm:rolapDataSource") && (aggregateDefElement = (item = cls.getItemElement()).element(INMEMORYAGGREGATES_PROPERTY)).hasContent() && (aggregateDefValue = aggregateDefElement.element(VALUE_ELEMENT_NAME)) != null) {
                inMemoryAggregates = aggregateDefValue.getText();
            }
        }
        catch (CMException ce) {
            ROLAPLog.logError("ROLAPCubes.AggregateCache", "Failed to read in memory aggregate information from CM.", ce.getCause());
            throw new XQERuntimeException(ce);
        }
        return inMemoryAggregates;
    }

    public void saveInMemoryAggregateXML(final String inMemoryAggregateXML) {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getName());
        boolean registered = false;
        try {
            registered = this.registerCurrentThread(false);
            ROLAPLog.log("ROLAPCubes.Management", "Save in-memory aggregate XML began.");
            Runnable work = new Runnable(){

                @Override
                public void run() {
                    ROLAPBaseCube.this.saveInMemoryAggregateXMLImpl(inMemoryAggregateXML);
                }
            };
            HashSet<ROLAPCubeStateEnum> set = new HashSet<ROLAPCubeStateEnum>();
            set.add(ROLAPCubeStateEnum.RUNNING);
            set.add(ROLAPCubeStateEnum.PAUSED);
            if (!this.mStateMachine.testAndExecuteAtomically(set, work, new ROLAPCubeStateContext(this))) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, new ROLAPCubeNameWrapper(this.getName()));
            }
            ROLAPLog.log("ROLAPCubes.Management", "Save in-memory aggregate XML succeeded.");
        }
        catch (Throwable t) {
            ROLAPLog.logError("ROLAPCubes.Management", "Save in-memory aggregate XML failed.", t);
            throw XQERuntimeException.wrap(t);
        }
        finally {
            this.deregisterCurrentThread(false, registered);
            traceContext.exit();
        }
    }

    private void saveInMemoryAggregateXMLImpl(String inMemoryAggregateXML) {
        try {
            String dataSourceSearchPath = this.constructDatasourceBasePath();
            ROLAPLog.log("ROLAPCubes.Management", String.format("Sending a request to CM to update the aggregates property of the rolapDataSource object with search path %s", dataSourceSearchPath));
            ContentManager.updateInMemoryAggregateXML(dataSourceSearchPath, inMemoryAggregateXML);
        }
        catch (Throwable t) {
            throw XQERuntimeException.wrap(t);
        }
    }

    public final int getEstimatedInMemoryAggregateCount() {
        int aggCount = this.estimatedInMemoryAggregateCount.get();
        long msLastRetrieval = this.timestampEstimatedInMemoryAggregateCountRetrieved.get();
        long msCurrentTime = System.currentTimeMillis();
        if (aggCount < 0 || 5000L < msCurrentTime - msLastRetrieval) {
            aggCount = 0;
            try {
                ROLAPMetaInMemoryAggregate aggModel = this.loadInMemoryAggregateSchema();
                if (aggModel != null) {
                    aggCount = aggModel.getAggregateCount();
                }
            }
            catch (Exception e) {
                ROLAPLog.logError("ROLAPCubes.AggregateCache", "Could not pull the in memory aggregate defs to get an early aggregate count", e);
            }
            this.estimatedInMemoryAggregateCount.set(aggCount);
            this.timestampEstimatedInMemoryAggregateCountRetrieved.set(msCurrentTime);
        }
        return aggCount;
    }

    public boolean isNearRealTime() {
        boolean nearRealTime = false;
        ROLAPMetaCube metaCube = this.getModelCube();
        if (metaCube != null) {
            String factTIDQueryItem = metaCube.getFactTransactionIDQueryItem();
            nearRealTime = factTIDQueryItem != null && factTIDQueryItem.length() > 0;
        }
        return nearRealTime;
    }

    public boolean isPCH() {
        for (IHierarchy h : this.getHierarchies()) {
            if (!h.isParentChild()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName(String locale) {
        String localizedName = null;
        if (this.getModelCube() != null) {
            localizedName = this.getModelCube().getName(locale);
        }
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    public AggregateLoadInfoLogger getAggregateLoadInfoLogger() {
        return this.aggregateLoadInfoLogger;
    }

    @Override
    public boolean isValidateCube() {
        boolean bIsValidateCube = false;
        ROLAPMetaCube metaCube = this.getModelCube();
        if (metaCube != null) {
            bIsValidateCube = metaCube.isValidateCube();
        }
        return bIsValidateCube;
    }

    @Override
    public String getCubeCurrentPeriod() {
        return null;
    }
}

