/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMessages;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateEnum;
import com.cognos.xqe.util.ConfigurationValues;

public class ROLAPCubeConfiguration {
    public static final int DEFAULT_MEMBER_CACHE_LIMIT = 100000;
    public static final int DEFAULT_PREDICATE_THRESHOLD = 90;
    private static final int MAX_PREDICATE_THRESHOLD = 100;
    public static final int DEFAULT_MAX_DATA_CACHE_SIZE = 1024;
    public static final int DEFAULT_MAX_AGGREGATE_CACHE_SIZE = Integer.MAX_VALUE;
    public static final String DEFAULT_STARTUP_TRIGGER_NAME = "";
    public static final int DEFAULT_RESULT_SET_CACHE_DISK_QUOTA = 1024;
    public static final int DEFAULT_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT = -1;
    private static final int MIN_RESULT_SET_CACHE_SIZE_LIMIT = 100;
    private final String cubeName;
    private boolean virtual = false;
    private boolean disabled = false;
    private boolean enableDynamicMemberCaching = false;
    private int memberCacheLimit = 100000;
    private String startupTriggerName = "";
    private boolean disableResultSetCache = false;
    private int resultSetCacheSizeLimit = 1024;
    private int predicateThreshold = 90;
    private boolean disableExternalAggregates = false;
    private boolean aggregateLoggingEnabled = false;
    private int multiDimensionalQuerySizeLimit = -1;
    private int maxDataCacheSize = 1024;
    private int maxAggregateCacheSize = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_HIERARCHY_LOAD_THREADS = ConfigurationValues.getInt("MaxCubeLoadThreadsOverride", 2 * Runtime.getRuntime().availableProcessors(), 1, Integer.MAX_VALUE);
    public static final int DEFAULT_MAX_AGGREGATE_LOAD_THREADS = ConfigurationValues.getInt("MaxCubeLoadThreadsOverride", 2 * Runtime.getRuntime().availableProcessors(), 1, Integer.MAX_VALUE);
    public static final int DEFAULT_MEASURES_THRESHOLD = 30;
    public static final int MIN_MEASURE_THRESHOLD = 0;
    public static final int MAX_MEASURE_THRESHOLD = 100;
    public static final AutoAggrOptimization DEFAULT_AUTOMATIC_AGGREGATE_OPTIMIZATION = AutoAggrOptimization.Off;
    public static final String DEFAULT_POST_IN_MEMORY_TRIGGER_NAME = "";
    private int maxHierarchyLoadThreads = DEFAULT_MAX_HIERARCHY_LOAD_THREADS;
    private int maxAggregateLoadThreads = DEFAULT_MAX_AGGREGATE_LOAD_THREADS;
    private int measuresThreshold = 30;
    private AutoAggrOptimization autoAggrOptimization = DEFAULT_AUTOMATIC_AGGREGATE_OPTIMIZATION;
    private String postInMemoryTriggerName = "";
    private ROLAPConfiguration mServerConfiguration = null;
    private static final String COMMA = ",";

    public ROLAPCubeConfiguration(String name, boolean isVirtual) {
        this.cubeName = name;
        this.virtual = isVirtual;
    }

    public String getName() {
        return this.cubeName;
    }

    public void setVirtual(boolean isVirtual) {
        this.virtual = isVirtual;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setDisabled(boolean disable) {
        this.disabled = disable;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isEnableDynamicMemberCaching() {
        return this.enableDynamicMemberCaching;
    }

    public void setEnableDynamicMemberCaching(boolean enableCaching) {
        this.enableDynamicMemberCaching = enableCaching;
    }

    public int getMemberCacheLimit() {
        return this.memberCacheLimit;
    }

    public void setMemberCacheLimit(int limit) {
        if (limit < 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - memberCacheLimit", Integer.toString(limit));
        }
        this.memberCacheLimit = limit;
    }

    public String getStartupTriggerName() {
        return this.startupTriggerName;
    }

    public void setStartupTriggerName(String triggerName) {
        this.startupTriggerName = triggerName;
    }

    public boolean isDisableResultSetCache() {
        return this.disableResultSetCache;
    }

    public void setDisableResultSetCache(boolean disableCache) {
        this.disableResultSetCache = disableCache;
    }

    public int getPredicateThreshold() {
        return this.predicateThreshold;
    }

    public void setPredicateThreshold(int threshold) {
        if (threshold < 0 || threshold > 100) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - predicateMemberReferenceThreshold", Integer.toString(threshold));
        }
        this.predicateThreshold = threshold;
    }

    public boolean isDisableExternalAggregates() {
        return this.disableExternalAggregates;
    }

    public void setDisableExternalAggregates(boolean disableAggregates) {
        this.disableExternalAggregates = disableAggregates;
    }

    public boolean isAggregateLoggingEnabled() {
        return this.aggregateLoggingEnabled;
    }

    public void setAggregateLoggingEnabled(boolean enableLogging) {
        this.aggregateLoggingEnabled = enableLogging;
    }

    public int getMultiDimensionalQuerySizeLimit() {
        if (this.multiDimensionalQuerySizeLimit == -1 && this.mServerConfiguration != null) {
            return this.mServerConfiguration.getMultiDimensionalQuerySizeLimit();
        }
        return this.multiDimensionalQuerySizeLimit;
    }

    public void setMultiDimensionalQuerySizeLimit(int size) {
        if (size < -1) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - multiDimensionalQuerySizeLimit", Integer.toString(size));
        }
        this.multiDimensionalQuerySizeLimit = size;
    }

    public int getMaxDataCacheSize() {
        return this.maxDataCacheSize;
    }

    public void setMaxDataCacheSize(int size) {
        if (size < 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - dataCacheSizeLimit", Integer.toString(size));
        }
        this.maxDataCacheSize = size;
    }

    public int getMaxAggregateCacheSize() {
        return this.maxAggregateCacheSize;
    }

    public void setMaxAggregateCacheSize(int size) {
        if (size < 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - aggregateCacheSize", Integer.toString(size));
        }
        this.maxAggregateCacheSize = size;
    }

    public int getResultSetCacheSizeLimit() {
        return this.resultSetCacheSizeLimit;
    }

    public void setResultSetCacheSizeLimit(int size) {
        if (size < 100) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - resultSetCacheSizeLimit", Integer.toString(size));
        }
        this.resultSetCacheSizeLimit = size;
    }

    public String dump() {
        StringBuilder s = new StringBuilder();
        s.append("{cubeName=" + this.cubeName + COMMA);
        s.append("isVirtual=" + Boolean.toString(this.isVirtual()) + COMMA);
        s.append("dataCacheSizeLimit=" + this.getMaxDataCacheSize() + COMMA);
        s.append("aggregateCacheSize=" + this.getMaxAggregateCacheSize() + COMMA);
        s.append("disabled=" + Boolean.toString(this.isDisabled()) + COMMA);
        s.append("disableExternalAggregates=" + Boolean.toString(this.isDisableExternalAggregates()) + COMMA);
        s.append("aggregateLoggingEnabled=" + Boolean.toString(this.isAggregateLoggingEnabled()) + COMMA);
        s.append("multiDimensionalQuerySizeLimit=" + Integer.toString(this.getMultiDimensionalQuerySizeLimit()) + COMMA);
        s.append("disableResultSetCache=" + Boolean.toString(this.isDisableResultSetCache()) + COMMA);
        s.append("resultSetCacheSizeLimit=" + Long.toString(this.getResultSetCacheSizeLimit()) + COMMA);
        s.append("predicateMemberReferenceThreshold=" + Integer.toString(this.getPredicateThreshold()) + COMMA);
        s.append("startupTriggerName=" + this.getStartupTriggerName() + COMMA);
        s.append("enableDynamicMemberCaching=" + Boolean.toString(this.isEnableDynamicMemberCaching()) + COMMA);
        s.append("maxHierarchyLoadThreads=" + this.getMaxHierarchyLoadThreads() + COMMA);
        s.append("maxAggregateLoadThreads=" + this.getMaxAggregateLoadThreads() + COMMA);
        s.append("measuresThreshold=" + this.getMeasuresThreshold() + COMMA);
        s.append("postInMemoryTriggerName=" + this.getPostInMemoryTriggerName() + COMMA);
        s.append("autoAggrOptimization=" + this.getAutoAggrOptimization().name() + COMMA);
        s.append("memberCacheLimit=" + this.getMemberCacheLimit() + "}\n");
        return s.toString();
    }

    public void setServerConfiguration(ROLAPConfiguration rolapConfiguration) {
        this.mServerConfiguration = rolapConfiguration;
    }

    public ROLAPCubeStateEnum getInitialState() {
        if (this.isDisabled()) {
            return ROLAPCubeStateEnum.DISABLED;
        }
        return ROLAPCubeStateEnum.STOPPED;
    }

    public String getPostInMemoryTriggerName() {
        return this.postInMemoryTriggerName;
    }

    public void setPostInMemoryTriggerName(String triggerName) {
        this.postInMemoryTriggerName = triggerName;
    }

    public int getMaxHierarchyLoadThreads() {
        return this.maxHierarchyLoadThreads;
    }

    public void setMaxHierarchyLoadThreads(int threads) {
        if (threads < 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - maxHieararchyLoadThreads", Integer.toString(threads));
        }
        this.maxHierarchyLoadThreads = threads == 0 ? DEFAULT_MAX_HIERARCHY_LOAD_THREADS : threads;
    }

    public int getMaxAggregateLoadThreads() {
        return this.maxAggregateLoadThreads;
    }

    public void setMaxAggregateLoadThreads(int threads) {
        if (threads < 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - maxAggregateLoadThreads", Integer.toString(threads));
        }
        this.maxAggregateLoadThreads = threads == 0 ? DEFAULT_MAX_AGGREGATE_LOAD_THREADS : threads;
    }

    public int getMeasuresThreshold() {
        return this.measuresThreshold;
    }

    public void setMeasuresThreshold(int threshold) {
        if (threshold < 0 || threshold > 100) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - measuresThreshold", Integer.toString(threshold));
        }
        this.measuresThreshold = threshold;
    }

    public AutoAggrOptimization getAutoAggrOptimization() {
        return this.autoAggrOptimization;
    }

    public void setAutoAggrOptimization(String optimization) {
        AutoAggrOptimization opt = AutoAggrOptimization.getValue(optimization);
        if (opt == null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, this.getName() + " - automaticAggregateOptimizationEnabled", optimization);
        }
        this.autoAggrOptimization = opt;
    }

    public void reportUnsupportedProperties(ROLAPCubeMessages messages) {
        this.mServerConfiguration.reportUnsupportedProperties(messages);
    }

    public static enum AutoAggrOptimization {
        Off("automaticAggregateOptimizationOff"),
        On("automaticAggregateOptimizationOn");

        private final String value;

        private AutoAggrOptimization(String val) {
            this.value = val;
        }

        public static AutoAggrOptimization getValue(String val) {
            for (AutoAggrOptimization type : AutoAggrOptimization.values()) {
                if (!type.value.equals(val)) continue;
                return type;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }
    }
}

