/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBasicCubeStateGovernor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservationGovernor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPVirtualCubeGovernor;
import com.cognos.xqe.util.concurrent.locks.LockManager;
import com.cognos.xqe.util.fsm.StateMachine;
import java.util.concurrent.TimeUnit;

public class ROLAPCubeStateMachine
extends StateMachine<ROLAPCubeStateEnum, ROLAPCubeStateContext> {
    private static final long START_LOCK_WAIT = 10000L;

    public ROLAPCubeStateMachine(ROLAPCubeStateEnum initialState, ROLAPCubeStateContext cubeContext, LockManager lockManager, long waitTime) {
        super(initialState, cubeContext, lockManager, waitTime);
        this.addGovernor(new ROLAPBasicCubeStateGovernor());
        this.addGovernor(new ROLAPCubeReservationGovernor());
        this.addGovernor(new ROLAPVirtualCubeGovernor());
    }

    public boolean waitForTransition(ROLAPCubeStateEnum from, ROLAPCubeStateEnum to, ROLAPCubeStateContext ctx, boolean indefinitely) throws InterruptedException {
        long timeout = Long.MAX_VALUE;
        if (!indefinitely) {
            timeout = ROLAPCubeManager.getInstance().getConfigActualAdminCommandTimeout();
        }
        return this.waitForTransition(from, to, timeout, TimeUnit.SECONDS, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transitionToStartingState(ROLAPCubeStateContext cubeContext) {
        ROLAPCubeConfiguration cubeConfiguration = cubeContext.getCube().getLatestConfiguration();
        ROLAPCubeStateEnum currentState = cubeContext.getCube().getState();
        if (currentState == ROLAPCubeStateEnum.STOPPING) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_CannotUseStoppingCube, cubeContext.getCube().getName());
        }
        if (!(cubeConfiguration.isDisabled() || currentState != ROLAPCubeStateEnum.STARTING && currentState != ROLAPCubeStateEnum.RUNNING)) {
            return false;
        }
        cubeContext.getCube().throwExceptionIfCurrentThreadIsInterrupted();
        this.acquireLock(this.stateUniqueName, true, 10000L);
        try {
            currentState = cubeContext.getCube().getState();
            if (!(cubeConfiguration.isDisabled() || currentState != ROLAPCubeStateEnum.STARTING && currentState != ROLAPCubeStateEnum.RUNNING)) {
                boolean bl = false;
                return bl;
            }
            ROLAPCubeStateEnum initialState = cubeConfiguration.getInitialState();
            if (initialState != currentState && !this.extendedTransition(initialState, cubeContext)) {
                boolean bl = false;
                return bl;
            }
            cubeContext.getCube().setConfiguration(cubeConfiguration);
            if (!this.extendedTransition(ROLAPCubeStateEnum.STARTING, cubeContext)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseLock(this.stateUniqueName, true);
        }
    }
}

