/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateEnum;
import com.cognos.xqe.util.fsm.IStateGovernor;
import java.util.Set;

public class ROLAPVirtualCubeGovernor
implements IStateGovernor<ROLAPCubeStateEnum, ROLAPCubeStateContext> {
    private static final String DIVIDER = ", ";

    @Override
    public boolean canTransition(ROLAPCubeStateEnum from, ROLAPCubeStateEnum to, ROLAPCubeStateContext ctx) {
        return true;
    }

    @Override
    public void beforeTransition(ROLAPCubeStateEnum from, ROLAPCubeStateEnum to, ROLAPCubeStateContext ctx) {
        String cubeList = "";
        if ((from == ROLAPCubeStateEnum.RUNNING || from == ROLAPCubeStateEnum.PAUSING || from == ROLAPCubeStateEnum.PAUSED) && to == ROLAPCubeStateEnum.STOPPING || from == ROLAPCubeStateEnum.RUNNING && to == ROLAPCubeStateEnum.PAUSING) {
            if (ctx.getCube().isDeleted()) {
                return;
            }
            Set<ROLAPCube> dependentCubes = ctx.getCube().getDependentCubes();
            for (ROLAPCube dependent : dependentCubes) {
                if (dependent.isStopped() || dependent.isPaused() || !dependent.isEnabled()) continue;
                if (cubeList.length() != 0) {
                    cubeList = cubeList + DIVIDER;
                }
                cubeList = cubeList + dependent.getName();
            }
            if (cubeList.length() != 0) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_StopDependentCubes, ctx.getCube().getName(), cubeList);
            }
        }
    }

    @Override
    public void afterTransition(ROLAPCubeStateEnum from, ROLAPCubeStateEnum to, ROLAPCubeStateContext ctx) {
    }

    @Override
    public void failedTransition(ROLAPCubeStateEnum from, ROLAPCubeStateEnum to, ROLAPCubeStateContext ctx) {
    }
}

