/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Advisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCancelHandler;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorRunTimeLimitEnforcerTask;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQELogger;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AdvisorRecommendTask
implements Callable<Object> {
    private static final XQELogger LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor.Management");
    private ExecutorService executorService;
    private Advisor advisor;
    private String sessionID;

    public AdvisorRecommendTask(Advisor theAdvisor, String theSessionID) {
        this.advisor = theAdvisor;
        this.sessionID = theSessionID;
    }

    @Override
    public Object call() throws Exception {
        this.recommendAggregates();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recommendAggregates() throws Exception {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.advisor.getCubeName());
        AdvisorCancelHandler advisorCancelHandler = this.advisor.getAdvisorCancelHandler();
        boolean registered = false;
        try {
            registered = advisorCancelHandler.registerAdvisorThread();
            LOGGER.log(String.format("The %s started.", this));
            this.startRunTimeLimitEnforcerTask();
            try {
                this.advisor.setState(AggregateAdvisorState.EXECUTING);
                this.advisor.startProgressTimer();
                try {
                    this.advisor.recommend();
                }
                finally {
                    this.advisor.setState(AggregateAdvisorState.COMPLETED);
                    this.advisor.stopProgressTimer();
                }
            }
            finally {
                this.stopRunTimeLimitEnforcerTask();
            }
            LOGGER.log(String.format("The %s stopped.", this));
        }
        finally {
            advisorCancelHandler.unregisterAdvisorThread(registered);
            traceContext.exit();
        }
    }

    private void startRunTimeLimitEnforcerTask() {
        int runTimeLimit = this.advisor.getRequestParameters().getRunTimeLimit();
        LOGGER.log(String.format("The run time limit of the advisor is %d minute(s).", runTimeLimit));
        if (runTimeLimit > 0) {
            AdvisorRunTimeLimitEnforcerTask runTimeLimitEnforcerTask = new AdvisorRunTimeLimitEnforcerTask(this.advisor, this.sessionID, runTimeLimit);
            this.executorService = Executors.newFixedThreadPool(1);
            this.executorService.submit(runTimeLimitEnforcerTask);
            LOGGER.log("The task that enforces the run time limit of the advisor was submitted for execution.");
        }
    }

    private void stopRunTimeLimitEnforcerTask() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
            LOGGER.log("The task that enforces the run time limit of the advisor was stopped.");
        }
    }

    public String toString() {
        return String.format("task that asks the advisor to recommend aggregates for session %s", this.sessionID);
    }
}

