/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRequestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateSQLInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.LogUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.ExistingInDatabaseAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.indatabase.xml.InDatabaseRecommendationsXMLUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.util.FileHandler;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AdvisorRecommendations {
    private AdvisorRequestParameters requestParameters = new AdvisorRequestParameters();
    private List<Aggregate> inDatabaseAggregates = new ArrayList<Aggregate>();
    private List<Aggregate> inMemoryAggregates = new ArrayList<Aggregate>();
    private List<ExistingInDatabaseAggregate> existingInDatabaseAggregates = new ArrayList<ExistingInDatabaseAggregate>();
    private List<XQERuntimeException> messages = new ArrayList<XQERuntimeException>();
    private String cubeName = null;
    private Date startTime = null;
    private AdvisorMetrics advisorMetrics = new AdvisorMetrics();
    private static final long COVERAGE = 10L;
    private static final String PREFIX = "* ";
    private static final String NEW_LINE = "\n";
    private static final String COMMA_SPACE = ", ";
    private static final String SPACE_STR = " ";
    protected static final String BLOCK_HEADER_LINE_START = "/*******************************************************************************\n";
    protected static final String BLOCK_HEADER_LINE_END = "*******************************************************************************/\n";
    protected static final String BLOCK_HEADER_SEPARATOR = "*******************************************************************************\n";
    private static final String VERSION = "version";
    private static final String VERSION_1_0 = "1.0";
    private static final String UTF8 = "UTF-8";
    private static final String INDENTATION = "  ";
    private static final String OLAP_NS_PREFIX = "xmlns:olap";
    private static final String OLAP_URI = "http://www.ibm.com/olap";
    private static final String XML_NS_PREFIX = "xmlns";
    private static final String XSI_SCHEMALOCATION_PREFIX = "xsi:schemaLocation";
    private static final String XSI_NS_PREFIX = "xmlns:xsi";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSD_NS_PREFIX = "xmlns:xsd";
    private static final String XSD_URI = "http://www.w3.org/2001/XMLSchema";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss z");
    private long timestamp = System.currentTimeMillis();
    private static final String BACKUP_ADVISOR_RESULTS = "BackupAdvisorResults";
    private static final String BACKUP_DIRECTORY_PREFIX = "Cache_";
    private static final String MESSAGES_BACKUP_FILE_NAME = "manifest.xml";
    private static final String INMEMORY_BACKUP_FILE_NAME = "inMemory.xml";
    private static final String INDATABASE_BACKUP_FILE_NAME = "inDatabase.xml";
    private static final String INDATABASEXML_BACKUP_FILE_NAME = "inDatabaseXML.xml";
    private static final String MANIFEST_TAG = "manifest";
    private static final String NAME_TAG = "name";
    private static final String TIMESTAMP_TAG = "timestamp";
    private static final String MESSAGES_TAG = "messages";
    private static final String MESSAGE_TAG = "message";
    private static final String OPTIONS_TAG = "options";
    private static final String INFOS_TAG = "infos";
    private static final String INFO_TAG = "info";
    private static final String COUNT_TAG = "count";
    private static final String ESTIMATED_SPACE_TAG = "estimatedSpace";
    private static final String AGGREGATES_TAG = "aggregates";
    private static final String AGGREGATE_TAG = "aggregate";
    private static final String SIZE_TAG = "size";
    private static final String LEVELS_TAG = "levels";
    private static final String LEVEL_TAG = "level";
    private static final String MEASURES_TAG = "measures";
    private static final String MEASURE_TAG = "measure";
    private static final int MAX_ALLOWED_CHAR = 127;
    private static final double MAKE_PERCENTAGE = 100.0;
    private static final String ADDITIVE = "Additive";

    public AdvisorRecommendations(String theCubeName, AdvisorRequestParameters theRequestParameters, List<Aggregate> theInDatabaseAggregates, List<Aggregate> theInMemoryAggregates, List<XQERuntimeException> theMessages, List<ExistingInDatabaseAggregate> theExistingInDatabaseAggregates, Date theStartTime) {
        this.requestParameters = theRequestParameters;
        this.inDatabaseAggregates = theInDatabaseAggregates;
        this.inMemoryAggregates = theInMemoryAggregates;
        this.messages = theMessages;
        this.cubeName = theCubeName;
        this.startTime = theStartTime;
        this.existingInDatabaseAggregates = theExistingInDatabaseAggregates;
    }

    public AdvisorRequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public List<ExistingInDatabaseAggregate> getExistingInDatabaseAggregates() {
        return this.existingInDatabaseAggregates;
    }

    public void setAdvisorMetrics(AdvisorMetrics theAdvisorMetrics) {
        this.advisorMetrics = theAdvisorMetrics;
    }

    public final AdvisorMetrics getAdvisorMetrics() {
        return this.advisorMetrics;
    }

    public final List<XQERuntimeException> getMessages() {
        return this.messages;
    }

    public final List<Aggregate> getInDatabaseAggregates() {
        return this.inDatabaseAggregates;
    }

    public final List<Aggregate> getInMemoryAggregates() {
        return this.inMemoryAggregates;
    }

    public final List<Aggregate> getAggregates() {
        ArrayList<Aggregate> aggregates = new ArrayList<Aggregate>();
        aggregates.addAll(this.inMemoryAggregates);
        aggregates.addAll(this.inDatabaseAggregates);
        return aggregates;
    }

    public final String getCubeName() {
        return this.cubeName;
    }

    public final long getInDatabaseAggregatesEstimatedSize() {
        long size = 0L;
        for (Aggregate agg : this.inDatabaseAggregates) {
            size += agg.getEstimatedSize();
        }
        return size;
    }

    public final long getInMemoryAggregatesEstimatedSize() {
        long size = 0L;
        for (Aggregate agg : this.inMemoryAggregates) {
            size += agg.getEstimatedSize();
        }
        return size;
    }

    public final long getInDatabaseAggregatesCoverage() {
        return 10L;
    }

    public final long getInMemoryAggregatesCoverage() {
        return 10L;
    }

    public void determineDependencies() {
        int numInMemAggrCovered;
        try {
            for (Aggregate inDbAggregate : this.inDatabaseAggregates) {
                for (Aggregate otherInDbAggregate : this.inDatabaseAggregates) {
                    if (inDbAggregate == otherInDbAggregate || !otherInDbAggregate.isCovered(inDbAggregate)) continue;
                    inDbAggregate.addCoveredByAggregate(otherInDbAggregate.getName());
                }
                for (ExistingInDatabaseAggregate existingAggregate : this.existingInDatabaseAggregates) {
                    if (!existingAggregate.coversIgnoreFiltering(inDbAggregate)) continue;
                    if (!existingAggregate.hasFiltering()) {
                        inDbAggregate.addCoveredByExistingAggregateCube(existingAggregate.getName());
                        continue;
                    }
                    inDbAggregate.addCoveredByExistingAggregateCubeButHasSlicer(existingAggregate.getName());
                }
                numInMemAggrCovered = 0;
                for (Aggregate inMemAggregate : this.inMemoryAggregates) {
                    if (!inDbAggregate.isCovered(inMemAggregate)) continue;
                    ++numInMemAggrCovered;
                    inDbAggregate.addCoveredInMemoryAggregate(inMemAggregate);
                }
                inDbAggregate.setNumberOfInMemoryAggregatesCovered(numInMemAggrCovered);
            }
        }
        catch (Exception e) {
            ROLAPLog.logError("ROLAPAggregateAdvisor", "Advisor encountered unexpected error when determining in-database aggregate dependencies: ", e);
        }
        try {
            for (ExistingInDatabaseAggregate existingAggregate : this.existingInDatabaseAggregates) {
                numInMemAggrCovered = 0;
                for (Aggregate inMemAggregate : this.inMemoryAggregates) {
                    if (!existingAggregate.covers(inMemAggregate)) continue;
                    ++numInMemAggrCovered;
                }
                existingAggregate.setNumberOfInMemoryAggregatesCovered(numInMemAggrCovered);
            }
        }
        catch (Exception e) {
            ROLAPLog.logError("ROLAPAggregateAdvisor", "Advisor encountered unexpected error when determining existing aggregate cube dependencies: ", e);
        }
    }

    public String getInDatabaseRecommendationsAsText() {
        Aggregate baseAggregate;
        boolean hasExistingInDBAggregates;
        String text = "";
        StringBuilder sb = new StringBuilder();
        boolean hasInDBAggregates = this.inDatabaseAggregates.size() > 0;
        boolean bl = hasExistingInDBAggregates = this.existingInDatabaseAggregates.size() > 0;
        if (!hasInDBAggregates) {
            sb.append(NEW_LINE);
            sb.append(BLOCK_HEADER_LINE_START);
            if (!hasExistingInDBAggregates) {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog25, XQEMessages.getCurrProductLocale())));
            } else {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog26, XQEMessages.getCurrProductLocale())));
            }
            sb.append(BLOCK_HEADER_LINE_END);
            sb.append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        sb.append(BLOCK_HEADER_LINE_START);
        sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog10, XQEMessages.getCurrProductLocale())));
        sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog20, XQEMessages.getCurrProductLocale())));
        sb.append(this.prolog(""));
        sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_CubeName, XQEMessages.getCurrProductLocale(), this.cubeName)));
        sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_StartTime, XQEMessages.getCurrProductLocale(), this.dateFormat.format(this.startTime))));
        sb.append(this.prolog(""));
        sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_GeneralOptions, XQEMessages.getCurrProductLocale())));
        if (this.requestParameters.getUserDefinedAggregatesOnly()) {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_UserDefinedInMemAggregatesOnly, XQEMessages.getCurrProductLocale())));
        } else if (this.requestParameters.getIncludeWorkloadInfo()) {
            if (this.requestParameters.getUseWorkloadOnly()) {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_UseWorkloadOnly, XQEMessages.getCurrProductLocale())));
            } else {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_IncWorkload, XQEMessages.getCurrProductLocale())));
            }
        }
        if (!this.requestParameters.getIncludeWorkloadInfo()) {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_NotIncWorkload, XQEMessages.getCurrProductLocale())));
        }
        boolean includeInMemoryAggregates = true;
        long limit = this.requestParameters.getInMemoryAggregatesLimit();
        if (limit > 0L) {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_InMemSizeLimit, XQEMessages.getCurrProductLocale(), String.valueOf(limit))));
        } else {
            includeInMemoryAggregates = false;
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_NotIncInMemAggregate, XQEMessages.getCurrProductLocale())));
        }
        limit = this.requestParameters.getInDatabaseAggregatesLimit();
        if (limit > 0L) {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_InDBSizeLimit, XQEMessages.getCurrProductLocale(), String.valueOf(limit))));
        } else {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_NotIncInDBAggregate, XQEMessages.getCurrProductLocale())));
        }
        limit = this.requestParameters.getRunTimeLimit();
        if (limit > 0L) {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_RuntimeLimit, XQEMessages.getCurrProductLocale(), String.valueOf(limit))));
        } else {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_RuntimeLimitUntilCompletion, XQEMessages.getCurrProductLocale())));
        }
        sb.append(this.prolog(""));
        if (this.requestParameters.getIncludeWorkloadInfo()) {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_WorkloadOptions, XQEMessages.getCurrProductLocale())));
            if (this.requestParameters.isFilterOnReportUsage()) {
                int usage = this.requestParameters.getReportUsage();
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_TopUsedReport, XQEMessages.getCurrProductLocale(), String.valueOf(usage))));
            }
            if (!this.requestParameters.getReportNames().isEmpty()) {
                List<String> reportNames = this.requestParameters.getReportNames();
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_Reports, XQEMessages.getCurrProductLocale(), this.addListToString(reportNames))));
            }
            if (!this.requestParameters.getPackageNames().isEmpty()) {
                List<String> packageNames = this.requestParameters.getPackageNames();
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_Packages, XQEMessages.getCurrProductLocale(), this.addListToString(packageNames))));
            }
            if (!this.requestParameters.getUserNames().isEmpty()) {
                List<String> userNames = this.requestParameters.getUserNames();
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_Users, XQEMessages.getCurrProductLocale(), this.addListToString(userNames))));
            }
            if (!this.requestParameters.isFilterOnTimePeriod()) {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_AllTimePeriods, XQEMessages.getCurrProductLocale())));
            } else if (this.requestParameters.isFilterOnDaysOfTheWeek()) {
                sb.append(PREFIX + XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_DayOfWeekIs, XQEMessages.getCurrProductLocale()));
                if (this.requestParameters.isFilterOnDay(1)) {
                    sb.append("Monday ");
                }
                if (this.requestParameters.isFilterOnDay(2)) {
                    sb.append("Tuesday ");
                }
                if (this.requestParameters.isFilterOnDay(4)) {
                    sb.append("Wednesday ");
                }
                if (this.requestParameters.isFilterOnDay(8)) {
                    sb.append("Thursday ");
                }
                if (this.requestParameters.isFilterOnDay(16)) {
                    sb.append("Friday ");
                }
                if (this.requestParameters.isFilterOnDay(32)) {
                    sb.append("Saturday ");
                }
                if (this.requestParameters.isFilterOnDay(64)) {
                    sb.append("Sunday ");
                }
                sb.append(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_DayOfWeekBetweenTimes, XQEMessages.getCurrProductLocale(), this.timeFormat.format(this.requestParameters.getStartTime()), this.timeFormat.format(this.requestParameters.getEndTime())));
                sb.append(NEW_LINE);
            } else {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_FromToTime, XQEMessages.getCurrProductLocale(), this.dateFormat.format(this.requestParameters.getStartTime()), this.dateFormat.format(this.requestParameters.getEndTime()))));
            }
            sb.append(this.prolog(""));
        }
        if (hasInDBAggregates || hasExistingInDBAggregates) {
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_Summary, XQEMessages.getCurrProductLocale())));
            if (hasInDBAggregates) {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_SummaryNumDBRecs, XQEMessages.getCurrProductLocale(), String.valueOf(this.inDatabaseAggregates.size()))));
                int numStackedAggregates = 0;
                for (Aggregate dbAgg : this.inDatabaseAggregates) {
                    baseAggregate = this.determineAggregateToStackOn(dbAgg);
                    if (baseAggregate == null) continue;
                    ++numStackedAggregates;
                }
                int numBaseAggregates = this.inDatabaseAggregates.size() - numStackedAggregates;
                sb.append(this.prolog(INDENTATION + XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_SummaryNumBaseDBRecs, XQEMessages.getCurrProductLocale(), String.valueOf(numBaseAggregates))));
                sb.append(this.prolog(INDENTATION + XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_SummaryNumStackedDBRecs, XQEMessages.getCurrProductLocale(), String.valueOf(numStackedAggregates))));
            }
            if (hasExistingInDBAggregates) {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBText_SummaryNumExistingAggrCubes, XQEMessages.getCurrProductLocale(), String.valueOf(this.existingInDatabaseAggregates.size()))));
            }
        }
        sb.append(BLOCK_HEADER_LINE_END);
        if (hasInDBAggregates) {
            sb.append(NEW_LINE);
            sb.append(NEW_LINE);
            sb.append(NEW_LINE);
            sb.append(BLOCK_HEADER_LINE_START);
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog30, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(""));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog40, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog50, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(""));
            if (includeInMemoryAggregates) {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog55, XQEMessages.getCurrProductLocale())));
                sb.append(this.prolog(""));
            }
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog60, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog70, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog80, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog90, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog100, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog110, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog111, XQEMessages.getCurrProductLocale())));
            if (hasExistingInDBAggregates) {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog113, XQEMessages.getCurrProductLocale())));
            }
            if (includeInMemoryAggregates) {
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog112, XQEMessages.getCurrProductLocale())));
            }
            sb.append(this.prolog(""));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog120, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog121, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(""));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog124, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog125, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog126, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog131, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(""));
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextProglog130, XQEMessages.getCurrProductLocale())));
            sb.append(BLOCK_HEADER_LINE_END);
            for (Aggregate aggregate : this.inDatabaseAggregates) {
                try {
                    AggregateSQLInfo sqlInfo = aggregate.getSQLInfo();
                    sb.append(NEW_LINE);
                    sb.append(NEW_LINE);
                    sb.append(NEW_LINE);
                    aggregate.getAggregateAsText(sb, sqlInfo, includeInMemoryAggregates, hasExistingInDBAggregates);
                    sb.append(NEW_LINE);
                    sb.append(NEW_LINE);
                    baseAggregate = this.determineAggregateToStackOn(aggregate);
                    if (baseAggregate != null) {
                        String stackedSql = aggregate.getStackedSql(baseAggregate);
                        sb.append(stackedSql);
                    } else {
                        sb.append(sqlInfo.getSQL());
                    }
                    sb.append(NEW_LINE);
                }
                catch (Exception exception) {}
            }
        }
        if (hasExistingInDBAggregates) {
            sb.append(NEW_LINE);
            sb.append(NEW_LINE);
            sb.append(NEW_LINE);
            sb.append(BLOCK_HEADER_LINE_START);
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextExisting_Prolog10, XQEMessages.getCurrProductLocale())));
            for (ExistingInDatabaseAggregate existing : this.existingInDatabaseAggregates) {
                sb.append(BLOCK_HEADER_SEPARATOR);
                existing.getAggregateAsText(sb, includeInMemoryAggregates);
            }
            sb.append(BLOCK_HEADER_LINE_END);
        }
        text = sb.toString();
        return text;
    }

    private Aggregate determineAggregateToStackOn(Aggregate aggregate) {
        Aggregate bestBaseAggregate = null;
        ArrayList<Aggregate> candidateBaseAggregates = new ArrayList<Aggregate>();
        List<String> coveredByAggregateNames = aggregate.getCoveredByAggregates();
        block0: for (String aggregateName : coveredByAggregateNames) {
            for (Aggregate inDatabaseAggregate : this.inDatabaseAggregates) {
                if (!inDatabaseAggregate.getName().equals(aggregateName)) continue;
                candidateBaseAggregates.add(inDatabaseAggregate);
                continue block0;
            }
        }
        for (Aggregate candidateBaseAggregate : candidateBaseAggregates) {
            if (bestBaseAggregate == null) {
                bestBaseAggregate = candidateBaseAggregate;
                continue;
            }
            if (candidateBaseAggregate.getCardinality() < bestBaseAggregate.getCardinality()) {
                bestBaseAggregate = candidateBaseAggregate;
                continue;
            }
            if (candidateBaseAggregate.getCardinality() != bestBaseAggregate.getCardinality() || candidateBaseAggregate.getSliceId().getNumberOfTurns() >= bestBaseAggregate.getSliceId().getNumberOfTurns()) continue;
            bestBaseAggregate = candidateBaseAggregate;
        }
        return bestBaseAggregate;
    }

    private String addListToString(List<String> names) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                sb.append(COMMA_SPACE);
            }
            sb.append(names.get(i));
        }
        return sb.toString();
    }

    private String prolog(String text) {
        String line = PREFIX + text + NEW_LINE;
        return line;
    }

    public String getInDatabaseRecommendationsAsXML() {
        return InDatabaseRecommendationsXMLUtility.generateXML(this.cubeName, this.startTime, this);
    }

    public void getInDatabaseRecommendationsAsXML(Writer writer) {
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(writer);
        xmlWriter.setIndentString(INDENTATION);
        xmlWriter.writeHeader(VERSION_1_0, UTF8);
        xmlWriter.beginElement("olap:advisorDatabaseAggregates", -1);
        xmlWriter.attribute(OLAP_NS_PREFIX, OLAP_URI);
        xmlWriter.attribute(XML_NS_PREFIX, OLAP_URI);
        xmlWriter.attribute(XSI_NS_PREFIX, XSI_URI);
        xmlWriter.attribute(XSD_NS_PREFIX, XSD_URI);
        xmlWriter.attribute(XSI_SCHEMALOCATION_PREFIX, OLAP_URI);
        xmlWriter.attribute(VERSION, VERSION_1_0);
        for (Aggregate aggregate : this.inDatabaseAggregates) {
            aggregate.toXML(xmlWriter);
        }
        xmlWriter.beginElement("description", -1);
        xmlWriter.cdata(this.getInDatabaseRecommendationsAsText());
        xmlWriter.endElement();
        xmlWriter.endElement();
    }

    public void getInMemoryRecommendationsAsXML(Writer writer) {
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(writer);
        xmlWriter.setIndentString(INDENTATION);
        xmlWriter.writeHeader(VERSION_1_0, UTF8);
        xmlWriter.beginElement("olap:advisorMemoryAggregates", -1);
        xmlWriter.attribute(OLAP_NS_PREFIX, OLAP_URI);
        xmlWriter.attribute(XML_NS_PREFIX, OLAP_URI);
        xmlWriter.attribute(XSI_NS_PREFIX, XSI_URI);
        xmlWriter.attribute(XSD_NS_PREFIX, XSD_URI);
        xmlWriter.attribute(XSI_SCHEMALOCATION_PREFIX, OLAP_URI);
        xmlWriter.attribute(VERSION, VERSION_1_0);
        for (Aggregate aggregate : this.inMemoryAggregates) {
            aggregate.toXML(xmlWriter);
        }
        xmlWriter.endElement();
    }

    public String formatForTrace() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.formatSummaryForTrace());
        sb.append(NEW_LINE);
        sb.append(AdvisorTrace.majorHeading("In memory aggregates details:"));
        sb.append(NEW_LINE);
        for (Aggregate agg : this.inMemoryAggregates) {
            sb.append(agg.toTraceString());
            sb.append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        sb.append(AdvisorTrace.majorHeading("In database aggregates details:"));
        sb.append(NEW_LINE);
        sb.append(this.getInDatabaseRecommendationsAsText());
        return sb.toString();
    }

    public String formatSummaryForTrace() {
        StringBuilder sb = new StringBuilder();
        sb.append(" \n");
        sb.append(AdvisorTrace.heading("Recommendations for cube " + this.cubeName));
        sb.append(NEW_LINE);
        sb.append("In memory aggregates summary: \n");
        sb.append(AdvisorTrace.formatAggregates(this.inMemoryAggregates));
        sb.append(NEW_LINE);
        sb.append("In database aggregates summary: \n");
        sb.append(AdvisorTrace.formatAggregates(this.inDatabaseAggregates));
        sb.append(NEW_LINE);
        sb.append("Messages:\n");
        for (XQERuntimeException msg : this.messages) {
            sb.append(msg.getMessage());
            sb.append(NEW_LINE);
        }
        sb.append(NEW_LINE);
        sb.append(this.formatSummaryDependencyForTrace());
        return sb.toString();
    }

    private String formatSummaryDependencyForTrace() {
        StringBuilder sb = new StringBuilder();
        sb.append("In memory aggregates - indication of whether covered by in database aggregates:\n");
        int numInMemoryAggregates = this.inMemoryAggregates.size();
        int numAdditiveInMemoryAggregates = 0;
        int numNonAdditiveInMemoryAggregates = 0;
        int numInMemoryAggregatesCovered = 0;
        int numAdditiveInMemoryAggregatesCovered = 0;
        int numNonAdditiveInMemoryAggregatesCovered = 0;
        for (Aggregate memAgg : this.inMemoryAggregates) {
            if (memAgg.getAdditiveStatus().equals(ADDITIVE)) {
                ++numAdditiveInMemoryAggregates;
            } else {
                ++numNonAdditiveInMemoryAggregates;
            }
            String coveredStatus = "Not covered";
            if (Aggregate.isAggregateCovered(memAgg, this.inDatabaseAggregates)) {
                if (memAgg.getAdditiveStatus().equals(ADDITIVE)) {
                    ++numAdditiveInMemoryAggregatesCovered;
                } else {
                    ++numNonAdditiveInMemoryAggregatesCovered;
                }
                coveredStatus = "Covered";
            }
            sb.append(String.format("%15s    %12s    %s", coveredStatus, memAgg.getAdditiveStatus(), memAgg.getName()));
            sb.append(NEW_LINE);
        }
        numInMemoryAggregatesCovered = numAdditiveInMemoryAggregatesCovered + numNonAdditiveInMemoryAggregatesCovered;
        sb.append(NEW_LINE);
        double pctInMemoryAggregatesCovered = 0.0;
        if (numInMemoryAggregates > 0) {
            pctInMemoryAggregatesCovered = 100.0 * (double)numInMemoryAggregatesCovered / (double)numInMemoryAggregates;
        }
        sb.append(String.format("Database aggregates cover %.1f%% of in memory aggregates (%d of %d)", pctInMemoryAggregatesCovered, numInMemoryAggregatesCovered, numInMemoryAggregates));
        sb.append(NEW_LINE);
        double pctAdditiveInMemoryAggregatesCovered = 0.0;
        if (numAdditiveInMemoryAggregates > 0) {
            pctAdditiveInMemoryAggregatesCovered = 100.0 * (double)numAdditiveInMemoryAggregatesCovered / (double)numAdditiveInMemoryAggregates;
        }
        sb.append(String.format("Database aggregates cover %.1f%% of additive in memory aggregates (%d of %d)", pctAdditiveInMemoryAggregatesCovered, numAdditiveInMemoryAggregatesCovered, numAdditiveInMemoryAggregates));
        sb.append(NEW_LINE);
        double pctNonAdditiveInMemoryAggregatesCovered = 0.0;
        if (numNonAdditiveInMemoryAggregates > 0) {
            pctNonAdditiveInMemoryAggregatesCovered = 100.0 * (double)numNonAdditiveInMemoryAggregatesCovered / (double)numNonAdditiveInMemoryAggregates;
        }
        sb.append(String.format("Database aggregates cover %.1f%% of non-Additive in memory aggregates (%d of %d)", pctNonAdditiveInMemoryAggregatesCovered, numNonAdditiveInMemoryAggregatesCovered, numNonAdditiveInMemoryAggregates));
        sb.append(NEW_LINE);
        return sb.toString();
    }

    public void storeBackup(List<String> advisorMessages) throws Exception {
        File workloadFolder = LogUtility.getWorkloadFolder(this.cubeName, true);
        String backupDirectory = this.getBackupDirectoryFileName(workloadFolder);
        this.storeBackupFile(backupDirectory, MESSAGES_BACKUP_FILE_NAME, advisorMessages);
        this.storeBackupFile(backupDirectory, INMEMORY_BACKUP_FILE_NAME, null);
        this.storeBackupFile(backupDirectory, INDATABASE_BACKUP_FILE_NAME, null);
        this.storeBackupFile(backupDirectory, INDATABASEXML_BACKUP_FILE_NAME, null);
    }

    private String getBackupDirectoryFileName(File directory) {
        StringBuilder sb;
        try {
            sb = new StringBuilder(directory.getCanonicalPath());
        }
        catch (IOException e) {
            sb = new StringBuilder(directory.getPath());
        }
        sb.append(File.separatorChar).append(BACKUP_ADVISOR_RESULTS);
        sb.append(File.separatorChar).append(BACKUP_DIRECTORY_PREFIX).append(this.timestamp);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBackupFile(String directory, String fileName, List<String> advisorMessages) throws IOException {
        StringBuilder sb = new StringBuilder(directory);
        sb.append(File.separatorChar).append(fileName);
        String backupFileName = sb.toString();
        Writer writer = null;
        try {
            if (fileName.equals(MESSAGES_BACKUP_FILE_NAME)) {
                FileHandler.createOutputFolders(backupFileName);
                writer = FileHandler.createFileWriter(backupFileName);
                this.backupMessagesToFile(writer, advisorMessages);
            } else if (fileName.equals(INMEMORY_BACKUP_FILE_NAME)) {
                FileHandler.createOutputFolders(backupFileName);
                writer = FileHandler.createFileWriter(backupFileName);
                this.backupInMemoryRecommendationsToFile(writer);
            } else if (fileName.equals(INDATABASE_BACKUP_FILE_NAME)) {
                FileHandler.createOutputFolders(backupFileName);
                writer = FileHandler.createFileWriter(backupFileName);
                this.backupInDatabaseRecommendationsToFile(writer);
            } else if (fileName.equals(INDATABASEXML_BACKUP_FILE_NAME)) {
                FileHandler.createOutputFolders(backupFileName);
                writer = FileHandler.createFileWriter(backupFileName);
                writer.write(this.getInDatabaseRecommendationsAsXML());
            }
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    private void backupMessagesToFile(Writer writer, List<String> advisorMessages) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(MANIFEST_TAG);
        root.addAttribute(NAME_TAG, this.cubeName);
        root.addAttribute(TIMESTAMP_TAG, String.valueOf(this.timestamp));
        Element messagesMemento = root.addElement(MESSAGES_TAG);
        for (String message : advisorMessages) {
            messagesMemento.addElement(MESSAGE_TAG).setText(message);
        }
        Element optionsMemento = root.addElement(OPTIONS_TAG);
        this.writeDocument(writer, document);
    }

    private void backupInMemoryRecommendationsToFile(Writer writer) throws IOException {
        StringWriter sw = null;
        try {
            sw = new StringWriter();
            this.getInMemoryRecommendationsAsXML(sw);
            this.backupRecommendationsToFile(writer, sw.toString(), this.getInMemoryAggregatesEstimatedSize(), this.inMemoryAggregates);
        }
        finally {
            if (sw != null) {
                sw.close();
                sw = null;
            }
        }
    }

    private void backupInDatabaseRecommendationsToFile(Writer writer) throws IOException {
        this.backupRecommendationsToFile(writer, this.getInDatabaseRecommendationsAsText(), this.getInDatabaseAggregatesEstimatedSize(), this.inDatabaseAggregates);
    }

    private void backupRecommendationsToFile(Writer writer, String metaInfo, long estimatedSize, List<Aggregate> recommendedAggregates) throws IOException {
        Document document = DocumentHelper.createDocument();
        Element memento = document.addElement(INFOS_TAG);
        Element infoMemento = memento.addElement(INFO_TAG);
        infoMemento.addAttribute(COUNT_TAG, String.valueOf(recommendedAggregates.size()));
        infoMemento.addAttribute(ESTIMATED_SPACE_TAG, String.valueOf(estimatedSize));
        infoMemento.setText(metaInfo);
        Element aggregates = infoMemento.addElement(AGGREGATES_TAG);
        for (Aggregate aggregate : recommendedAggregates) {
            Element aggregateMemento = aggregates.addElement(AGGREGATE_TAG);
            aggregateMemento.addAttribute(NAME_TAG, aggregate.getName());
            aggregateMemento.addAttribute(SIZE_TAG, String.valueOf((float)aggregate.getEstimatedSize()));
            Element levels = aggregateMemento.addElement(LEVELS_TAG);
            for (ROLAPMetaLevel level : aggregate.getLevels()) {
                if (level == null) continue;
                Element levelMemento = levels.addElement(LEVEL_TAG);
                levelMemento.setText(level.getName());
            }
            Element measures = aggregateMemento.addElement(MEASURES_TAG);
            for (ROLAPMetaMeasure measure : aggregate.getMeasures()) {
                if (measure == null) continue;
                Element measureMemento = measures.addElement(MEASURE_TAG);
                measureMemento.setText(measure.getName());
            }
        }
        this.writeDocument(writer, document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocument(Writer writer, Document document) throws IOException {
        org.dom4j.io.XMLWriter xmlWriter = null;
        try {
            xmlWriter = new org.dom4j.io.XMLWriter(writer);
            xmlWriter.setMaximumAllowedCharacter(127);
            xmlWriter.write(document);
        }
        finally {
            if (xmlWriter != null) {
                xmlWriter.close();
                xmlWriter = null;
            }
        }
    }

    public void sortInDatabaseAggregates() {
        this.traceInDatabaseAggregatesCoveredInMemoryAggregates(true);
        ArrayList<Aggregate> sortedInDatabaseAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> unsortedInDatabaseAggregates = new ArrayList<Aggregate>(this.inDatabaseAggregates);
        HashSet<Aggregate> inMemoryAggregatesCoveredBySortedInDatabaseAggregates = new HashSet<Aggregate>();
        while (!unsortedInDatabaseAggregates.isEmpty()) {
            int maxNumberOfCoveredInMemoryAggregates = -1;
            Aggregate inDatabaseAggregateWithMaxNumberOfCoveredInMemoryAggregates = null;
            for (Aggregate unsortedInDatabaseAggregate : unsortedInDatabaseAggregates) {
                ArrayList<Aggregate> inMemoryAggregatesCoveredByUnsortedInDatabaseAggregate = new ArrayList<Aggregate>(unsortedInDatabaseAggregate.getCoveredInMemoryAggregates());
                inMemoryAggregatesCoveredByUnsortedInDatabaseAggregate.removeAll(inMemoryAggregatesCoveredBySortedInDatabaseAggregates);
                int numberOfCoveredInMemoryAggregates = inMemoryAggregatesCoveredByUnsortedInDatabaseAggregate.size();
                if (numberOfCoveredInMemoryAggregates <= maxNumberOfCoveredInMemoryAggregates) continue;
                maxNumberOfCoveredInMemoryAggregates = numberOfCoveredInMemoryAggregates;
                inDatabaseAggregateWithMaxNumberOfCoveredInMemoryAggregates = unsortedInDatabaseAggregate;
            }
            sortedInDatabaseAggregates.add(inDatabaseAggregateWithMaxNumberOfCoveredInMemoryAggregates);
            unsortedInDatabaseAggregates.remove(inDatabaseAggregateWithMaxNumberOfCoveredInMemoryAggregates);
            inMemoryAggregatesCoveredBySortedInDatabaseAggregates.addAll(inDatabaseAggregateWithMaxNumberOfCoveredInMemoryAggregates.getCoveredInMemoryAggregates());
        }
        ArrayList<Aggregate> sortedInDatabaseBaseAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> sortedInDatabaseStackedAggregates = new ArrayList<Aggregate>();
        for (Aggregate aggregate : sortedInDatabaseAggregates) {
            if (aggregate.getCoveredByAggregates().isEmpty()) {
                sortedInDatabaseBaseAggregates.add(aggregate);
                continue;
            }
            sortedInDatabaseStackedAggregates.add(aggregate);
        }
        this.inDatabaseAggregates.clear();
        this.inDatabaseAggregates.addAll(sortedInDatabaseBaseAggregates);
        this.inDatabaseAggregates.addAll(sortedInDatabaseStackedAggregates);
        this.traceInDatabaseAggregatesCoveredInMemoryAggregates(false);
    }

    private void traceInDatabaseAggregatesCoveredInMemoryAggregates(boolean traceAllCoveredInMemoryAggregates) {
        StringBuilder sb = new StringBuilder();
        if (traceAllCoveredInMemoryAggregates) {
            sb.append(AdvisorTrace.heading("In-database aggregates and the in-memory aggregates derivable from them"));
            sb.append("\nFor each in-database aggregate list all derivable in-memory aggregates.\n");
        } else {
            sb.append(AdvisorTrace.heading("In-database aggregates ordered by the number of derivable in-memory aggregates"));
            sb.append("\nFor each in-database aggregate list the subset of derivable in-memory aggregates not derivable from a previous in-database aggregate.\n");
        }
        HashSet<Aggregate> inMemoryAggregatesCoveredByHigherSortOrderInDatabaseAggregates = new HashSet<Aggregate>();
        for (Aggregate inDatabaseAggregate : this.inDatabaseAggregates) {
            sb.append('\n');
            sb.append(inDatabaseAggregate.getName() + '\n');
            ArrayList<Aggregate> inMemoryAggregatesCoveredByCurrentInDatabaseAggregate = new ArrayList<Aggregate>(inDatabaseAggregate.getCoveredInMemoryAggregates());
            if (!traceAllCoveredInMemoryAggregates) {
                inMemoryAggregatesCoveredByCurrentInDatabaseAggregate.removeAll(inMemoryAggregatesCoveredByHigherSortOrderInDatabaseAggregates);
            }
            for (Aggregate inMemoryAggregateCoveredByCurrentInDatabaseAggregate : inMemoryAggregatesCoveredByCurrentInDatabaseAggregate) {
                sb.append(String.format("  %s\n", inMemoryAggregateCoveredByCurrentInDatabaseAggregate.getName()));
            }
            sb.append(String.format("  Total: %,d\n", inMemoryAggregatesCoveredByCurrentInDatabaseAggregate.size()));
            inMemoryAggregatesCoveredByHigherSortOrderInDatabaseAggregates.addAll(inMemoryAggregatesCoveredByCurrentInDatabaseAggregate);
        }
        if (sb.length() > 0) {
            ROLAPLog.log("ROLAPAggregateAdvisor", sb.toString());
        }
    }
}

