/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRequestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUnitTestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeRegion;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;

public class AdvisorTrace {
    private static final String NEW_LINE = "\n";
    private static final String PREFIX = "* ";
    private static final String BLOCK_HEADER_SEPARATOR = "*******************************************************************************\n";
    private static final int DEFAULT_BLOCK_HEADER_WIDTH = 100;
    private static final String MAJOR_HEADING_PADDING = "***";
    private static final String NAME_FORMAT = "%-40s";
    private static final String NAME_SEPARATOR = " - ";
    private static final String COMMASPACE_STR = ", ";
    private static final String CALCULATED_STR = "(calculated)";
    private static final int AGGREGATE_NAME_MINIMUM_LENGTH = 60;
    private static final String COLUMN_ADDITIVE = "Additive?";
    private static final String COLUMN_DIM_ID = "DimId";
    private static final String COLUMN_ID = "Id";
    private static final String COLUMN_DEPTH = "Depth";
    private static final String MEASURES_HEADING = "[Measures]";
    private static final double THOUSAND = 1000.0;
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#,##0.000s");
    private static final String TIME_STRING = "Time";
    private static String fmtd = "%-40s = %,d \n";
    private static String fmtb = "%-40s = %b \n";
    private static String fmts = "%-40s = %s \n";

    public static String heading(String text) {
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append(BLOCK_HEADER_SEPARATOR);
        sb.append(PREFIX + text + NEW_LINE);
        sb.append(BLOCK_HEADER_SEPARATOR);
        return sb.toString();
    }

    public static String majorHeading(String heading) {
        String title = String.format("     %s     ", heading);
        int titleWidth = Math.max(title.length(), 100) + 2;
        int padWidth = (titleWidth - title.length()) / 2;
        String titleLine = MAJOR_HEADING_PADDING + AdvisorTrace.pad("", padWidth) + title + AdvisorTrace.pad("", padWidth) + MAJOR_HEADING_PADDING;
        String blockHeaderSeparator = AdvisorTrace.pad("", titleLine.length());
        blockHeaderSeparator = blockHeaderSeparator.replace(' ', '*') + NEW_LINE;
        int padLen = titleLine.length() - MAJOR_HEADING_PADDING.length() - MAJOR_HEADING_PADDING.length();
        String blockHeaderSpacer = MAJOR_HEADING_PADDING + AdvisorTrace.pad("", padLen) + MAJOR_HEADING_PADDING + NEW_LINE;
        StringBuilder sb = new StringBuilder();
        sb.append(NEW_LINE);
        sb.append(NEW_LINE);
        sb.append(blockHeaderSeparator);
        sb.append(blockHeaderSeparator);
        sb.append(blockHeaderSpacer);
        sb.append(titleLine + NEW_LINE);
        sb.append(blockHeaderSpacer);
        sb.append(blockHeaderSeparator);
        sb.append(blockHeaderSeparator);
        return sb.toString();
    }

    public static String formatStringsAsString(List<String> strings, String delimiter) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = strings.iterator();
        while (iter.hasNext()) {
            String string = iter.next();
            sb.append(string);
            if (!iter.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String formatStringsAsList(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String formatMetadata(ROLAPMetaCube metaCube, AggregateAdvisor aggregateAdvisor) {
        StringBuilder sb = new StringBuilder();
        sb.append(AdvisorTrace.heading("Cube: " + metaCube.getName()));
        sb.append('\n');
        Aggregate cubeShape = new Aggregate(metaCube);
        int numNamedLevels = 0;
        int numAllLevels = 0;
        for (ROLAPMetaDimension dim : metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy rOLAPMetaHierarchy : metaCube.getHierarchies(dim)) {
                numNamedLevels += rOLAPMetaHierarchy.getLevels().length;
                if (!rOLAPMetaHierarchy.hasAllLevel()) continue;
                ++numAllLevels;
            }
        }
        sb.append("METRICS\n");
        String fmt = "%-30s %,15d \n";
        sb.append(String.format(fmt, "Dimensions", metaCube.getDimensions().length));
        sb.append(String.format(fmt, "Hierarchies", metaCube.getHierarchies().length));
        sb.append(String.format(fmt, "Levels", numNamedLevels + numAllLevels));
        sb.append(String.format(fmt, "Named levels", numNamedLevels));
        sb.append(String.format(fmt, "'All' levels", numAllLevels));
        sb.append(String.format(fmt, "Measures", metaCube.getMeasures().length));
        String fmtStrDouble = "%-30s %,15.0f \n";
        sb.append(String.format(fmtStrDouble, "Dimension slices ", cubeShape.getDimensionSliceId().getNumberOfCombinations()));
        sb.append(String.format(fmtStrDouble, "Hierarchy slices ", cubeShape.getSliceId().getNumberOfCombinations()));
        sb.append('\n');
        sb.append("PROPERTIES\n");
        String fmtPropertyStr = "%-40s %s \n";
        String fmtPropertyBool = "%-40s %b \n";
        sb.append(String.format(fmtPropertyStr, "Cube shape", cubeShape.getSliceId().rangeToString()));
        sb.append(String.format(fmtPropertyBool, "Autonomic", aggregateAdvisor.isCubeAutonomic()));
        sb.append(String.format(fmtPropertyBool, "Near real time support", metaCube.isNearRealTimeCube()));
        if (metaCube.isNearRealTimeCube()) {
            sb.append(String.format(fmtPropertyStr, "Fact transaction id query item", metaCube.getFactTransactionIDQueryItem()));
        }
        sb.append('\n');
        sb.append(String.format("%-40s %-40s %-10s \n", "DIMENSION", "HIERARCHY", "LEVELS"));
        for (ROLAPMetaObject rOLAPMetaObject : metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hier : metaCube.getHierarchies((ROLAPMetaDimension)rOLAPMetaObject)) {
                sb.append(String.format(NAME_FORMAT, rOLAPMetaObject.getName()));
                sb.append(' ');
                sb.append(String.format(NAME_FORMAT, hier.getName()));
                sb.append(" [");
                boolean first = true;
                ROLAPMetaLevel[] rOLAPMetaLevelArray = hier.getLevels();
                int n = rOLAPMetaLevelArray.length;
                for (int i = 0; i < n; ++i) {
                    ROLAPMetaLevel level = rOLAPMetaLevelArray[i];
                    if (first) {
                        first = false;
                    } else {
                        sb.append(COMMASPACE_STR);
                    }
                    sb.append(level.getName());
                    String type = level.getType();
                    if (type == null || type.equals("regular")) continue;
                    sb.append(" (" + type + ')');
                }
                sb.append("]");
                if (!hier.hasAllLevel()) {
                    sb.append(" (no 'all' level)");
                }
                if (hier.isRecursive()) {
                    sb.append(" (recursive hierarchy)");
                }
                if (((ROLAPMetaDimension)rOLAPMetaObject).isTimeDimension()) {
                    sb.append(" (time dimension)");
                }
                sb.append('\n');
            }
        }
        sb.append('\n');
        sb.append(String.format("%-40s %-40s %-20s \n", "MEASURE", "AGGREGATE TYPE", "QUERY ITEM"));
        for (ROLAPMetaObject rOLAPMetaObject : metaCube.getMeasures()) {
            FormatId metaMeasureFormatId;
            sb.append(String.format(NAME_FORMAT, rOLAPMetaObject.getName()));
            sb.append(' ');
            if (((ROLAPMetaMeasure)rOLAPMetaObject).getAggregationFunction().compareTo("calculated") != 0) {
                if (((ROLAPMetaMeasure)rOLAPMetaObject).getQueryItem() != null) {
                    sb.append(String.format(NAME_FORMAT, aggregateAdvisor.getAggregateType((ROLAPMetaMeasure)rOLAPMetaObject).toString()));
                    sb.append(' ');
                    sb.append(((ROLAPMetaMeasure)rOLAPMetaObject).getQueryItem());
                }
            } else {
                sb.append(CALCULATED_STR);
            }
            if (!((ROLAPMetaMeasure)rOLAPMetaObject).isVisible()) {
                sb.append(" (hidden)");
            }
            if (AdvisorUtils.isMeasureSemiAggregate((ROLAPMetaMeasure)rOLAPMetaObject)) {
                sb.append(" (semi-aggregate)");
            }
            if ((metaMeasureFormatId = ((ROLAPMetaMeasure)rOLAPMetaObject).getFormatId()) != null) {
                sb.append(String.format(" (formatId=%s)", metaMeasureFormatId));
            }
            sb.append('\n');
        }
        sb.append('\n');
        sb.append("LEVELS - PROPERTY DETAILS\n");
        sb.append('\n');
        for (ROLAPMetaObject rOLAPMetaObject : metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hier : metaCube.getHierarchies((ROLAPMetaDimension)rOLAPMetaObject)) {
                for (ROLAPMetaLevel level : hier.getLevels()) {
                    sb.append(String.format(NAME_FORMAT, "Name"));
                    sb.append(' ');
                    sb.append(String.format(NAME_FORMAT, level.getName()));
                    sb.append('\n');
                    sb.append(String.format(NAME_FORMAT, "Caption"));
                    if (level.getCaption() != null) {
                        sb.append(' ');
                        sb.append(String.format(NAME_FORMAT, level.getCaption().getName()));
                    }
                    sb.append('\n');
                    sb.append(String.format(NAME_FORMAT, "Business key"));
                    if (level.getBusinessKey() != null) {
                        sb.append(' ');
                        sb.append(String.format(NAME_FORMAT, level.getBusinessKey().getName()));
                    }
                    sb.append('\n');
                    List<ROLAPMetaAttribute> levelKeys = level.getLevelKeys();
                    for (ROLAPMetaAttribute levelKey : levelKeys) {
                        sb.append(String.format(NAME_FORMAT, "Level key"));
                        sb.append(' ');
                        sb.append(levelKey.getQueryItem());
                        sb.append('\n');
                    }
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }

    public static String formatHierarchyCardinalities(CubeCardinalityMetrics cubeCardinalityMetrics) {
        StringBuilder sb = new StringBuilder();
        sb.append(AdvisorTrace.heading("Hierarchy cardinalities"));
        ROLAPMetaCube metaCube = cubeCardinalityMetrics.getMetaCube();
        for (ROLAPMetaDimension dim : metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hier : metaCube.getHierarchies(dim)) {
                sb.append(String.format(NAME_FORMAT, hier.getName()));
                long cardinality = cubeCardinalityMetrics.getHierarchyMemberCount(hier);
                sb.append(String.format("%,15d ", cardinality));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static String formatLevelCardinalities(CubeCardinalityMetrics cubeCardinalityMetrics) {
        StringBuilder sb = new StringBuilder();
        sb.append(AdvisorTrace.heading("Level cardinalities"));
        ROLAPMetaCube metaCube = cubeCardinalityMetrics.getMetaCube();
        for (ROLAPMetaDimension dim : metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hier : metaCube.getHierarchies(dim)) {
                sb.append('\n');
                sb.append("Dimension: " + dim.getName() + '\n');
                sb.append("Hierarchy: " + hier.getName() + '\n');
                sb.append("Levels: \n");
                for (ROLAPMetaLevel level : hier.getLevels()) {
                    sb.append(String.format(NAME_FORMAT, level.getName()));
                    if (!hier.isRecursive()) {
                        long cardinality = cubeCardinalityMetrics.getLevelCardinality(dim.getName(), hier.getName(), level.getName());
                        sb.append(String.format("%,15d", cardinality));
                    } else {
                        sb.append("n/a");
                    }
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }

    public static String formatSliceCardinalities(CubeCardinalityMetrics cubeCardinalityMetrics) {
        StringBuilder sb = new StringBuilder();
        List<SliceCombination> sliceIds = cubeCardinalityMetrics.getSliceCardinalityIds();
        String msg = String.format("Slice cardinalities: %d elements", sliceIds.size());
        sb.append(AdvisorTrace.heading(msg));
        if (!sliceIds.isEmpty()) {
            SliceCombination sliceId = sliceIds.get(0);
            int sliceIdWidth = sliceId.valueToString().length();
            String sliceIdFormat = AdvisorTrace.getSliceIdFormatString(sliceIdWidth);
            String fmt = sliceIdFormat + "  %5s  %5s  %15s  %15s  %15s  %10s  %10s \n";
            sb.append(String.format(fmt, "Slice id", TIME_STRING, COLUMN_DEPTH, "Actual", "Smart estimate", "Sample estimate", "Actual/Est", "Slice/Fact"));
        }
        long factRows = cubeCardinalityMetrics.getFactCardinality();
        for (SliceCombination sliceId : sliceIds) {
            int timeLevel = -1;
            int samplingHierarchyIndex = cubeCardinalityMetrics.getSamplingHierarchyIndex();
            if (samplingHierarchyIndex >= 0) {
                timeLevel = sliceId.getValue(samplingHierarchyIndex);
            }
            double sliceToFactRatio = AdvisorUtils.getRatio(cubeCardinalityMetrics.getSliceCardinality(sliceId), factRows);
            double actualToEstimatedRatio = AdvisorUtils.getRatio(cubeCardinalityMetrics.getActualSliceCardinality(sliceId), cubeCardinalityMetrics.getEstimatedSliceCardinality(sliceId));
            sb.append(String.format("%s  %5d  %5d  %,15d  %,15d  %,15d  %10.4f  %10.4f \n", sliceId.valueToString(), timeLevel, sliceId.getNumberOfTurns(), cubeCardinalityMetrics.getActualSliceCardinality(sliceId), cubeCardinalityMetrics.getExtrapolatedSliceCardinality(sliceId), cubeCardinalityMetrics.getEstimatedSliceCardinality(sliceId), actualToEstimatedRatio, sliceToFactRatio));
        }
        return sb.toString();
    }

    public static String formatRequestParameters(AdvisorRequestParameters requestParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(fmtb, "Consider workload", requestParameters.getIncludeWorkloadInfo()));
        sb.append(String.format(fmtb, "Analyze workload only", requestParameters.getUseWorkloadOnly()));
        sb.append(String.format(fmtb, "Recommend user defined aggregates only", requestParameters.getUserDefinedAggregatesOnly()));
        sb.append(String.format(fmts, "Start time", requestParameters.getStartTime().toString()));
        sb.append(String.format(fmts, "End time", requestParameters.getEndTime().toString()));
        sb.append(String.format(fmtd, "Top N reports", requestParameters.getReportUsage()));
        sb.append(String.format(fmts, "User names", requestParameters.getUserNames()));
        sb.append(String.format(fmts, "Report names", requestParameters.getReportNames()));
        sb.append(String.format(fmts, "Package names", requestParameters.getPackageNames()));
        sb.append(String.format(fmtd, "Run time limit (minutes)", requestParameters.getRunTimeLimit()));
        sb.append(String.format(fmtd, "In memory aggregate space", requestParameters.getInMemoryAggregatesLimit()));
        sb.append(String.format(fmtd, "In database aggregate space", requestParameters.getInDatabaseAggregatesLimit()));
        sb.append(String.format(fmtd, "In memory aggregate count", requestParameters.getMaxNumberOfInMemoryAggregates()));
        sb.append(String.format(fmtd, "In database aggregate count", requestParameters.getMaxNumberOfInDatabaseAggregates()));
        sb.append(String.format(fmtd, "# of workload queries to consider", requestParameters.getMaxWorkloadQueriesToConsider()));
        sb.append(String.format(fmtb, "Include all additive measures", requestParameters.getIncludeAllAdditiveMeasures()));
        sb.append(String.format(fmtb, "Exclude non-additive measures", requestParameters.isExcludeNonAdditiveMeasures()));
        sb.append(String.format(fmtb, "In-memory aggs must match in-db aggs", requestParameters.isInMemoryAggregatesMustMatchInDatabaseAggregates()));
        sb.append(String.format(fmtb, "Enable test features", requestParameters.isEnableTestFeatures()));
        sb.append(String.format(fmtd, "In-memory aggregate cells", requestParameters.getMaxNumberOfInMemoryAggregateCells()));
        return sb.toString();
    }

    public static String formatUnitTestParameters(AdvisorUnitTestParameters unitTestParameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(fmtb, "Model provided", unitTestParameters.getModel() != null));
        sb.append(String.format(fmtb, "Workload provided", unitTestParameters.getWorkloadSummary() != null));
        sb.append(String.format(fmts, "Workload directory", unitTestParameters.getWorkloadDirectory()));
        int numAggregateLoadInfo = 0;
        if (unitTestParameters.getAggregateLoadSummary() != null) {
            numAggregateLoadInfo = unitTestParameters.getAggregateLoadSummary().size();
        }
        sb.append(String.format(fmtd, "# of loaded in-memory aggregates", numAggregateLoadInfo));
        sb.append(String.format(fmtd, "# of existing database aggregates", unitTestParameters.getExistingDatabaseAggregates().size()));
        sb.append(String.format(fmtd, "# of desired database aggregates", unitTestParameters.getDesiredDatabaseAggregates().size()));
        sb.append(String.format(fmtd, "# of user defined aggregates", unitTestParameters.getUserDefinedAggregates().size()));
        return sb.toString();
    }

    public static String formatQuerySummary(QuerySummaryInfoLog querySummaryInfoLog) {
        StringBuilder sb = new StringBuilder();
        List<QuerySummaryInfo> querySummaryInfos = querySummaryInfoLog.getQuerySummaryInfos();
        long totalExecutionCount = 0L;
        double totalWeightedExecutionCount = 0.0;
        for (QuerySummaryInfo querySummaryInfo : querySummaryInfos) {
            totalExecutionCount += (long)querySummaryInfo.getExecutionCount();
            totalWeightedExecutionCount += querySummaryInfo.getWeightedExecutionCount();
        }
        sb.append(String.format("\n\nQuery summary collection: %d queries across %d unique slices (weighted query count = %,.2f) \n\n", totalExecutionCount, querySummaryInfos.size(), totalWeightedExecutionCount));
        sb.append(String.format("%15s %15s %15s %s\n", " Count", "Weighted Count", TIME_STRING, "Levels / Measures"));
        for (QuerySummaryInfo querySummaryInfo : querySummaryInfos) {
            sb.append(String.format("%,15d %,15.2f %,15d ", querySummaryInfo.getExecutionCount(), querySummaryInfo.getWeightedExecutionCount(), querySummaryInfo.getExecutionTime()));
            sb.append("[");
            for (String levelName : querySummaryInfo.getLevelNames()) {
                if (levelName == null) continue;
                sb.append(levelName + NAME_SEPARATOR);
            }
            sb.delete(sb.length() - NAME_SEPARATOR.length(), sb.length());
            sb.append(']');
            sb.append("  Measures = [");
            for (String measureName : querySummaryInfo.getMeasureNames()) {
                sb.append(String.format("%s (%d), ", measureName, querySummaryInfo.getMeasureHitCount(measureName)));
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append(']');
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String formatQueryCoverage(List<Aggregate> sliceUsageAggregates, List<Aggregate> aggregates) {
        StringBuilder sb = new StringBuilder();
        sb.append(AdvisorTrace.heading("Logical query slice coverage"));
        if (sliceUsageAggregates.size() > 0) {
            int sliceIdWidth = sliceUsageAggregates.get(0).getSliceId().valueToString().length();
            String sliceIdFormat = AdvisorTrace.getSliceIdFormatString(sliceIdWidth);
            String fmt = "%15s  %-11s  %-12s  " + sliceIdFormat + "  %s \n";
            sb.append(String.format(fmt, "Queries", "Covered?", COLUMN_ADDITIVE, COLUMN_ID, AdvisorTrace.pad("Slice name ", 60) + MEASURES_HEADING));
        }
        for (Aggregate querySlice : sliceUsageAggregates) {
            Aggregate aggregate;
            boolean covered = false;
            Iterator<Aggregate> iterator = aggregates.iterator();
            while (iterator.hasNext() && !(covered = (aggregate = iterator.next()).isCovered(querySlice, true))) {
            }
            SliceCombination sliceId = querySlice.getSliceId();
            sb.append(String.format("%,15d  %-11s  %-12s  %s  %s \n", querySlice.getWorkloadHitCount(), AdvisorTrace.getCoveredStatus(covered), querySlice.getAdditiveStatus(), sliceId.valueToString(), AdvisorTrace.formatAggregateNameAndMeasures(querySlice)));
        }
        return sb.toString();
    }

    private static String getCoveredStatus(boolean covered) {
        String status = "";
        status = covered ? "Covered" : "Not covered";
        return status;
    }

    public static String toTraceString(List<Aggregate> aggregates) {
        return AdvisorTrace.formatAggregates(aggregates);
    }

    public static String formatQueries(List<Aggregate> queries) {
        StringBuilder sb = new StringBuilder();
        if (queries.size() > 0) {
            int dimIdWidth = AdvisorTrace.formatDimensionSliceIdAsString(queries.get(0)).length();
            String dimIdFormat = AdvisorTrace.getSliceIdFormatString(dimIdWidth);
            int sliceIdWidth = queries.get(0).getSliceId().valueToString().length();
            String sliceIdFormat = AdvisorTrace.getSliceIdFormatString(sliceIdWidth);
            String fmt = "%15s  " + dimIdFormat + ' ' + ' ' + sliceIdFormat + "  %5s  %s   \n";
            sb.append(String.format(fmt, "Hits", COLUMN_DIM_ID, COLUMN_ID, COLUMN_DEPTH, AdvisorTrace.pad("Query name", 60) + MEASURES_HEADING));
            long hits = 0L;
            for (Aggregate query : queries) {
                SliceCombination sliceId = query.getSliceId();
                sb.append(String.format("%,15d  %s  %s  %5s  %s \n", query.getHitCount(), AdvisorTrace.formatDimensionSliceIdAsString(query), sliceId.valueToString(), sliceId.getNumberOfTurns(), AdvisorTrace.formatAggregateNameAndMeasures(query)));
                hits += (long)query.getHitCount();
            }
            sb.append(String.format("%d queries spread over %d unique slices", hits, queries.size()));
        } else {
            sb.append("<No queries> \n");
        }
        return sb.toString();
    }

    public static String formatAggregates(List<Aggregate> aggregates) {
        StringBuilder sb = new StringBuilder();
        if (aggregates.size() > 0) {
            int dimIdWidth = AdvisorTrace.formatDimensionSliceIdAsString(aggregates.get(0)).length();
            String dimIdFormat = AdvisorTrace.getSliceIdFormatString(dimIdWidth);
            int sliceIdWidth = aggregates.get(0).getSliceId().valueToString().length();
            String sliceIdFormat = AdvisorTrace.getSliceIdFormatString(sliceIdWidth);
            String fmt = "%15s  %15s  %15s  %5s  %-10s  %-12s  " + dimIdFormat + ' ' + ' ' + sliceIdFormat + "  %5s  %s \n";
            sb.append(String.format(fmt, "Rows", "Cells", "Size", "LogCd", "Source", COLUMN_ADDITIVE, COLUMN_DIM_ID, COLUMN_ID, COLUMN_DEPTH, AdvisorTrace.pad("Aggregate name", 60) + MEASURES_HEADING));
            long rows = 0L;
            long cells = 0L;
            long size = 0L;
            for (Aggregate aggregate : aggregates) {
                SliceCombination sliceId = aggregate.getSliceId();
                AggregateAdvisor aggregateAdvisor = aggregate.getAggregateAdvisor();
                double logarithmicCardinality = 0.0;
                if (aggregateAdvisor != null) {
                    logarithmicCardinality = aggregateAdvisor.getLogarithmicCardinality(aggregate);
                }
                sb.append(String.format("%,15d  %,15d  %,15d  %5.1f  %-10s  %-12s  %s  %s  %5s  %s \n", new Object[]{aggregate.getCardinality(), aggregate.getNumberOfCells(), aggregate.getEstimatedSize(), logarithmicCardinality, aggregate.getRecommendedBy(), aggregate.getAdditiveStatus(), AdvisorTrace.formatDimensionSliceIdAsString(aggregate), sliceId.valueToString(), sliceId.getNumberOfTurns(), AdvisorTrace.formatAggregateNameAndMeasures(aggregate)}));
                rows += aggregate.getCardinality();
                cells += aggregate.getNumberOfCells();
                size += aggregate.getEstimatedSize();
            }
            sb.append(String.format("%,15d  %,15d  %,15d  %5s  %10s  %12s  " + dimIdFormat + ' ' + ' ' + sliceIdFormat + "  %5s  %s  \n", rows, cells, size, "", "", "", "", "", "", "TOTAL - # OF AGGREGATES = " + aggregates.size()));
        } else {
            sb.append("<No aggregates> \n");
        }
        return sb.toString();
    }

    public static String formatDimensionSliceIdAsString(Aggregate aggregate) {
        ROLAPMetaCube metaCube = aggregate.getMetaCube();
        SliceCombination sliceId = aggregate.getSliceId();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int hierarchyIndex = -1;
        for (ROLAPMetaDimension dimension : metaCube.getDimensions()) {
            int maxDepth = 0;
            int currDepth = 0;
            int numHierarchies = metaCube.getHierarchies(dimension).length;
            for (int count = 1; count <= numHierarchies; ++count) {
                maxDepth += sliceId.getMaximum(++hierarchyIndex) - sliceId.getMinimum(hierarchyIndex);
                currDepth += sliceId.getValue(hierarchyIndex) - sliceId.getMinimum(hierarchyIndex);
            }
            if (currDepth == 0) {
                sb.append('0');
                continue;
            }
            if (currDepth == maxDepth) {
                sb.append('1');
                continue;
            }
            sb.append('*');
        }
        sb.append(']');
        return sb.toString();
    }

    private static String formatAggregateNameAndMeasures(Aggregate aggregate) {
        String aggregateName = aggregate.getName();
        String aggregateNameMeasureNames = aggregateName.length() < 60 ? AdvisorTrace.pad(aggregateName, 60) : aggregateName + "  ";
        List<String> measureNames = AdvisorUtils.getMeasureNames(aggregate.getMeasures());
        aggregateNameMeasureNames = aggregateNameMeasureNames + measureNames;
        return aggregateNameMeasureNames;
    }

    public static String sliceUsageToTraceString(List<Aggregate> sliceUsageCollection) {
        StringBuilder sb = new StringBuilder();
        if (sliceUsageCollection.size() > 0) {
            int totalCount = 0;
            long totalQueryExecutionTime = 0L;
            sb.append(String.format("%15s  %15s  %s  \n", "Count", TIME_STRING, "Slice name"));
            for (Aggregate sliceUsage : sliceUsageCollection) {
                sb.append(String.format("%,15d  %15s  %s  \n", sliceUsage.getWorkloadHitCount(), TIME_FORMAT.format((double)sliceUsage.getWorkloadQueryExecutionTime() / 1000.0), sliceUsage.getName()));
                totalCount += sliceUsage.getWorkloadHitCount();
                totalQueryExecutionTime += sliceUsage.getWorkloadQueryExecutionTime();
            }
            sb.append(String.format("%,15d  %15s  %s   \n", totalCount, TIME_FORMAT.format((double)totalQueryExecutionTime / 1000.0), "TOTAL - # OF SLICES = " + sliceUsageCollection.size()));
        } else {
            sb.append("<No query slice information> \n");
        }
        return sb.toString();
    }

    public static String cubeRegionToTraceString(ROLAPMetaCube metaCube, CubeRegion region) {
        StringBuilder sb = new StringBuilder();
        String fmt = "Dimension = %s; hierarchy = %s; level = %s; selected = %s\n";
        for (ROLAPMetaDimension dimension : metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : metaCube.getHierarchies(dimension)) {
                Boolean selected;
                if (hierarchy.hasAllLevel()) {
                    selected = region.isSelected(dimension.getName(), hierarchy.getName(), "[All]");
                    sb.append(String.format(fmt, dimension.getName(), hierarchy.getName(), "[All]", selected.toString()));
                } else if (hierarchy.isRecursive()) {
                    selected = region.isSelected(dimension.getName(), hierarchy.getName(), "[Root]");
                    sb.append(String.format(fmt, dimension.getName(), hierarchy.getName(), "[Root]", selected.toString()));
                }
                if (hierarchy.isRecursive()) continue;
                for (ROLAPMetaLevel level : hierarchy.getLevels()) {
                    Boolean selected2 = region.isSelected(dimension.getName(), hierarchy.getName(), level.getName());
                    sb.append(String.format(fmt, dimension.getName(), hierarchy.getName(), level.getName(), selected2.toString()));
                }
            }
        }
        return sb.toString();
    }

    public static String formatAggregateCoverageAnalysis(List<Aggregate> upperAggregates, List<Aggregate> lowerAggregates, AggregateAdvisor aggregateAdvisor) {
        StringBuilder sb = new StringBuilder();
        if (upperAggregates.isEmpty()) {
            return sb.toString();
        }
        int totalDepthDelta = 0;
        long totalRowDelta = 0L;
        String fmt = "%s %3d %,15d %s\n";
        for (Aggregate upperAggregate : upperAggregates) {
            int currDepthDelta = 0;
            long currRowDelta = 0L;
            double currRowRatio = 0.0;
            Aggregate matchingAggregate = aggregateAdvisor.determineAggregateThatWillBeMatched(upperAggregate, lowerAggregates);
            sb.append('\n');
            if (matchingAggregate != null) {
                sb.append(String.format(fmt, upperAggregate.getSliceId().valueToString(), upperAggregate.getSliceId().getNumberOfTurns(), upperAggregate.getCardinality(), upperAggregate.getName()));
                sb.append(String.format(fmt, matchingAggregate.getSliceId().valueToString(), matchingAggregate.getSliceId().getNumberOfTurns(), matchingAggregate.getCardinality(), matchingAggregate.getName()));
                currDepthDelta = matchingAggregate.getSliceId().getNumberOfTurns() - upperAggregate.getSliceId().getNumberOfTurns();
                currRowDelta = Math.max(matchingAggregate.getCardinality() - upperAggregate.getCardinality(), 0L);
                currRowRatio = 1.0 * (double)matchingAggregate.getCardinality() / (double)upperAggregate.getCardinality();
            } else {
                SliceCombination bottomSlice = upperAggregate.getSliceId();
                bottomSlice.last();
                sb.append(String.format(fmt, upperAggregate.getSliceId().valueToString(), upperAggregate.getSliceId().getNumberOfTurns(), upperAggregate.getCardinality(), upperAggregate.getName()));
                sb.append(String.format(fmt, bottomSlice.valueToString(), bottomSlice.getNumberOfTurns(), aggregateAdvisor.getFactRowCount(), "[Base tables]"));
                currDepthDelta = bottomSlice.getNumberOfTurns();
                currRowDelta = Math.max(aggregateAdvisor.getFactRowCount() - upperAggregate.getCardinality(), 0L);
                currRowRatio = 1.0 * (double)aggregateAdvisor.getFactRowCount() / (double)upperAggregate.getCardinality();
            }
            sb.append(String.format("Depth delta = %,d, Row delta = %,d, Row ratio = %,.1f\n", currDepthDelta, currRowDelta, currRowRatio));
            totalDepthDelta += currDepthDelta;
            totalRowDelta += currRowDelta;
        }
        double avgDepthDelta = 1.0 * (double)totalDepthDelta / (double)upperAggregates.size();
        long avgRowDelta = totalRowDelta / (long)upperAggregates.size();
        sb.insert(0, String.format("Coverage metrics: avg depth delta=%.1f, avg row delta=%,d \n", avgDepthDelta, avgRowDelta));
        sb.insert(0, "\nMapping from upper aggregates to those they are derived from.\n");
        return sb.toString();
    }

    private static String getSliceIdFormatString(int sliceIdWidth) {
        return AdvisorTrace.getFormatString(sliceIdWidth);
    }

    private static String pad(String string, int length) {
        String fmt = AdvisorTrace.getFormatString(length);
        String paddedString = String.format(fmt, string);
        return paddedString;
    }

    private static String getFormatString(int width) {
        return "%-" + width + "s";
    }
}

