/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Advisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.QueryHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import java.util.ArrayList;
import java.util.List;

public class AdvisorUtils {
    public static final double HUNDRED = 100.0;
    private static final String UNIQUE_NAME_TEMPLATE = "[$DIMENSION].[$HIERARCHY].[$LEVEL]";
    private static final String DIMENSION_TOKEN = "$DIMENSION";
    private static final String HIERARCHY_TOKEN = "$HIERARCHY";
    private static final String LEVEL_TOKEN = "$LEVEL";

    public static long getFactCardinality(Advisor advisor, ROLAPMetaCube metaCube, ROLAPMetaMeasure measure) throws OperationCanceledException {
        long rows = 0L;
        QueryHelper.CountFactQuerySetBuilder querySetBuilder = new QueryHelper.CountFactQuerySetBuilder(metaCube.getName(), new String[]{measure.getName(), measure.getQueryItem()});
        rows = QueryHelper.getCellValueForExecutedV5QuerySet(advisor, metaCube.getName(), querySetBuilder);
        return rows;
    }

    public static long getLevelCardinality(Advisor advisor, ROLAPMetaCube metaCube, ROLAPMetaHierarchy aHierarchy, ROLAPMetaLevel aLevel) throws OperationCanceledException {
        ArrayList<String[]> dataItemsInfo;
        long rows = 0L;
        if (aHierarchy != null && aLevel != null) {
            if (aHierarchy.isRecursive()) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_LevelCardinalityNotSupportedForPCH_INTERNAL, UNIQUE_NAME_TEMPLATE.replace(DIMENSION_TOKEN, aHierarchy.getParent().getName()).replace(HIERARCHY_TOKEN, aHierarchy.getName()).replace(LEVEL_TOKEN, aLevel.getName()));
            }
            dataItemsInfo = new ArrayList<String[]>();
            List<ROLAPMetaAttribute> attributes = aLevel.getLevelKeys();
            for (ROLAPMetaAttribute attr : attributes) {
                dataItemsInfo.add(new String[]{attr.getName(), attr.getQueryItem()});
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.ROL_NeedHierarchyAndLevelForLevelCardinality_INTERNAL);
        }
        QueryHelper.CountLevelMembersQuerySetBuilder querySetBuilder = new QueryHelper.CountLevelMembersQuerySetBuilder(metaCube.getName(), aLevel.getName(), dataItemsInfo);
        rows = QueryHelper.getCellValueForExecutedV5QuerySet(advisor, metaCube.getName(), querySetBuilder);
        return rows;
    }

    public static long getSliceCardinality(Advisor advisor, ROLAPMetaCube metaCube, List<ROLAPMetaLevel> slice, ROLAPMetaMeasure measure, List<String> filters) throws OperationCanceledException {
        long rows = 0L;
        boolean isTopSlice = true;
        ArrayList<String[]> dataItemsInfo = new ArrayList<String[]>();
        for (ROLAPMetaLevel level : slice) {
            if (level == null) continue;
            List<ROLAPMetaAttribute> attributes = level.getLevelKeys();
            for (ROLAPMetaAttribute attr : attributes) {
                String qualName = ROLAPQuery.createUniqueDataItemName(dataItemsInfo, attr);
                dataItemsInfo.add(new String[]{qualName, attr.getQueryItem()});
            }
            isTopSlice = false;
        }
        if (!isTopSlice) {
            QueryHelper.CountAggregateResultQuerySetBuilder querySetBuilder = new QueryHelper.CountAggregateResultQuerySetBuilder(dataItemsInfo, new String[]{measure.getName(), measure.getQueryItem()}, filters);
            rows = QueryHelper.getCellValueForExecutedV5QuerySet(advisor, metaCube.getName(), querySetBuilder);
        } else {
            rows = 1L;
        }
        return rows;
    }

    public static double getPercentage(long number1, long number2) {
        double pct = 0.0;
        if (number2 != 0L) {
            pct = 100.0 * (double)number1 / (double)number2;
        }
        return pct;
    }

    public static double getPercentage(double number1, double number2) {
        double pct = 0.0;
        if (number2 != 0.0) {
            pct = 100.0 * number1 / number2;
        }
        return pct;
    }

    public static double getRatio(long number1, long number2) {
        double ratio = 0.0;
        if (number2 != 0L) {
            ratio = 1.0 * (double)number1 / (double)number2;
        }
        return ratio;
    }

    public static int getHierarchyIndex(ROLAPMetaCube metaCube, String aDimensionName, String aHierarchyName) {
        int hierarchyIndex = -1;
        for (ROLAPMetaDimension dimension : metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : metaCube.getHierarchies(dimension)) {
                ++hierarchyIndex;
                if (dimension.getName().compareTo(aDimensionName) != 0 || hierarchy.getName().compareTo(aHierarchyName) != 0) continue;
                return hierarchyIndex;
            }
        }
        return -1;
    }

    public static int getLevelIndex(ROLAPMetaHierarchy hierarchy, String aLevelName) {
        int levelIndex = -1;
        for (ROLAPMetaLevel level : hierarchy.getLevels()) {
            ++levelIndex;
            if (level.getName().compareTo(aLevelName) != 0) continue;
            return levelIndex;
        }
        return -1;
    }

    public static ROLAPMetaDimension getMetaDimension(ROLAPMetaCube metaCube, String dimensionName) {
        ROLAPMetaDimension[] metaDimensions;
        for (ROLAPMetaDimension metaDimension : metaDimensions = metaCube.getDimensions()) {
            if (!metaDimension.getName().equals(dimensionName)) continue;
            return metaDimension;
        }
        return null;
    }

    public static ROLAPMetaHierarchy getMetaHierarchy(ROLAPMetaCube metaCube, String dimensionName, String hierarchyName) {
        ROLAPMetaDimension metaDimension = AdvisorUtils.getMetaDimension(metaCube, dimensionName);
        if (metaDimension != null) {
            ROLAPMetaHierarchy[] metaHierarchies;
            for (ROLAPMetaHierarchy metaHierarchy : metaHierarchies = metaCube.getHierarchies(metaDimension)) {
                if (!metaHierarchy.getName().equals(hierarchyName)) continue;
                return metaHierarchy;
            }
        }
        return null;
    }

    public static ROLAPMetaLevel getMetaLevel(ROLAPMetaCube metaCube, String dimensionName, String hierarchyName, String levelName) {
        ROLAPMetaHierarchy metaHierarchy = AdvisorUtils.getMetaHierarchy(metaCube, dimensionName, hierarchyName);
        if (metaHierarchy == null) {
            return null;
        }
        return metaHierarchy.getLevel(levelName);
    }

    public static ROLAPMetaMeasure getMetaMeasure(ROLAPMetaCube metaCube, String measureName) {
        ROLAPMetaMeasure[] metaMeasures;
        for (ROLAPMetaMeasure metaMeasure : metaMeasures = metaCube.getMeasures()) {
            if (!metaMeasure.getName().equals(measureName)) continue;
            return metaMeasure;
        }
        return null;
    }

    public static int getLevelDepth(ROLAPMetaHierarchy hierarchy, String levelName) {
        if (!AdvisorUtils.isRegularLevel(levelName)) {
            return 0;
        }
        int levelDepth = AdvisorUtils.getLevelIndex(hierarchy, levelName);
        if (levelDepth >= 0 && hierarchy.hasAllLevel()) {
            ++levelDepth;
        }
        return levelDepth;
    }

    public static List<String> getMeasureNames(List<ROLAPMetaMeasure> measures) {
        ArrayList<String> measureNames = new ArrayList<String>();
        for (ROLAPMetaMeasure measure : measures) {
            measureNames.add(measure.getName());
        }
        return measureNames;
    }

    public static boolean isRegularLevel(String levelName) {
        return !"[All]".equals(levelName) && !"[Root]".equals(levelName);
    }

    public static boolean isMeasureSemiAggregate(ROLAPMetaMeasure measure) {
        ROLAPMetaAggregation[] aggregations;
        if (measure.isCalculated()) {
            return false;
        }
        for (ROLAPMetaAggregation aggregation : aggregations = measure.getAggregations()) {
            ROLAPMetaDimension[] dimensions = aggregation.getDimensions();
            if (dimensions.length <= 0) continue;
            return true;
        }
        return false;
    }

    public static String getNameOfTopLevel(ROLAPMetaHierarchy hierarchy) {
        String levelName = "";
        levelName = hierarchy.isRecursive() ? (hierarchy.hasAllLevel() ? "[All]" : "[Root]") : (hierarchy.hasAllLevel() ? "[All]" : hierarchy.getLevels()[0].getName());
        return levelName;
    }

    public static String getNameOfBottomLevel(ROLAPMetaHierarchy hierarchy) {
        String levelName = "";
        if (hierarchy.isRecursive()) {
            levelName = hierarchy.hasAllLevel() ? "[All]" : "[Root]";
        } else {
            ROLAPMetaLevel level = hierarchy.getLevels()[hierarchy.getLevels().length - 1];
            levelName = level.getName();
        }
        return levelName;
    }
}

