/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import java.util.Random;

public class Combination {
    private int numPositions = 0;
    private int[] minimums = null;
    private int[] maximums = null;
    private int[] values = null;
    private boolean eof = false;

    public void setNumPositions(int pNumPositions) {
        if (pNumPositions < 0) {
            throw new IllegalArgumentException("Number of positions is negative");
        }
        this.numPositions = 0;
        this.minimums = null;
        this.maximums = null;
        this.values = null;
        if (pNumPositions >= 0) {
            this.numPositions = pNumPositions;
            this.minimums = new int[pNumPositions];
            this.maximums = new int[pNumPositions];
            this.values = new int[pNumPositions];
            for (int position = 0; position < pNumPositions; ++position) {
                this.minimums[position] = 0;
                this.maximums[position] = 0;
                this.values[position] = 0;
            }
        }
        this.first();
    }

    public int getNumPositions() {
        return this.numPositions;
    }

    public void setMinimum(int position, int newMinimum) {
        if (newMinimum > this.maximums[position]) {
            String msg = newMinimum + " greater than maximum " + this.maximums[position];
            throw new IllegalArgumentException(msg);
        }
        this.minimums[position] = newMinimum;
        if (this.values[position] < newMinimum) {
            this.values[position] = newMinimum;
        }
    }

    public void setMaximum(int position, int newMaximum) {
        if (newMaximum < this.minimums[position]) {
            String msg = newMaximum + " less than minimum " + this.minimums[position];
            throw new IllegalArgumentException(msg);
        }
        this.maximums[position] = newMaximum;
        if (this.values[position] > newMaximum) {
            this.values[position] = newMaximum;
        }
    }

    public void setValue(int position, int newValue) {
        if (newValue < this.minimums[position] || newValue > this.maximums[position]) {
            String fmt = "Position %d specified as %d which isn't in the range %d to %d";
            String msg = String.format(fmt, position, newValue, this.minimums[position], this.maximums[position]);
            throw new IllegalArgumentException(msg);
        }
        this.values[position] = newValue;
    }

    public void setValues(String newValues) {
        if (!newValues.startsWith("(") || !newValues.endsWith(")")) {
            throw new IllegalArgumentException("Format is (n,...,n)");
        }
        String excludeParenthesis = newValues.substring(1, newValues.length() - 1);
        String[] numbers = excludeParenthesis.split(",");
        if (numbers.length != this.numPositions) {
            String msg = String.format("%s does not have %d numbers", newValues, this.numPositions);
            throw new IllegalArgumentException(msg);
        }
        for (int position = 0; position < this.numPositions; ++position) {
            int value = Integer.valueOf(numbers[position]);
            this.setValue(position, value);
        }
    }

    public int getMinimum(int position) {
        return this.minimums[position];
    }

    public int getMaximum(int position) {
        return this.maximums[position];
    }

    public int getValue(int position) {
        return this.values[position];
    }

    public int getNumberOfValues() {
        int numberOfValuesForAllPositions = 0;
        for (int position = 0; position < this.numPositions; ++position) {
            numberOfValuesForAllPositions += this.getNumberOfValuesAtPosition(position);
        }
        return numberOfValuesForAllPositions;
    }

    private int getNumberOfValuesAtPosition(int position) {
        return this.maximums[position] - this.minimums[position] + 1;
    }

    public int getNumberOfTurns() {
        int numberOfTurns = 0;
        for (int position = 0; position < this.numPositions; ++position) {
            numberOfTurns += this.values[position] - this.minimums[position];
        }
        return numberOfTurns;
    }

    public int getMaxNumberOfTurns() {
        int numberOfTurns = 0;
        for (int position = 0; position < this.numPositions; ++position) {
            numberOfTurns += this.maximums[position] - this.minimums[position];
        }
        return numberOfTurns;
    }

    public double getNumberOfCombinations() {
        double numberOfCombinations = 1.0;
        if (this.numPositions == 0) {
            return 0.0;
        }
        for (int position = 0; position < this.numPositions; ++position) {
            numberOfCombinations *= (double)this.getNumberOfValuesAtPosition(position);
        }
        return numberOfCombinations;
    }

    public double getNumberOfCombinationsCovered() {
        double numberOfCombinationsCovered = 1.0;
        if (this.numPositions == 0) {
            return 0.0;
        }
        for (int position = 0; position < this.numPositions; ++position) {
            int numValuesCoveredAtPosition = this.values[position] - this.minimums[position] + 1;
            numberOfCombinationsCovered *= (double)numValuesCoveredAtPosition;
        }
        return numberOfCombinationsCovered;
    }

    public boolean isEqual(Combination otherCombination) {
        if (this.numPositions != otherCombination.getNumPositions()) {
            return false;
        }
        for (int position = 0; position < this.numPositions; ++position) {
            if (this.values[position] == otherCombination.getValue(position)) continue;
            return false;
        }
        return true;
    }

    public boolean isRangeEqual(Combination otherCombination) {
        if (this.numPositions != otherCombination.getNumPositions()) {
            return false;
        }
        for (int position = 0; position < this.numPositions; ++position) {
            if (this.minimums[position] == otherCombination.getMinimum(position) && this.maximums[position] == otherCombination.getMaximum(position)) continue;
            return false;
        }
        return true;
    }

    public boolean isCovered(Combination otherCombination) {
        if (this.numPositions != otherCombination.getNumPositions()) {
            return false;
        }
        for (int position = 0; position < this.numPositions; ++position) {
            if (this.values[position] >= otherCombination.getValue(position)) continue;
            return false;
        }
        return true;
    }

    public boolean isSliceWithinRegion(Combination otherCombination) {
        if (this.numPositions != otherCombination.getNumPositions()) {
            return false;
        }
        for (int position = 0; position < this.numPositions; ++position) {
            if (otherCombination.getValue(position) >= this.minimums[position] && otherCombination.getValue(position) <= this.maximums[position]) continue;
            return false;
        }
        return true;
    }

    public boolean isRegionWithinRegion(Combination otherCombination) {
        if (this.numPositions != otherCombination.getNumPositions()) {
            return false;
        }
        for (int position = 0; position < this.numPositions; ++position) {
            if (otherCombination.getMinimum(position) >= this.minimums[position] && otherCombination.getMaximum(position) <= this.maximums[position]) continue;
            return false;
        }
        return true;
    }

    public void copy(Combination otherCombination) {
        if (null != otherCombination) {
            this.setNumPositions(otherCombination.getNumPositions());
            for (int position = 0; position < this.numPositions; ++position) {
                this.minimums[position] = otherCombination.getMinimum(position);
                this.maximums[position] = otherCombination.getMaximum(position);
                this.values[position] = otherCombination.getValue(position);
            }
        }
    }

    public void copyValues(Combination otherCombination) {
        for (int position = 0; position < this.numPositions; ++position) {
            this.setValue(position, otherCombination.getValue(position));
        }
    }

    public void union(Combination otherCombination) {
        for (int position = 0; position < this.numPositions; ++position) {
            this.values[position] = Math.max(this.values[position], otherCombination.getValue(position));
        }
    }

    public void first() {
        for (int position = 0; position < this.numPositions; ++position) {
            this.values[position] = this.minimums[position];
        }
        this.eof = this.numPositions <= 0;
    }

    public void last() {
        for (int position = 0; position < this.numPositions; ++position) {
            this.values[position] = this.maximums[position];
        }
    }

    public void next() {
        if (this.isLast()) {
            this.eof = true;
            return;
        }
        boolean continueUpdatingSequence = true;
        for (int position = this.numPositions - 1; position >= 0 && continueUpdatingSequence; --position) {
            if (this.values[position] < this.maximums[position]) {
                int n = position;
                this.values[n] = this.values[n] + 1;
                continueUpdatingSequence = false;
                continue;
            }
            this.values[position] = this.minimums[position];
        }
    }

    public boolean isEof() {
        return this.eof;
    }

    public boolean isLast() {
        boolean bFlag = true;
        for (int position = 0; position < this.numPositions; ++position) {
            if (this.values[position] >= this.maximums[position]) continue;
            bFlag = false;
        }
        return bFlag;
    }

    public void random(Random aGenerator) {
        Random generator = aGenerator != null ? aGenerator : new Random();
        for (int position = 0; position < this.numPositions; ++position) {
            int numbers = this.getNumberOfValuesAtPosition(position);
            int uiDelta = generator.nextInt(numbers);
            this.values[position] = this.minimums[position] + uiDelta;
        }
    }

    public void random(int numOfTurns, Random aGenerator) {
        Random generator = aGenerator != null ? aGenerator : new Random();
        this.first();
        block0: for (int turns = 1; turns <= numOfTurns; ++turns) {
            int numTurnable = 0;
            for (int position = 0; position < this.numPositions; ++position) {
                if (this.values[position] >= this.maximums[position]) continue;
                ++numTurnable;
            }
            int turnThis = generator.nextInt(numTurnable) + 1;
            int turnIndex = 0;
            for (int position = 0; position < this.numPositions; ++position) {
                if (this.values[position] >= this.maximums[position] || ++turnIndex != turnThis) continue;
                int n = position;
                this.values[n] = this.values[n] + 1;
                continue block0;
            }
        }
    }

    public String valueToString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int position = 0; position < this.numPositions; ++position) {
            if (position > 0) {
                sb.append(',');
            }
            sb.append(this.values[position]);
        }
        sb.append(')');
        return sb.toString();
    }

    public String rangeToString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (int position = 0; position < this.numPositions; ++position) {
            if (position > 0) {
                sb.append(',');
            }
            sb.append(this.minimums[position]);
            sb.append('-');
            sb.append(this.maximums[position]);
        }
        sb.append(')');
        return sb.toString();
    }
}

