/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.RolapQueryHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Advisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateSQLInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCancelHandler;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.runtree.relational.decoration.XValueDecoration;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QueryHelper {
    private static final String ALL_ROWS = "allRows";
    private static final String MODEL_XML = "./model.xml";
    private static final String REQUEST_ID_FOR_AGGREGATE_QUERY = "requestIDForAggregateQuery";
    private static final String CUBE_NAME_VAR = "$CUBE_NAME$";
    private static final String AGGR_NAME_VAR = "$AGGR_NAME$";
    private static final String QUERY_NAME_VAR = "$QUERY_NAME$";
    private static final String ITEM_NAME_VAR = "$ITEM_NAME$";
    private static final String LEVEL_NAME_VAR = "$LEVEL_NAME$";
    private static final String EXPRESSION_VAR = "$EXPRESSION$";
    private static final String UNDERSCORE = "_";
    private static final String OPENSQRBRACKET_STR = "[";
    private static final String CLOSESQRBRACKET_STR = "]";
    private static final String DOT_STR = ".";
    private static final String MODEL_PATH_TEMPLATE = "CAMID(\":\")/rolapDataSource[@name=$CUBE_NAME$]/model";
    private static final String FACT_COUNT_BASE_QUERY_NAME_TEMPLATE = "FactCountQuery_for_$CUBE_NAME$";
    private static final String AGGR_QUERY_NAME_TEMPLATE = "AggrQuery_for_$CUBE_NAME$_$AGGR_NAME$";
    private static final String MEMBER_COUNT_BASE_QUERY_NAME_TEMPLATE = "MemberCountBaseQuery_for_$CUBE_NAME$_$LEVEL_NAME$";
    private static final String COUNT_STR = "Count";
    private static final String COLUMNCOUNT_STR = "columnCount";
    private static final String COUNT_ROWS = "count(rows ";
    private static final String COUNT_QUERY_REF_ITEM_TEMPLATE = "count(rows [$QUERY_NAME$].[$ITEM_NAME$])";
    private static final String QUERY_REF_ITEM_TEMPLATE = "[$QUERY_NAME$].[$ITEM_NAME$]";
    private static final String COUNT_ROWS_EXPRESSION_TEMPLATE = "count(rows $EXPRESSION$)";
    private static final String DATAITEM_AGGREGATE_NONE = "none";
    public static final String DATA_TYPE_UNKNOWN = "UNKNOWN";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PlannedV5QuerySet planV5QuerySet(String cubeName, QuerySetBuilder queryBuilder) {
        TraceContext traceCtx = TraceContext.enter();
        MetadataConnection metadataConnection = null;
        try {
            QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
            ROLAPCube cube = ROLAPCubeManager.getInstance().getCube(cubeName);
            envHelper.setCMRequestExecutor(cube.getAccountManager());
            envHelper.setInternalUse(true);
            envHelper.setUpEnvironment(true);
            ExecutionEnvironment execEnv = envHelper.getExecutionEnvironment();
            RequestEnvironment reqEnv = envHelper.getRequestEnvironment();
            ROLAPContext.setRelQueryExecuting();
            try {
                PlannedV5QuerySet plannedQuerySet;
                QueryHelper.setupRequestEnvironment(reqEnv, cubeName);
                PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
                metadataConnection = MetadataService.getInstance().getConnection("MFW4J", MODEL_PATH_TEMPLATE.replace(CUBE_NAME_VAR, XMLUtils.xPathLiteral(cubeName)), execEnv, false);
                planEnv.setMetdataConnection(metadataConnection);
                V5QuerySet v5QuerySet = queryBuilder.build(planEnv);
                PlannedV5QuerySet plannedV5QuerySet = plannedQuerySet = QueryPlanner.getInstance().planQuery(v5QuerySet, planEnv);
                envHelper.tearDownEnvironment();
                return plannedV5QuerySet;
            }
            catch (Throwable throwable) {
                envHelper.tearDownEnvironment();
                throw throwable;
            }
        }
        finally {
            traceCtx.exit();
        }
    }

    public static AggregateSQLInfo captureSQLInfoForAggregate(String cubeName, String aggrName, List<String[]> dataItemsInfo, List<String> metaNames, List<String> filters, HashMapIntObject<Map<String, String>> metaIndexMetaNameColumnNameMap, Map<String, Map<String, Map<String, String>>> dimensionNameHierarchyNameMetaNameColumnNameMap) {
        IXQEQueryNode[] sqls;
        AggregateQuerySetBuilder aggrQuerySetBuilder = new AggregateQuerySetBuilder(cubeName, aggrName, dataItemsInfo, filters);
        PlannedV5QuerySet plannedQuery = QueryHelper.planV5QuerySet(cubeName, aggrQuerySetBuilder);
        List<SQLAlias> sqlAlias = null;
        IXQEQueryNode[] valueDecorationNodes = plannedQuery.getDescendantsOfType(501043, false);
        if (valueDecorationNodes != null && valueDecorationNodes.length > 0) {
            sqlAlias = ((XValueDecoration)valueDecorationNodes[0]).getAliasList();
        }
        if ((sqls = plannedQuery.getDescendantsOfType(501013, false)) != null && sqls.length > 0) {
            XSql sqlNode = (XSql)sqls[0];
            IRowsetInfo rowsetInfo = sqlNode.getCalculatedRowsetInfo();
            LinkedHashMap<String, String> columnSetInfo = new LinkedHashMap<String, String>();
            HashMap<String, String> cubeAttributeobjectNameToColumnNameMap = new HashMap<String, String>();
            for (int i = 0; i < rowsetInfo.getNumColumns(); ++i) {
                Map<String, String> metaNameColumnNameMap;
                IColumnInfo columnInfo = rowsetInfo.getColumnInfo(i);
                IDataType dataType = columnInfo.getDataType();
                String columnDataType = dataType.getSQLText();
                if (columnDataType.equals(VariantType.VARIANT.getSQLText())) {
                    columnDataType = DATA_TYPE_UNKNOWN;
                }
                String columnName = null;
                columnName = sqlAlias != null && i < sqlAlias.size() ? sqlAlias.get(i).getName() : "__Column" + (i + 1);
                columnSetInfo.put(columnName, columnDataType);
                String[] dataItem = dataItemsInfo.get(i);
                String uniqueAttributeName = dataItem[0];
                cubeAttributeobjectNameToColumnNameMap.put(uniqueAttributeName, columnName);
                String metaName = null;
                if (i < metaNames.size()) {
                    metaName = metaNames.get(i);
                }
                if (metaName == null || (metaNameColumnNameMap = metaIndexMetaNameColumnNameMap.get(i)) == null) continue;
                metaNameColumnNameMap.put(metaName, columnName);
            }
            return new AggregateSQLInfo(sqlNode.getQuerySpecificationSQL(), columnSetInfo, dimensionNameHierarchyNameMetaNameColumnNameMap, cubeAttributeobjectNameToColumnNameMap);
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_UnableToCaptureSQLForAggregate, aggrName, cubeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getCellValueForExecutedV5QuerySet(Advisor advisor, String cubeName, QuerySetBuilder queryBuilder) {
        TraceContext traceCtx = TraceContext.enter();
        MetadataConnection metadataConnection = null;
        long value = 0L;
        try {
            QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
            ROLAPCube cube = ROLAPCubeManager.getInstance().getCube(cubeName);
            envHelper.setCMRequestExecutor(cube.getAccountManager());
            envHelper.setInternalUse(true);
            envHelper.setUpEnvironment(true);
            ExecutionEnvironment execEnv = envHelper.getExecutionEnvironment();
            RequestEnvironment reqEnv = envHelper.getRequestEnvironment();
            ROLAPContext.setRelQueryExecuting();
            AdvisorCancelHandler advisorCancelHandler = advisor.getAdvisorCancelHandler();
            String queryName = queryBuilder.getMainQueryName();
            try {
                advisorCancelHandler.registerAdvisorQuery(queryName, execEnv);
                QueryHelper.setupRequestEnvironment(reqEnv, cubeName);
                PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
                metadataConnection = MetadataService.getInstance().getConnection("MFW4J", MODEL_PATH_TEMPLATE.replace(CUBE_NAME_VAR, XMLUtils.xPathLiteral(cubeName)), execEnv, false);
                planEnv.setMetdataConnection(metadataConnection);
                V5QuerySet v5QuerySet = queryBuilder.build(planEnv);
                String v5QuerySetDump = v5QuerySet.dumpToString();
                PlannedV5QuerySet plannedQuerySet = QueryPlanner.getInstance().planQuery(v5QuerySet, planEnv);
                QueryHelper.detectLocalProcessing(cubeName, queryBuilder, v5QuerySetDump, plannedQuerySet);
                RSAPIDataset dataset = RolapQueryHelper.getDataset(queryBuilder.getMainQueryName(), plannedQuerySet);
                RSAPIPartialDataset partialDataset = null;
                RSAPIEdgeIterator edgeIterator = null;
                if (dataset != null) {
                    try {
                        partialDataset = QueryEngine.getInstance().getPartialDataset(dataset, new int[]{0}, new int[]{0}, true, false, execEnv);
                        edgeIterator = partialDataset.edgeIterator(0);
                        while (edgeIterator.hasNext()) {
                            RSAPIRow r = edgeIterator.next();
                            IValue[] values = r.getColumns();
                            if (values.length <= 0 || !(values[0] instanceof ExactNumericValue)) continue;
                            value = ((ExactNumericValue)values[0]).getLong();
                            break;
                        }
                    }
                    finally {
                        try {
                            if (edgeIterator != null) {
                                edgeIterator.close();
                                edgeIterator = null;
                            }
                        }
                        finally {
                            try {
                                if (partialDataset != null) {
                                    partialDataset.release();
                                    partialDataset = null;
                                }
                            }
                            finally {
                                if (dataset != null) {
                                    dataset.releaseResultset(execEnv);
                                    dataset = null;
                                }
                            }
                        }
                    }
                }
                long l = value;
                advisorCancelHandler.unregisterAdvisorQuery(queryName);
                envHelper.tearDownEnvironment();
                return l;
            }
            catch (Throwable throwable) {
                advisorCancelHandler.unregisterAdvisorQuery(queryName);
                envHelper.tearDownEnvironment();
                throw throwable;
            }
        }
        finally {
            traceCtx.exit();
        }
    }

    private static String detectLocalProcessing(String cubeName, QuerySetBuilder queryBuilder, String v5QueryDump, PlannedV5QuerySet plannedQuerySet) {
        String sql = null;
        IXQEQueryNode[] sqls = plannedQuerySet.getDescendantsOfType(501013, false);
        if (sqls == null || sqls.length <= 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, String.format("The following V5 query built by %s against the cube %s is expected to be converted to SQL that performs aggregation in the database but it was actually converted to SQL that retrieves data and performs aggregation locally:%s%s", queryBuilder.getClass().getSimpleName(), cubeName, System.getProperty("line.separator"), v5QueryDump));
        }
        sql = ((XSql)sqls[0]).getSqlText();
        return sql;
    }

    private static void setupRequestEnvironment(RequestEnvironment reqEnv, String cubeName) {
        reqEnv.setRequestID(REQUEST_ID_FOR_AGGREGATE_QUERY);
        reqEnv.setSubRequestID(null);
        reqEnv.setOperationName("command");
        reqEnv.setCubeName(cubeName);
    }

    public static class CountFactQuerySetBuilder
    extends QuerySetBuilder {
        private String cubeName;
        private String[] dataItemInfo;

        public CountFactQuerySetBuilder(String theCubeName, String[] theFactDataItemInfo) {
            this.cubeName = theCubeName;
            this.dataItemInfo = theFactDataItemInfo;
        }

        @Override
        public String getMainQueryName() {
            return QueryHelper.FACT_COUNT_BASE_QUERY_NAME_TEMPLATE.replace(QueryHelper.CUBE_NAME_VAR, this.cubeName);
        }

        @Override
        public V5QuerySet build(PlanningEnvironment planEnv) {
            RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            V5QuerySet v5QuerySet = (V5QuerySet)nodeFactory.createV5Node("querySet");
            planEnv.getNodeIndex().addNode(v5QuerySet);
            String queryName = this.getMainQueryName();
            v5QuerySet.setPropertyValue("expressionLocale", LocaleConverter.localeToStr(reqEnv.getExpressionLocale()));
            v5QuerySet.setPropertyValue("modelPath", QueryHelper.MODEL_XML);
            reqEnv.setModelPath(QueryHelper.MODEL_XML);
            IXQEQueryNode query = nodeFactory.createNode(101006);
            query.setPropertyValue("name", queryName);
            query.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), QueryHelper.ALL_ROWS);
            query.setPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName(), "minimizeLocal");
            query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
            query.setPropertyValue("containsQueryHint", true);
            v5QuerySet.addChild(query);
            IXQEQueryNode selection = nodeFactory.createNode(101009);
            selection.setPropertyValue("autoSummary", true);
            query.addChild(selection);
            IXQEQueryNode source = nodeFactory.createNode(101007);
            source.setPropertyValue("relational", true);
            query.addChild(source);
            IXQEQueryNode dataItem = nodeFactory.createNode(101003);
            String dataItemName = this.dataItemInfo[0];
            String dataItemExpression = this.dataItemInfo[1];
            dataItem.setPropertyValue("name", dataItemName);
            dataItem.setPropertyValue("aggregate", QueryHelper.DATAITEM_AGGREGATE_NONE);
            selection.addChild(dataItem);
            IXQEQueryNode expression = nodeFactory.createNode(101004);
            expression.setPropertyValue("expression", QueryHelper.COUNT_ROWS_EXPRESSION_TEMPLATE.replace(QueryHelper.EXPRESSION_VAR, dataItemExpression));
            dataItem.addChild(expression);
            IXQEQueryNode groupBody = nodeFactory.createNode(101051);
            groupBody.setPropertyValue("name", queryName);
            IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", dataItemName);
            groupBody.addChild(dataItemRef);
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)nodeFactory.createNode(101055);
            qrd.setPropertyValue("name", queryName);
            qrd.setPropertyValue("refQuery", queryName);
            v5QuerySet.addChild(qrd);
            IXQEQueryNode edge = nodeFactory.createNode(101049);
            edge.setPropertyValue("name", queryName);
            qrd.addChild(edge);
            IXQEQueryNode edgeGroup = nodeFactory.createNode(101050);
            edge.addChild(edgeGroup);
            V5ValueSet valueSet = (V5ValueSet)nodeFactory.createNode(101057);
            valueSet.setNameProperty(queryName);
            valueSet.addChild(groupBody);
            edgeGroup.addChild(valueSet);
            return v5QuerySet;
        }
    }

    public static class CountLevelMembersQuerySetBuilder
    extends QuerySetBuilder {
        private String cubeName;
        private String levelName;
        private List<String[]> levelDataItemsInfo;

        public CountLevelMembersQuerySetBuilder(String theCubeName, String theLevelName, List<String[]> theLevelDataItemsInfo) {
            this.cubeName = theCubeName;
            this.levelName = theLevelName;
            this.levelDataItemsInfo = theLevelDataItemsInfo;
        }

        @Override
        public String getMainQueryName() {
            return QueryHelper.MEMBER_COUNT_BASE_QUERY_NAME_TEMPLATE.replace(QueryHelper.CUBE_NAME_VAR, this.cubeName).replace(QueryHelper.LEVEL_NAME_VAR, this.levelName);
        }

        @Override
        public V5QuerySet build(PlanningEnvironment planEnv) {
            V5QuerySet v5QuerySet = null;
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            v5QuerySet = (V5QuerySet)nodeFactory.createV5Node("querySet");
            planEnv.getNodeIndex().addNode(v5QuerySet);
            String baseQueryName = this.getMainQueryName();
            LevelQueryBuilder levelQueryBuilder = new LevelQueryBuilder(baseQueryName, v5QuerySet, this.levelDataItemsInfo);
            v5QuerySet = levelQueryBuilder.build(planEnv);
            ResultCountQueryBuilder resultCountQuery = new ResultCountQueryBuilder(baseQueryName, v5QuerySet, this.levelDataItemsInfo.get(0)[0]);
            v5QuerySet = resultCountQuery.build(planEnv);
            return v5QuerySet;
        }
    }

    private static class LevelQueryBuilder
    extends QuerySetBuilder {
        private String queryName;
        private V5QuerySet v5QuerySet;
        private List<String[]> dataItemsInfo;

        LevelQueryBuilder(String theQueryName, V5QuerySet theV5QuerySet, List<String[]> theDataItemsInfo) {
            this.queryName = theQueryName;
            this.v5QuerySet = theV5QuerySet;
            this.dataItemsInfo = theDataItemsInfo;
        }

        @Override
        public String getMainQueryName() {
            return this.queryName;
        }

        @Override
        public V5QuerySet build(PlanningEnvironment planEnv) {
            RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            this.v5QuerySet.setPropertyValue("expressionLocale", LocaleConverter.localeToStr(reqEnv.getExpressionLocale()));
            this.v5QuerySet.setPropertyValue("modelPath", QueryHelper.MODEL_XML);
            reqEnv.setModelPath(QueryHelper.MODEL_XML);
            IXQEQueryNode query = nodeFactory.createNode(101006);
            query.setPropertyValue("name", this.queryName);
            query.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), QueryHelper.ALL_ROWS);
            query.setPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName(), "minimizeLocal");
            query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
            query.setPropertyValue("containsQueryHint", true);
            this.v5QuerySet.addChild(query);
            IXQEQueryNode selection = nodeFactory.createNode(101009);
            selection.setPropertyValue("autoSummary", true);
            query.addChild(selection);
            IXQEQueryNode source = nodeFactory.createNode(101007);
            source.setPropertyValue("relational", true);
            query.addChild(source);
            for (String[] info : this.dataItemsInfo) {
                IXQEQueryNode dataItem = nodeFactory.createNode(101003);
                String dataItemName = info[0];
                dataItem.setPropertyValue("name", dataItemName);
                dataItem.setPropertyValue("aggregate", QueryHelper.DATAITEM_AGGREGATE_NONE);
                selection.addChild(dataItem);
                IXQEQueryNode expression = nodeFactory.createNode(101004);
                expression.setPropertyValue("expression", info[1]);
                dataItem.addChild(expression);
            }
            return this.v5QuerySet;
        }
    }

    private static class ResultCountQueryBuilder
    extends QuerySetBuilder {
        private String baseQueryName;
        private V5QuerySet v5QuerySet;
        private String columnRef;

        ResultCountQueryBuilder(String theBaseQueryName, V5QuerySet theV5QuerySet, String theColumnRef) {
            this.baseQueryName = theBaseQueryName;
            this.v5QuerySet = theV5QuerySet;
            this.columnRef = theColumnRef;
        }

        @Override
        public V5QuerySet build(PlanningEnvironment planEnv) {
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            String countResultQueryName = "CountResultQuery";
            IXQEQueryNode countQuery = nodeFactory.createNode(101006);
            countQuery.setPropertyValue("name", countResultQueryName);
            countQuery.setPropertyValue(V5Query.QueryHint.AVOID_ZERODIV.getPropertyName(), true);
            countQuery.setPropertyValue("containsQueryHint", true);
            countQuery.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
            countQuery.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), QueryHelper.ALL_ROWS);
            countQuery.setPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName(), "minimizeLocal");
            IXQEQueryNode queryRef = nodeFactory.createNode(101023);
            queryRef.setPropertyValue("refQuery", this.baseQueryName);
            IXQEQueryNode countSource = nodeFactory.createNode(101007);
            countQuery.addChild(countSource);
            IXQEQueryNode countQuerySelection = nodeFactory.createNode(101009);
            countQuerySelection.setPropertyValue("autoSummary", true);
            IXQEQueryNode dataItem1 = nodeFactory.createNode(101003);
            dataItem1.setPropertyValue("name", QueryHelper.COLUMNCOUNT_STR);
            IXQEQueryNode expression1 = nodeFactory.createNode(101004);
            expression1.setPropertyValue("expression", QueryHelper.COUNT_QUERY_REF_ITEM_TEMPLATE.replace(QueryHelper.QUERY_NAME_VAR, this.baseQueryName).replace(QueryHelper.ITEM_NAME_VAR, this.columnRef));
            dataItem1.addChild(expression1);
            countQuerySelection.addChild(dataItem1);
            countQuery.addChild(countQuerySelection);
            this.v5QuerySet.addChild(countQuery);
            String singleCountQueryName = "SingleCount";
            IXQEQueryNode singleCountQuery = nodeFactory.createNode(101006);
            singleCountQuery.setPropertyValue("name", singleCountQueryName);
            singleCountQuery.setPropertyValue(V5Query.QueryHint.AVOID_ZERODIV.getPropertyName(), true);
            singleCountQuery.setPropertyValue("containsQueryHint", true);
            singleCountQuery.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
            singleCountQuery.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), QueryHelper.ALL_ROWS);
            singleCountQuery.setPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName(), "minimizeLocal");
            IXQEQueryNode countResultQueryRef = nodeFactory.createNode(101023);
            countResultQueryRef.setPropertyValue("refQuery", countResultQueryName);
            IXQEQueryNode countResultSource = nodeFactory.createNode(101007);
            singleCountQuery.addChild(countResultSource);
            IXQEQueryNode singleCountQuerySelection = nodeFactory.createNode(101009);
            singleCountQuerySelection.setPropertyValue("autoSummary", false);
            IXQEQueryNode dataItemCount = nodeFactory.createNode(101003);
            dataItemCount.setPropertyValue("name", QueryHelper.COUNT_STR);
            IXQEQueryNode expressionCount = nodeFactory.createNode(101004);
            expressionCount.setPropertyValue("expression", QueryHelper.QUERY_REF_ITEM_TEMPLATE.replace(QueryHelper.QUERY_NAME_VAR, countResultQueryName).replace(QueryHelper.ITEM_NAME_VAR, QueryHelper.COLUMNCOUNT_STR));
            dataItemCount.addChild(expressionCount);
            singleCountQuerySelection.addChild(dataItemCount);
            singleCountQuery.addChild(singleCountQuerySelection);
            this.v5QuerySet.addChild(singleCountQuery);
            String qrdName = "rsd" + singleCountQueryName;
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)nodeFactory.createNode(101055);
            qrd.setPropertyValue("name", qrdName);
            qrd.setPropertyValue("refQuery", singleCountQueryName);
            this.v5QuerySet.addChild(qrd);
            IXQEQueryNode edge = nodeFactory.createNode(101049);
            edge.setPropertyValue("name", qrdName);
            qrd.addChild(edge);
            IXQEQueryNode edgeGroup = nodeFactory.createNode(101050);
            edge.addChild(edgeGroup);
            V5ValueSet valueSet = (V5ValueSet)nodeFactory.createNode(101057);
            valueSet.setNameProperty("valueSet");
            IXQEQueryNode groupBody = nodeFactory.createNode(101051);
            groupBody.setPropertyValue("name", "groupBody");
            IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", QueryHelper.COUNT_STR);
            groupBody.addChild(dataItemRef);
            valueSet.addChild(groupBody);
            edgeGroup.addChild(valueSet);
            return this.v5QuerySet;
        }
    }

    public static class CountAggregateResultQuerySetBuilder
    extends QuerySetBuilder {
        private List<String[]> levelDataItemsInfo;
        private String[] measureDataItemInfo;
        private List<String> filters;

        public CountAggregateResultQuerySetBuilder(List<String[]> theLevelDataItemsInfo, String[] theMeasureDataItemInfo, List<String> theFilters) {
            this.levelDataItemsInfo = theLevelDataItemsInfo;
            this.measureDataItemInfo = theMeasureDataItemInfo;
            this.filters = theFilters;
        }

        @Override
        public String getMainQueryName() {
            return "CountAggregateResult_query";
        }

        @Override
        public V5QuerySet build(PlanningEnvironment planEnv) {
            V5QuerySet v5QuerySet = null;
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            v5QuerySet = (V5QuerySet)nodeFactory.createV5Node("querySet");
            planEnv.getNodeIndex().addNode(v5QuerySet);
            String baseQueryName = this.getMainQueryName();
            String countRowsColumnName = this.measureDataItemInfo[0];
            String countRowsColumnExpression = QueryHelper.COUNT_ROWS_EXPRESSION_TEMPLATE.replace(QueryHelper.EXPRESSION_VAR, this.measureDataItemInfo[1]);
            ArrayList<String[]> dataItemsInfo = new ArrayList<String[]>();
            dataItemsInfo.addAll(this.levelDataItemsInfo);
            String[] countRowsColumn = new String[]{countRowsColumnName, countRowsColumnExpression};
            dataItemsInfo.add(countRowsColumn);
            AggregateQueryBuilder aggregateQuery = new AggregateQueryBuilder(baseQueryName, v5QuerySet, dataItemsInfo, this.filters);
            v5QuerySet = aggregateQuery.build(planEnv);
            ResultCountQueryBuilder resultCountQuery = new ResultCountQueryBuilder(baseQueryName, v5QuerySet, countRowsColumnName);
            v5QuerySet = resultCountQuery.build(planEnv);
            return v5QuerySet;
        }
    }

    public static class AggregateQuerySetBuilder
    extends QuerySetBuilder {
        private String cubeName;
        private String aggrName;
        private List<String[]> dataItemsInfo;
        private List<String> filters = null;

        public AggregateQuerySetBuilder(String theCubeName, String theAggrName, List<String[]> theDataItemsInfo, List<String> theFilters) {
            this.cubeName = theCubeName;
            this.aggrName = theAggrName;
            this.dataItemsInfo = theDataItemsInfo;
            this.filters = theFilters;
        }

        @Override
        public String getMainQueryName() {
            return QueryHelper.AGGR_QUERY_NAME_TEMPLATE.replace(QueryHelper.CUBE_NAME_VAR, this.cubeName).replace(QueryHelper.AGGR_NAME_VAR, this.aggrName);
        }

        @Override
        public V5QuerySet build(PlanningEnvironment planEnv) {
            V5QuerySet v5QuerySet = null;
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            v5QuerySet = (V5QuerySet)nodeFactory.createV5Node("querySet");
            planEnv.getNodeIndex().addNode(v5QuerySet);
            String queryName = this.getMainQueryName();
            AggregateQueryBuilder aggregateV5QueryBuilder = new AggregateQueryBuilder(queryName, v5QuerySet, this.dataItemsInfo, this.filters);
            v5QuerySet = aggregateV5QueryBuilder.build(planEnv);
            IXQEQueryNode groupBody = nodeFactory.createNode(101051);
            groupBody.setPropertyValue("name", queryName);
            for (int i = 0; i < this.dataItemsInfo.size(); ++i) {
                IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
                dataItemRef.setPropertyValue("refDataItem", this.dataItemsInfo.get(i)[0]);
                groupBody.addChild(dataItemRef);
            }
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)nodeFactory.createNode(101055);
            qrd.setPropertyValue("name", queryName);
            qrd.setPropertyValue("refQuery", queryName);
            qrd.addQueryFeedback("nativeQuerySpecificationText");
            v5QuerySet.addChild(qrd);
            IXQEQueryNode edge = nodeFactory.createNode(101049);
            edge.setPropertyValue("name", queryName);
            qrd.addChild(edge);
            IXQEQueryNode edgeGroup = nodeFactory.createNode(101050);
            edge.addChild(edgeGroup);
            V5ValueSet valueSet = (V5ValueSet)nodeFactory.createNode(101057);
            valueSet.setNameProperty(queryName);
            valueSet.addChild(groupBody);
            edgeGroup.addChild(valueSet);
            return v5QuerySet;
        }
    }

    private static class AggregateQueryBuilder
    extends QuerySetBuilder {
        private String queryName;
        private V5QuerySet v5QuerySet;
        private List<String[]> dataItemsInfo;
        private List<String> filters;

        AggregateQueryBuilder(String theQueryName, V5QuerySet theV5QuerySet, List<String[]> theDataItemsInfo, List<String> theFilters) {
            this.queryName = theQueryName;
            this.v5QuerySet = theV5QuerySet;
            this.dataItemsInfo = theDataItemsInfo;
            this.filters = theFilters;
        }

        @Override
        public String getMainQueryName() {
            return this.queryName;
        }

        @Override
        public V5QuerySet build(PlanningEnvironment planEnv) {
            RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
            XQENodeFactory nodeFactory = planEnv.getNodeFactory();
            this.v5QuerySet.setPropertyValue("expressionLocale", LocaleConverter.localeToStr(reqEnv.getExpressionLocale()));
            this.v5QuerySet.setPropertyValue("modelPath", QueryHelper.MODEL_XML);
            reqEnv.setModelPath(QueryHelper.MODEL_XML);
            IXQEQueryNode query = nodeFactory.createNode(101006);
            query.setPropertyValue("name", this.queryName);
            query.setPropertyValue(V5Query.QueryHint.EXECUTION_OPTIMIZATION.getPropertyName(), QueryHelper.ALL_ROWS);
            query.setPropertyValue(V5Query.QueryHint.QUERY_PROCESSING.getPropertyName(), "minimizeLocal");
            query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
            query.setPropertyValue("containsQueryHint", true);
            this.v5QuerySet.addChild(query);
            IXQEQueryNode selection = nodeFactory.createNode(101009);
            selection.setPropertyValue("autoSummary", true);
            query.addChild(selection);
            IXQEQueryNode source = nodeFactory.createNode(101007);
            source.setPropertyValue("relational", true);
            query.addChild(source);
            for (int i = 0; i < this.dataItemsInfo.size(); ++i) {
                String[] info = this.dataItemsInfo.get(i);
                IXQEQueryNode dataItem = nodeFactory.createNode(101003);
                dataItem.setPropertyValue("name", info[0]);
                if (info.length > 2) {
                    dataItem.setPropertyValue("aggregate", info[2]);
                }
                selection.addChild(dataItem);
                IXQEQueryNode expression = nodeFactory.createNode(101004);
                expression.setPropertyValue("expression", info[1]);
                dataItem.addChild(expression);
            }
            if (null != this.filters && 0 != this.filters.size()) {
                for (String filter : this.filters) {
                    if (null == filter || filter.isEmpty()) continue;
                    V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
                    detailFilter.setPostAutoAggregation(false);
                    query.addChild(detailFilter);
                    IXQEQueryNode filterExpression = nodeFactory.createNode(101013);
                    filterExpression.setPropertyValue("expression", filter);
                    detailFilter.addChild(filterExpression);
                }
            }
            return this.v5QuerySet;
        }
    }

    public static abstract class QuerySetBuilder {
        public abstract V5QuerySet build(PlanningEnvironment var1);

        public String getMainQueryName() {
            return "";
        }
    }
}

