/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QueryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkloadInfo {
    private WorkloadLogger mLogger;
    private String mRequestID;
    private String mSubRequestID;
    private String mPackageName;
    private String mReportName;
    private String mUser;
    private Date mDateTime;
    private long mExecutionTime;
    private Map<String, WorkloadEntry> mWorkloadMap = new HashMap<String, WorkloadEntry>();

    public WorkloadInfo() {
    }

    public WorkloadInfo(WorkloadLogger logger, RequestEnvironment reqEnv) {
        this.mLogger = logger;
        this.mRequestID = reqEnv.getRequestID();
        this.mSubRequestID = reqEnv.getSubRequestID();
        this.mPackageName = reqEnv.getPackageName();
        if (null == this.mPackageName) {
            this.mPackageName = reqEnv.getPackageFromRequestDocument();
        }
        this.mReportName = reqEnv.getReportName();
        this.mUser = ContentManager.getUserName(reqEnv);
        this.mDateTime = new Date(System.currentTimeMillis());
        this.mExecutionTime = 0L;
    }

    public void setExecutionTime(long executionTime) {
        this.mExecutionTime = executionTime;
    }

    public void save() {
        this.mLogger.logWorkloadInfo(this);
    }

    public WorkloadEntry getEntry(String id) {
        WorkloadEntry entry = this.mWorkloadMap.get(id);
        if (entry == null) {
            entry = new WorkloadEntry();
            this.mWorkloadMap.put(id, entry);
        }
        return entry;
    }

    public String getRequestID() {
        return this.mRequestID;
    }

    public String getSubRequestID() {
        return this.mSubRequestID;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getReportName() {
        return this.mReportName;
    }

    public String getUser() {
        return this.mUser;
    }

    public Date getDateTime() {
        return this.mDateTime;
    }

    public long getExecutionTime() {
        return this.mExecutionTime;
    }

    public Collection<WorkloadEntry> getWorkloadEntries() {
        return this.mWorkloadMap.values();
    }

    public static class WorkloadEntry {
        private List<String> mMeasures = new ArrayList<String>();
        private Map<String, Map<String, HierarchyRecord>> mMetadataMap = new HashMap<String, Map<String, HierarchyRecord>>();
        private long mNumberOfRows;
        private boolean mCacheHit;
        private int mAccessType = 0;
        private String mAggregateName;
        private long mExecutionTime;
        private QueryType queryType;

        public void addMeasure(String name) {
            this.mMeasures.add(name);
        }

        public List<String> getMeasures() {
            return this.mMeasures;
        }

        public void setNumberOfRows(long numberOfRows) {
            this.mNumberOfRows = numberOfRows;
        }

        public long getNumberOfRows() {
            return this.mNumberOfRows;
        }

        public void setAccessType(int accessTypeFlag) {
            this.mAccessType |= accessTypeFlag;
        }

        public boolean isAccessed(int accessTypeFlag) {
            return (this.mAccessType & accessTypeFlag) == accessTypeFlag;
        }

        public int getAccessType() {
            return this.mAccessType;
        }

        public void setCacheHit(boolean cacheHit) {
            this.mCacheHit = cacheHit;
        }

        public boolean isCacheHit() {
            return this.mCacheHit;
        }

        public void setAggregateName(String aggregateName) {
            this.mAggregateName = aggregateName;
        }

        public String getAggregateName() {
            return this.mAggregateName;
        }

        public void setExecutionTime(long executionTime) {
            this.mExecutionTime = executionTime;
        }

        public long getExecutionTime() {
            return this.mExecutionTime;
        }

        public HierarchyRecord addHierarchy(String hierarchy, String dimension, int numberOfMembers) {
            HierarchyRecord hierRecord;
            Map<String, HierarchyRecord> hierarchyMap = this.mMetadataMap.get(dimension);
            if (hierarchyMap == null) {
                hierarchyMap = new HashMap<String, HierarchyRecord>();
                this.mMetadataMap.put(dimension, hierarchyMap);
            }
            if ((hierRecord = hierarchyMap.get(hierarchy)) == null) {
                hierRecord = new HierarchyRecord(numberOfMembers);
                hierarchyMap.put(hierarchy, hierRecord);
            }
            return hierRecord;
        }

        public Map<String, Map<String, HierarchyRecord>> getMetadataMap() {
            return this.mMetadataMap;
        }

        public String getLevelName(String dimensionName, String hierarchyName) {
            HierarchyRecord hierarchyRecord;
            String levelName = null;
            Map<String, HierarchyRecord> hierarchyMap = this.mMetadataMap.get(dimensionName);
            if (hierarchyMap != null && (hierarchyRecord = hierarchyMap.get(hierarchyName)) != null) {
                levelName = hierarchyRecord.getLevelName();
            }
            return levelName;
        }

        public QueryType getQueryType() {
            return this.queryType;
        }

        public void setQueryType(QueryType theQueryType) {
            this.queryType = theQueryType;
        }
    }

    public static class HierarchyRecord {
        private String mLevelName;
        private List<MemberRecord> mMembers = new ArrayList<MemberRecord>();
        private int mMemberCount;

        public HierarchyRecord(int memberCount) {
            this.mMemberCount = memberCount;
        }

        public String getLevelName() {
            return this.mLevelName;
        }

        public void addMember(String mun) {
            this.mMembers.add(new MemberRecord(mun));
        }

        public List<MemberRecord> getMembers() {
            return this.mMembers;
        }

        public int getMemberCount() {
            return this.mMemberCount;
        }

        public void addLevel(String name) {
            if (this.mLevelName != null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "More than one level per hierarchy is not supported.");
            }
            this.mLevelName = name;
        }
    }

    public static class MemberRecord {
        private String mMun;

        MemberRecord(String mun) {
            this.mMun = mun;
        }

        public String getMun() {
            return this.mMun;
        }
    }
}

