/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadInfoLogFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadManagerTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class AggregateLoadInfoLogger {
    private static XQELogger logger = ROLAPLog.getLogger("ROLAPCubes.AggregateCache", LogLevel.TRACE);
    private ROLAPBaseCube cube;
    private AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo;
    private boolean stopped = true;

    public AggregateLoadInfoLogger(ROLAPBaseCube theCube) {
        this.cube = theCube;
    }

    public synchronized void startLogging() {
        logger.log("Starting the logging of the information about the loading of the in-memory aggregates");
        this.aggregateLoadManagerTaskInfo = new AggregateLoadManagerTaskInfo();
        this.stopped = false;
    }

    public synchronized void stopLogging() {
        logger.log("Stopping the logging of the information about the loading of the in-memory aggregates");
        this.stopped = true;
        this.aggregateLoadManagerTaskInfo = null;
    }

    public synchronized void logInitialLoad(AggregateLoadManagerTaskInfo theAggregateLoadManagerTaskInfo) throws Exception {
        if (this.stopped) {
            return;
        }
        logger.log("Logging the information about an initial loading of the in-memory aggregates");
        this.logToMemory(theAggregateLoadManagerTaskInfo);
        this.logToDisk();
        if (this.cube.getConfigAutoAggrOptimizationEnum() != ROLAPCubeConfiguration.AutoAggrOptimization.On) {
            this.aggregateLoadManagerTaskInfo = null;
        }
    }

    public synchronized void logSubsequentLoad(AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfoToAdd, List<AggregateDefinition> aggregateDefinitionsToRemove) throws Exception {
        if (this.stopped) {
            return;
        }
        logger.log("Logging the information about a subsequent loading of the in-memory aggregates");
        this.logToMemory(aggregateLoadManagerTaskInfoToAdd, aggregateDefinitionsToRemove);
        this.logToDisk();
    }

    private void logToMemory(AggregateLoadManagerTaskInfo theAggregateLoadManagerTaskInfo) {
        logger.log("Logging the information about an initial loading of the in-memory aggregates to memory");
        this.aggregateLoadManagerTaskInfo = theAggregateLoadManagerTaskInfo;
        this.traceAggregateLoadManagerTaskInfo();
    }

    private void logToMemory(AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfoToAdd, List<AggregateDefinition> aggregateDefinitionsToRemove) {
        logger.log("Logging the information about a subsequent loading of the in-memory aggregates to memory");
        String aggregateXML = aggregateLoadManagerTaskInfoToAdd.getAggregateXML();
        this.aggregateLoadManagerTaskInfo.setAggregateXML(aggregateXML);
        long loadStartTime = this.aggregateLoadManagerTaskInfo.getLoadStartTime();
        if (loadStartTime == 0L) {
            loadStartTime = aggregateLoadManagerTaskInfoToAdd.getLoadStartTime();
            this.aggregateLoadManagerTaskInfo.setLoadStartTime(loadStartTime);
        }
        long loadEndTime = aggregateLoadManagerTaskInfoToAdd.getLoadEndTime();
        this.aggregateLoadManagerTaskInfo.setLoadEndTime(loadEndTime);
        for (AggregateDefinition aggregateDefinitionToRemove : aggregateDefinitionsToRemove) {
            logger.log(String.format("Removing the information about the loading of the in-memory aggregate: %s", aggregateDefinitionToRemove.getName()));
            AggregateLoadTaskInfo aggregateLoadTaskInfoToRemove = this.aggregateLoadManagerTaskInfo.getAggregateLoadTaskInfo(aggregateDefinitionToRemove);
            this.aggregateLoadManagerTaskInfo.removeAggregateLoadTaskInfo(aggregateLoadTaskInfoToRemove);
        }
        List<AggregateLoadTaskInfo> aggregateLoadTaskInfosToAdd = aggregateLoadManagerTaskInfoToAdd.getAggregateLoadTaskInfos();
        for (AggregateLoadTaskInfo aggregateLoadTaskInfoToAdd : aggregateLoadTaskInfosToAdd) {
            logger.log(String.format("Adding the information about the loading of the in-memory aggregate: %s", aggregateLoadTaskInfoToAdd.getAggregateName()));
            this.aggregateLoadManagerTaskInfo.addAggregateLoadTaskInfo(aggregateLoadTaskInfoToAdd);
        }
        this.traceAggregateLoadManagerTaskInfo();
    }

    private void logToDisk() throws Exception {
        logger.log("Logging the information about the loading of the in-memory aggregates to disk");
        String cubeName = this.cube.getName(this.cube.getDefaultLocale());
        AggregateLoadInfoLogFileUtility.writeAggregateLoadManagerTaskInfo(cubeName, this.aggregateLoadManagerTaskInfo);
    }

    private void traceAggregateLoadManagerTaskInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nInformation about the loading of the in-memory aggregates in memory:\n\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String loadStartTime = dateFormat.format(new Date(this.aggregateLoadManagerTaskInfo.getLoadStartTime()));
        String loadEndTime = dateFormat.format(new Date(this.aggregateLoadManagerTaskInfo.getLoadEndTime()));
        sb.append(String.format("Load start time = %s%n", loadStartTime));
        sb.append(String.format("Load end time = %s%n", loadEndTime));
        sb.append(String.format("%n%20s  %20s  %20s  %s%n", "Load time", "Size in bytes", "Size in cells", "Aggregate name"));
        List<AggregateLoadTaskInfo> aggregateLoadTaskInfos = this.aggregateLoadManagerTaskInfo.getAggregateLoadTaskInfos();
        for (AggregateLoadTaskInfo aggregateLoadTaskInfo : aggregateLoadTaskInfos) {
            long aggregateLoadTime = aggregateLoadTaskInfo.getAggregateLoadTime();
            long aggregateSizeInBytes = aggregateLoadTaskInfo.getAggregateSizeInBytes();
            long aggregateSizeInCells = aggregateLoadTaskInfo.getAggregateSizeInCells();
            String aggregateName = aggregateLoadTaskInfo.getAggregateName();
            sb.append(String.format("%,20d  %,20d  %,20d  %s%n", aggregateLoadTime, aggregateSizeInBytes, aggregateSizeInCells, aggregateName));
        }
        logger.log(sb.toString());
    }
}

