/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.LogUtility;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Element;

public class QueryDetailedInfoLogger
extends WorkloadLogger {
    private static final String CM_PROPERTY_DISPATCHER_ID = "dispatcherID";
    private static final String CM_PROPERTY_DISPATCHER_PATH = "dispatcherPath";
    private static final String CM_PROPERTY_SERVERGROUP = "serverGroup";
    private static final String VALUE_STRING = "value";
    private FileOutputStream mOutputStream;
    private String mServerGroup;
    private String mDispatcher;

    public QueryDetailedInfoLogger(ROLAPCube cube) {
        super(cube);
    }

    @Override
    public boolean isLoggingEnabledForCube() {
        return this.mCube.getConfigIsAggregateLoggingEnabled();
    }

    private String getServerGroup() {
        return this.mServerGroup;
    }

    private String getDispatcher() {
        return this.mDispatcher;
    }

    public FileOutputStream getOutputStream() {
        return this.mOutputStream;
    }

    @Override
    public synchronized void startLogging() {
        if (this.isLoggingInitialized()) {
            return;
        }
        if (!this.isLoggingEnabledForCube()) {
            return;
        }
        try {
            List<CMClass> cmQueryResult = ContentManager.getProperties("/configuration/descendant::dispatcher", CM_PROPERTY_DISPATCHER_PATH, CM_PROPERTY_DISPATCHER_ID, CM_PROPERTY_SERVERGROUP);
            for (CMClass cmClass : cmQueryResult) {
                if (!cmClass.getCMClassName().equals("cm:dispatcher")) continue;
                Element itemElement = cmClass.getItemElement();
                Element dispatcherPathElement = itemElement.element(CM_PROPERTY_DISPATCHER_PATH);
                Element dispatcherPathValueElement = dispatcherPathElement.element(VALUE_STRING);
                this.mDispatcher = dispatcherPathValueElement.getText();
                Element serverGroupElement = itemElement.element(CM_PROPERTY_SERVERGROUP);
                Element serverGroupValueElement = serverGroupElement.element(VALUE_STRING);
                if (serverGroupValueElement == null) continue;
                this.mServerGroup = serverGroupValueElement.getText();
            }
            File file = new File(LogUtility.getWorkloadLogFileName(this.getCubeName(), true));
            boolean fileExisted = file.exists();
            FileOutputStream fileOutputStream = new FileOutputStream(file, fileExisted);
            if (!fileExisted || file.length() == 0L) {
                XMLStreamWriter writer = StaxUtil.createXMLStreamWriter(fileOutputStream);
                writer.setPrefix("olap", "http://www.ibm.com/olap/rolap/advisor");
                writer.writeStartDocument();
                writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateWorkloads");
                writer.writeAttribute("cube", this.getCubeName());
                writer.writeNamespace("olap", "http://www.ibm.com/olap/rolap/advisor");
                writer.writeAttribute("version", "1.0");
                writer.flush();
            }
            this.mOutputStream = fileOutputStream;
        }
        catch (Exception e) {
            throw new XQERuntimeException(e);
        }
        this.initialized = true;
    }

    @Override
    public synchronized void stopLogging() {
        this.initialized = false;
        try {
            this.closeOutputStream();
        }
        catch (IOException e) {
            this.logger.log("Error closing the workload log file: ", (Throwable)e);
        }
    }

    @Override
    public synchronized void clearLogs() {
        try {
            boolean outputStreamExists = this.mOutputStream != null;
            this.closeOutputStream();
            String logFilePath = LogUtility.getWorkloadLogFileName(this.getCubeName(), true);
            File file = new File(logFilePath);
            if (!file.exists()) {
                this.logger.log("Workload log file does not exist: " + logFilePath);
                return;
            }
            boolean bDeleted = file.delete();
            if (!bDeleted) {
                this.logger.log("Could not delete workload log file: " + logFilePath);
            } else {
                this.logger.log("Deleted workload log file: " + logFilePath);
            }
            if (outputStreamExists) {
                this.logger.log("Recreating workload log file: " + logFilePath);
                this.startLogging();
            }
        }
        catch (Exception e) {
            this.logger.log("Error clearing workload log for cube: " + this.getCubeName());
            throw new XQERuntimeException(e);
        }
    }

    private synchronized void closeOutputStream() throws IOException {
        if (this.mOutputStream != null) {
            this.mOutputStream.close();
            this.mOutputStream = null;
        }
    }

    @Override
    public synchronized void logWorkloadInfo(WorkloadInfo workloadInfo) {
        try {
            if (this.isWorkloadInfoFromAggregateLoad(workloadInfo)) {
                return;
            }
            FileOutputStream fos = this.getOutputStream();
            if (fos == null) {
                return;
            }
            XMLStreamWriter writer = StaxUtil.createXMLStreamWriter(fos);
            writer.setPrefix("olap", "http://www.ibm.com/olap/rolap/advisor");
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "report");
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "requestID");
            writer.writeCharacters(workloadInfo.getRequestID());
            writer.writeEndElement();
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "subRequestID");
            writer.writeCharacters(workloadInfo.getSubRequestID());
            writer.writeEndElement();
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "package");
            writer.writeCharacters(workloadInfo.getPackageName());
            writer.writeEndElement();
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", CM_PROPERTY_SERVERGROUP);
            writer.writeCharacters(this.getServerGroup());
            writer.writeEndElement();
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "dispatcher");
            writer.writeCharacters(this.getDispatcher());
            writer.writeEndElement();
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "user");
            writer.writeCharacters(workloadInfo.getUser());
            writer.writeEndElement();
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "reportName");
            writer.writeCharacters(workloadInfo.getReportName());
            writer.writeEndElement();
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "dateTime");
            writer.writeCharacters(LogUtility.generateReportDateTimeFormat().format(workloadInfo.getDateTime()));
            writer.writeEndElement();
            for (WorkloadInfo.WorkloadEntry entry : workloadInfo.getWorkloadEntries()) {
                this.logWorkloadEntry(entry, writer);
            }
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "executionTime");
            writer.writeCharacters(Long.toString(workloadInfo.getExecutionTime()));
            writer.writeEndElement();
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new XQERuntimeException(e);
        }
    }

    private void logWorkloadEntry(WorkloadInfo.WorkloadEntry workloadEntry, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateWorkload");
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "measures");
        for (String name : workloadEntry.getMeasures()) {
            writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "measure");
            writer.writeCharacters(name);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "hierarchies");
        for (String dimension : workloadEntry.getMetadataMap().keySet()) {
            Map<String, WorkloadInfo.HierarchyRecord> hierarchyMap = workloadEntry.getMetadataMap().get(dimension);
            for (String hierarchy : hierarchyMap.keySet()) {
                writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "hierarchy");
                writer.writeAttribute("name", hierarchy);
                writer.writeAttribute("dimension", dimension);
                WorkloadInfo.HierarchyRecord hierRecord = hierarchyMap.get(hierarchy);
                writer.writeAttribute("memberCount", Integer.toString(hierRecord.getMemberCount()));
                writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "level");
                writer.writeAttribute("name", hierRecord.getLevelName());
                List<WorkloadInfo.MemberRecord> members = hierRecord.getMembers();
                for (WorkloadInfo.MemberRecord member : members) {
                    writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "member");
                    writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "mun");
                    writer.writeCharacters(member.getMun());
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "statistics");
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "numberOfRows");
        writer.writeCharacters(Long.toString(workloadEntry.getNumberOfRows()));
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "cacheHit");
        writer.writeCharacters(Boolean.toString(workloadEntry.isCacheHit()));
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "accessType");
        writer.writeCharacters(Integer.toString(workloadEntry.getAccessType()));
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "aggregateName");
        writer.writeCharacters(workloadEntry.getAggregateName());
        writer.writeEndElement();
        writer.writeStartElement("http://www.ibm.com/olap/rolap/advisor", "executionTime");
        writer.writeCharacters(Long.toString(workloadEntry.getExecutionTime()));
        writer.writeEndElement();
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

