/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogElementParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogHierarchyParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogStatisticsElementParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLoggerTypes;
import javax.xml.stream.XMLStreamException;

public class WorkloadLogAggregateWorkloadParser
extends WorkloadLogElementParser {
    @Override
    protected void initialize() {
        this.registerType("measure", WorkloadLoggerTypes.ElementEnum.aggregateWorkloadElementMeasure);
        this.registerType("hierarchy", WorkloadLoggerTypes.ElementEnum.aggregateWorkloadElementHierarchy);
        this.registerType("statistics", WorkloadLoggerTypes.ElementEnum.statisticsElement);
        this.registerType("aggregateWorkload", WorkloadLoggerTypes.ElementEnum.reportElementAggregateWorkload);
    }

    @Override
    public boolean parse(WorkloadParser workloadParser, boolean start, WorkloadParser.ParseData parseData) {
        boolean moreDataAvailable = true;
        if (start) {
            parseData.createNewAggregateWorkloadTraceData();
            String elementName = null;
            WorkloadLoggerTypes.ElementEnum type = WorkloadLoggerTypes.ElementEnum.unknownElement;
            try {
                block7: while (moreDataAvailable && this.locateNextStartOrEndElement()) {
                    elementName = this.getElementName();
                    type = this.getType(elementName);
                    if (this.isStartElement()) {
                        switch (type) {
                            case aggregateWorkloadElementMeasure: {
                                parseData.addMeasure(this.getElementValue());
                                continue block7;
                            }
                            case aggregateWorkloadElementHierarchy: {
                                WorkloadLogHierarchyParser hierarchyParser = new WorkloadLogHierarchyParser();
                                hierarchyParser.setReader(this.mReader);
                                moreDataAvailable = hierarchyParser.parse(workloadParser, start, parseData);
                                continue block7;
                            }
                            case statisticsElement: {
                                WorkloadLogStatisticsElementParser statisticsParser = new WorkloadLogStatisticsElementParser();
                                statisticsParser.setReader(this.mReader);
                                moreDataAvailable = statisticsParser.parse(workloadParser, start, parseData);
                                continue block7;
                            }
                        }
                        continue;
                    }
                    if (WorkloadLoggerTypes.ElementEnum.reportElementAggregateWorkload != type) continue;
                    parseData.finishAggregateWorkload();
                    break;
                }
            }
            catch (XMLStreamException ex) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_ErrorParsingWorkloadLogFile, (Throwable)ex, (Object)elementName, (Object)workloadParser.getWorkloadLogPath());
            }
        }
        return moreDataAvailable && this.isMoreDataAvailable();
    }
}

