/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management;

import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorOptionName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorPropertyName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorRecommendationSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Advisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRecommendTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRecommendations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCancelReason;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AutonomicAggregateCubeTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AutonomicAggregateTaskManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.recommendation.RecommendationFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AutonomicAggregateLoadManagerCubeTask;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQELogger;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class AutonomicAggregateOptimizeCubeTask
implements AutonomicAggregateCubeTask {
    private static final long TIME_TO_WAIT_IN_MS = 60000L;
    private static final int LOG_WAIT_FREQUENCY = 30;
    private static final int ADVISOR_RUN_TIME_LIMIT_IN_MIN = 1440;
    private static final long BYTES_PER_MB = 0x100000L;
    private static final int MILLISECONDS_PER_SECOND = 1000;
    private static final XQELogger ADVISOR_MANAGEMENT_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor.Management");
    private static final XQELogger AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER = ROLAPLog.getLogger("ROLAPCubes.AutomaticAggregateOptimization");
    private static final Locale LOG_MESSAGE_LOCALE = XQEMessages.getCurrProductLocale();
    private ROLAPBaseCube cube;
    private Advisor advisor;
    private boolean canceled;

    public AutonomicAggregateOptimizeCubeTask(ROLAPBaseCube theCube) {
        this.cube = theCube;
    }

    private boolean isCanceled() {
        return this.canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String cubeName = this.cube.getName();
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", cubeName);
        try {
            ADVISOR_MANAGEMENT_LOGGER.log(String.format("The %s started.", this));
            boolean isAggregateOptimizeServerTaskConfiguredToRunAtFixedRate = AutonomicAggregateTaskManager.getInstance().isAggregateOptimizeServerTaskConfiguredToRunAtFixedRate();
            if (isAggregateOptimizeServerTaskConfiguredToRunAtFixedRate) {
                AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.log(XQEMessages.getMessage(XQEMessageKeys.RAO_ServerStartedOptimizingAggregates, LOG_MESSAGE_LOCALE, cubeName));
            }
            this.waitForInMemoryAggregatesToLoad();
            AdvisorRecommendations advisorRecommendations = this.runAdvisor();
            this.saveInMemoryAggregateRecommendations(advisorRecommendations);
            this.loadInMemoryAggregates(advisorRecommendations);
            ADVISOR_MANAGEMENT_LOGGER.log(String.format("The %s stopped.", this));
            if (isAggregateOptimizeServerTaskConfiguredToRunAtFixedRate) {
                AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.log(XQEMessages.getMessage(XQEMessageKeys.RAO_ServerStoppedOptimizingAggregates, LOG_MESSAGE_LOCALE, cubeName));
            }
        }
        finally {
            traceContext.exit();
        }
    }

    private AdvisorRecommendations runAdvisor() {
        try {
            this.advisor = this.createAdvisor();
            String sessionID = this.advisor.getProperty(AggregateAdvisorPropertyName.SESSION_ID);
            if (this.isCanceled()) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            AdvisorRecommendTask advisorRecommendTask = new AdvisorRecommendTask(this.advisor, sessionID);
            ADVISOR_MANAGEMENT_LOGGER.log(String.format("Calling the %s", advisorRecommendTask));
            advisorRecommendTask.call();
            ADVISOR_MANAGEMENT_LOGGER.log(String.format("The %s completed.", advisorRecommendTask));
            if (this.isCanceled()) {
                return null;
            }
            AdvisorRecommendations advisorRecommendations = this.advisor.getRecommendations();
            if (!AutonomicAggregateOptimizeCubeTask.advisorRecommendationsContainInMemoryAggregates(advisorRecommendations)) {
                ADVISOR_MANAGEMENT_LOGGER.log(LogLevel.WARN, "The advisor did not recommend any in-memory aggregates.");
            } else {
                long elapsedTime = (System.currentTimeMillis() - startTime) / 1000L;
                String elapsedTimeString = String.format(LOG_MESSAGE_LOCALE, "%,d", elapsedTime);
                SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss a", LOG_MESSAGE_LOCALE);
                String startTimeString = dateFormat.format(new Date(startTime));
                AUTOMATIC_AGGREGATE_OPTIMIZATION_LOGGER.log(XQEMessages.getMessage(XQEMessageKeys.RAO_AdvisorAnalyzedCube, LOG_MESSAGE_LOCALE, this.cube.getName(), startTimeString, elapsedTimeString));
            }
            return advisorRecommendations;
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
    }

    private void waitForInMemoryAggregatesToLoad() {
        int waitCount = 0;
        boolean loaded = false;
        while (!loaded && !this.isCanceled()) {
            try {
                if (waitCount % 30 == 0) {
                    ADVISOR_MANAGEMENT_LOGGER.log(LogLevel.TRACE, "Waiting for the in-memory aggregates to load");
                }
                ++waitCount;
                this.cube.waitForInMemoryAggregatesToLoad(60000L);
                loaded = true;
            }
            catch (XQERuntimeException ex) {
                if (ex.getMessageKey() == XQEMessageKeys.ROL_InMemoryAggregatesAreNotLoaded) continue;
                throw ex;
            }
        }
    }

    private void saveInMemoryAggregateRecommendations(AdvisorRecommendations advisorRecommendations) {
        if (this.isCanceled() || !AutonomicAggregateOptimizeCubeTask.advisorRecommendationsContainInMemoryAggregates(advisorRecommendations)) {
            return;
        }
        ADVISOR_MANAGEMENT_LOGGER.log("Saving the in-memory aggregate XML to the content store");
        List<Aggregate> inMemoryAggregates = advisorRecommendations.getInMemoryAggregates();
        ADVISOR_MANAGEMENT_LOGGER.log(String.format("%nIn-memory aggregates:%n%n%s", AdvisorTrace.toTraceString(inMemoryAggregates)));
        StringWriter inMemoryAggregateXMLStringWriter = new StringWriter();
        advisorRecommendations.getInMemoryRecommendationsAsXML(inMemoryAggregateXMLStringWriter);
        String inMemoryAggregateXMLString = inMemoryAggregateXMLStringWriter.toString();
        this.cube.saveInMemoryAggregateXML(inMemoryAggregateXMLString);
    }

    private void loadInMemoryAggregates(AdvisorRecommendations advisorRecommendations) {
        if (this.isCanceled() || !AutonomicAggregateOptimizeCubeTask.advisorRecommendationsContainInMemoryAggregates(advisorRecommendations)) {
            return;
        }
        ADVISOR_MANAGEMENT_LOGGER.log("Loading the in-memory aggregates autonomically");
        AutonomicAggregateLoadManagerCubeTask autonomicAggregateLoadManagerCubeTask = new AutonomicAggregateLoadManagerCubeTask(this.cube);
        this.cube.loadInMemoryAggregatesAutonomically(autonomicAggregateLoadManagerCubeTask);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.advisor != null) {
            String sessionID = this.advisor.getProperty(AggregateAdvisorPropertyName.SESSION_ID);
            this.advisor.stop(sessionID, AdvisorCancelReason.CANCEL_REQUEST);
        }
    }

    private Advisor createAdvisor() {
        Advisor advisorInstance = new Advisor(this.cube, this.createAdvisorRunProperties(), this.createAdvisorRunOptions());
        QuerySummaryInfoLogger querySummaryInfoLogger = (QuerySummaryInfoLogger)this.cube.getWorkloadLogger();
        QuerySummaryInfoLog querySummaryInfoLog = querySummaryInfoLogger.getQuerySummaryInfoLog();
        advisorInstance.setQuerySummaryInfoLog(querySummaryInfoLog);
        advisorInstance.setStoreBackupResults(true);
        return advisorInstance;
    }

    private Properties createAdvisorRunProperties() {
        String recommendationID;
        Properties properties = new Properties();
        String cubeName = this.cube.getName();
        String sessionID = recommendationID = RecommendationFileUtility.generateRecommendationID();
        long startTime = System.currentTimeMillis();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        String recommendationName = XQEMessages.getMessage(XQEMessageKeys.RLU_AutonomicAdvisorRecommendationName, XQEMessages.getCurrProductLocale(), cubeName, dateFormat.format(new Date(startTime)));
        properties.setProperty(AggregateAdvisorPropertyName.CUBE_NAME.toString(), cubeName);
        properties.setProperty(AggregateAdvisorPropertyName.RECOMMENDATION_ID.toString(), recommendationID);
        properties.setProperty(AggregateAdvisorPropertyName.RECOMMENDATION_NAME.toString(), recommendationName);
        properties.setProperty(AggregateAdvisorPropertyName.RECOMMENDATION_SOURCE.toString(), AggregateAdvisorRecommendationSource.SERVER.toString());
        properties.setProperty(AggregateAdvisorPropertyName.SESSION_ID.toString(), sessionID);
        properties.setProperty(AggregateAdvisorPropertyName.START_TIME.toString(), String.valueOf(startTime));
        properties.setProperty(AggregateAdvisorPropertyName.USER_ID.toString(), "IBM_System");
        return properties;
    }

    private Map<String, String> createAdvisorRunOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(AggregateAdvisorOptionName.IN_DATABASE_AGGREGATES_LIMIT.toString(), String.valueOf(0));
        options.put(AggregateAdvisorOptionName.IN_MEMORY_AGGREGATES_LIMIT.toString(), String.valueOf((long)this.cube.getConfigMaxAggregateCacheSize() * 0x100000L));
        options.put(AggregateAdvisorOptionName.INCLUDE_WORKLOAD_INFO.toString(), String.valueOf(true));
        options.put(AggregateAdvisorOptionName.RUN_TIME_LIMIT.toString(), String.valueOf(1440));
        options.put(AggregateAdvisorOptionName.USE_WORKLOAD_ONLY.toString(), String.valueOf(true));
        return options;
    }

    public String toString() {
        return String.format("autonomic cube task that optimizes the aggregates of the cube %s", this.cube.getName());
    }

    private static boolean advisorRecommendationsContainInMemoryAggregates(AdvisorRecommendations advisorRecommendations) {
        return advisorRecommendations != null && !advisorRecommendations.getInMemoryAggregates().isEmpty();
    }
}

