/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AutonomicAggregateCubeTask;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class AutonomicAggregateServerTask
implements Runnable {
    protected static final XQELogger LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor.Management");
    private int maxConcurrentCubeTasks;
    protected Map<ROLAPBaseCube, AutonomicAggregateCubeTask> cubeToCubeTaskMap = new ConcurrentHashMap<ROLAPBaseCube, AutonomicAggregateCubeTask>();
    private ExecutorService executorService;
    private List<ROLAPBaseCube> cubes;
    private List<AutonomicAggregateCubeTask> cubeTasks;
    private List<Future<?>> cubeTaskFutures;

    public abstract void handleCubeStart(ROLAPBaseCube var1);

    public void handleCubeStop(ROLAPBaseCube cube) {
        AutonomicAggregateCubeTask cubeTask = this.cubeToCubeTaskMap.get(cube);
        if (cubeTask != null) {
            cubeTask.cancel();
            this.cubeToCubeTaskMap.remove(cube);
            LOGGER.log(String.format("Removed the %s from the %s", cubeTask, this));
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block10: {
            LOGGER.log(String.format("The %s started.", this));
            this.setUpRun();
            this.submitCubeTasks();
            this.waitForCubeTasksToComplete();
            LOGGER.log(String.format("The %s stopped.", this));
            try {
                this.tearDownRun();
            }
            catch (Throwable th) {
                LOGGER.log(LogLevel.ERROR, String.format("The %s encountered an unexpected exception while releasing resources.", this), th);
            }
            break block10;
            catch (Throwable th) {
                try {
                    LOGGER.log(LogLevel.ERROR, String.format("The %s encountered an unexpected exception.", this), th);
                }
                catch (Throwable throwable) {
                    try {
                        this.tearDownRun();
                    }
                    catch (Throwable th2) {
                        LOGGER.log(LogLevel.ERROR, String.format("The %s encountered an unexpected exception while releasing resources.", this), th2);
                    }
                    throw throwable;
                }
                try {
                    this.tearDownRun();
                }
                catch (Throwable th3) {
                    LOGGER.log(LogLevel.ERROR, String.format("The %s encountered an unexpected exception while releasing resources.", this), th3);
                }
            }
        }
    }

    private void setUpRun() {
        this.cubes = new ArrayList<ROLAPBaseCube>();
        this.cubeTasks = new ArrayList<AutonomicAggregateCubeTask>();
        Set<Map.Entry<ROLAPBaseCube, AutonomicAggregateCubeTask>> entrySet = this.cubeToCubeTaskMap.entrySet();
        for (Map.Entry<ROLAPBaseCube, AutonomicAggregateCubeTask> entry : entrySet) {
            ROLAPBaseCube cube = entry.getKey();
            AutonomicAggregateCubeTask cubeTask = entry.getValue();
            this.cubes.add(cube);
            this.cubeTasks.add(cubeTask);
        }
        this.cubeTaskFutures = new ArrayList();
        this.maxConcurrentCubeTasks = AutonomicAggregateServerTask.getNumberOfThreadsToCreate(this.cubeTasks.size());
        this.executorService = Executors.newFixedThreadPool(this.maxConcurrentCubeTasks);
    }

    private void tearDownRun() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        if (this.cubeTaskFutures != null) {
            this.cubeTaskFutures.clear();
            this.cubeTaskFutures = null;
        }
        if (this.cubeTasks != null) {
            this.cubeTasks.clear();
            this.cubeTasks = null;
        }
        if (this.cubes != null) {
            this.cubes.clear();
            this.cubes = null;
        }
    }

    private void submitCubeTasks() {
        int cubeTaskCount = this.cubeTasks.size();
        LOGGER.log(String.format("Submitting %d autonomic cube tasks for execution", cubeTaskCount));
        for (AutonomicAggregateCubeTask cubeTask : this.cubeTasks) {
            Future<?> cubeTaskFuture = this.executorService.submit(cubeTask);
            this.cubeTaskFutures.add(cubeTaskFuture);
        }
        LOGGER.log(String.format("Submitted %d autonomic cube tasks for execution with a maximum of %d tasks executing concurrently", cubeTaskCount, this.maxConcurrentCubeTasks));
    }

    private void waitForCubeTasksToComplete() throws InterruptedException {
        int cubeTaskCount = this.cubeTasks.size();
        for (int cubeTaskIndex = 0; cubeTaskIndex < cubeTaskCount; ++cubeTaskIndex) {
            this.waitForCubeTaskToComplete(cubeTaskIndex);
        }
    }

    private void waitForCubeTaskToComplete(int cubeTaskIndex) throws InterruptedException {
        AutonomicAggregateCubeTask cubeTask = this.cubeTasks.get(cubeTaskIndex);
        LOGGER.log(String.format("Waiting for the %s to complete execution (task index = %d, task count = %d)", cubeTask, cubeTaskIndex, this.cubeTasks.size()));
        Future<?> cubeTaskFuture = this.cubeTaskFutures.get(cubeTaskIndex);
        try {
            cubeTaskFuture.get();
            LOGGER.log(String.format("The %s completed.", cubeTask));
        }
        catch (CancellationException ex) {
            LOGGER.log(LogLevel.ERROR, String.format("The %s was cancelled.", cubeTask), (Throwable)ex);
        }
        catch (ExecutionException ex) {
            LOGGER.log(LogLevel.ERROR, String.format("The %s threw an exception.", cubeTask), ex.getCause());
        }
    }

    private static int getNumberOfThreadsToCreate(int cubeTaskCount) {
        ROLAPConfiguration rolapConfiguration = new ROLAPConfiguration();
        int threadCount = rolapConfiguration.getAutomaticAggregateOptimizationMaxConcurrentCubeTasks();
        if (threadCount <= 0) {
            threadCount = 1;
        }
        if (cubeTaskCount <= 0) {
            threadCount = 1;
        } else if (cubeTaskCount < threadCount) {
            threadCount = cubeTaskCount;
        }
        return threadCount;
    }
}

