/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AutonomicAggregateOptimizeServerTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.JVMArguments;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class AutonomicAggregateTaskManager {
    private static AutonomicAggregateTaskManagerSingletonHelper singletonHelper = new AutonomicAggregateTaskManagerSingletonHelper();
    private static final XQELogger LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor.Management");
    private static final int MILLISECONDS_PER_DAY = 86400000;
    private ROLAPConfiguration rolapConfiguration = new ROLAPConfiguration();
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private AutonomicAggregateOptimizeServerTask aggregateOptimizeServerTask;
    private AtomicBoolean scheduledAggregateOptimizeServerTask = new AtomicBoolean();

    public static AutonomicAggregateTaskManager getInstance() {
        return (AutonomicAggregateTaskManager)singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private void initialize() {
    }

    private void release() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
        }
    }

    public void handleCubeStart(ROLAPBaseCube cube) {
        boolean createServerTask = cube.isAutonomicAggregateOptimizationEnabled();
        AutonomicAggregateOptimizeServerTask serverTask = this.getAggregateOptimizeServerTask(createServerTask);
        if (serverTask != null) {
            serverTask.handleCubeStart(cube);
            this.scheduleAggregateOptimizeServerTaskToRun(serverTask);
        }
    }

    public void handleCubeStop(ROLAPBaseCube cube) {
        AutonomicAggregateOptimizeServerTask serverTask = this.getAggregateOptimizeServerTask(false);
        if (serverTask != null) {
            serverTask.handleCubeStop(cube);
        }
    }

    public void handleCubePause(ROLAPBaseCube cube) {
        AutonomicAggregateOptimizeServerTask serverTask = this.getAggregateOptimizeServerTask(false);
        if (serverTask != null) {
            serverTask.handleCubeStop(cube);
        }
    }

    public void handleCubeUnpause(ROLAPBaseCube cube) {
        AutonomicAggregateOptimizeServerTask serverTask = this.getAggregateOptimizeServerTask(false);
        if (serverTask != null) {
            serverTask.handleCubeStart(cube);
        }
    }

    private AutonomicAggregateOptimizeServerTask getAggregateOptimizeServerTask(boolean create) {
        if (this.aggregateOptimizeServerTask != null) {
            return this.aggregateOptimizeServerTask;
        }
        if (!create) {
            return null;
        }
        return this.createAggregateOptimizeServerTask();
    }

    private synchronized AutonomicAggregateOptimizeServerTask createAggregateOptimizeServerTask() {
        if (this.aggregateOptimizeServerTask == null) {
            AutonomicAggregateOptimizeServerTask serverTask = new AutonomicAggregateOptimizeServerTask();
            LOGGER.log(String.format("Created the %s", serverTask));
            this.aggregateOptimizeServerTask = serverTask;
        }
        return this.aggregateOptimizeServerTask;
    }

    private void scheduleAggregateOptimizeServerTaskToRun(AutonomicAggregateOptimizeServerTask serverTask) {
        if (!this.scheduledAggregateOptimizeServerTask.compareAndSet(false, true)) {
            return;
        }
        if (this.isAggregateOptimizeServerTaskConfiguredToRunAtFixedRate()) {
            this.scheduleAggregateOptimizeServerTaskToRunAtFixedRate(serverTask);
        } else {
            this.scheduleAggregateOptimizeServerTaskToRunWithFixedDelay(serverTask);
        }
    }

    private void scheduleAggregateOptimizeServerTaskToRunAtFixedRate(AutonomicAggregateOptimizeServerTask serverTask) {
        long initialDelayInMs = this.getInitialDelayForSchedulingAggregateOptimizeServerTaskToRunAtFixedRate();
        long periodInMs = 86400000L;
        this.scheduledExecutorService.scheduleAtFixedRate(serverTask, initialDelayInMs, periodInMs, TimeUnit.MILLISECONDS);
        LOGGER.log(String.format("Scheduled the %s for execution with an initial delay of %,d ms and period of %,d ms", serverTask, initialDelayInMs, periodInMs));
    }

    private void scheduleAggregateOptimizeServerTaskToRunWithFixedDelay(AutonomicAggregateOptimizeServerTask serverTask) {
        long initialDelayInMs = JVMArguments.getAutonomicAggregateOptimizeServerTaskInitialDelay();
        long subsequentDelayInMs = JVMArguments.getAutonomicAggregateOptimizeServerTaskSubsequentDelay();
        this.scheduledExecutorService.scheduleWithFixedDelay(serverTask, initialDelayInMs, subsequentDelayInMs, TimeUnit.MILLISECONDS);
        LOGGER.log(String.format("Scheduled the %s for execution with an initial delay of %,d ms and subsequent delay of %,d ms", serverTask, initialDelayInMs, subsequentDelayInMs));
    }

    public boolean isAggregateOptimizeServerTaskConfiguredToRunAtFixedRate() {
        return !"".equals(this.rolapConfiguration.getAutomaticAggregateOptimizationStartTime());
    }

    private long getInitialDelayForSchedulingAggregateOptimizeServerTaskToRunAtFixedRate() {
        SimpleDateFormat dateFormatForFormatting = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        String startTime = this.rolapConfiguration.getAutomaticAggregateOptimizationStartTime();
        LOGGER.log(LogLevel.TRACE, String.format("Parsing the configuration parameter: name = %s, value = %s", "qsAutomaticAggregateOptimizationStartTime", startTime));
        int hourToScheduleTask = 0;
        int minuteToScheduleTask = 0;
        try {
            SimpleDateFormat dateFormatForParsing = new SimpleDateFormat("HH:mm");
            dateFormatForParsing.setLenient(false);
            Date dateWithNonCurrentDayAndConfiguredTime = dateFormatForParsing.parse(startTime);
            LOGGER.log(LogLevel.TRACE, String.format("Created a Date object with a non-current day and the configured time: %s", dateFormatForFormatting.format(dateWithNonCurrentDayAndConfiguredTime)));
            Calendar calendarWithNonCurrentDayAndConfiguredTime = Calendar.getInstance();
            calendarWithNonCurrentDayAndConfiguredTime.setTime(dateWithNonCurrentDayAndConfiguredTime);
            LOGGER.log(LogLevel.TRACE, String.format("Created a Calendar object with a non-current day and the configured time: %s", dateFormatForFormatting.format(calendarWithNonCurrentDayAndConfiguredTime.getTime())));
            hourToScheduleTask = calendarWithNonCurrentDayAndConfiguredTime.get(11);
            minuteToScheduleTask = calendarWithNonCurrentDayAndConfiguredTime.get(12);
        }
        catch (Exception ex) {
            LOGGER.log(LogLevel.ERROR, String.format("An exception occurred parsing the configuration parameter: name = %s, value = %s", "qsAutomaticAggregateOptimizationStartTime", startTime), (Throwable)ex);
        }
        LOGGER.log(LogLevel.TRACE, String.format("Using the hour: %d", hourToScheduleTask));
        LOGGER.log(LogLevel.TRACE, String.format("Using the minute: %d", minuteToScheduleTask));
        Calendar calendarWithCurrentDayAndTime = Calendar.getInstance();
        LOGGER.log(LogLevel.TRACE, String.format("Created a Calendar object with the current day and time: %s", dateFormatForFormatting.format(calendarWithCurrentDayAndTime.getTime())));
        Calendar calendarWithDayAndTimeToScheduleTask = Calendar.getInstance();
        calendarWithDayAndTimeToScheduleTask.set(11, hourToScheduleTask);
        calendarWithDayAndTimeToScheduleTask.set(12, minuteToScheduleTask);
        calendarWithDayAndTimeToScheduleTask.clear(13);
        calendarWithDayAndTimeToScheduleTask.clear(14);
        LOGGER.log(LogLevel.TRACE, String.format("Created a Calendar object with the current day and the scheduled time: %s", dateFormatForFormatting.format(calendarWithDayAndTimeToScheduleTask.getTime())));
        if (calendarWithDayAndTimeToScheduleTask.before(calendarWithCurrentDayAndTime)) {
            calendarWithDayAndTimeToScheduleTask.add(5, 1);
            LOGGER.log(LogLevel.TRACE, String.format("Adjusted the Calendar object with the scheduled time to the next day: %s", dateFormatForFormatting.format(calendarWithDayAndTimeToScheduleTask.getTime())));
        }
        long currentTimeInMs = calendarWithCurrentDayAndTime.getTimeInMillis();
        long scheduledTimeInMs = calendarWithDayAndTimeToScheduleTask.getTimeInMillis();
        long initialDelayInMs = scheduledTimeInMs - currentTimeInMs;
        LOGGER.log(LogLevel.TRACE, String.format("Calculated the initial delay to be: %d - %d = %d ms", scheduledTimeInMs, currentTimeInMs, initialDelayInMs));
        return initialDelayInMs;
    }

    private static class AutonomicAggregateTaskManagerSingletonHelper
    extends SingletonHelper<AutonomicAggregateTaskManager> {
        private AutonomicAggregateTaskManagerSingletonHelper() {
        }

        @Override
        protected AutonomicAggregateTaskManager newInstance() {
            return new AutonomicAggregateTaskManager();
        }

        @Override
        protected void initializeImpl(AutonomicAggregateTaskManager theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(AutonomicAggregateTaskManager theInstance) {
            theInstance.release();
        }
    }
}

