/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateLevelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import java.util.List;

public class ExistingInDatabaseAggregate {
    private ROLAPMetaCube metaCube;
    private ROLAPMetaAggregateCube metaAggregateCube;
    private static final String PREFIX = "* ";
    private static final String NEW_LINE = "\n";
    private static final String DASHES_STR = "---------------";
    private static final String SPACE_STR = " ";
    private static final String PADDINGSPACE_STR = "    ";
    private int numberOfInMemoryAggregatesCovered = 0;

    public ExistingInDatabaseAggregate(ROLAPMetaCube theMetaCube, ROLAPMetaAggregateCube theMetaAggregateCube) {
        this.metaCube = theMetaCube;
        this.metaAggregateCube = theMetaAggregateCube;
    }

    public String getName() {
        return this.metaAggregateCube.getName();
    }

    public ROLAPMetaAggregateCube getMetaAggregateCube() {
        return this.metaAggregateCube;
    }

    public boolean covers(Aggregate aggregate) {
        return !this.hasFiltering() && this.hasAllMeasures(aggregate) && this.hasLowestLevelsAtOrBelowLevels(aggregate);
    }

    public boolean coversIgnoreFiltering(Aggregate aggregate) {
        return this.hasAllMeasures(aggregate) && this.hasLowestLevelsAtOrBelowLevels(aggregate);
    }

    public boolean hasFiltering() {
        return this.metaAggregateCube.hasAggregateSlice();
    }

    private boolean hasAllMeasures(Aggregate aggregate) {
        List<ROLAPMetaMeasure> metaMeasures = aggregate.getMeasures();
        for (ROLAPMetaMeasure metaMeasure : metaMeasures) {
            String measureName = metaMeasure.getName();
            ROLAPMetaAggregateMeasureRef metaAggregateMeasureRef = this.getMetaAggregateMeasureRef(measureName);
            if (metaAggregateMeasureRef != null) continue;
            return false;
        }
        return true;
    }

    private boolean hasLowestLevelsAtOrBelowLevels(Aggregate aggregate) {
        ROLAPMetaDimension[] metaDimensions;
        int hierarchyIndex = 0;
        List<ROLAPMetaLevel> metaLevels = aggregate.getLevels();
        for (ROLAPMetaDimension metaDimension : metaDimensions = this.metaCube.getDimensions()) {
            ROLAPMetaHierarchy[] metaHierarchies;
            String dimensionName = metaDimension.getName();
            for (ROLAPMetaHierarchy metaHierarchy : metaHierarchies = this.metaCube.getHierarchies(metaDimension)) {
                String hierarchyName = metaHierarchy.getName();
                ROLAPMetaLevel metaLevel = metaLevels.get(hierarchyIndex);
                if (metaLevel != null) {
                    String levelName = metaLevel.getName();
                    int levelIndex = AdvisorUtils.getLevelIndex(metaHierarchy, levelName);
                    int lowestLevelIndex = -1;
                    ROLAPMetaAggregateLevelRef metaAggregateLevelRef = this.getLowestMetaAggregateLevelRef(dimensionName, hierarchyName);
                    if (metaAggregateLevelRef != null) {
                        String lowestLevelName = metaAggregateLevelRef.getName();
                        lowestLevelIndex = AdvisorUtils.getLevelIndex(metaHierarchy, lowestLevelName);
                    }
                    if (lowestLevelIndex < levelIndex) {
                        return false;
                    }
                }
                ++hierarchyIndex;
            }
        }
        return true;
    }

    private ROLAPMetaAggregateDimensionRef getMetaAggregateDimensionRef(String dimensionName) {
        ROLAPMetaAggregateDimensionRef[] metaAggregateDimensionRefs;
        for (ROLAPMetaAggregateDimensionRef metaAggregateDimensionRef : metaAggregateDimensionRefs = this.metaAggregateCube.getAggregateDimensionRefs()) {
            if (!metaAggregateDimensionRef.getName().equals(dimensionName)) continue;
            return metaAggregateDimensionRef;
        }
        return null;
    }

    private ROLAPMetaAggregateHierarchyRef getMetaAggregateHierarchyRef(String dimensionName, String hierarchyName) {
        ROLAPMetaAggregateDimensionRef metaAggregateDimensionRef = this.getMetaAggregateDimensionRef(dimensionName);
        if (metaAggregateDimensionRef != null) {
            ROLAPMetaAggregateHierarchyRef[] metaAggregateHierarchyRefs;
            for (ROLAPMetaAggregateHierarchyRef metaAggregateHierarchyRef : metaAggregateHierarchyRefs = metaAggregateDimensionRef.getAggregateHierarchyRefs()) {
                if (!metaAggregateHierarchyRef.getName().equals(hierarchyName)) continue;
                return metaAggregateHierarchyRef;
            }
        }
        return null;
    }

    private ROLAPMetaAggregateLevelRef getLowestMetaAggregateLevelRef(String dimensionName, String hierarchyName) {
        ROLAPMetaAggregateHierarchyRef metaAggregateHierarchyRef = this.getMetaAggregateHierarchyRef(dimensionName, hierarchyName);
        if (metaAggregateHierarchyRef != null) {
            return metaAggregateHierarchyRef.getLowestAggregateLevelRef();
        }
        return null;
    }

    private ROLAPMetaAggregateMeasureRef getMetaAggregateMeasureRef(String measureName) {
        ROLAPMetaAggregateMeasureRef[] metaAggregateMeasureRefs;
        for (ROLAPMetaAggregateMeasureRef metaAggregateMeasureRef : metaAggregateMeasureRefs = this.metaAggregateCube.getAggregateMeasureRefs()) {
            if (!metaAggregateMeasureRef.getName().equals(measureName)) continue;
            return metaAggregateMeasureRef;
        }
        return null;
    }

    public String[] getMeasureNames() {
        ROLAPMetaAggregateMeasureRef[] metaAggregateMeasureRefs = this.metaAggregateCube.getAggregateMeasureRefs();
        String[] measureNames = new String[metaAggregateMeasureRefs.length];
        int index = -1;
        for (ROLAPMetaAggregateMeasureRef metaAggregateMeasureRef : metaAggregateMeasureRefs) {
            measureNames[++index] = metaAggregateMeasureRef.getName();
        }
        return measureNames;
    }

    public int getLevelDepth() {
        ROLAPMetaDimension[] dimensions;
        int totalLevelDepth = 0;
        for (ROLAPMetaDimension dimension : dimensions = this.metaCube.getDimensions()) {
            ROLAPMetaHierarchy[] hierarchies;
            String dimensionName = dimension.getName();
            for (ROLAPMetaHierarchy hierarchy : hierarchies = this.metaCube.getHierarchies(dimension)) {
                String hierarchyName = hierarchy.getName();
                int levelDepth = 0;
                ROLAPMetaAggregateLevelRef metaAggregateLevelRef = this.getLowestMetaAggregateLevelRef(dimensionName, hierarchyName);
                if (metaAggregateLevelRef != null) {
                    if (hierarchy.isRecursive()) {
                        if (hierarchy.hasAllLevel()) {
                            levelDepth = 1;
                        }
                    } else {
                        String levelName = metaAggregateLevelRef.getName();
                        levelDepth = AdvisorUtils.getLevelDepth(hierarchy, levelName);
                    }
                }
                totalLevelDepth += levelDepth;
            }
        }
        return totalLevelDepth;
    }

    public String getLevelName(String dimensionName, String hierarchyName) {
        ROLAPMetaAggregateHierarchyRef metaAggregateHierarchyRef = this.getMetaAggregateHierarchyRef(dimensionName, hierarchyName);
        if (metaAggregateHierarchyRef != null) {
            return metaAggregateHierarchyRef.getLowestAggregateLevelRef().getName();
        }
        return null;
    }

    public String toTraceString() {
        ROLAPMetaAggregateDimensionRef[] metaAggregateDimensionRefs;
        StringBuilder sb = new StringBuilder();
        sb.append("%n%nExisting in-database aggregate:%n");
        sb.append(String.format("name = %s%n", this.metaAggregateCube.getName()));
        for (ROLAPMetaAggregateDimensionRef metaAggregateDimensionRef : metaAggregateDimensionRefs = this.metaAggregateCube.getAggregateDimensionRefs()) {
            ROLAPMetaAggregateHierarchyRef[] metaAggregateHierarchyRefs;
            String dimensionName = metaAggregateDimensionRef.getName();
            for (ROLAPMetaAggregateHierarchyRef metaAggregateHierarchyRef : metaAggregateHierarchyRefs = metaAggregateDimensionRef.getAggregateHierarchyRefs()) {
                String hierarchyName = metaAggregateHierarchyRef.getName();
                ROLAPMetaObject[] metaAggregateLevelRefs = metaAggregateHierarchyRef.getAggregateLevelRefs();
                sb.append(String.format("dimension = %s; hierarchy = %s; levels = %s%n", dimensionName, hierarchyName, ExistingInDatabaseAggregate.toTraceString(metaAggregateLevelRefs)));
            }
        }
        ROLAPMetaObject[] metaAggregateMeasureRefs = this.metaAggregateCube.getAggregateMeasureRefs();
        sb.append(String.format("measures = %s%n", ExistingInDatabaseAggregate.toTraceString(metaAggregateMeasureRefs)));
        if (this.hasFiltering()) {
            sb.append("Contains a slicer that represents a subset of aggregated data");
        }
        return sb.toString();
    }

    private static String toTraceString(ROLAPMetaObject[] metaObjects) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < metaObjects.length; ++i) {
            ROLAPMetaObject metaObject = metaObjects[i];
            sb.append(metaObject.getName());
            if (i + 1 >= metaObjects.length) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void setNumberOfInMemoryAggregatesCovered(int num) {
        this.numberOfInMemoryAggregatesCovered = num;
    }

    public final void getAggregateAsText(StringBuilder sb, boolean describeInMemoryDependencies) {
        try {
            ROLAPMetaAggregateMeasureRef[] rOLAPMetaAggregateMeasureRefArray;
            ROLAPMetaAggregateDimensionRef[] metaAggregateDimensionRefs;
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextExisting_Name, XQEMessages.getCurrProductLocale(), this.metaAggregateCube.getName())));
            sb.append("* \n");
            int maxDimLength = DASHES_STR.length();
            int maxHierLength = DASHES_STR.length();
            int maxLevelLength = DASHES_STR.length();
            for (ROLAPMetaAggregateDimensionRef rOLAPMetaAggregateDimensionRef : metaAggregateDimensionRefs = this.metaAggregateCube.getAggregateDimensionRefs()) {
                ROLAPMetaAggregateHierarchyRef[] metaAggregateHierarchyRefs;
                String dimensionName = rOLAPMetaAggregateDimensionRef.getName();
                for (ROLAPMetaAggregateHierarchyRef metaAggregateHierarchyRef : metaAggregateHierarchyRefs = rOLAPMetaAggregateDimensionRef.getAggregateHierarchyRefs()) {
                    String levelName;
                    ROLAPMetaAggregateLevelRef metaAggregateLevelRef;
                    String hierarchyName = metaAggregateHierarchyRef.getName();
                    if (dimensionName.length() > maxDimLength) {
                        maxDimLength = dimensionName.length();
                    }
                    if (hierarchyName.length() > maxHierLength) {
                        maxHierLength = hierarchyName.length();
                    }
                    if ((metaAggregateLevelRef = this.getLowestMetaAggregateLevelRef(dimensionName, hierarchyName)) == null || (levelName = metaAggregateLevelRef.getName()).length() <= maxLevelLength) continue;
                    maxLevelLength = levelName.length();
                }
            }
            String dimHeader = XQEMessages.getMessage(XQEMessageKeys.RLU_DimensionString, XQEMessages.getCurrProductLocale());
            String hierHeader = XQEMessages.getMessage(XQEMessageKeys.RLU_HierarchyString, XQEMessages.getCurrProductLocale());
            String levelHeader = XQEMessages.getMessage(XQEMessageKeys.RLU_LevelString, XQEMessages.getCurrProductLocale());
            sb.append(PREFIX + XQEMessages.getMessage(XQEMessageKeys.RLU_ColumnizedDisplayOfDimensionHierarchyLevel, XQEMessages.getCurrProductLocale(), dimHeader + this.addSpaces(maxDimLength - dimHeader.length(), true), hierHeader + this.addSpaces(maxHierLength - hierHeader.length(), true), levelHeader + this.addSpaces(maxLevelLength - levelHeader.length(), true)) + NEW_LINE);
            sb.append(PREFIX + XQEMessages.getMessage(XQEMessageKeys.RLU_ColumnizedDisplayOfDimensionHierarchyLevel, XQEMessages.getCurrProductLocale(), DASHES_STR + this.addSpaces(maxDimLength - DASHES_STR.length(), true), DASHES_STR + this.addSpaces(maxHierLength - DASHES_STR.length(), true), DASHES_STR + this.addSpaces(maxLevelLength - DASHES_STR.length(), true)) + NEW_LINE);
            for (ROLAPMetaAggregateDimensionRef metaAggregateDimensionRef : metaAggregateDimensionRefs) {
                ROLAPMetaAggregateHierarchyRef[] metaAggregateHierarchyRefs;
                String metaDimensionName = metaAggregateDimensionRef.getName();
                for (ROLAPMetaAggregateHierarchyRef metaAggregateHierarchyRef : metaAggregateHierarchyRefs = metaAggregateDimensionRef.getAggregateHierarchyRefs()) {
                    String metaHierarchyName = metaAggregateHierarchyRef.getName();
                    ROLAPMetaAggregateLevelRef metaAggregateLevelRef = this.getLowestMetaAggregateLevelRef(metaDimensionName, metaHierarchyName);
                    if (metaAggregateLevelRef == null) continue;
                    String metaLevelName = metaAggregateLevelRef.getName();
                    String dimName = metaDimensionName + this.addSpaces(maxDimLength - metaDimensionName.length(), true);
                    String hierName = metaHierarchyName + this.addSpaces(maxHierLength - metaHierarchyName.length(), true);
                    String levelName = metaLevelName + this.addSpaces(maxLevelLength - metaLevelName.length(), true);
                    sb.append(PREFIX);
                    sb.append(XQEMessages.getMessage(XQEMessageKeys.RLU_ColumnizedDisplayOfDimensionHierarchyLevel, XQEMessages.getCurrProductLocale(), dimName, hierName, levelName));
                    sb.append(NEW_LINE);
                }
            }
            sb.append("* \n");
            sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_MeasureList, XQEMessages.getCurrProductLocale())));
            sb.append(this.prolog(DASHES_STR));
            for (ROLAPMetaAggregateMeasureRef measure : rOLAPMetaAggregateMeasureRefArray = this.metaAggregateCube.getAggregateMeasureRefs()) {
                sb.append(PREFIX + measure.getName() + NEW_LINE);
            }
            if (this.hasFiltering()) {
                sb.append("* \n");
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextExisting_HasSlicer, XQEMessages.getCurrProductLocale())));
            }
            if (describeInMemoryDependencies) {
                sb.append("* \n");
                sb.append(this.prolog(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_NumInMemory, XQEMessages.getCurrProductLocale(), String.valueOf(this.numberOfInMemoryAggregatesCovered))));
            }
        }
        catch (Exception e) {
            ROLAPLog.logError("ROLAPAggregateAdvisor", "Advisor encountered unexpected error when getting existing aggregate cube information: ", e);
        }
    }

    private String prolog(String text) {
        return PREFIX + text + NEW_LINE;
    }

    private String addSpaces(int length, boolean padding) {
        StringBuilder sb = new StringBuilder();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                sb.append(SPACE_STR);
            }
        }
        if (padding) {
            sb.append(PADDINGSPACE_STR);
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "";
    }
}

