/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.indatabase.xml;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRecommendations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRequestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateSQLInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.ExistingInDatabaseAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateLevelKeyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateLevelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaQueryItem;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class InDatabaseRecommendationsXMLUtility {
    public static String generateXML(String cubeName, Date startTime, AdvisorRecommendations recommendations) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(stringWriter);
        xmlWriter.setIndentString("  ");
        xmlWriter.writeHeader("1.0", "UTF-8");
        xmlWriter.beginElement("inDatabaseRecommendations", -1);
        xmlWriter.attribute("cube", cubeName);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        xmlWriter.attribute("startTime", dateFormat.format(startTime));
        xmlWriter.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlWriter.attribute("xsi:noNamespaceSchemaLocation", "RolapAdvisorDatabaseRecommendations.xsd");
        AdvisorRequestParameters requestParameters = recommendations.getRequestParameters();
        InDatabaseRecommendationsXMLUtility.writeGeneralOptionsElement(xmlWriter, requestParameters);
        InDatabaseRecommendationsXMLUtility.writeWorkloadOptionsElement(xmlWriter, requestParameters);
        InDatabaseRecommendationsXMLUtility.writeNewDatabaseRecommendationsElement(xmlWriter, cubeName, recommendations.getInDatabaseAggregates());
        InDatabaseRecommendationsXMLUtility.writeExistingAggregateCubesElement(xmlWriter, recommendations.getExistingInDatabaseAggregates());
        xmlWriter.endElement();
        return stringWriter.toString();
    }

    private static void writeGeneralOptionsElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        xmlWriter.beginElement("generalOptions", -1);
        InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "includeWorkloadInfo", String.valueOf(requestParameters.getIncludeWorkloadInfo()));
        InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "useWorkloadOnly", String.valueOf(requestParameters.getUseWorkloadOnly()));
        InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "userDefinedAggregatesOnly", String.valueOf(requestParameters.getUserDefinedAggregatesOnly()));
        InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "inMemoryAggregatesLimit", String.valueOf(requestParameters.getInMemoryAggregatesLimit()));
        InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "inDatabaseAggregatesLimit", String.valueOf(requestParameters.getInDatabaseAggregatesLimit()));
        InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "runTimeLimit", String.valueOf(requestParameters.getRunTimeLimit()));
        xmlWriter.endElement();
    }

    private static void writeWorkloadOptionsElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        if (!requestParameters.getIncludeWorkloadInfo()) {
            return;
        }
        xmlWriter.beginElement("workloadOptions", -1);
        InDatabaseRecommendationsXMLUtility.writeReportUsageElement(xmlWriter, requestParameters);
        InDatabaseRecommendationsXMLUtility.writeReportNamesElement(xmlWriter, requestParameters);
        InDatabaseRecommendationsXMLUtility.writePackageNamesElement(xmlWriter, requestParameters);
        InDatabaseRecommendationsXMLUtility.writeUserNamesElement(xmlWriter, requestParameters);
        InDatabaseRecommendationsXMLUtility.writeDateTimePeriodElement(xmlWriter, requestParameters);
        xmlWriter.endElement();
    }

    private static void writeReportUsageElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        if (requestParameters.isFilterOnReportUsage()) {
            InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "reportUsage", String.valueOf(requestParameters.getReportUsage()));
        }
    }

    private static void writeReportNamesElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        List<String> reportNames = requestParameters.getReportNames();
        if (!reportNames.isEmpty()) {
            xmlWriter.beginElement("reportNames", -1);
            for (String reportName : reportNames) {
                InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "reportName", reportName);
            }
            xmlWriter.endElement();
        }
    }

    private static void writePackageNamesElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        List<String> packageNames = requestParameters.getPackageNames();
        if (!packageNames.isEmpty()) {
            xmlWriter.beginElement("packageNames", -1);
            for (String packageName : packageNames) {
                InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "packageName", packageName);
            }
            xmlWriter.endElement();
        }
    }

    private static void writeUserNamesElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        List<String> userNames = requestParameters.getUserNames();
        if (!userNames.isEmpty()) {
            xmlWriter.beginElement("userNames", -1);
            for (String userName : userNames) {
                InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "userName", userName);
            }
            xmlWriter.endElement();
        }
    }

    private static void writeDateTimePeriodElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        xmlWriter.beginElement("dateTimePeriod", -1);
        InDatabaseRecommendationsXMLUtility.writeAllPeriodsElement(xmlWriter, requestParameters);
        InDatabaseRecommendationsXMLUtility.writeDaysOfWeekAndTimeElement(xmlWriter, requestParameters);
        InDatabaseRecommendationsXMLUtility.writeStartAndEndTimeElement(xmlWriter, requestParameters);
        xmlWriter.endElement();
    }

    private static void writeAllPeriodsElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        if (!requestParameters.isFilterOnTimePeriod()) {
            xmlWriter.beginElement("allPeriods", -1);
            xmlWriter.endElement();
        }
    }

    private static void writeDaysOfWeekAndTimeElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        if (requestParameters.isFilterOnDaysOfTheWeek() && requestParameters.isFilterOnTimePeriod()) {
            xmlWriter.beginElement("daysOfWeekAndTime", -1);
            InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "daysOfWeek", String.valueOf(requestParameters.getDaysOfTheWeek()));
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss z");
            InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "fromTime", timeFormat.format(requestParameters.getStartTime()));
            InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "toTime", timeFormat.format(requestParameters.getEndTime()));
            xmlWriter.endElement();
        }
    }

    private static void writeStartAndEndTimeElement(XMLWriter xmlWriter, AdvisorRequestParameters requestParameters) {
        if (!requestParameters.isFilterOnDaysOfTheWeek() && requestParameters.isFilterOnTimePeriod()) {
            xmlWriter.beginElement("startAndEndTime", -1);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "startTime", dateFormat.format(requestParameters.getStartTime()));
            InDatabaseRecommendationsXMLUtility.writeElement(xmlWriter, "endTime", dateFormat.format(requestParameters.getEndTime()));
            xmlWriter.endElement();
        }
    }

    private static void writeNewDatabaseRecommendationsElement(XMLWriter xmlWriter, String cubeName, List<Aggregate> aggregates) {
        int aggregateCount = aggregates.size();
        if (aggregateCount > 0) {
            xmlWriter.beginElement("newDatabaseRecommendations", -1);
            xmlWriter.attribute("count", aggregateCount);
            for (Aggregate aggregate : aggregates) {
                InDatabaseRecommendationsXMLUtility.writeAggregateCubeElement(xmlWriter, cubeName, aggregate);
            }
            xmlWriter.endElement();
        }
    }

    private static void writeAggregateCubeElement(XMLWriter xmlWriter, String cubeName, Aggregate aggregate) {
        String aggregateName = aggregate.getName();
        xmlWriter.beginElement("aggregateCube", -1);
        xmlWriter.attribute("name", aggregateName);
        xmlWriter.attribute("recommendedTableName", InDatabaseRecommendationsXMLUtility.getRecommendedTableName(cubeName, aggregateName));
        InDatabaseRecommendationsXMLUtility.writeAggregateDimensionRefElements(xmlWriter, aggregate);
        InDatabaseRecommendationsXMLUtility.writeAggregateMeasureRefElements(xmlWriter, aggregate);
        InDatabaseRecommendationsXMLUtility.writeCanBeDerivedFromAnyOtherNewRecommendationElement(xmlWriter, aggregate);
        InDatabaseRecommendationsXMLUtility.writeNumRecommendedInMemoryAggregatesCanCoverElement(xmlWriter, aggregate);
        InDatabaseRecommendationsXMLUtility.writeEstimatedRowCountElement(xmlWriter, aggregate);
        InDatabaseRecommendationsXMLUtility.writeSQLElement(xmlWriter, aggregate);
        xmlWriter.endElement();
    }

    private static void writeAggregateDimensionRefElements(XMLWriter xmlWriter, Aggregate aggregate) {
        ROLAPMetaDimension[] dimensions;
        ROLAPMetaCube metaCube = aggregate.getMetaCube();
        for (ROLAPMetaDimension dimension : dimensions = metaCube.getDimensions()) {
            InDatabaseRecommendationsXMLUtility.writeAggregateDimensionRefElement(xmlWriter, aggregate, dimension);
        }
    }

    private static void writeAggregateDimensionRefElement(XMLWriter xmlWriter, Aggregate aggregate, ROLAPMetaDimension dimension) {
        if (!InDatabaseRecommendationsXMLUtility.hasRegularLevel(aggregate, dimension)) {
            return;
        }
        xmlWriter.beginElement("aggregateDimensionRef", -1);
        xmlWriter.attribute("name", dimension.getName());
        String dimensionCategory = null;
        dimensionCategory = "public".equals(dimension.getCategory()) ? "public" : "private";
        xmlWriter.attribute("category", dimensionCategory);
        InDatabaseRecommendationsXMLUtility.writeAggregateHierarchyRefElements(xmlWriter, aggregate, dimension);
        xmlWriter.endElement();
    }

    private static void writeAggregateHierarchyRefElements(XMLWriter xmlWriter, Aggregate aggregate, ROLAPMetaDimension dimension) {
        ROLAPMetaHierarchy[] hierarchies;
        ROLAPMetaCube metaCube = aggregate.getMetaCube();
        for (ROLAPMetaHierarchy hierarchy : hierarchies = metaCube.getHierarchies(dimension)) {
            InDatabaseRecommendationsXMLUtility.writeAggregateHierarchyRefElement(xmlWriter, aggregate, dimension, hierarchy);
        }
    }

    private static void writeAggregateHierarchyRefElement(XMLWriter xmlWriter, Aggregate aggregate, ROLAPMetaDimension dimension, ROLAPMetaHierarchy hierarchy) {
        if (!InDatabaseRecommendationsXMLUtility.hasRegularLevel(aggregate, dimension, hierarchy)) {
            return;
        }
        xmlWriter.beginElement("aggregateHierarchyRef", -1);
        xmlWriter.attribute("name", hierarchy.getName());
        InDatabaseRecommendationsXMLUtility.writeAggregateLevelRefElements(xmlWriter, aggregate, dimension, hierarchy);
        xmlWriter.endElement();
    }

    private static void writeAggregateLevelRefElements(XMLWriter xmlWriter, Aggregate aggregate, ROLAPMetaDimension dimension, ROLAPMetaHierarchy hierarchy) {
        ROLAPMetaLevel[] levels = hierarchy.getLevels();
        ROLAPMetaLevel lastLevel = aggregate.getLevel(dimension.getName(), hierarchy.getName());
        for (ROLAPMetaLevel level : levels) {
            InDatabaseRecommendationsXMLUtility.writeAggregateLevelRefElement(xmlWriter, aggregate, dimension, hierarchy, level);
            if (level == lastLevel) break;
        }
    }

    private static void writeAggregateLevelRefElement(XMLWriter xmlWriter, Aggregate aggregate, ROLAPMetaDimension dimension, ROLAPMetaHierarchy hierarchy, ROLAPMetaLevel level) {
        xmlWriter.beginElement("aggregateLevelRef", -1);
        xmlWriter.attribute("name", level.getName());
        List<ROLAPMetaAttribute> levelKeys = level.getLevelKeys();
        for (ROLAPMetaAttribute levelKey : levelKeys) {
            InDatabaseRecommendationsXMLUtility.writeAggregateLevelKeyRefElement(xmlWriter, aggregate, dimension, hierarchy, levelKey);
        }
        xmlWriter.endElement();
    }

    private static void writeAggregateLevelKeyRefElement(XMLWriter xmlWriter, Aggregate aggregate, ROLAPMetaDimension dimension, ROLAPMetaHierarchy hierarchy, ROLAPMetaAttribute levelKey) {
        String dimensionName = dimension.getName();
        String hierarchyName = hierarchy.getName();
        String levelKeyName = levelKey.getName();
        xmlWriter.beginElement("aggregateLevelKeyRef", -1);
        xmlWriter.attribute("name", levelKeyName);
        AggregateSQLInfo sqlInfo = aggregate.getSQLInfo();
        String columnName = sqlInfo.getColumnName(dimensionName, hierarchyName, levelKeyName);
        String columnDataType = sqlInfo.getColumnDataType(columnName);
        InDatabaseRecommendationsXMLUtility.writeRecommendedColumnElement(xmlWriter, columnName, columnDataType);
        if ("UNKNOWN".equals(columnDataType)) {
            InDatabaseRecommendationsXMLUtility.writeBaseCubeQueryItemElement(xmlWriter, levelKey.getQueryItem());
        }
        xmlWriter.endElement();
    }

    private static void writeRecommendedColumnElement(XMLWriter xmlWriter, String columnName, String columnDataType) {
        xmlWriter.beginElement("recommendedColumn", -1);
        xmlWriter.attribute("name", columnName);
        xmlWriter.attribute("dataType", columnDataType);
        xmlWriter.endElement();
    }

    private static void writeBaseCubeQueryItemElement(XMLWriter xmlWriter, String queryItem) {
        xmlWriter.beginElement("baseCubeQueryItem", -1);
        xmlWriter.attribute("refObject", queryItem);
        xmlWriter.endElement();
    }

    private static void writeAggregateMeasureRefElements(XMLWriter xmlWriter, Aggregate aggregate) {
        List<ROLAPMetaMeasure> measures = aggregate.getMeasures();
        for (ROLAPMetaMeasure measure : measures) {
            InDatabaseRecommendationsXMLUtility.writeAggregateMeasureRefElement(xmlWriter, aggregate, measure);
        }
    }

    private static void writeAggregateMeasureRefElement(XMLWriter xmlWriter, Aggregate aggregate, ROLAPMetaMeasure measure) {
        String dimensionName;
        String hierarchyName = dimensionName = aggregate.getMetaCube().getMetaCubeModel().getMeasureDimensionName();
        String measureName = measure.getName();
        xmlWriter.beginElement("aggregateMeasureRef", -1);
        xmlWriter.attribute("name", measureName);
        AggregateSQLInfo sqlInfo = aggregate.getSQLInfo();
        String columnName = sqlInfo.getColumnName(dimensionName, hierarchyName, measureName);
        String columnDataType = sqlInfo.getColumnDataType(columnName);
        InDatabaseRecommendationsXMLUtility.writeRecommendedColumnElement(xmlWriter, columnName, columnDataType);
        xmlWriter.endElement();
    }

    private static void writeCanBeDerivedFromAnyOtherNewRecommendationElement(XMLWriter xmlWriter, Aggregate aggregate) {
        xmlWriter.beginElement("canBeDerivedFromAnyOtherNewRecommendation", -1);
        List<String> aggregateCubeNames = aggregate.getCoveredByAggregates();
        for (String aggregateCubeName : aggregateCubeNames) {
            InDatabaseRecommendationsXMLUtility.writeAggregateCubeRefElement(xmlWriter, aggregateCubeName);
        }
        xmlWriter.endElement();
    }

    private static void writeAggregateCubeRefElement(XMLWriter xmlWriter, String aggregateCubeName) {
        xmlWriter.beginElement("aggregateCubeRef", -1);
        xmlWriter.attribute("name", aggregateCubeName);
        xmlWriter.endElement();
    }

    private static void writeNumRecommendedInMemoryAggregatesCanCoverElement(XMLWriter xmlWriter, Aggregate aggregate) {
        xmlWriter.beginElement("numRecommendedInMemoryAggregatesCanCover", -1);
        xmlWriter.data(String.valueOf(aggregate.getNumberOfInMemoryAggregatesCovered()));
        xmlWriter.endElement();
    }

    private static void writeEstimatedRowCountElement(XMLWriter xmlWriter, Aggregate aggregate) {
        xmlWriter.beginElement("estimatedRowCount", -1);
        xmlWriter.data(String.valueOf(aggregate.getCardinality()));
        xmlWriter.endElement();
    }

    private static void writeSQLElement(XMLWriter xmlWriter, Aggregate aggregate) {
        xmlWriter.beginElement("SQL", -1);
        xmlWriter.cdata(aggregate.getSQLInfo().getSQL());
        xmlWriter.endElement();
    }

    private static void writeExistingAggregateCubesElement(XMLWriter xmlWriter, List<ExistingInDatabaseAggregate> existingInDatabaseAggregates) {
        int existingInDatabaseAggregateCount = existingInDatabaseAggregates.size();
        if (existingInDatabaseAggregateCount > 0) {
            xmlWriter.beginElement("existingAggregateCubes", -1);
            xmlWriter.attribute("count", existingInDatabaseAggregateCount);
            for (ExistingInDatabaseAggregate existingInDatabaseAggregate : existingInDatabaseAggregates) {
                InDatabaseRecommendationsXMLUtility.writeAggregateCubeElement(xmlWriter, existingInDatabaseAggregate);
            }
            xmlWriter.endElement();
        }
    }

    private static void writeAggregateCubeElement(XMLWriter xmlWriter, ExistingInDatabaseAggregate aggregate) {
        ROLAPMetaAggregateCube metaAggregateCube = aggregate.getMetaAggregateCube();
        xmlWriter.beginElement("aggregateCube", -1);
        xmlWriter.attribute("name", aggregate.getName());
        xmlWriter.attribute("ordinal", metaAggregateCube.getOrdinal());
        InDatabaseRecommendationsXMLUtility.writeAggregateDimensionRefElements(xmlWriter, aggregate);
        InDatabaseRecommendationsXMLUtility.writeAggregateMeasureRefElements(xmlWriter, aggregate);
        xmlWriter.endElement();
    }

    private static void writeAggregateDimensionRefElements(XMLWriter xmlWriter, ExistingInDatabaseAggregate aggregate) {
        ROLAPMetaAggregateDimensionRef[] dimensionRefs;
        ROLAPMetaAggregateCube metaAggregateCube = aggregate.getMetaAggregateCube();
        for (ROLAPMetaAggregateDimensionRef dimensionRef : dimensionRefs = metaAggregateCube.getAggregateDimensionRefs()) {
            InDatabaseRecommendationsXMLUtility.writeAggregateDimensionRefElement(xmlWriter, dimensionRef);
        }
    }

    private static void writeAggregateDimensionRefElement(XMLWriter xmlWriter, ROLAPMetaAggregateDimensionRef dimension) {
        ROLAPMetaAggregateHierarchyRef[] hierarchyRefs;
        xmlWriter.beginElement("aggregateDimensionRef", -1);
        xmlWriter.attribute("name", dimension.getName());
        for (ROLAPMetaAggregateHierarchyRef hierarchyRef : hierarchyRefs = dimension.getAggregateHierarchyRefs()) {
            InDatabaseRecommendationsXMLUtility.writeAggregateHierarchyRefElement(xmlWriter, hierarchyRef);
        }
        xmlWriter.endElement();
    }

    private static void writeAggregateHierarchyRefElement(XMLWriter xmlWriter, ROLAPMetaAggregateHierarchyRef hierarchy) {
        ROLAPMetaAggregateLevelRef[] levelRefs;
        xmlWriter.beginElement("aggregateHierarchyRef", -1);
        xmlWriter.attribute("name", hierarchy.getName());
        for (ROLAPMetaAggregateLevelRef levelRef : levelRefs = hierarchy.getAggregateLevelRefs()) {
            InDatabaseRecommendationsXMLUtility.writeAggregateLevelRefElement(xmlWriter, levelRef);
        }
        xmlWriter.endElement();
    }

    private static void writeAggregateLevelRefElement(XMLWriter xmlWriter, ROLAPMetaAggregateLevelRef level) {
        ROLAPMetaAggregateLevelKeyRef[] levelKeyRefs;
        xmlWriter.beginElement("aggregateLevelRef", -1);
        xmlWriter.attribute("name", level.getName());
        for (ROLAPMetaAggregateLevelKeyRef levelKeyRef : levelKeyRefs = level.getAggregateLevelKeyRefs()) {
            InDatabaseRecommendationsXMLUtility.writeAggregateLevelKeyRefElement(xmlWriter, levelKeyRef);
        }
        xmlWriter.endElement();
    }

    private static void writeAggregateLevelKeyRefElement(XMLWriter xmlWriter, ROLAPMetaAggregateLevelKeyRef levelKey) {
        ROLAPMetaQueryItem[] queryItems;
        xmlWriter.beginElement("aggregateLevelKeyRef", -1);
        xmlWriter.attribute("name", levelKey.getName());
        for (ROLAPMetaQueryItem queryItem : queryItems = levelKey.getQueryItems()) {
            InDatabaseRecommendationsXMLUtility.writeQueryItemElement(xmlWriter, queryItem.getRefObject());
        }
        xmlWriter.endElement();
    }

    private static void writeQueryItemElement(XMLWriter xmlWriter, String refObject) {
        xmlWriter.beginElement("queryItem", -1);
        xmlWriter.attribute("refObject", refObject);
        xmlWriter.endElement();
    }

    private static void writeAggregateMeasureRefElements(XMLWriter xmlWriter, ExistingInDatabaseAggregate aggregate) {
        ROLAPMetaAggregateMeasureRef[] measureRefs;
        ROLAPMetaAggregateCube metaAggregateCube = aggregate.getMetaAggregateCube();
        for (ROLAPMetaAggregateMeasureRef measureRef : measureRefs = metaAggregateCube.getAggregateMeasureRefs()) {
            InDatabaseRecommendationsXMLUtility.writeAggregateMeasureRefElement(xmlWriter, measureRef);
        }
    }

    private static void writeAggregateMeasureRefElement(XMLWriter xmlWriter, ROLAPMetaAggregateMeasureRef measure) {
        xmlWriter.beginElement("aggregateMeasureRef", -1);
        xmlWriter.attribute("name", measure.getName());
        InDatabaseRecommendationsXMLUtility.writeQueryItemElement(xmlWriter, measure.getQueryItem());
        xmlWriter.endElement();
    }

    private static void writeElement(XMLWriter xmlWriter, String elementName, String elementValue) {
        xmlWriter.beginElement(elementName, -1);
        xmlWriter.data(elementValue);
        xmlWriter.endElement();
    }

    private static boolean hasRegularLevel(Aggregate aggregate, ROLAPMetaDimension dimension) {
        ROLAPMetaHierarchy[] hierarchies;
        ROLAPMetaCube metaCube = aggregate.getMetaCube();
        for (ROLAPMetaHierarchy hierarchy : hierarchies = metaCube.getHierarchies(dimension)) {
            if (!InDatabaseRecommendationsXMLUtility.hasRegularLevel(aggregate, dimension, hierarchy)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRegularLevel(Aggregate aggregate, ROLAPMetaDimension dimension, ROLAPMetaHierarchy hierarchy) {
        String dimensionName = dimension.getName();
        String hierarchyName = hierarchy.getName();
        String levelName = aggregate.getLevelName(dimensionName, hierarchyName);
        return AdvisorUtils.isRegularLevel(levelName);
    }

    private static String getRecommendedTableName(String cubeName, String aggregateName) {
        String recommendedTableNameSuffix = UniqueNameGenerator.createUniqueName(cubeName, aggregateName);
        int recommendedTableNameSuffixHashCode = recommendedTableNameSuffix.hashCode();
        String recommendedTableName = "AGG_" + recommendedTableNameSuffixHashCode;
        return recommendedTableName;
    }
}

